/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiOptionButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiCustomizeSkin
extends GuiScreen {
    private final GuiScreen parentScreen;
    private String title;

    public GuiCustomizeSkin(GuiScreen p_i45516_1_) {
        this.parentScreen = p_i45516_1_;
    }

    @Override
    public void initGui() {
        int lvt_1_1_ = 0;
        this.title = I18n.format("options.skinCustomisation.title", new Object[0]);
        for (EnumPlayerModelParts lvt_5_1_ : EnumPlayerModelParts.values()) {
            this.buttonList.add(new ButtonPart(lvt_5_1_.getPartId(), this.width / 2 - 155 + lvt_1_1_ % 2 * 160, this.height / 6 + 24 * (lvt_1_1_ >> 1), 150, 20, lvt_5_1_));
            ++lvt_1_1_;
        }
        this.buttonList.add(new GuiOptionButton(199, this.width / 2 - 155 + lvt_1_1_ % 2 * 160, this.height / 6 + 24 * (lvt_1_1_ >> 1), GameSettings.Options.MAIN_HAND, this.mc.gameSettings.getKeyBinding(GameSettings.Options.MAIN_HAND)));
        if (++lvt_1_1_ % 2 == 1) {
            ++lvt_1_1_;
        }
        this.buttonList.add(new GuiButton(200, this.width / 2 - 100, this.height / 6 + 24 * (lvt_1_1_ >> 1), I18n.format("gui.done", new Object[0])));
    }

    @Override
    protected void keyTyped(char p_keyTyped_1_, int p_keyTyped_2_) throws IOException {
        if (p_keyTyped_2_ == 1) {
            this.mc.gameSettings.saveOptions();
        }
        super.keyTyped(p_keyTyped_1_, p_keyTyped_2_);
    }

    @Override
    protected void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
        if (!p_actionPerformed_1_.enabled) {
            return;
        }
        if (p_actionPerformed_1_.id == 200) {
            this.mc.gameSettings.saveOptions();
            this.mc.displayGuiScreen(this.parentScreen);
        } else if (p_actionPerformed_1_.id == 199) {
            this.mc.gameSettings.setOptionValue(GameSettings.Options.MAIN_HAND, 1);
            p_actionPerformed_1_.displayString = this.mc.gameSettings.getKeyBinding(GameSettings.Options.MAIN_HAND);
            this.mc.gameSettings.sendSettingsToServer();
        } else if (p_actionPerformed_1_ instanceof ButtonPart) {
            EnumPlayerModelParts lvt_2_1_ = ((ButtonPart)p_actionPerformed_1_).playerModelParts;
            this.mc.gameSettings.switchModelPartEnabled(lvt_2_1_);
            p_actionPerformed_1_.displayString = this.getMessage(lvt_2_1_);
        }
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRendererObj, this.title, this.width / 2, 20, 0xFFFFFF);
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
    }

    private String getMessage(EnumPlayerModelParts p_getMessage_1_) {
        String lvt_2_2_;
        if (this.mc.gameSettings.getModelParts().contains((Object)p_getMessage_1_)) {
            String lvt_2_1_ = I18n.format("options.on", new Object[0]);
        } else {
            lvt_2_2_ = I18n.format("options.off", new Object[0]);
        }
        return p_getMessage_1_.getName().getFormattedText() + ": " + lvt_2_2_;
    }

    @SideOnly(value=Side.CLIENT)
    class ButtonPart
    extends GuiButton {
        private final EnumPlayerModelParts playerModelParts;

        private ButtonPart(int p_i45514_2_, int p_i45514_3_, int p_i45514_4_, int p_i45514_5_, int p_i45514_6_, EnumPlayerModelParts p_i45514_7_) {
            super(p_i45514_2_, p_i45514_3_, p_i45514_4_, p_i45514_5_, p_i45514_6_, GuiCustomizeSkin.this.getMessage(p_i45514_7_));
            this.playerModelParts = p_i45514_7_;
        }
    }
}

