/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.base.Predicate;
import com.google.common.primitives.Floats;
import java.io.IOException;
import java.util.Random;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiListButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenCustomizePresets;
import net.minecraft.client.gui.GuiSlider;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkProviderSettings;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiCustomizeWorldScreen
extends GuiScreen
implements GuiSlider.FormatHelper,
GuiPageButtonList.GuiResponder {
    private final GuiCreateWorld parent;
    protected String title = "Customize World Settings";
    protected String subtitle = "Page 1 of 3";
    protected String pageTitle = "Basic Settings";
    protected String[] pageNames = new String[4];
    private GuiPageButtonList list;
    private GuiButton done;
    private GuiButton randomize;
    private GuiButton defaults;
    private GuiButton previousPage;
    private GuiButton nextPage;
    private GuiButton confirm;
    private GuiButton cancel;
    private GuiButton presets;
    private boolean settingsModified;
    private int confirmMode;
    private boolean confirmDismissed;
    private final Predicate<String> numberFilter = new Predicate<String>(){

        public boolean apply(String p_apply_1_) {
            Float lvt_2_1_ = Floats.tryParse((String)p_apply_1_);
            return p_apply_1_.isEmpty() || lvt_2_1_ != null && Floats.isFinite((float)lvt_2_1_.floatValue()) && lvt_2_1_.floatValue() >= 0.0f;
        }

        public /* synthetic */ boolean apply(Object p_apply_1_) {
            return this.apply((String)p_apply_1_);
        }
    };
    private final ChunkProviderSettings.Factory defaultSettings = new ChunkProviderSettings.Factory();
    private ChunkProviderSettings.Factory settings;
    private final Random random = new Random();

    public GuiCustomizeWorldScreen(GuiScreen p_i45521_1_, String p_i45521_2_) {
        this.parent = (GuiCreateWorld)p_i45521_1_;
        this.loadValues(p_i45521_2_);
    }

    @Override
    public void initGui() {
        int lvt_1_1_ = 0;
        int lvt_2_1_ = 0;
        if (this.list != null) {
            lvt_1_1_ = this.list.getPage();
            lvt_2_1_ = this.list.getAmountScrolled();
        }
        this.title = I18n.format("options.customizeTitle", new Object[0]);
        this.buttonList.clear();
        this.previousPage = this.addButton(new GuiButton(302, 20, 5, 80, 20, I18n.format("createWorld.customize.custom.prev", new Object[0])));
        this.nextPage = this.addButton(new GuiButton(303, this.width - 100, 5, 80, 20, I18n.format("createWorld.customize.custom.next", new Object[0])));
        this.defaults = this.addButton(new GuiButton(304, this.width / 2 - 187, this.height - 27, 90, 20, I18n.format("createWorld.customize.custom.defaults", new Object[0])));
        this.randomize = this.addButton(new GuiButton(301, this.width / 2 - 92, this.height - 27, 90, 20, I18n.format("createWorld.customize.custom.randomize", new Object[0])));
        this.presets = this.addButton(new GuiButton(305, this.width / 2 + 3, this.height - 27, 90, 20, I18n.format("createWorld.customize.custom.presets", new Object[0])));
        this.done = this.addButton(new GuiButton(300, this.width / 2 + 98, this.height - 27, 90, 20, I18n.format("gui.done", new Object[0])));
        this.defaults.enabled = this.settingsModified;
        this.confirm = new GuiButton(306, this.width / 2 - 55, 160, 50, 20, I18n.format("gui.yes", new Object[0]));
        this.confirm.visible = false;
        this.buttonList.add(this.confirm);
        this.cancel = new GuiButton(307, this.width / 2 + 5, 160, 50, 20, I18n.format("gui.no", new Object[0]));
        this.cancel.visible = false;
        this.buttonList.add(this.cancel);
        if (this.confirmMode != 0) {
            this.confirm.visible = true;
            this.cancel.visible = true;
        }
        this.createPagedList();
        if (lvt_1_1_ != 0) {
            this.list.setPage(lvt_1_1_);
            this.list.scrollBy(lvt_2_1_);
            this.updatePageControls();
        }
    }

    @Override
    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        this.list.handleMouseInput();
    }

    private void createPagedList() {
        GuiPageButtonList.GuiListEntry[] lvt_1_1_ = new GuiPageButtonList.GuiListEntry[]{new GuiPageButtonList.GuiSlideEntry(160, I18n.format("createWorld.customize.custom.seaLevel", new Object[0]), true, this, 1.0f, 255.0f, this.settings.seaLevel), new GuiPageButtonList.GuiButtonEntry(148, I18n.format("createWorld.customize.custom.useCaves", new Object[0]), true, this.settings.useCaves), new GuiPageButtonList.GuiButtonEntry(150, I18n.format("createWorld.customize.custom.useStrongholds", new Object[0]), true, this.settings.useStrongholds), new GuiPageButtonList.GuiButtonEntry(151, I18n.format("createWorld.customize.custom.useVillages", new Object[0]), true, this.settings.useVillages), new GuiPageButtonList.GuiButtonEntry(152, I18n.format("createWorld.customize.custom.useMineShafts", new Object[0]), true, this.settings.useMineShafts), new GuiPageButtonList.GuiButtonEntry(153, I18n.format("createWorld.customize.custom.useTemples", new Object[0]), true, this.settings.useTemples), new GuiPageButtonList.GuiButtonEntry(210, I18n.format("createWorld.customize.custom.useMonuments", new Object[0]), true, this.settings.useMonuments), new GuiPageButtonList.GuiButtonEntry(211, I18n.format("createWorld.customize.custom.useMansions", new Object[0]), true, this.settings.useMansions), new GuiPageButtonList.GuiButtonEntry(154, I18n.format("createWorld.customize.custom.useRavines", new Object[0]), true, this.settings.useRavines), new GuiPageButtonList.GuiButtonEntry(149, I18n.format("createWorld.customize.custom.useDungeons", new Object[0]), true, this.settings.useDungeons), new GuiPageButtonList.GuiSlideEntry(157, I18n.format("createWorld.customize.custom.dungeonChance", new Object[0]), true, this, 1.0f, 100.0f, this.settings.dungeonChance), new GuiPageButtonList.GuiButtonEntry(155, I18n.format("createWorld.customize.custom.useWaterLakes", new Object[0]), true, this.settings.useWaterLakes), new GuiPageButtonList.GuiSlideEntry(158, I18n.format("createWorld.customize.custom.waterLakeChance", new Object[0]), true, this, 1.0f, 100.0f, this.settings.waterLakeChance), new GuiPageButtonList.GuiButtonEntry(156, I18n.format("createWorld.customize.custom.useLavaLakes", new Object[0]), true, this.settings.useLavaLakes), new GuiPageButtonList.GuiSlideEntry(159, I18n.format("createWorld.customize.custom.lavaLakeChance", new Object[0]), true, this, 10.0f, 100.0f, this.settings.lavaLakeChance), new GuiPageButtonList.GuiButtonEntry(161, I18n.format("createWorld.customize.custom.useLavaOceans", new Object[0]), true, this.settings.useLavaOceans), new GuiPageButtonList.GuiSlideEntry(162, I18n.format("createWorld.customize.custom.fixedBiome", new Object[0]), true, this, -1.0f, 37.0f, this.settings.fixedBiome), new GuiPageButtonList.GuiSlideEntry(163, I18n.format("createWorld.customize.custom.biomeSize", new Object[0]), true, this, 1.0f, 8.0f, this.settings.biomeSize), new GuiPageButtonList.GuiSlideEntry(164, I18n.format("createWorld.customize.custom.riverSize", new Object[0]), true, this, 1.0f, 5.0f, this.settings.riverSize)};
        GuiPageButtonList.GuiListEntry[] lvt_2_1_ = new GuiPageButtonList.GuiListEntry[]{new GuiPageButtonList.GuiLabelEntry(416, I18n.format("tile.dirt.name", new Object[0]), false), null, new GuiPageButtonList.GuiSlideEntry(165, I18n.format("createWorld.customize.custom.size", new Object[0]), false, this, 1.0f, 50.0f, this.settings.dirtSize), new GuiPageButtonList.GuiSlideEntry(166, I18n.format("createWorld.customize.custom.count", new Object[0]), false, this, 0.0f, 40.0f, this.settings.dirtCount), new GuiPageButtonList.GuiSlideEntry(167, I18n.format("createWorld.customize.custom.minHeight", new Object[0]), false, this, 0.0f, 255.0f, this.settings.dirtMinHeight), new GuiPageButtonList.GuiSlideEntry(168, I18n.format("createWorld.customize.custom.maxHeight", new Object[0]), false, this, 0.0f, 255.0f, this.settings.dirtMaxHeight), new GuiPageButtonList.GuiLabelEntry(417, I18n.format("tile.gravel.name", new Object[0]), false), null, new GuiPageButtonList.GuiSlideEntry(169, I18n.format("createWorld.customize.custom.size", new Object[0]), false, this, 1.0f, 50.0f, this.settings.gravelSize), new GuiPageButtonList.GuiSlideEntry(170, I18n.format("createWorld.customize.custom.count", new Object[0]), false, this, 0.0f, 40.0f, this.settings.gravelCount), new GuiPageButtonList.GuiSlideEntry(171, I18n.format("createWorld.customize.custom.minHeight", new Object[0]), false, this, 0.0f, 255.0f, this.settings.gravelMinHeight), new GuiPageButtonList.GuiSlideEntry(172, I18n.format("createWorld.customize.custom.maxHeight", new Object[0]), false, this, 0.0f, 255.0f, this.settings.gravelMaxHeight), new GuiPageButtonList.GuiLabelEntry(418, I18n.format("tile.stone.granite.name", new Object[0]), false), null, new GuiPageButtonList.GuiSlideEntry(173, I18n.format("createWorld.customize.custom.size", new Object[0]), false, this, 1.0f, 50.0f, this.settings.graniteSize), new GuiPageButtonList.GuiSlideEntry(174, I18n.format("createWorld.customize.custom.count", new Object[0]), false, this, 0.0f, 40.0f, this.settings.graniteCount), new GuiPageButtonList.GuiSlideEntry(175, I18n.format("createWorld.customize.custom.minHeight", new Object[0]), false, this, 0.0f, 255.0f, this.settings.graniteMinHeight), new GuiPageButtonList.GuiSlideEntry(176, I18n.format("createWorld.customize.custom.maxHeight", new Object[0]), false, this, 0.0f, 255.0f, this.settings.graniteMaxHeight), new GuiPageButtonList.GuiLabelEntry(419, I18n.format("tile.stone.diorite.name", new Object[0]), false), null, new GuiPageButtonList.GuiSlideEntry(177, I18n.format("createWorld.customize.custom.size", new Object[0]), false, this, 1.0f, 50.0f, this.settings.dioriteSize), new GuiPageButtonList.GuiSlideEntry(178, I18n.format("createWorld.customize.custom.count", new Object[0]), false, this, 0.0f, 40.0f, this.settings.dioriteCount), new GuiPageButtonList.GuiSlideEntry(179, I18n.format("createWorld.customize.custom.minHeight", new Object[0]), false, this, 0.0f, 255.0f, this.settings.dioriteMinHeight), new GuiPageButtonList.GuiSlideEntry(180, I18n.format("createWorld.customize.custom.maxHeight", new Object[0]), false, this, 0.0f, 255.0f, this.settings.dioriteMaxHeight), new GuiPageButtonList.GuiLabelEntry(420, I18n.format("tile.stone.andesite.name", new Object[0]), false), null, new GuiPageButtonList.GuiSlideEntry(181, I18n.format("createWorld.customize.custom.size", new Object[0]), false, this, 1.0f, 50.0f, this.settings.andesiteSize), new GuiPageButtonList.GuiSlideEntry(182, I18n.format("createWorld.customize.custom.count", new Object[0]), false, this, 0.0f, 40.0f, this.settings.andesiteCount), new GuiPageButtonList.GuiSlideEntry(183, I18n.format("createWorld.customize.custom.minHeight", new Object[0]), false, this, 0.0f, 255.0f, this.settings.andesiteMinHeight), new GuiPageButtonList.GuiSlideEntry(184, I18n.format("createWorld.customize.custom.maxHeight", new Object[0]), false, this, 0.0f, 255.0f, this.settings.andesiteMaxHeight), new GuiPageButtonList.GuiLabelEntry(421, I18n.format("tile.oreCoal.name", new Object[0]), false), null, new GuiPageButtonList.GuiSlideEntry(185, I18n.format("createWorld.customize.custom.size", new Object[0]), false, this, 1.0f, 50.0f, this.settings.coalSize), new GuiPageButtonList.GuiSlideEntry(186, I18n.format("createWorld.customize.custom.count", new Object[0]), false, this, 0.0f, 40.0f, this.settings.coalCount), new GuiPageButtonList.GuiSlideEntry(187, I18n.format("createWorld.customize.custom.minHeight", new Object[0]), false, this, 0.0f, 255.0f, this.settings.coalMinHeight), new GuiPageButtonList.GuiSlideEntry(189, I18n.format("createWorld.customize.custom.maxHeight", new Object[0]), false, this, 0.0f, 255.0f, this.settings.coalMaxHeight), new GuiPageButtonList.GuiLabelEntry(422, I18n.format("tile.oreIron.name", new Object[0]), false), null, new GuiPageButtonList.GuiSlideEntry(190, I18n.format("createWorld.customize.custom.size", new Object[0]), false, this, 1.0f, 50.0f, this.settings.ironSize), new GuiPageButtonList.GuiSlideEntry(191, I18n.format("createWorld.customize.custom.count", new Object[0]), false, this, 0.0f, 40.0f, this.settings.ironCount), new GuiPageButtonList.GuiSlideEntry(192, I18n.format("createWorld.customize.custom.minHeight", new Object[0]), false, this, 0.0f, 255.0f, this.settings.ironMinHeight), new GuiPageButtonList.GuiSlideEntry(193, I18n.format("createWorld.customize.custom.maxHeight", new Object[0]), false, this, 0.0f, 255.0f, this.settings.ironMaxHeight), new GuiPageButtonList.GuiLabelEntry(423, I18n.format("tile.oreGold.name", new Object[0]), false), null, new GuiPageButtonList.GuiSlideEntry(194, I18n.format("createWorld.customize.custom.size", new Object[0]), false, this, 1.0f, 50.0f, this.settings.goldSize), new GuiPageButtonList.GuiSlideEntry(195, I18n.format("createWorld.customize.custom.count", new Object[0]), false, this, 0.0f, 40.0f, this.settings.goldCount), new GuiPageButtonList.GuiSlideEntry(196, I18n.format("createWorld.customize.custom.minHeight", new Object[0]), false, this, 0.0f, 255.0f, this.settings.goldMinHeight), new GuiPageButtonList.GuiSlideEntry(197, I18n.format("createWorld.customize.custom.maxHeight", new Object[0]), false, this, 0.0f, 255.0f, this.settings.goldMaxHeight), new GuiPageButtonList.GuiLabelEntry(424, I18n.format("tile.oreRedstone.name", new Object[0]), false), null, new GuiPageButtonList.GuiSlideEntry(198, I18n.format("createWorld.customize.custom.size", new Object[0]), false, this, 1.0f, 50.0f, this.settings.redstoneSize), new GuiPageButtonList.GuiSlideEntry(199, I18n.format("createWorld.customize.custom.count", new Object[0]), false, this, 0.0f, 40.0f, this.settings.redstoneCount), new GuiPageButtonList.GuiSlideEntry(200, I18n.format("createWorld.customize.custom.minHeight", new Object[0]), false, this, 0.0f, 255.0f, this.settings.redstoneMinHeight), new GuiPageButtonList.GuiSlideEntry(201, I18n.format("createWorld.customize.custom.maxHeight", new Object[0]), false, this, 0.0f, 255.0f, this.settings.redstoneMaxHeight), new GuiPageButtonList.GuiLabelEntry(425, I18n.format("tile.oreDiamond.name", new Object[0]), false), null, new GuiPageButtonList.GuiSlideEntry(202, I18n.format("createWorld.customize.custom.size", new Object[0]), false, this, 1.0f, 50.0f, this.settings.diamondSize), new GuiPageButtonList.GuiSlideEntry(203, I18n.format("createWorld.customize.custom.count", new Object[0]), false, this, 0.0f, 40.0f, this.settings.diamondCount), new GuiPageButtonList.GuiSlideEntry(204, I18n.format("createWorld.customize.custom.minHeight", new Object[0]), false, this, 0.0f, 255.0f, this.settings.diamondMinHeight), new GuiPageButtonList.GuiSlideEntry(205, I18n.format("createWorld.customize.custom.maxHeight", new Object[0]), false, this, 0.0f, 255.0f, this.settings.diamondMaxHeight), new GuiPageButtonList.GuiLabelEntry(426, I18n.format("tile.oreLapis.name", new Object[0]), false), null, new GuiPageButtonList.GuiSlideEntry(206, I18n.format("createWorld.customize.custom.size", new Object[0]), false, this, 1.0f, 50.0f, this.settings.lapisSize), new GuiPageButtonList.GuiSlideEntry(207, I18n.format("createWorld.customize.custom.count", new Object[0]), false, this, 0.0f, 40.0f, this.settings.lapisCount), new GuiPageButtonList.GuiSlideEntry(208, I18n.format("createWorld.customize.custom.center", new Object[0]), false, this, 0.0f, 255.0f, this.settings.lapisCenterHeight), new GuiPageButtonList.GuiSlideEntry(209, I18n.format("createWorld.customize.custom.spread", new Object[0]), false, this, 0.0f, 255.0f, this.settings.lapisSpread)};
        GuiPageButtonList.GuiListEntry[] lvt_3_1_ = new GuiPageButtonList.GuiListEntry[]{new GuiPageButtonList.GuiSlideEntry(100, I18n.format("createWorld.customize.custom.mainNoiseScaleX", new Object[0]), false, this, 1.0f, 5000.0f, this.settings.mainNoiseScaleX), new GuiPageButtonList.GuiSlideEntry(101, I18n.format("createWorld.customize.custom.mainNoiseScaleY", new Object[0]), false, this, 1.0f, 5000.0f, this.settings.mainNoiseScaleY), new GuiPageButtonList.GuiSlideEntry(102, I18n.format("createWorld.customize.custom.mainNoiseScaleZ", new Object[0]), false, this, 1.0f, 5000.0f, this.settings.mainNoiseScaleZ), new GuiPageButtonList.GuiSlideEntry(103, I18n.format("createWorld.customize.custom.depthNoiseScaleX", new Object[0]), false, this, 1.0f, 2000.0f, this.settings.depthNoiseScaleX), new GuiPageButtonList.GuiSlideEntry(104, I18n.format("createWorld.customize.custom.depthNoiseScaleZ", new Object[0]), false, this, 1.0f, 2000.0f, this.settings.depthNoiseScaleZ), new GuiPageButtonList.GuiSlideEntry(105, I18n.format("createWorld.customize.custom.depthNoiseScaleExponent", new Object[0]), false, this, 0.01f, 20.0f, this.settings.depthNoiseScaleExponent), new GuiPageButtonList.GuiSlideEntry(106, I18n.format("createWorld.customize.custom.baseSize", new Object[0]), false, this, 1.0f, 25.0f, this.settings.baseSize), new GuiPageButtonList.GuiSlideEntry(107, I18n.format("createWorld.customize.custom.coordinateScale", new Object[0]), false, this, 1.0f, 6000.0f, this.settings.coordinateScale), new GuiPageButtonList.GuiSlideEntry(108, I18n.format("createWorld.customize.custom.heightScale", new Object[0]), false, this, 1.0f, 6000.0f, this.settings.heightScale), new GuiPageButtonList.GuiSlideEntry(109, I18n.format("createWorld.customize.custom.stretchY", new Object[0]), false, this, 0.01f, 50.0f, this.settings.stretchY), new GuiPageButtonList.GuiSlideEntry(110, I18n.format("createWorld.customize.custom.upperLimitScale", new Object[0]), false, this, 1.0f, 5000.0f, this.settings.upperLimitScale), new GuiPageButtonList.GuiSlideEntry(111, I18n.format("createWorld.customize.custom.lowerLimitScale", new Object[0]), false, this, 1.0f, 5000.0f, this.settings.lowerLimitScale), new GuiPageButtonList.GuiSlideEntry(112, I18n.format("createWorld.customize.custom.biomeDepthWeight", new Object[0]), false, this, 1.0f, 20.0f, this.settings.biomeDepthWeight), new GuiPageButtonList.GuiSlideEntry(113, I18n.format("createWorld.customize.custom.biomeDepthOffset", new Object[0]), false, this, 0.0f, 20.0f, this.settings.biomeDepthOffset), new GuiPageButtonList.GuiSlideEntry(114, I18n.format("createWorld.customize.custom.biomeScaleWeight", new Object[0]), false, this, 1.0f, 20.0f, this.settings.biomeScaleWeight), new GuiPageButtonList.GuiSlideEntry(115, I18n.format("createWorld.customize.custom.biomeScaleOffset", new Object[0]), false, this, 0.0f, 20.0f, this.settings.biomeScaleOffset)};
        GuiPageButtonList.GuiListEntry[] lvt_4_1_ = new GuiPageButtonList.GuiListEntry[]{new GuiPageButtonList.GuiLabelEntry(400, I18n.format("createWorld.customize.custom.mainNoiseScaleX", new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(132, String.format("%5.3f", Float.valueOf(this.settings.mainNoiseScaleX)), false, this.numberFilter), new GuiPageButtonList.GuiLabelEntry(401, I18n.format("createWorld.customize.custom.mainNoiseScaleY", new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(133, String.format("%5.3f", Float.valueOf(this.settings.mainNoiseScaleY)), false, this.numberFilter), new GuiPageButtonList.GuiLabelEntry(402, I18n.format("createWorld.customize.custom.mainNoiseScaleZ", new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(134, String.format("%5.3f", Float.valueOf(this.settings.mainNoiseScaleZ)), false, this.numberFilter), new GuiPageButtonList.GuiLabelEntry(403, I18n.format("createWorld.customize.custom.depthNoiseScaleX", new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(135, String.format("%5.3f", Float.valueOf(this.settings.depthNoiseScaleX)), false, this.numberFilter), new GuiPageButtonList.GuiLabelEntry(404, I18n.format("createWorld.customize.custom.depthNoiseScaleZ", new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(136, String.format("%5.3f", Float.valueOf(this.settings.depthNoiseScaleZ)), false, this.numberFilter), new GuiPageButtonList.GuiLabelEntry(405, I18n.format("createWorld.customize.custom.depthNoiseScaleExponent", new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(137, String.format("%2.3f", Float.valueOf(this.settings.depthNoiseScaleExponent)), false, this.numberFilter), new GuiPageButtonList.GuiLabelEntry(406, I18n.format("createWorld.customize.custom.baseSize", new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(138, String.format("%2.3f", Float.valueOf(this.settings.baseSize)), false, this.numberFilter), new GuiPageButtonList.GuiLabelEntry(407, I18n.format("createWorld.customize.custom.coordinateScale", new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(139, String.format("%5.3f", Float.valueOf(this.settings.coordinateScale)), false, this.numberFilter), new GuiPageButtonList.GuiLabelEntry(408, I18n.format("createWorld.customize.custom.heightScale", new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(140, String.format("%5.3f", Float.valueOf(this.settings.heightScale)), false, this.numberFilter), new GuiPageButtonList.GuiLabelEntry(409, I18n.format("createWorld.customize.custom.stretchY", new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(141, String.format("%2.3f", Float.valueOf(this.settings.stretchY)), false, this.numberFilter), new GuiPageButtonList.GuiLabelEntry(410, I18n.format("createWorld.customize.custom.upperLimitScale", new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(142, String.format("%5.3f", Float.valueOf(this.settings.upperLimitScale)), false, this.numberFilter), new GuiPageButtonList.GuiLabelEntry(411, I18n.format("createWorld.customize.custom.lowerLimitScale", new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(143, String.format("%5.3f", Float.valueOf(this.settings.lowerLimitScale)), false, this.numberFilter), new GuiPageButtonList.GuiLabelEntry(412, I18n.format("createWorld.customize.custom.biomeDepthWeight", new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(144, String.format("%2.3f", Float.valueOf(this.settings.biomeDepthWeight)), false, this.numberFilter), new GuiPageButtonList.GuiLabelEntry(413, I18n.format("createWorld.customize.custom.biomeDepthOffset", new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(145, String.format("%2.3f", Float.valueOf(this.settings.biomeDepthOffset)), false, this.numberFilter), new GuiPageButtonList.GuiLabelEntry(414, I18n.format("createWorld.customize.custom.biomeScaleWeight", new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(146, String.format("%2.3f", Float.valueOf(this.settings.biomeScaleWeight)), false, this.numberFilter), new GuiPageButtonList.GuiLabelEntry(415, I18n.format("createWorld.customize.custom.biomeScaleOffset", new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(147, String.format("%2.3f", Float.valueOf(this.settings.biomeScaleOffset)), false, this.numberFilter)};
        this.list = new GuiPageButtonList(this.mc, this.width, this.height, 32, this.height - 32, 25, this, lvt_1_1_, lvt_2_1_, lvt_3_1_, lvt_4_1_);
        for (int lvt_5_1_ = 0; lvt_5_1_ < 4; ++lvt_5_1_) {
            this.pageNames[lvt_5_1_] = I18n.format("createWorld.customize.custom.page" + lvt_5_1_, new Object[0]);
        }
        this.updatePageControls();
    }

    public String saveValues() {
        return this.settings.toString().replace("\n", "");
    }

    public void loadValues(String p_loadValues_1_) {
        this.settings = p_loadValues_1_ != null && !p_loadValues_1_.isEmpty() ? ChunkProviderSettings.Factory.jsonToFactory(p_loadValues_1_) : new ChunkProviderSettings.Factory();
    }

    @Override
    public void setEntryValue(int p_setEntryValue_1_, String p_setEntryValue_2_) {
        float lvt_3_1_ = 0.0f;
        try {
            lvt_3_1_ = Float.parseFloat(p_setEntryValue_2_);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        float lvt_4_1_ = 0.0f;
        switch (p_setEntryValue_1_) {
            case 139: {
                lvt_4_1_ = this.settings.coordinateScale = MathHelper.clamp(lvt_3_1_, 1.0f, 6000.0f);
                break;
            }
            case 140: {
                lvt_4_1_ = this.settings.heightScale = MathHelper.clamp(lvt_3_1_, 1.0f, 6000.0f);
                break;
            }
            case 142: {
                lvt_4_1_ = this.settings.upperLimitScale = MathHelper.clamp(lvt_3_1_, 1.0f, 5000.0f);
                break;
            }
            case 143: {
                lvt_4_1_ = this.settings.lowerLimitScale = MathHelper.clamp(lvt_3_1_, 1.0f, 5000.0f);
                break;
            }
            case 135: {
                lvt_4_1_ = this.settings.depthNoiseScaleX = MathHelper.clamp(lvt_3_1_, 1.0f, 2000.0f);
                break;
            }
            case 136: {
                lvt_4_1_ = this.settings.depthNoiseScaleZ = MathHelper.clamp(lvt_3_1_, 1.0f, 2000.0f);
                break;
            }
            case 137: {
                lvt_4_1_ = this.settings.depthNoiseScaleExponent = MathHelper.clamp(lvt_3_1_, 0.01f, 20.0f);
                break;
            }
            case 132: {
                lvt_4_1_ = this.settings.mainNoiseScaleX = MathHelper.clamp(lvt_3_1_, 1.0f, 5000.0f);
                break;
            }
            case 133: {
                lvt_4_1_ = this.settings.mainNoiseScaleY = MathHelper.clamp(lvt_3_1_, 1.0f, 5000.0f);
                break;
            }
            case 134: {
                lvt_4_1_ = this.settings.mainNoiseScaleZ = MathHelper.clamp(lvt_3_1_, 1.0f, 5000.0f);
                break;
            }
            case 138: {
                lvt_4_1_ = this.settings.baseSize = MathHelper.clamp(lvt_3_1_, 1.0f, 25.0f);
                break;
            }
            case 141: {
                lvt_4_1_ = this.settings.stretchY = MathHelper.clamp(lvt_3_1_, 0.01f, 50.0f);
                break;
            }
            case 144: {
                lvt_4_1_ = this.settings.biomeDepthWeight = MathHelper.clamp(lvt_3_1_, 1.0f, 20.0f);
                break;
            }
            case 145: {
                lvt_4_1_ = this.settings.biomeDepthOffset = MathHelper.clamp(lvt_3_1_, 0.0f, 20.0f);
                break;
            }
            case 146: {
                lvt_4_1_ = this.settings.biomeScaleWeight = MathHelper.clamp(lvt_3_1_, 1.0f, 20.0f);
                break;
            }
            case 147: {
                lvt_4_1_ = this.settings.biomeScaleOffset = MathHelper.clamp(lvt_3_1_, 0.0f, 20.0f);
            }
        }
        if (lvt_4_1_ != lvt_3_1_ && lvt_3_1_ != 0.0f) {
            ((GuiTextField)this.list.getComponent(p_setEntryValue_1_)).setText(this.getFormattedValue(p_setEntryValue_1_, lvt_4_1_));
        }
        ((GuiSlider)this.list.getComponent(p_setEntryValue_1_ - 132 + 100)).setSliderValue(lvt_4_1_, false);
        if (!this.settings.equals(this.defaultSettings)) {
            this.setSettingsModified(true);
        }
    }

    private void setSettingsModified(boolean p_setSettingsModified_1_) {
        this.settingsModified = p_setSettingsModified_1_;
        this.defaults.enabled = p_setSettingsModified_1_;
    }

    @Override
    public String getText(int p_getText_1_, String p_getText_2_, float p_getText_3_) {
        return p_getText_2_ + ": " + this.getFormattedValue(p_getText_1_, p_getText_3_);
    }

    private String getFormattedValue(int p_getFormattedValue_1_, float p_getFormattedValue_2_) {
        switch (p_getFormattedValue_1_) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 139: 
            case 140: 
            case 142: 
            case 143: {
                return String.format("%5.3f", Float.valueOf(p_getFormattedValue_2_));
            }
            case 105: 
            case 106: 
            case 109: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 137: 
            case 138: 
            case 141: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                return String.format("%2.3f", Float.valueOf(p_getFormattedValue_2_));
            }
            case 162: {
                if (p_getFormattedValue_2_ < 0.0f) {
                    return I18n.format("gui.all", new Object[0]);
                }
                if ((int)p_getFormattedValue_2_ >= Biome.getIdForBiome(Biomes.HELL)) {
                    Biome lvt_3_1_ = Biome.getBiomeForId((int)p_getFormattedValue_2_ + 2);
                    return lvt_3_1_ != null ? lvt_3_1_.getBiomeName() : "?";
                }
                Biome lvt_3_2_ = Biome.getBiomeForId((int)p_getFormattedValue_2_);
                return lvt_3_2_ != null ? lvt_3_2_.getBiomeName() : "?";
            }
        }
        return String.format("%d", (int)p_getFormattedValue_2_);
    }

    @Override
    public void setEntryValue(int p_setEntryValue_1_, boolean p_setEntryValue_2_) {
        switch (p_setEntryValue_1_) {
            case 148: {
                this.settings.useCaves = p_setEntryValue_2_;
                break;
            }
            case 149: {
                this.settings.useDungeons = p_setEntryValue_2_;
                break;
            }
            case 150: {
                this.settings.useStrongholds = p_setEntryValue_2_;
                break;
            }
            case 151: {
                this.settings.useVillages = p_setEntryValue_2_;
                break;
            }
            case 152: {
                this.settings.useMineShafts = p_setEntryValue_2_;
                break;
            }
            case 153: {
                this.settings.useTemples = p_setEntryValue_2_;
                break;
            }
            case 154: {
                this.settings.useRavines = p_setEntryValue_2_;
                break;
            }
            case 210: {
                this.settings.useMonuments = p_setEntryValue_2_;
                break;
            }
            case 211: {
                this.settings.useMansions = p_setEntryValue_2_;
                break;
            }
            case 155: {
                this.settings.useWaterLakes = p_setEntryValue_2_;
                break;
            }
            case 156: {
                this.settings.useLavaLakes = p_setEntryValue_2_;
                break;
            }
            case 161: {
                this.settings.useLavaOceans = p_setEntryValue_2_;
            }
        }
        if (!this.settings.equals(this.defaultSettings)) {
            this.setSettingsModified(true);
        }
    }

    @Override
    public void setEntryValue(int p_setEntryValue_1_, float p_setEntryValue_2_) {
        Gui lvt_3_1_;
        switch (p_setEntryValue_1_) {
            case 107: {
                this.settings.coordinateScale = p_setEntryValue_2_;
                break;
            }
            case 108: {
                this.settings.heightScale = p_setEntryValue_2_;
                break;
            }
            case 110: {
                this.settings.upperLimitScale = p_setEntryValue_2_;
                break;
            }
            case 111: {
                this.settings.lowerLimitScale = p_setEntryValue_2_;
                break;
            }
            case 103: {
                this.settings.depthNoiseScaleX = p_setEntryValue_2_;
                break;
            }
            case 104: {
                this.settings.depthNoiseScaleZ = p_setEntryValue_2_;
                break;
            }
            case 105: {
                this.settings.depthNoiseScaleExponent = p_setEntryValue_2_;
                break;
            }
            case 100: {
                this.settings.mainNoiseScaleX = p_setEntryValue_2_;
                break;
            }
            case 101: {
                this.settings.mainNoiseScaleY = p_setEntryValue_2_;
                break;
            }
            case 102: {
                this.settings.mainNoiseScaleZ = p_setEntryValue_2_;
                break;
            }
            case 106: {
                this.settings.baseSize = p_setEntryValue_2_;
                break;
            }
            case 109: {
                this.settings.stretchY = p_setEntryValue_2_;
                break;
            }
            case 112: {
                this.settings.biomeDepthWeight = p_setEntryValue_2_;
                break;
            }
            case 113: {
                this.settings.biomeDepthOffset = p_setEntryValue_2_;
                break;
            }
            case 114: {
                this.settings.biomeScaleWeight = p_setEntryValue_2_;
                break;
            }
            case 115: {
                this.settings.biomeScaleOffset = p_setEntryValue_2_;
                break;
            }
            case 157: {
                this.settings.dungeonChance = (int)p_setEntryValue_2_;
                break;
            }
            case 158: {
                this.settings.waterLakeChance = (int)p_setEntryValue_2_;
                break;
            }
            case 159: {
                this.settings.lavaLakeChance = (int)p_setEntryValue_2_;
                break;
            }
            case 160: {
                this.settings.seaLevel = (int)p_setEntryValue_2_;
                break;
            }
            case 162: {
                this.settings.fixedBiome = (int)p_setEntryValue_2_;
                break;
            }
            case 163: {
                this.settings.biomeSize = (int)p_setEntryValue_2_;
                break;
            }
            case 164: {
                this.settings.riverSize = (int)p_setEntryValue_2_;
                break;
            }
            case 166: {
                this.settings.dirtCount = (int)p_setEntryValue_2_;
                break;
            }
            case 165: {
                this.settings.dirtSize = (int)p_setEntryValue_2_;
                break;
            }
            case 167: {
                this.settings.dirtMinHeight = (int)p_setEntryValue_2_;
                break;
            }
            case 168: {
                this.settings.dirtMaxHeight = (int)p_setEntryValue_2_;
                break;
            }
            case 170: {
                this.settings.gravelCount = (int)p_setEntryValue_2_;
                break;
            }
            case 169: {
                this.settings.gravelSize = (int)p_setEntryValue_2_;
                break;
            }
            case 171: {
                this.settings.gravelMinHeight = (int)p_setEntryValue_2_;
                break;
            }
            case 172: {
                this.settings.gravelMaxHeight = (int)p_setEntryValue_2_;
                break;
            }
            case 174: {
                this.settings.graniteCount = (int)p_setEntryValue_2_;
                break;
            }
            case 173: {
                this.settings.graniteSize = (int)p_setEntryValue_2_;
                break;
            }
            case 175: {
                this.settings.graniteMinHeight = (int)p_setEntryValue_2_;
                break;
            }
            case 176: {
                this.settings.graniteMaxHeight = (int)p_setEntryValue_2_;
                break;
            }
            case 178: {
                this.settings.dioriteCount = (int)p_setEntryValue_2_;
                break;
            }
            case 177: {
                this.settings.dioriteSize = (int)p_setEntryValue_2_;
                break;
            }
            case 179: {
                this.settings.dioriteMinHeight = (int)p_setEntryValue_2_;
                break;
            }
            case 180: {
                this.settings.dioriteMaxHeight = (int)p_setEntryValue_2_;
                break;
            }
            case 182: {
                this.settings.andesiteCount = (int)p_setEntryValue_2_;
                break;
            }
            case 181: {
                this.settings.andesiteSize = (int)p_setEntryValue_2_;
                break;
            }
            case 183: {
                this.settings.andesiteMinHeight = (int)p_setEntryValue_2_;
                break;
            }
            case 184: {
                this.settings.andesiteMaxHeight = (int)p_setEntryValue_2_;
                break;
            }
            case 186: {
                this.settings.coalCount = (int)p_setEntryValue_2_;
                break;
            }
            case 185: {
                this.settings.coalSize = (int)p_setEntryValue_2_;
                break;
            }
            case 187: {
                this.settings.coalMinHeight = (int)p_setEntryValue_2_;
                break;
            }
            case 189: {
                this.settings.coalMaxHeight = (int)p_setEntryValue_2_;
                break;
            }
            case 191: {
                this.settings.ironCount = (int)p_setEntryValue_2_;
                break;
            }
            case 190: {
                this.settings.ironSize = (int)p_setEntryValue_2_;
                break;
            }
            case 192: {
                this.settings.ironMinHeight = (int)p_setEntryValue_2_;
                break;
            }
            case 193: {
                this.settings.ironMaxHeight = (int)p_setEntryValue_2_;
                break;
            }
            case 195: {
                this.settings.goldCount = (int)p_setEntryValue_2_;
                break;
            }
            case 194: {
                this.settings.goldSize = (int)p_setEntryValue_2_;
                break;
            }
            case 196: {
                this.settings.goldMinHeight = (int)p_setEntryValue_2_;
                break;
            }
            case 197: {
                this.settings.goldMaxHeight = (int)p_setEntryValue_2_;
                break;
            }
            case 199: {
                this.settings.redstoneCount = (int)p_setEntryValue_2_;
                break;
            }
            case 198: {
                this.settings.redstoneSize = (int)p_setEntryValue_2_;
                break;
            }
            case 200: {
                this.settings.redstoneMinHeight = (int)p_setEntryValue_2_;
                break;
            }
            case 201: {
                this.settings.redstoneMaxHeight = (int)p_setEntryValue_2_;
                break;
            }
            case 203: {
                this.settings.diamondCount = (int)p_setEntryValue_2_;
                break;
            }
            case 202: {
                this.settings.diamondSize = (int)p_setEntryValue_2_;
                break;
            }
            case 204: {
                this.settings.diamondMinHeight = (int)p_setEntryValue_2_;
                break;
            }
            case 205: {
                this.settings.diamondMaxHeight = (int)p_setEntryValue_2_;
                break;
            }
            case 207: {
                this.settings.lapisCount = (int)p_setEntryValue_2_;
                break;
            }
            case 206: {
                this.settings.lapisSize = (int)p_setEntryValue_2_;
                break;
            }
            case 208: {
                this.settings.lapisCenterHeight = (int)p_setEntryValue_2_;
                break;
            }
            case 209: {
                this.settings.lapisSpread = (int)p_setEntryValue_2_;
            }
        }
        if (p_setEntryValue_1_ >= 100 && p_setEntryValue_1_ < 116 && (lvt_3_1_ = this.list.getComponent(p_setEntryValue_1_ - 100 + 132)) != null) {
            ((GuiTextField)lvt_3_1_).setText(this.getFormattedValue(p_setEntryValue_1_, p_setEntryValue_2_));
        }
        if (!this.settings.equals(this.defaultSettings)) {
            this.setSettingsModified(true);
        }
    }

    @Override
    protected void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
        if (!p_actionPerformed_1_.enabled) {
            return;
        }
        switch (p_actionPerformed_1_.id) {
            case 300: {
                this.parent.chunkProviderSettingsJson = this.settings.toString();
                this.mc.displayGuiScreen(this.parent);
                break;
            }
            case 305: {
                this.mc.displayGuiScreen(new GuiScreenCustomizePresets(this));
                break;
            }
            case 301: {
                for (int lvt_2_1_ = 0; lvt_2_1_ < this.list.getSize(); ++lvt_2_1_) {
                    Gui lvt_5_2_;
                    GuiPageButtonList.GuiEntry lvt_3_1_ = this.list.getListEntry(lvt_2_1_);
                    Gui lvt_4_1_ = lvt_3_1_.getComponent1();
                    if (lvt_4_1_ instanceof GuiButton) {
                        GuiButton lvt_5_1_ = (GuiButton)lvt_4_1_;
                        if (lvt_5_1_ instanceof GuiSlider) {
                            float lvt_6_1_ = ((GuiSlider)lvt_5_1_).getSliderPosition() * (0.75f + this.random.nextFloat() * 0.5f) + (this.random.nextFloat() * 0.1f - 0.05f);
                            ((GuiSlider)lvt_5_1_).setSliderPosition(MathHelper.clamp(lvt_6_1_, 0.0f, 1.0f));
                        } else if (lvt_5_1_ instanceof GuiListButton) {
                            ((GuiListButton)lvt_5_1_).setValue(this.random.nextBoolean());
                        }
                    }
                    if (!((lvt_5_2_ = lvt_3_1_.getComponent2()) instanceof GuiButton)) continue;
                    GuiButton lvt_6_2_ = (GuiButton)lvt_5_2_;
                    if (lvt_6_2_ instanceof GuiSlider) {
                        float lvt_7_1_ = ((GuiSlider)lvt_6_2_).getSliderPosition() * (0.75f + this.random.nextFloat() * 0.5f) + (this.random.nextFloat() * 0.1f - 0.05f);
                        ((GuiSlider)lvt_6_2_).setSliderPosition(MathHelper.clamp(lvt_7_1_, 0.0f, 1.0f));
                        continue;
                    }
                    if (!(lvt_6_2_ instanceof GuiListButton)) continue;
                    ((GuiListButton)lvt_6_2_).setValue(this.random.nextBoolean());
                }
                break;
            }
            case 302: {
                this.list.previousPage();
                this.updatePageControls();
                break;
            }
            case 303: {
                this.list.nextPage();
                this.updatePageControls();
                break;
            }
            case 304: {
                if (!this.settingsModified) break;
                this.enterConfirmation(304);
                break;
            }
            case 307: {
                this.confirmMode = 0;
                this.exitConfirmation();
                break;
            }
            case 306: {
                this.exitConfirmation();
            }
        }
    }

    private void restoreDefaults() {
        this.settings.setDefaults();
        this.createPagedList();
        this.setSettingsModified(false);
    }

    private void enterConfirmation(int p_enterConfirmation_1_) {
        this.confirmMode = p_enterConfirmation_1_;
        this.setConfirmationControls(true);
    }

    private void exitConfirmation() throws IOException {
        switch (this.confirmMode) {
            case 300: {
                this.actionPerformed((GuiListButton)this.list.getComponent(300));
                break;
            }
            case 304: {
                this.restoreDefaults();
            }
        }
        this.confirmMode = 0;
        this.confirmDismissed = true;
        this.setConfirmationControls(false);
    }

    private void setConfirmationControls(boolean p_setConfirmationControls_1_) {
        this.confirm.visible = p_setConfirmationControls_1_;
        this.cancel.visible = p_setConfirmationControls_1_;
        this.randomize.enabled = !p_setConfirmationControls_1_;
        this.done.enabled = !p_setConfirmationControls_1_;
        this.previousPage.enabled = !p_setConfirmationControls_1_;
        this.nextPage.enabled = !p_setConfirmationControls_1_;
        this.defaults.enabled = this.settingsModified && !p_setConfirmationControls_1_;
        this.presets.enabled = !p_setConfirmationControls_1_;
        this.list.setActive(!p_setConfirmationControls_1_);
    }

    private void updatePageControls() {
        this.previousPage.enabled = this.list.getPage() != 0;
        this.nextPage.enabled = this.list.getPage() != this.list.getPageCount() - 1;
        this.subtitle = I18n.format("book.pageIndicator", this.list.getPage() + 1, this.list.getPageCount());
        this.pageTitle = this.pageNames[this.list.getPage()];
        this.randomize.enabled = this.list.getPage() != this.list.getPageCount() - 1;
    }

    @Override
    protected void keyTyped(char p_keyTyped_1_, int p_keyTyped_2_) throws IOException {
        super.keyTyped(p_keyTyped_1_, p_keyTyped_2_);
        if (this.confirmMode != 0) {
            return;
        }
        switch (p_keyTyped_2_) {
            case 208: {
                this.modifyFocusValue(-1.0f);
                break;
            }
            case 200: {
                this.modifyFocusValue(1.0f);
                break;
            }
            default: {
                this.list.onKeyPressed(p_keyTyped_1_, p_keyTyped_2_);
            }
        }
    }

    private void modifyFocusValue(float p_modifyFocusValue_1_) {
        GuiTextField lvt_4_1_;
        Float lvt_5_1_;
        Gui lvt_2_1_ = this.list.getFocusedControl();
        if (!(lvt_2_1_ instanceof GuiTextField)) {
            return;
        }
        float lvt_3_1_ = p_modifyFocusValue_1_;
        if (GuiScreen.isShiftKeyDown()) {
            lvt_3_1_ *= 0.1f;
            if (GuiScreen.isCtrlKeyDown()) {
                lvt_3_1_ *= 0.1f;
            }
        } else if (GuiScreen.isCtrlKeyDown()) {
            lvt_3_1_ *= 10.0f;
            if (GuiScreen.isAltKeyDown()) {
                lvt_3_1_ *= 10.0f;
            }
        }
        if ((lvt_5_1_ = Floats.tryParse((String)(lvt_4_1_ = (GuiTextField)lvt_2_1_).getText())) == null) {
            return;
        }
        lvt_5_1_ = Float.valueOf(lvt_5_1_.floatValue() + lvt_3_1_);
        int lvt_6_1_ = lvt_4_1_.getId();
        String lvt_7_1_ = this.getFormattedValue(lvt_4_1_.getId(), lvt_5_1_.floatValue());
        lvt_4_1_.setText(lvt_7_1_);
        this.setEntryValue(lvt_6_1_, lvt_7_1_);
    }

    @Override
    protected void mouseClicked(int p_mouseClicked_1_, int p_mouseClicked_2_, int p_mouseClicked_3_) throws IOException {
        super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        if (this.confirmMode != 0 || this.confirmDismissed) {
            return;
        }
        this.list.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
    }

    @Override
    protected void mouseReleased(int p_mouseReleased_1_, int p_mouseReleased_2_, int p_mouseReleased_3_) {
        super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_2_, p_mouseReleased_3_);
        if (this.confirmDismissed) {
            this.confirmDismissed = false;
            return;
        }
        if (this.confirmMode != 0) {
            return;
        }
        this.list.mouseReleased(p_mouseReleased_1_, p_mouseReleased_2_, p_mouseReleased_3_);
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        this.drawDefaultBackground();
        this.list.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
        this.drawCenteredString(this.fontRendererObj, this.title, this.width / 2, 2, 0xFFFFFF);
        this.drawCenteredString(this.fontRendererObj, this.subtitle, this.width / 2, 12, 0xFFFFFF);
        this.drawCenteredString(this.fontRendererObj, this.pageTitle, this.width / 2, 22, 0xFFFFFF);
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
        if (this.confirmMode != 0) {
            GuiCustomizeWorldScreen.drawRect(0, 0, this.width, this.height, Integer.MIN_VALUE);
            this.drawHorizontalLine(this.width / 2 - 91, this.width / 2 + 90, 99, -2039584);
            this.drawHorizontalLine(this.width / 2 - 91, this.width / 2 + 90, 185, -6250336);
            this.drawVerticalLine(this.width / 2 - 91, 99, 185, -2039584);
            this.drawVerticalLine(this.width / 2 + 90, 99, 185, -6250336);
            float lvt_4_1_ = 85.0f;
            float lvt_5_1_ = 180.0f;
            GlStateManager.disableLighting();
            GlStateManager.disableFog();
            Tessellator lvt_6_1_ = Tessellator.getInstance();
            VertexBuffer lvt_7_1_ = lvt_6_1_.getBuffer();
            this.mc.getTextureManager().bindTexture(OPTIONS_BACKGROUND);
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            float lvt_8_1_ = 32.0f;
            lvt_7_1_.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
            lvt_7_1_.pos(this.width / 2 - 90, 185.0, 0.0).tex(0.0, 2.65625).color(64, 64, 64, 64).endVertex();
            lvt_7_1_.pos(this.width / 2 + 90, 185.0, 0.0).tex(5.625, 2.65625).color(64, 64, 64, 64).endVertex();
            lvt_7_1_.pos(this.width / 2 + 90, 100.0, 0.0).tex(5.625, 0.0).color(64, 64, 64, 64).endVertex();
            lvt_7_1_.pos(this.width / 2 - 90, 100.0, 0.0).tex(0.0, 0.0).color(64, 64, 64, 64).endVertex();
            lvt_6_1_.draw();
            this.drawCenteredString(this.fontRendererObj, I18n.format("createWorld.customize.custom.confirmTitle", new Object[0]), this.width / 2, 105, 0xFFFFFF);
            this.drawCenteredString(this.fontRendererObj, I18n.format("createWorld.customize.custom.confirm1", new Object[0]), this.width / 2, 125, 0xFFFFFF);
            this.drawCenteredString(this.fontRendererObj, I18n.format("createWorld.customize.custom.confirm2", new Object[0]), this.width / 2, 135, 0xFFFFFF);
            this.confirm.drawButton(this.mc, p_drawScreen_1_, p_drawScreen_2_);
            this.cancel.drawButton(this.mc, p_drawScreen_1_, p_drawScreen_2_);
        }
    }
}

