/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.model.ModelBook;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ContainerEnchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnchantmentNameParts;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.glu.Project;

@SideOnly(value=Side.CLIENT)
public class GuiEnchantment
extends GuiContainer {
    private static final ResourceLocation ENCHANTMENT_TABLE_GUI_TEXTURE = new ResourceLocation("textures/gui/container/enchanting_table.png");
    private static final ResourceLocation ENCHANTMENT_TABLE_BOOK_TEXTURE = new ResourceLocation("textures/entity/enchanting_table_book.png");
    private static final ModelBook MODEL_BOOK = new ModelBook();
    private final InventoryPlayer playerInventory;
    private final Random random = new Random();
    private final ContainerEnchantment container;
    public int ticks;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float open;
    public float oOpen;
    private ItemStack last = ItemStack.EMPTY;
    private final IWorldNameable nameable;

    public GuiEnchantment(InventoryPlayer p_i45502_1_, World p_i45502_2_, IWorldNameable p_i45502_3_) {
        super(new ContainerEnchantment(p_i45502_1_, p_i45502_2_));
        this.playerInventory = p_i45502_1_;
        this.container = (ContainerEnchantment)this.inventorySlots;
        this.nameable = p_i45502_3_;
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int p_drawGuiContainerForegroundLayer_1_, int p_drawGuiContainerForegroundLayer_2_) {
        this.fontRendererObj.drawString(this.nameable.getDisplayName().getUnformattedText(), 12, 5, 0x404040);
        this.fontRendererObj.drawString(this.playerInventory.getDisplayName().getUnformattedText(), 8, this.ySize - 96 + 2, 0x404040);
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        this.tickBook();
    }

    @Override
    protected void mouseClicked(int p_mouseClicked_1_, int p_mouseClicked_2_, int p_mouseClicked_3_) throws IOException {
        super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        int i = (this.width - this.xSize) / 2;
        int j = (this.height - this.ySize) / 2;
        for (int k = 0; k < 3; ++k) {
            int l = p_mouseClicked_1_ - (i + 60);
            int i1 = p_mouseClicked_2_ - (j + 14 + 19 * k);
            if (l < 0 || i1 < 0 || l >= 108 || i1 >= 19 || !this.container.enchantItem(this.mc.player, k)) continue;
            this.mc.playerController.sendEnchantPacket(this.container.windowId, k);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float p_drawGuiContainerBackgroundLayer_1_, int p_drawGuiContainerBackgroundLayer_2_, int p_drawGuiContainerBackgroundLayer_3_) {
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.getTextureManager().bindTexture(ENCHANTMENT_TABLE_GUI_TEXTURE);
        int i = (this.width - this.xSize) / 2;
        int j = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(i, j, 0, 0, this.xSize, this.ySize);
        GlStateManager.pushMatrix();
        GlStateManager.matrixMode(5889);
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        ScaledResolution scaledresolution = new ScaledResolution(this.mc);
        GlStateManager.viewport((scaledresolution.getScaledWidth() - 320) / 2 * scaledresolution.getScaleFactor(), (scaledresolution.getScaledHeight() - 240) / 2 * scaledresolution.getScaleFactor(), 320 * scaledresolution.getScaleFactor(), 240 * scaledresolution.getScaleFactor());
        GlStateManager.translate(-0.34f, 0.23f, 0.0f);
        Project.gluPerspective((float)90.0f, (float)1.3333334f, (float)9.0f, (float)80.0f);
        float f = 1.0f;
        GlStateManager.matrixMode(5888);
        GlStateManager.loadIdentity();
        RenderHelper.enableStandardItemLighting();
        GlStateManager.translate(0.0f, 3.3f, -16.0f);
        GlStateManager.scale(1.0f, 1.0f, 1.0f);
        float f1 = 5.0f;
        GlStateManager.scale(5.0f, 5.0f, 5.0f);
        GlStateManager.rotate(180.0f, 0.0f, 0.0f, 1.0f);
        this.mc.getTextureManager().bindTexture(ENCHANTMENT_TABLE_BOOK_TEXTURE);
        GlStateManager.rotate(20.0f, 1.0f, 0.0f, 0.0f);
        float f2 = this.oOpen + (this.open - this.oOpen) * p_drawGuiContainerBackgroundLayer_1_;
        GlStateManager.translate((1.0f - f2) * 0.2f, (1.0f - f2) * 0.1f, (1.0f - f2) * 0.25f);
        GlStateManager.rotate(-(1.0f - f2) * 90.0f - 90.0f, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotate(180.0f, 1.0f, 0.0f, 0.0f);
        float f3 = this.oFlip + (this.flip - this.oFlip) * p_drawGuiContainerBackgroundLayer_1_ + 0.25f;
        float f4 = this.oFlip + (this.flip - this.oFlip) * p_drawGuiContainerBackgroundLayer_1_ + 0.75f;
        f3 = (f3 - (float)MathHelper.fastFloor(f3)) * 1.6f - 0.3f;
        f4 = (f4 - (float)MathHelper.fastFloor(f4)) * 1.6f - 0.3f;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        GlStateManager.enableRescaleNormal();
        MODEL_BOOK.render(null, 0.0f, f3, f4, f2, 0.0f, 0.0625f);
        GlStateManager.disableRescaleNormal();
        RenderHelper.disableStandardItemLighting();
        GlStateManager.matrixMode(5889);
        GlStateManager.viewport(0, 0, this.mc.displayWidth, this.mc.displayHeight);
        GlStateManager.popMatrix();
        GlStateManager.matrixMode(5888);
        GlStateManager.popMatrix();
        RenderHelper.disableStandardItemLighting();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        EnchantmentNameParts.getInstance().reseedRandomGenerator(this.container.xpSeed);
        int k = this.container.getLapisAmount();
        for (int l = 0; l < 3; ++l) {
            int i1 = i + 60;
            int j1 = i1 + 20;
            this.zLevel = 0.0f;
            this.mc.getTextureManager().bindTexture(ENCHANTMENT_TABLE_GUI_TEXTURE);
            int k1 = this.container.enchantLevels[l];
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            if (k1 == 0) {
                this.drawTexturedModalRect(i1, j + 14 + 19 * l, 0, 185, 108, 19);
                continue;
            }
            String s = "" + k1;
            int l1 = 86 - this.fontRendererObj.getStringWidth(s);
            String s1 = EnchantmentNameParts.getInstance().generateNewRandomName(this.fontRendererObj, l1);
            FontRenderer fontrenderer = this.mc.standardGalacticFontRenderer;
            int i2 = 6839882;
            if ((k < l + 1 || this.mc.player.experienceLevel < k1) && !this.mc.player.capabilities.isCreativeMode || this.container.enchantClue[l] == -1) {
                this.drawTexturedModalRect(i1, j + 14 + 19 * l, 0, 185, 108, 19);
                this.drawTexturedModalRect(i1 + 1, j + 15 + 19 * l, 16 * l, 239, 16, 16);
                fontrenderer.drawSplitString(s1, j1, j + 16 + 19 * l, l1, (i2 & 0xFEFEFE) >> 1);
                i2 = 4226832;
            } else {
                int j2 = p_drawGuiContainerBackgroundLayer_2_ - (i + 60);
                int k2 = p_drawGuiContainerBackgroundLayer_3_ - (j + 14 + 19 * l);
                if (j2 >= 0 && k2 >= 0 && j2 < 108 && k2 < 19) {
                    this.drawTexturedModalRect(i1, j + 14 + 19 * l, 0, 204, 108, 19);
                    i2 = 0xFFFF80;
                } else {
                    this.drawTexturedModalRect(i1, j + 14 + 19 * l, 0, 166, 108, 19);
                }
                this.drawTexturedModalRect(i1 + 1, j + 15 + 19 * l, 16 * l, 223, 16, 16);
                fontrenderer.drawSplitString(s1, j1, j + 16 + 19 * l, l1, i2);
                i2 = 8453920;
            }
            fontrenderer = this.mc.fontRendererObj;
            fontrenderer.drawStringWithShadow(s, j1 + 86 - fontrenderer.getStringWidth(s), j + 16 + 19 * l + 7, i2);
        }
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
        boolean flag = this.mc.player.capabilities.isCreativeMode;
        int i = this.container.getLapisAmount();
        for (int j = 0; j < 3; ++j) {
            int k = this.container.enchantLevels[j];
            Enchantment enchantment = Enchantment.getEnchantmentByID(this.container.enchantClue[j]);
            int l = this.container.worldClue[j];
            int i1 = j + 1;
            if (!this.isPointInRegion(60, 14 + 19 * j, 108, 17, p_drawScreen_1_, p_drawScreen_2_) || k <= 0) continue;
            ArrayList list = Lists.newArrayList();
            list.add("" + (Object)((Object)TextFormatting.WHITE) + (Object)((Object)TextFormatting.ITALIC) + I18n.format("container.enchant.clue", enchantment == null ? "" : enchantment.getTranslatedName(l)));
            if (enchantment == null) {
                Collections.addAll(list, "", (Object)((Object)TextFormatting.RED) + I18n.format("forge.container.enchant.limitedEnchantability", new Object[0]));
            } else if (!flag) {
                list.add("");
                if (this.mc.player.experienceLevel < k) {
                    list.add((Object)((Object)TextFormatting.RED) + "Level Requirement: " + this.container.enchantLevels[j]);
                } else {
                    String s = i1 == 1 ? I18n.format("container.enchant.lapis.one", new Object[0]) : I18n.format("container.enchant.lapis.many", i1);
                    TextFormatting textformatting = i >= i1 ? TextFormatting.GRAY : TextFormatting.RED;
                    list.add((Object)((Object)textformatting) + "" + s);
                    s = i1 == 1 ? I18n.format("container.enchant.level.one", new Object[0]) : I18n.format("container.enchant.level.many", i1);
                    list.add((Object)((Object)TextFormatting.GRAY) + "" + s);
                }
            }
            this.drawHoveringText(list, p_drawScreen_1_, p_drawScreen_2_);
            break;
        }
    }

    public void tickBook() {
        ItemStack itemstack = this.inventorySlots.getSlot(0).getStack();
        if (!ItemStack.areItemStacksEqual(itemstack, this.last)) {
            this.last = itemstack;
            do {
                this.flipT += (float)(this.random.nextInt(4) - this.random.nextInt(4));
            } while (!(this.flip > this.flipT + 1.0f) && !(this.flip < this.flipT - 1.0f));
        }
        ++this.ticks;
        this.oFlip = this.flip;
        this.oOpen = this.open;
        boolean flag = false;
        for (int i = 0; i < 3; ++i) {
            if (this.container.enchantLevels[i] == 0) continue;
            flag = true;
        }
        this.open = flag ? (this.open += 0.2f) : (this.open -= 0.2f);
        this.open = MathHelper.clamp(this.open, 0.0f, 1.0f);
        float f1 = (this.flipT - this.flip) * 0.4f;
        float f = 0.2f;
        f1 = MathHelper.clamp(f1, -0.2f, 0.2f);
        this.flipA += (f1 - this.flipA) * 0.9f;
        this.flip += this.flipA;
    }
}

