/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateFlatWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.FlatGeneratorInfo;
import net.minecraft.world.gen.FlatLayerInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiFlatPresets
extends GuiScreen {
    private static final List<LayerItem> FLAT_WORLD_PRESETS = Lists.newArrayList();
    private final GuiCreateFlatWorld parentScreen;
    private String presetsTitle;
    private String presetsShare;
    private String listText;
    private ListSlot list;
    private GuiButton btnSelect;
    private GuiTextField export;

    public GuiFlatPresets(GuiCreateFlatWorld p_i46318_1_) {
        this.parentScreen = p_i46318_1_;
    }

    @Override
    public void initGui() {
        this.buttonList.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.presetsTitle = I18n.format("createWorld.customize.presets.title", new Object[0]);
        this.presetsShare = I18n.format("createWorld.customize.presets.share", new Object[0]);
        this.listText = I18n.format("createWorld.customize.presets.list", new Object[0]);
        this.export = new GuiTextField(2, this.fontRendererObj, 50, 40, this.width - 100, 20);
        this.list = new ListSlot();
        this.export.setMaxStringLength(1230);
        this.export.setText(this.parentScreen.getPreset());
        this.btnSelect = this.addButton(new GuiButton(0, this.width / 2 - 155, this.height - 28, 150, 20, I18n.format("createWorld.customize.presets.select", new Object[0])));
        this.buttonList.add(new GuiButton(1, this.width / 2 + 5, this.height - 28, 150, 20, I18n.format("gui.cancel", new Object[0])));
        this.updateButtonValidity();
    }

    @Override
    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        this.list.handleMouseInput();
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void mouseClicked(int p_mouseClicked_1_, int p_mouseClicked_2_, int p_mouseClicked_3_) throws IOException {
        this.export.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
    }

    @Override
    protected void keyTyped(char p_keyTyped_1_, int p_keyTyped_2_) throws IOException {
        if (!this.export.textboxKeyTyped(p_keyTyped_1_, p_keyTyped_2_)) {
            super.keyTyped(p_keyTyped_1_, p_keyTyped_2_);
        }
    }

    @Override
    protected void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
        if (p_actionPerformed_1_.id == 0 && this.hasValidSelection()) {
            this.parentScreen.setPreset(this.export.getText());
            this.mc.displayGuiScreen(this.parentScreen);
        } else if (p_actionPerformed_1_.id == 1) {
            this.mc.displayGuiScreen(this.parentScreen);
        }
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        this.drawDefaultBackground();
        this.list.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
        this.drawCenteredString(this.fontRendererObj, this.presetsTitle, this.width / 2, 8, 0xFFFFFF);
        this.drawString(this.fontRendererObj, this.presetsShare, 50, 30, 0xA0A0A0);
        this.drawString(this.fontRendererObj, this.listText, 50, 70, 0xA0A0A0);
        this.export.drawTextBox();
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
    }

    @Override
    public void updateScreen() {
        this.export.updateCursorCounter();
        super.updateScreen();
    }

    public void updateButtonValidity() {
        this.btnSelect.enabled = this.hasValidSelection();
    }

    private boolean hasValidSelection() {
        return this.list.selected > -1 && this.list.selected < FLAT_WORLD_PRESETS.size() || this.export.getText().length() > 1;
    }

    private static void registerPreset(String p_registerPreset_0_, Item p_registerPreset_1_, Biome p_registerPreset_2_, List<String> p_registerPreset_3_, FlatLayerInfo ... p_registerPreset_4_) {
        GuiFlatPresets.registerPreset(p_registerPreset_0_, p_registerPreset_1_, 0, p_registerPreset_2_, p_registerPreset_3_, p_registerPreset_4_);
    }

    private static void registerPreset(String p_registerPreset_0_, Item p_registerPreset_1_, int p_registerPreset_2_, Biome p_registerPreset_3_, List<String> p_registerPreset_4_, FlatLayerInfo ... p_registerPreset_5_) {
        FlatGeneratorInfo lvt_6_1_ = new FlatGeneratorInfo();
        for (int lvt_7_1_ = p_registerPreset_5_.length - 1; lvt_7_1_ >= 0; --lvt_7_1_) {
            lvt_6_1_.getFlatLayers().add(p_registerPreset_5_[lvt_7_1_]);
        }
        lvt_6_1_.setBiome(Biome.getIdForBiome(p_registerPreset_3_));
        lvt_6_1_.updateLayers();
        for (String lvt_8_1_ : p_registerPreset_4_) {
            lvt_6_1_.getWorldFeatures().put(lvt_8_1_, Maps.newHashMap());
        }
        FLAT_WORLD_PRESETS.add(new LayerItem(p_registerPreset_1_, p_registerPreset_2_, p_registerPreset_0_, lvt_6_1_.toString()));
    }

    static {
        GuiFlatPresets.registerPreset(I18n.format("createWorld.customize.preset.classic_flat", new Object[0]), Item.getItemFromBlock(Blocks.GRASS), Biomes.PLAINS, Arrays.asList("village"), new FlatLayerInfo(1, Blocks.GRASS), new FlatLayerInfo(2, Blocks.DIRT), new FlatLayerInfo(1, Blocks.BEDROCK));
        GuiFlatPresets.registerPreset(I18n.format("createWorld.customize.preset.tunnelers_dream", new Object[0]), Item.getItemFromBlock(Blocks.STONE), Biomes.EXTREME_HILLS, Arrays.asList("biome_1", "dungeon", "decoration", "stronghold", "mineshaft"), new FlatLayerInfo(1, Blocks.GRASS), new FlatLayerInfo(5, Blocks.DIRT), new FlatLayerInfo(230, Blocks.STONE), new FlatLayerInfo(1, Blocks.BEDROCK));
        GuiFlatPresets.registerPreset(I18n.format("createWorld.customize.preset.water_world", new Object[0]), Items.WATER_BUCKET, Biomes.DEEP_OCEAN, Arrays.asList("biome_1", "oceanmonument"), new FlatLayerInfo(90, Blocks.WATER), new FlatLayerInfo(5, Blocks.SAND), new FlatLayerInfo(5, Blocks.DIRT), new FlatLayerInfo(5, Blocks.STONE), new FlatLayerInfo(1, Blocks.BEDROCK));
        GuiFlatPresets.registerPreset(I18n.format("createWorld.customize.preset.overworld", new Object[0]), Item.getItemFromBlock(Blocks.TALLGRASS), BlockTallGrass.EnumType.GRASS.getMeta(), Biomes.PLAINS, Arrays.asList("village", "biome_1", "decoration", "stronghold", "mineshaft", "dungeon", "lake", "lava_lake"), new FlatLayerInfo(1, Blocks.GRASS), new FlatLayerInfo(3, Blocks.DIRT), new FlatLayerInfo(59, Blocks.STONE), new FlatLayerInfo(1, Blocks.BEDROCK));
        GuiFlatPresets.registerPreset(I18n.format("createWorld.customize.preset.snowy_kingdom", new Object[0]), Item.getItemFromBlock(Blocks.SNOW_LAYER), Biomes.ICE_PLAINS, Arrays.asList("village", "biome_1"), new FlatLayerInfo(1, Blocks.SNOW_LAYER), new FlatLayerInfo(1, Blocks.GRASS), new FlatLayerInfo(3, Blocks.DIRT), new FlatLayerInfo(59, Blocks.STONE), new FlatLayerInfo(1, Blocks.BEDROCK));
        GuiFlatPresets.registerPreset(I18n.format("createWorld.customize.preset.bottomless_pit", new Object[0]), Items.FEATHER, Biomes.PLAINS, Arrays.asList("village", "biome_1"), new FlatLayerInfo(1, Blocks.GRASS), new FlatLayerInfo(3, Blocks.DIRT), new FlatLayerInfo(2, Blocks.COBBLESTONE));
        GuiFlatPresets.registerPreset(I18n.format("createWorld.customize.preset.desert", new Object[0]), Item.getItemFromBlock(Blocks.SAND), Biomes.DESERT, Arrays.asList("village", "biome_1", "decoration", "stronghold", "mineshaft", "dungeon"), new FlatLayerInfo(8, Blocks.SAND), new FlatLayerInfo(52, Blocks.SANDSTONE), new FlatLayerInfo(3, Blocks.STONE), new FlatLayerInfo(1, Blocks.BEDROCK));
        GuiFlatPresets.registerPreset(I18n.format("createWorld.customize.preset.redstone_ready", new Object[0]), Items.REDSTONE, Biomes.DESERT, Collections.<String>emptyList(), new FlatLayerInfo(52, Blocks.SANDSTONE), new FlatLayerInfo(3, Blocks.STONE), new FlatLayerInfo(1, Blocks.BEDROCK));
        GuiFlatPresets.registerPreset(I18n.format("createWorld.customize.preset.the_void", new Object[0]), Item.getItemFromBlock(Blocks.BARRIER), Biomes.VOID, Arrays.asList("decoration"), new FlatLayerInfo(1, Blocks.AIR));
    }

    @SideOnly(value=Side.CLIENT)
    static class LayerItem {
        public Item icon;
        public int iconMetadata;
        public String name;
        public String generatorInfo;

        public LayerItem(Item p_i45518_1_, int p_i45518_2_, String p_i45518_3_, String p_i45518_4_) {
            this.icon = p_i45518_1_;
            this.iconMetadata = p_i45518_2_;
            this.name = p_i45518_3_;
            this.generatorInfo = p_i45518_4_;
        }
    }

    @SideOnly(value=Side.CLIENT)
    class ListSlot
    extends GuiSlot {
        public int selected;

        public ListSlot() {
            super(GuiFlatPresets.this.mc, GuiFlatPresets.this.width, GuiFlatPresets.this.height, 80, GuiFlatPresets.this.height - 37, 24);
            this.selected = -1;
        }

        private void renderIcon(int p_renderIcon_1_, int p_renderIcon_2_, Item p_renderIcon_3_, int p_renderIcon_4_) {
            this.blitSlotBg(p_renderIcon_1_ + 1, p_renderIcon_2_ + 1);
            GlStateManager.enableRescaleNormal();
            RenderHelper.enableGUIStandardItemLighting();
            GuiFlatPresets.this.itemRender.renderItemIntoGUI(new ItemStack(p_renderIcon_3_, 1, p_renderIcon_3_.getHasSubtypes() ? p_renderIcon_4_ : 0), p_renderIcon_1_ + 2, p_renderIcon_2_ + 2);
            RenderHelper.disableStandardItemLighting();
            GlStateManager.disableRescaleNormal();
        }

        private void blitSlotBg(int p_blitSlotBg_1_, int p_blitSlotBg_2_) {
            this.blitSlotIcon(p_blitSlotBg_1_, p_blitSlotBg_2_, 0, 0);
        }

        private void blitSlotIcon(int p_blitSlotIcon_1_, int p_blitSlotIcon_2_, int p_blitSlotIcon_3_, int p_blitSlotIcon_4_) {
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            this.mc.getTextureManager().bindTexture(Gui.STAT_ICONS);
            float lvt_5_1_ = 0.0078125f;
            float lvt_6_1_ = 0.0078125f;
            int lvt_7_1_ = 18;
            int lvt_8_1_ = 18;
            Tessellator lvt_9_1_ = Tessellator.getInstance();
            VertexBuffer lvt_10_1_ = lvt_9_1_.getBuffer();
            lvt_10_1_.begin(7, DefaultVertexFormats.POSITION_TEX);
            lvt_10_1_.pos(p_blitSlotIcon_1_ + 0, p_blitSlotIcon_2_ + 18, GuiFlatPresets.this.zLevel).tex((float)(p_blitSlotIcon_3_ + 0) * 0.0078125f, (float)(p_blitSlotIcon_4_ + 18) * 0.0078125f).endVertex();
            lvt_10_1_.pos(p_blitSlotIcon_1_ + 18, p_blitSlotIcon_2_ + 18, GuiFlatPresets.this.zLevel).tex((float)(p_blitSlotIcon_3_ + 18) * 0.0078125f, (float)(p_blitSlotIcon_4_ + 18) * 0.0078125f).endVertex();
            lvt_10_1_.pos(p_blitSlotIcon_1_ + 18, p_blitSlotIcon_2_ + 0, GuiFlatPresets.this.zLevel).tex((float)(p_blitSlotIcon_3_ + 18) * 0.0078125f, (float)(p_blitSlotIcon_4_ + 0) * 0.0078125f).endVertex();
            lvt_10_1_.pos(p_blitSlotIcon_1_ + 0, p_blitSlotIcon_2_ + 0, GuiFlatPresets.this.zLevel).tex((float)(p_blitSlotIcon_3_ + 0) * 0.0078125f, (float)(p_blitSlotIcon_4_ + 0) * 0.0078125f).endVertex();
            lvt_9_1_.draw();
        }

        @Override
        protected int getSize() {
            return FLAT_WORLD_PRESETS.size();
        }

        @Override
        protected void elementClicked(int p_elementClicked_1_, boolean p_elementClicked_2_, int p_elementClicked_3_, int p_elementClicked_4_) {
            this.selected = p_elementClicked_1_;
            GuiFlatPresets.this.updateButtonValidity();
            GuiFlatPresets.this.export.setText(((LayerItem)FLAT_WORLD_PRESETS.get((int)((GuiFlatPresets)GuiFlatPresets.this).list.selected)).generatorInfo);
        }

        @Override
        protected boolean isSelected(int p_isSelected_1_) {
            return p_isSelected_1_ == this.selected;
        }

        @Override
        protected void drawBackground() {
        }

        @Override
        protected void drawSlot(int p_drawSlot_1_, int p_drawSlot_2_, int p_drawSlot_3_, int p_drawSlot_4_, int p_drawSlot_5_, int p_drawSlot_6_) {
            LayerItem lvt_7_1_ = (LayerItem)FLAT_WORLD_PRESETS.get(p_drawSlot_1_);
            this.renderIcon(p_drawSlot_2_, p_drawSlot_3_, lvt_7_1_.icon, lvt_7_1_.iconMetadata);
            GuiFlatPresets.this.fontRendererObj.drawString(lvt_7_1_.name, p_drawSlot_2_ + 18 + 5, p_drawSlot_3_ + 6, 0xFFFFFF);
        }
    }
}

