/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiGameOver
extends GuiScreen {
    private int enableButtonsTimer;
    private final ITextComponent causeOfDeath;

    public GuiGameOver(ITextComponent p_i46598_1_) {
        this.causeOfDeath = p_i46598_1_;
    }

    @Override
    public void initGui() {
        this.buttonList.clear();
        this.enableButtonsTimer = 0;
        if (this.mc.world.getWorldInfo().isHardcoreModeEnabled()) {
            this.buttonList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 72, I18n.format("deathScreen.spectate", new Object[0])));
            this.buttonList.add(new GuiButton(1, this.width / 2 - 100, this.height / 4 + 96, I18n.format("deathScreen." + (this.mc.isIntegratedServerRunning() ? "deleteWorld" : "leaveServer"), new Object[0])));
        } else {
            this.buttonList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 72, I18n.format("deathScreen.respawn", new Object[0])));
            this.buttonList.add(new GuiButton(1, this.width / 2 - 100, this.height / 4 + 96, I18n.format("deathScreen.titleScreen", new Object[0])));
            if (this.mc.getSession() == null) {
                ((GuiButton)this.buttonList.get((int)1)).enabled = false;
            }
        }
        for (GuiButton lvt_2_1_ : this.buttonList) {
            lvt_2_1_.enabled = false;
        }
    }

    @Override
    protected void keyTyped(char p_keyTyped_1_, int p_keyTyped_2_) throws IOException {
    }

    @Override
    protected void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
        switch (p_actionPerformed_1_.id) {
            case 0: {
                this.mc.player.respawnPlayer();
                this.mc.displayGuiScreen(null);
                break;
            }
            case 1: {
                if (this.mc.world.getWorldInfo().isHardcoreModeEnabled()) {
                    this.mc.displayGuiScreen(new GuiMainMenu());
                    break;
                }
                GuiYesNo lvt_2_1_ = new GuiYesNo(this, I18n.format("deathScreen.quit.confirm", new Object[0]), "", I18n.format("deathScreen.titleScreen", new Object[0]), I18n.format("deathScreen.respawn", new Object[0]), 0);
                this.mc.displayGuiScreen(lvt_2_1_);
                lvt_2_1_.setButtonDelay(20);
            }
        }
    }

    @Override
    public void confirmClicked(boolean p_confirmClicked_1_, int p_confirmClicked_2_) {
        if (p_confirmClicked_1_) {
            if (this.mc.world != null) {
                this.mc.world.sendQuittingDisconnectingPacket();
            }
            this.mc.loadWorld(null);
            this.mc.displayGuiScreen(new GuiMainMenu());
        } else {
            this.mc.player.respawnPlayer();
            this.mc.displayGuiScreen(null);
        }
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        ITextComponent lvt_5_1_;
        boolean lvt_4_1_ = this.mc.world.getWorldInfo().isHardcoreModeEnabled();
        this.drawGradientRect(0, 0, this.width, this.height, 0x60500000, -1602211792);
        GlStateManager.pushMatrix();
        GlStateManager.scale(2.0f, 2.0f, 2.0f);
        this.drawCenteredString(this.fontRendererObj, I18n.format(lvt_4_1_ ? "deathScreen.title.hardcore" : "deathScreen.title", new Object[0]), this.width / 2 / 2, 30, 0xFFFFFF);
        GlStateManager.popMatrix();
        if (this.causeOfDeath != null) {
            this.drawCenteredString(this.fontRendererObj, this.causeOfDeath.getFormattedText(), this.width / 2, 85, 0xFFFFFF);
        }
        this.drawCenteredString(this.fontRendererObj, I18n.format("deathScreen.score", new Object[0]) + ": " + (Object)((Object)TextFormatting.YELLOW) + this.mc.player.getScore(), this.width / 2, 100, 0xFFFFFF);
        if (this.causeOfDeath != null && p_drawScreen_2_ > 85 && p_drawScreen_2_ < 85 + this.fontRendererObj.FONT_HEIGHT && (lvt_5_1_ = this.getClickedComponentAt(p_drawScreen_1_)) != null && lvt_5_1_.getStyle().getHoverEvent() != null) {
            this.handleComponentHover(lvt_5_1_, p_drawScreen_1_, p_drawScreen_2_);
        }
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
    }

    @Nullable
    public ITextComponent getClickedComponentAt(int p_getClickedComponentAt_1_) {
        if (this.causeOfDeath == null) {
            return null;
        }
        int lvt_2_1_ = this.mc.fontRendererObj.getStringWidth(this.causeOfDeath.getFormattedText());
        int lvt_3_1_ = this.width / 2 - lvt_2_1_ / 2;
        int lvt_4_1_ = this.width / 2 + lvt_2_1_ / 2;
        int lvt_5_1_ = lvt_3_1_;
        if (p_getClickedComponentAt_1_ < lvt_3_1_ || p_getClickedComponentAt_1_ > lvt_4_1_) {
            return null;
        }
        for (ITextComponent lvt_7_1_ : this.causeOfDeath) {
            if ((lvt_5_1_ += this.mc.fontRendererObj.getStringWidth(GuiUtilRenderComponents.removeTextColorsIfConfigured(lvt_7_1_.getUnformattedComponentText(), false))) <= p_getClickedComponentAt_1_) continue;
            return lvt_7_1_;
        }
        return null;
    }

    @Override
    public boolean doesGuiPauseGame() {
        return false;
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        ++this.enableButtonsTimer;
        if (this.enableButtonsTimer == 20) {
            for (GuiButton lvt_2_1_ : this.buttonList) {
                lvt_2_1_.enabled = true;
            }
        }
    }
}

