/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiControls;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

@SideOnly(value=Side.CLIENT)
public class GuiKeyBindingList
extends GuiListExtended {
    private final GuiControls controlsScreen;
    private final Minecraft mc;
    private final GuiListExtended.IGuiListEntry[] listEntries;
    private int maxListLabelWidth;

    public GuiKeyBindingList(GuiControls p_i45031_1_, Minecraft p_i45031_2_) {
        super(p_i45031_2_, p_i45031_1_.width + 45, p_i45031_1_.height, 63, p_i45031_1_.height - 32, 20);
        this.controlsScreen = p_i45031_1_;
        this.mc = p_i45031_2_;
        KeyBinding[] akeybinding = (KeyBinding[])ArrayUtils.clone((Object[])p_i45031_2_.gameSettings.keyBindings);
        this.listEntries = new GuiListExtended.IGuiListEntry[akeybinding.length + KeyBinding.getKeybinds().size()];
        Arrays.sort(akeybinding);
        int i = 0;
        String s = null;
        for (KeyBinding keybinding : akeybinding) {
            int j;
            String s1 = keybinding.getKeyCategory();
            if (!s1.equals(s)) {
                s = s1;
                this.listEntries[i++] = new CategoryEntry(s1);
            }
            if ((j = p_i45031_2_.fontRendererObj.getStringWidth(I18n.format(keybinding.getKeyDescription(), new Object[0]))) > this.maxListLabelWidth) {
                this.maxListLabelWidth = j;
            }
            this.listEntries[i++] = new KeyEntry(keybinding);
        }
    }

    @Override
    protected int getSize() {
        return this.listEntries.length;
    }

    @Override
    public GuiListExtended.IGuiListEntry getListEntry(int p_getListEntry_1_) {
        return this.listEntries[p_getListEntry_1_];
    }

    @Override
    protected int getScrollBarX() {
        return super.getScrollBarX() + 35;
    }

    @Override
    public int getListWidth() {
        return super.getListWidth() + 32;
    }

    @SideOnly(value=Side.CLIENT)
    public class KeyEntry
    implements GuiListExtended.IGuiListEntry {
        private final KeyBinding keybinding;
        private final String keyDesc;
        private final GuiButton btnChangeKeyBinding;
        private final GuiButton btnReset;

        private KeyEntry(KeyBinding p_i45029_2_) {
            this.keybinding = p_i45029_2_;
            this.keyDesc = I18n.format(p_i45029_2_.getKeyDescription(), new Object[0]);
            this.btnChangeKeyBinding = new GuiButton(0, 0, 0, 95, 20, I18n.format(p_i45029_2_.getKeyDescription(), new Object[0]));
            this.btnReset = new GuiButton(0, 0, 0, 50, 20, I18n.format("controls.reset", new Object[0]));
        }

        @Override
        public void drawEntry(int p_drawEntry_1_, int p_drawEntry_2_, int p_drawEntry_3_, int p_drawEntry_4_, int p_drawEntry_5_, int p_drawEntry_6_, int p_drawEntry_7_, boolean p_drawEntry_8_) {
            boolean flag = ((GuiKeyBindingList)GuiKeyBindingList.this).controlsScreen.buttonId == this.keybinding;
            ((GuiKeyBindingList)GuiKeyBindingList.this).mc.fontRendererObj.drawString(this.keyDesc, p_drawEntry_2_ + 90 - GuiKeyBindingList.this.maxListLabelWidth, p_drawEntry_3_ + p_drawEntry_5_ / 2 - ((GuiKeyBindingList)GuiKeyBindingList.this).mc.fontRendererObj.FONT_HEIGHT / 2, 0xFFFFFF);
            this.btnReset.xPosition = p_drawEntry_2_ + 210;
            this.btnReset.yPosition = p_drawEntry_3_;
            this.btnReset.enabled = !this.keybinding.isSetToDefaultValue();
            this.btnReset.drawButton(GuiKeyBindingList.this.mc, p_drawEntry_6_, p_drawEntry_7_);
            this.btnChangeKeyBinding.xPosition = p_drawEntry_2_ + 105;
            this.btnChangeKeyBinding.yPosition = p_drawEntry_3_;
            this.btnChangeKeyBinding.displayString = this.keybinding.getDisplayName();
            boolean flag1 = false;
            boolean keyCodeModifierConflict = true;
            if (this.keybinding.getKeyCode() != 0) {
                for (KeyBinding keybinding : ((GuiKeyBindingList)GuiKeyBindingList.this).mc.gameSettings.keyBindings) {
                    if (keybinding == this.keybinding || !keybinding.conflicts(this.keybinding)) continue;
                    flag1 = true;
                    keyCodeModifierConflict &= keybinding.hasKeyCodeModifierConflict(this.keybinding);
                }
            }
            if (flag) {
                this.btnChangeKeyBinding.displayString = (Object)((Object)TextFormatting.WHITE) + "> " + (Object)((Object)TextFormatting.YELLOW) + this.btnChangeKeyBinding.displayString + (Object)((Object)TextFormatting.WHITE) + " <";
            } else if (flag1) {
                this.btnChangeKeyBinding.displayString = (Object)((Object)(keyCodeModifierConflict ? TextFormatting.GOLD : TextFormatting.RED)) + this.btnChangeKeyBinding.displayString;
            }
            this.btnChangeKeyBinding.drawButton(GuiKeyBindingList.this.mc, p_drawEntry_6_, p_drawEntry_7_);
        }

        @Override
        public boolean mousePressed(int p_mousePressed_1_, int p_mousePressed_2_, int p_mousePressed_3_, int p_mousePressed_4_, int p_mousePressed_5_, int p_mousePressed_6_) {
            if (this.btnChangeKeyBinding.mousePressed(GuiKeyBindingList.this.mc, p_mousePressed_2_, p_mousePressed_3_)) {
                ((GuiKeyBindingList)GuiKeyBindingList.this).controlsScreen.buttonId = this.keybinding;
                return true;
            }
            if (this.btnReset.mousePressed(GuiKeyBindingList.this.mc, p_mousePressed_2_, p_mousePressed_3_)) {
                this.keybinding.setToDefault();
                ((GuiKeyBindingList)GuiKeyBindingList.this).mc.gameSettings.setOptionKeyBinding(this.keybinding, this.keybinding.getKeyCodeDefault());
                KeyBinding.resetKeyBindingArrayAndHash();
                return true;
            }
            return false;
        }

        @Override
        public void mouseReleased(int p_mouseReleased_1_, int p_mouseReleased_2_, int p_mouseReleased_3_, int p_mouseReleased_4_, int p_mouseReleased_5_, int p_mouseReleased_6_) {
            this.btnChangeKeyBinding.mouseReleased(p_mouseReleased_2_, p_mouseReleased_3_);
            this.btnReset.mouseReleased(p_mouseReleased_2_, p_mouseReleased_3_);
        }

        @Override
        public void setSelected(int p_setSelected_1_, int p_setSelected_2_, int p_setSelected_3_) {
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class CategoryEntry
    implements GuiListExtended.IGuiListEntry {
        private final String labelText;
        private final int labelWidth;

        public CategoryEntry(String p_i45028_2_) {
            this.labelText = I18n.format(p_i45028_2_, new Object[0]);
            this.labelWidth = ((GuiKeyBindingList)GuiKeyBindingList.this).mc.fontRendererObj.getStringWidth(this.labelText);
        }

        @Override
        public void drawEntry(int p_drawEntry_1_, int p_drawEntry_2_, int p_drawEntry_3_, int p_drawEntry_4_, int p_drawEntry_5_, int p_drawEntry_6_, int p_drawEntry_7_, boolean p_drawEntry_8_) {
            ((GuiKeyBindingList)GuiKeyBindingList.this).mc.fontRendererObj.drawString(this.labelText, ((GuiKeyBindingList)GuiKeyBindingList.this).mc.currentScreen.width / 2 - this.labelWidth / 2, p_drawEntry_3_ + p_drawEntry_5_ - ((GuiKeyBindingList)GuiKeyBindingList.this).mc.fontRendererObj.FONT_HEIGHT - 1, 0xFFFFFF);
        }

        @Override
        public boolean mousePressed(int p_mousePressed_1_, int p_mousePressed_2_, int p_mousePressed_3_, int p_mousePressed_4_, int p_mousePressed_5_, int p_mousePressed_6_) {
            return false;
        }

        @Override
        public void mouseReleased(int p_mouseReleased_1_, int p_mouseReleased_2_, int p_mouseReleased_3_, int p_mouseReleased_4_, int p_mouseReleased_5_, int p_mouseReleased_6_) {
        }

        @Override
        public void setSelected(int p_setSelected_1_, int p_setSelected_2_, int p_setSelected_3_) {
        }
    }
}

