/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiLabel
extends Gui {
    protected int width = 200;
    protected int height = 20;
    public int x;
    public int y;
    private final List<String> labels;
    public int id;
    private boolean centered;
    public boolean visible = true;
    private boolean labelBgEnabled;
    private final int textColor;
    private int backColor;
    private int ulColor;
    private int brColor;
    private final FontRenderer fontRenderer;
    private int border;

    public GuiLabel(FontRenderer p_i45540_1_, int p_i45540_2_, int p_i45540_3_, int p_i45540_4_, int p_i45540_5_, int p_i45540_6_, int p_i45540_7_) {
        this.fontRenderer = p_i45540_1_;
        this.id = p_i45540_2_;
        this.x = p_i45540_3_;
        this.y = p_i45540_4_;
        this.width = p_i45540_5_;
        this.height = p_i45540_6_;
        this.labels = Lists.newArrayList();
        this.centered = false;
        this.labelBgEnabled = false;
        this.textColor = p_i45540_7_;
        this.backColor = -1;
        this.ulColor = -1;
        this.brColor = -1;
        this.border = 0;
    }

    public void addLine(String p_addLine_1_) {
        this.labels.add(I18n.format(p_addLine_1_, new Object[0]));
    }

    public GuiLabel setCentered() {
        this.centered = true;
        return this;
    }

    public void drawLabel(Minecraft p_drawLabel_1_, int p_drawLabel_2_, int p_drawLabel_3_) {
        if (!this.visible) {
            return;
        }
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        this.drawLabelBackground(p_drawLabel_1_, p_drawLabel_2_, p_drawLabel_3_);
        int lvt_4_1_ = this.y + this.height / 2 + this.border / 2;
        int lvt_5_1_ = lvt_4_1_ - this.labels.size() * 10 / 2;
        for (int lvt_6_1_ = 0; lvt_6_1_ < this.labels.size(); ++lvt_6_1_) {
            if (this.centered) {
                this.drawCenteredString(this.fontRenderer, this.labels.get(lvt_6_1_), this.x + this.width / 2, lvt_5_1_ + lvt_6_1_ * 10, this.textColor);
                continue;
            }
            this.drawString(this.fontRenderer, this.labels.get(lvt_6_1_), this.x, lvt_5_1_ + lvt_6_1_ * 10, this.textColor);
        }
    }

    protected void drawLabelBackground(Minecraft p_drawLabelBackground_1_, int p_drawLabelBackground_2_, int p_drawLabelBackground_3_) {
        if (this.labelBgEnabled) {
            int lvt_4_1_ = this.width + this.border * 2;
            int lvt_5_1_ = this.height + this.border * 2;
            int lvt_6_1_ = this.x - this.border;
            int lvt_7_1_ = this.y - this.border;
            GuiLabel.drawRect(lvt_6_1_, lvt_7_1_, lvt_6_1_ + lvt_4_1_, lvt_7_1_ + lvt_5_1_, this.backColor);
            this.drawHorizontalLine(lvt_6_1_, lvt_6_1_ + lvt_4_1_, lvt_7_1_, this.ulColor);
            this.drawHorizontalLine(lvt_6_1_, lvt_6_1_ + lvt_4_1_, lvt_7_1_ + lvt_5_1_, this.brColor);
            this.drawVerticalLine(lvt_6_1_, lvt_7_1_, lvt_7_1_ + lvt_5_1_, this.ulColor);
            this.drawVerticalLine(lvt_6_1_ + lvt_4_1_, lvt_7_1_, lvt_7_1_ + lvt_5_1_, this.brColor);
        }
    }
}

