/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiOptionButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.Language;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiLanguage
extends GuiScreen {
    protected GuiScreen parentScreen;
    private List list;
    private final GameSettings game_settings_3;
    private final LanguageManager languageManager;
    private GuiOptionButton forceUnicodeFontBtn;
    private GuiOptionButton confirmSettingsBtn;

    public GuiLanguage(GuiScreen p_i1043_1_, GameSettings p_i1043_2_, LanguageManager p_i1043_3_) {
        this.parentScreen = p_i1043_1_;
        this.game_settings_3 = p_i1043_2_;
        this.languageManager = p_i1043_3_;
    }

    @Override
    public void initGui() {
        this.forceUnicodeFontBtn = this.addButton(new GuiOptionButton(100, this.width / 2 - 155, this.height - 38, GameSettings.Options.FORCE_UNICODE_FONT, this.game_settings_3.getKeyBinding(GameSettings.Options.FORCE_UNICODE_FONT)));
        this.confirmSettingsBtn = this.addButton(new GuiOptionButton(6, this.width / 2 - 155 + 160, this.height - 38, I18n.format("gui.done", new Object[0])));
        this.list = new List(this.mc);
        this.list.registerScrollButtons(7, 8);
    }

    @Override
    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        this.list.handleMouseInput();
    }

    @Override
    protected void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
        if (!p_actionPerformed_1_.enabled) {
            return;
        }
        switch (p_actionPerformed_1_.id) {
            case 100: {
                if (!(p_actionPerformed_1_ instanceof GuiOptionButton)) break;
                this.game_settings_3.setOptionValue(((GuiOptionButton)p_actionPerformed_1_).returnEnumOptions(), 1);
                p_actionPerformed_1_.displayString = this.game_settings_3.getKeyBinding(GameSettings.Options.FORCE_UNICODE_FONT);
                ScaledResolution lvt_2_1_ = new ScaledResolution(this.mc);
                int lvt_3_1_ = lvt_2_1_.getScaledWidth();
                int lvt_4_1_ = lvt_2_1_.getScaledHeight();
                this.setWorldAndResolution(this.mc, lvt_3_1_, lvt_4_1_);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.mc.displayGuiScreen(this.parentScreen);
                break;
            }
            default: {
                this.list.actionPerformed(p_actionPerformed_1_);
            }
        }
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        this.list.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
        this.drawCenteredString(this.fontRendererObj, I18n.format("options.language", new Object[0]), this.width / 2, 16, 0xFFFFFF);
        this.drawCenteredString(this.fontRendererObj, "(" + I18n.format("options.languageWarning", new Object[0]) + ")", this.width / 2, this.height - 56, 0x808080);
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
    }

    @SideOnly(value=Side.CLIENT)
    class List
    extends GuiSlot {
        private final java.util.List<String> langCodeList;
        private final Map<String, Language> languageMap;

        public List(Minecraft p_i45519_2_) {
            super(p_i45519_2_, GuiLanguage.this.width, GuiLanguage.this.height, 32, GuiLanguage.this.height - 65 + 4, 18);
            this.langCodeList = Lists.newArrayList();
            this.languageMap = Maps.newHashMap();
            for (Language lvt_4_1_ : GuiLanguage.this.languageManager.getLanguages()) {
                this.languageMap.put(lvt_4_1_.getLanguageCode(), lvt_4_1_);
                this.langCodeList.add(lvt_4_1_.getLanguageCode());
            }
        }

        @Override
        protected int getSize() {
            return this.langCodeList.size();
        }

        @Override
        protected void elementClicked(int p_elementClicked_1_, boolean p_elementClicked_2_, int p_elementClicked_3_, int p_elementClicked_4_) {
            Language lvt_5_1_ = this.languageMap.get(this.langCodeList.get(p_elementClicked_1_));
            GuiLanguage.this.languageManager.setCurrentLanguage(lvt_5_1_);
            ((GuiLanguage)GuiLanguage.this).game_settings_3.language = lvt_5_1_.getLanguageCode();
            this.mc.refreshResources();
            GuiLanguage.this.fontRendererObj.setUnicodeFlag(GuiLanguage.this.languageManager.isCurrentLocaleUnicode() || ((GuiLanguage)GuiLanguage.this).game_settings_3.forceUnicodeFont);
            GuiLanguage.this.fontRendererObj.setBidiFlag(GuiLanguage.this.languageManager.isCurrentLanguageBidirectional());
            ((GuiLanguage)GuiLanguage.this).confirmSettingsBtn.displayString = I18n.format("gui.done", new Object[0]);
            ((GuiLanguage)GuiLanguage.this).forceUnicodeFontBtn.displayString = GuiLanguage.this.game_settings_3.getKeyBinding(GameSettings.Options.FORCE_UNICODE_FONT);
            GuiLanguage.this.game_settings_3.saveOptions();
        }

        @Override
        protected boolean isSelected(int p_isSelected_1_) {
            return this.langCodeList.get(p_isSelected_1_).equals(GuiLanguage.this.languageManager.getCurrentLanguage().getLanguageCode());
        }

        @Override
        protected int getContentHeight() {
            return this.getSize() * 18;
        }

        @Override
        protected void drawBackground() {
            GuiLanguage.this.drawDefaultBackground();
        }

        @Override
        protected void drawSlot(int p_drawSlot_1_, int p_drawSlot_2_, int p_drawSlot_3_, int p_drawSlot_4_, int p_drawSlot_5_, int p_drawSlot_6_) {
            GuiLanguage.this.fontRendererObj.setBidiFlag(true);
            GuiLanguage.this.drawCenteredString(GuiLanguage.this.fontRendererObj, this.languageMap.get(this.langCodeList.get(p_drawSlot_1_)).toString(), this.width / 2, p_drawSlot_3_ + 1, 0xFFFFFF);
            GuiLanguage.this.fontRendererObj.setBidiFlag(GuiLanguage.this.languageManager.getCurrentLanguage().isBidirectional());
        }
    }
}

