/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiListWorldSelectionEntry;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class GuiListWorldSelection
extends GuiListExtended {
    private static final Logger LOGGER = LogManager.getLogger();
    private final GuiWorldSelection worldSelectionObj;
    private final List<GuiListWorldSelectionEntry> entries = Lists.newArrayList();
    private int selectedIdx = -1;

    public GuiListWorldSelection(GuiWorldSelection p_i46590_1_, Minecraft p_i46590_2_, int p_i46590_3_, int p_i46590_4_, int p_i46590_5_, int p_i46590_6_, int p_i46590_7_) {
        super(p_i46590_2_, p_i46590_3_, p_i46590_4_, p_i46590_5_, p_i46590_6_, p_i46590_7_);
        this.worldSelectionObj = p_i46590_1_;
        this.refreshList();
    }

    /*
     * WARNING - void declaration
     */
    public void refreshList() {
        void lvt_2_2_;
        ISaveFormat lvt_1_1_ = this.mc.getSaveLoader();
        try {
            List<WorldSummary> lvt_2_1_ = lvt_1_1_.getSaveList();
        }
        catch (AnvilConverterException lvt_3_1_) {
            LOGGER.error("Couldn't load level list", (Throwable)lvt_3_1_);
            this.mc.displayGuiScreen(new GuiErrorScreen(I18n.format("selectWorld.unable_to_load", new Object[0]), lvt_3_1_.getMessage()));
            return;
        }
        Collections.sort(lvt_2_2_);
        for (WorldSummary lvt_4_1_ : lvt_2_2_) {
            this.entries.add(new GuiListWorldSelectionEntry(this, lvt_4_1_, this.mc.getSaveLoader()));
        }
    }

    @Override
    public GuiListWorldSelectionEntry getListEntry(int p_getListEntry_1_) {
        return this.entries.get(p_getListEntry_1_);
    }

    @Override
    protected int getSize() {
        return this.entries.size();
    }

    @Override
    protected int getScrollBarX() {
        return super.getScrollBarX() + 20;
    }

    @Override
    public int getListWidth() {
        return super.getListWidth() + 50;
    }

    public void selectWorld(int p_selectWorld_1_) {
        this.selectedIdx = p_selectWorld_1_;
        this.worldSelectionObj.selectWorld(this.getSelectedWorld());
    }

    @Override
    protected boolean isSelected(int p_isSelected_1_) {
        return p_isSelected_1_ == this.selectedIdx;
    }

    @Nullable
    public GuiListWorldSelectionEntry getSelectedWorld() {
        return this.selectedIdx < 0 || this.selectedIdx >= this.getSize() ? null : this.getListEntry(this.selectedIdx);
    }

    public GuiWorldSelection getGuiWorldSelection() {
        return this.worldSelectionObj;
    }

    @Override
    public /* synthetic */ GuiListExtended.IGuiListEntry getListEntry(int p_getListEntry_1_) {
        return this.getListEntry(p_getListEntry_1_);
    }
}

