/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiLockIconButton
extends GuiButton {
    private boolean locked;

    public GuiLockIconButton(int p_i45538_1_, int p_i45538_2_, int p_i45538_3_) {
        super(p_i45538_1_, p_i45538_2_, p_i45538_3_, 20, 20, "");
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean p_setLocked_1_) {
        this.locked = p_setLocked_1_;
    }

    @Override
    public void drawButton(Minecraft p_drawButton_1_, int p_drawButton_2_, int p_drawButton_3_) {
        Icon lvt_5_6_;
        boolean lvt_4_1_;
        if (!this.visible) {
            return;
        }
        p_drawButton_1_.getTextureManager().bindTexture(GuiButton.BUTTON_TEXTURES);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        boolean bl = lvt_4_1_ = p_drawButton_2_ >= this.xPosition && p_drawButton_3_ >= this.yPosition && p_drawButton_2_ < this.xPosition + this.width && p_drawButton_3_ < this.yPosition + this.height;
        if (this.locked) {
            if (!this.enabled) {
                Icon lvt_5_1_ = Icon.LOCKED_DISABLED;
            } else if (lvt_4_1_) {
                Icon lvt_5_2_ = Icon.LOCKED_HOVER;
            } else {
                Icon lvt_5_3_ = Icon.LOCKED;
            }
        } else if (!this.enabled) {
            Icon lvt_5_4_ = Icon.UNLOCKED_DISABLED;
        } else if (lvt_4_1_) {
            Icon lvt_5_5_ = Icon.UNLOCKED_HOVER;
        } else {
            lvt_5_6_ = Icon.UNLOCKED;
        }
        this.drawTexturedModalRect(this.xPosition, this.yPosition, lvt_5_6_.getX(), lvt_5_6_.getY(), this.width, this.height);
    }

    @SideOnly(value=Side.CLIENT)
    static enum Icon {
        LOCKED(0, 146),
        LOCKED_HOVER(0, 166),
        LOCKED_DISABLED(0, 186),
        UNLOCKED(20, 146),
        UNLOCKED_HOVER(20, 166),
        UNLOCKED_DISABLED(20, 186);

        private final int x;
        private final int y;

        private Icon(int p_i45537_3_, int p_i45537_4_) {
            this.x = p_i45537_3_;
            this.y = p_i45537_4_;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }
}

