/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ContainerMerchant;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class GuiMerchant
extends GuiContainer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation MERCHANT_GUI_TEXTURE = new ResourceLocation("textures/gui/container/villager.png");
    private final IMerchant merchant;
    private MerchantButton nextButton;
    private MerchantButton previousButton;
    private int selectedMerchantRecipe;
    private final ITextComponent chatComponent;

    public GuiMerchant(InventoryPlayer p_i45500_1_, IMerchant p_i45500_2_, World p_i45500_3_) {
        super(new ContainerMerchant(p_i45500_1_, p_i45500_2_, p_i45500_3_));
        this.merchant = p_i45500_2_;
        this.chatComponent = p_i45500_2_.getDisplayName();
    }

    @Override
    public void initGui() {
        super.initGui();
        int lvt_1_1_ = (this.width - this.xSize) / 2;
        int lvt_2_1_ = (this.height - this.ySize) / 2;
        this.nextButton = this.addButton(new MerchantButton(1, lvt_1_1_ + 120 + 27, lvt_2_1_ + 24 - 1, true));
        this.previousButton = this.addButton(new MerchantButton(2, lvt_1_1_ + 36 - 19, lvt_2_1_ + 24 - 1, false));
        this.nextButton.enabled = false;
        this.previousButton.enabled = false;
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int p_drawGuiContainerForegroundLayer_1_, int p_drawGuiContainerForegroundLayer_2_) {
        String lvt_3_1_ = this.chatComponent.getUnformattedText();
        this.fontRendererObj.drawString(lvt_3_1_, this.xSize / 2 - this.fontRendererObj.getStringWidth(lvt_3_1_) / 2, 6, 0x404040);
        this.fontRendererObj.drawString(I18n.format("container.inventory", new Object[0]), 8, this.ySize - 96 + 2, 0x404040);
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        MerchantRecipeList lvt_1_1_ = this.merchant.getRecipes(this.mc.player);
        if (lvt_1_1_ != null) {
            this.nextButton.enabled = this.selectedMerchantRecipe < lvt_1_1_.size() - 1;
            this.previousButton.enabled = this.selectedMerchantRecipe > 0;
        }
    }

    @Override
    protected void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
        boolean lvt_2_1_ = false;
        if (p_actionPerformed_1_ == this.nextButton) {
            ++this.selectedMerchantRecipe;
            MerchantRecipeList lvt_3_1_ = this.merchant.getRecipes(this.mc.player);
            if (lvt_3_1_ != null && this.selectedMerchantRecipe >= lvt_3_1_.size()) {
                this.selectedMerchantRecipe = lvt_3_1_.size() - 1;
            }
            lvt_2_1_ = true;
        } else if (p_actionPerformed_1_ == this.previousButton) {
            --this.selectedMerchantRecipe;
            if (this.selectedMerchantRecipe < 0) {
                this.selectedMerchantRecipe = 0;
            }
            lvt_2_1_ = true;
        }
        if (lvt_2_1_) {
            ((ContainerMerchant)this.inventorySlots).setCurrentRecipeIndex(this.selectedMerchantRecipe);
            PacketBuffer lvt_3_2_ = new PacketBuffer(Unpooled.buffer());
            lvt_3_2_.writeInt(this.selectedMerchantRecipe);
            this.mc.getConnection().sendPacket(new CPacketCustomPayload("MC|TrSel", lvt_3_2_));
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float p_drawGuiContainerBackgroundLayer_1_, int p_drawGuiContainerBackgroundLayer_2_, int p_drawGuiContainerBackgroundLayer_3_) {
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.getTextureManager().bindTexture(MERCHANT_GUI_TEXTURE);
        int lvt_4_1_ = (this.width - this.xSize) / 2;
        int lvt_5_1_ = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(lvt_4_1_, lvt_5_1_, 0, 0, this.xSize, this.ySize);
        MerchantRecipeList lvt_6_1_ = this.merchant.getRecipes(this.mc.player);
        if (lvt_6_1_ != null && !lvt_6_1_.isEmpty()) {
            int lvt_7_1_ = this.selectedMerchantRecipe;
            if (lvt_7_1_ < 0 || lvt_7_1_ >= lvt_6_1_.size()) {
                return;
            }
            MerchantRecipe lvt_8_1_ = (MerchantRecipe)lvt_6_1_.get(lvt_7_1_);
            if (lvt_8_1_.isRecipeDisabled()) {
                this.mc.getTextureManager().bindTexture(MERCHANT_GUI_TEXTURE);
                GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
                GlStateManager.disableLighting();
                this.drawTexturedModalRect(this.guiLeft + 83, this.guiTop + 21, 212, 0, 28, 21);
                this.drawTexturedModalRect(this.guiLeft + 83, this.guiTop + 51, 212, 0, 28, 21);
            }
        }
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
        MerchantRecipeList lvt_4_1_ = this.merchant.getRecipes(this.mc.player);
        if (lvt_4_1_ != null && !lvt_4_1_.isEmpty()) {
            int lvt_5_1_ = (this.width - this.xSize) / 2;
            int lvt_6_1_ = (this.height - this.ySize) / 2;
            int lvt_7_1_ = this.selectedMerchantRecipe;
            MerchantRecipe lvt_8_1_ = (MerchantRecipe)lvt_4_1_.get(lvt_7_1_);
            ItemStack lvt_9_1_ = lvt_8_1_.getItemToBuy();
            ItemStack lvt_10_1_ = lvt_8_1_.getSecondItemToBuy();
            ItemStack lvt_11_1_ = lvt_8_1_.getItemToSell();
            GlStateManager.pushMatrix();
            RenderHelper.enableGUIStandardItemLighting();
            GlStateManager.disableLighting();
            GlStateManager.enableRescaleNormal();
            GlStateManager.enableColorMaterial();
            GlStateManager.enableLighting();
            this.itemRender.zLevel = 100.0f;
            this.itemRender.renderItemAndEffectIntoGUI(lvt_9_1_, lvt_5_1_ + 36, lvt_6_1_ + 24);
            this.itemRender.renderItemOverlays(this.fontRendererObj, lvt_9_1_, lvt_5_1_ + 36, lvt_6_1_ + 24);
            if (!lvt_10_1_.isEmpty()) {
                this.itemRender.renderItemAndEffectIntoGUI(lvt_10_1_, lvt_5_1_ + 62, lvt_6_1_ + 24);
                this.itemRender.renderItemOverlays(this.fontRendererObj, lvt_10_1_, lvt_5_1_ + 62, lvt_6_1_ + 24);
            }
            this.itemRender.renderItemAndEffectIntoGUI(lvt_11_1_, lvt_5_1_ + 120, lvt_6_1_ + 24);
            this.itemRender.renderItemOverlays(this.fontRendererObj, lvt_11_1_, lvt_5_1_ + 120, lvt_6_1_ + 24);
            this.itemRender.zLevel = 0.0f;
            GlStateManager.disableLighting();
            if (this.isPointInRegion(36, 24, 16, 16, p_drawScreen_1_, p_drawScreen_2_) && !lvt_9_1_.isEmpty()) {
                this.renderToolTip(lvt_9_1_, p_drawScreen_1_, p_drawScreen_2_);
            } else if (!lvt_10_1_.isEmpty() && this.isPointInRegion(62, 24, 16, 16, p_drawScreen_1_, p_drawScreen_2_) && !lvt_10_1_.isEmpty()) {
                this.renderToolTip(lvt_10_1_, p_drawScreen_1_, p_drawScreen_2_);
            } else if (!lvt_11_1_.isEmpty() && this.isPointInRegion(120, 24, 16, 16, p_drawScreen_1_, p_drawScreen_2_) && !lvt_11_1_.isEmpty()) {
                this.renderToolTip(lvt_11_1_, p_drawScreen_1_, p_drawScreen_2_);
            } else if (lvt_8_1_.isRecipeDisabled() && (this.isPointInRegion(83, 21, 28, 21, p_drawScreen_1_, p_drawScreen_2_) || this.isPointInRegion(83, 51, 28, 21, p_drawScreen_1_, p_drawScreen_2_))) {
                this.drawCreativeTabHoveringText(I18n.format("merchant.deprecated", new Object[0]), p_drawScreen_1_, p_drawScreen_2_);
            }
            GlStateManager.popMatrix();
            GlStateManager.enableLighting();
            GlStateManager.enableDepth();
            RenderHelper.enableStandardItemLighting();
        }
    }

    public IMerchant getMerchant() {
        return this.merchant;
    }

    @SideOnly(value=Side.CLIENT)
    static class MerchantButton
    extends GuiButton {
        private final boolean forward;

        public MerchantButton(int p_i1095_1_, int p_i1095_2_, int p_i1095_3_, boolean p_i1095_4_) {
            super(p_i1095_1_, p_i1095_2_, p_i1095_3_, 12, 19, "");
            this.forward = p_i1095_4_;
        }

        @Override
        public void drawButton(Minecraft p_drawButton_1_, int p_drawButton_2_, int p_drawButton_3_) {
            if (!this.visible) {
                return;
            }
            p_drawButton_1_.getTextureManager().bindTexture(MERCHANT_GUI_TEXTURE);
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            boolean lvt_4_1_ = p_drawButton_2_ >= this.xPosition && p_drawButton_3_ >= this.yPosition && p_drawButton_2_ < this.xPosition + this.width && p_drawButton_3_ < this.yPosition + this.height;
            int lvt_5_1_ = 0;
            int lvt_6_1_ = 176;
            if (!this.enabled) {
                lvt_6_1_ += this.width * 2;
            } else if (lvt_4_1_) {
                lvt_6_1_ += this.width;
            }
            if (!this.forward) {
                lvt_5_1_ += this.height;
            }
            this.drawTexturedModalRect(this.xPosition, this.yPosition, lvt_6_1_, lvt_5_1_, this.width, this.height);
        }
    }
}

