/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class GuiNewChat
extends Gui {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Minecraft mc;
    private final List<String> sentMessages = Lists.newArrayList();
    private final List<ChatLine> chatLines = Lists.newArrayList();
    private final List<ChatLine> drawnChatLines = Lists.newArrayList();
    private int scrollPos;
    private boolean isScrolled;

    public GuiNewChat(Minecraft p_i1022_1_) {
        this.mc = p_i1022_1_;
    }

    public void drawChat(int p_drawChat_1_) {
        if (this.mc.gameSettings.chatVisibility == EntityPlayer.EnumChatVisibility.HIDDEN) {
            return;
        }
        int lvt_2_1_ = this.getLineCount();
        int lvt_3_1_ = this.drawnChatLines.size();
        float lvt_4_1_ = this.mc.gameSettings.chatOpacity * 0.9f + 0.1f;
        if (lvt_3_1_ <= 0) {
            return;
        }
        boolean lvt_5_1_ = false;
        if (this.getChatOpen()) {
            lvt_5_1_ = true;
        }
        float lvt_6_1_ = this.getChatScale();
        int lvt_7_1_ = MathHelper.ceil((float)this.getChatWidth() / lvt_6_1_);
        GlStateManager.pushMatrix();
        GlStateManager.translate(2.0f, 8.0f, 0.0f);
        GlStateManager.scale(lvt_6_1_, lvt_6_1_, 1.0f);
        int lvt_8_1_ = 0;
        for (int lvt_9_1_ = 0; lvt_9_1_ + this.scrollPos < this.drawnChatLines.size() && lvt_9_1_ < lvt_2_1_; ++lvt_9_1_) {
            int lvt_11_1_;
            ChatLine lvt_10_1_ = this.drawnChatLines.get(lvt_9_1_ + this.scrollPos);
            if (lvt_10_1_ == null || (lvt_11_1_ = p_drawChat_1_ - lvt_10_1_.getUpdatedCounter()) >= 200 && !lvt_5_1_) continue;
            double lvt_12_1_ = (double)lvt_11_1_ / 200.0;
            lvt_12_1_ = 1.0 - lvt_12_1_;
            lvt_12_1_ *= 10.0;
            lvt_12_1_ = MathHelper.clamp(lvt_12_1_, 0.0, 1.0);
            lvt_12_1_ *= lvt_12_1_;
            int lvt_14_1_ = (int)(255.0 * lvt_12_1_);
            if (lvt_5_1_) {
                lvt_14_1_ = 255;
            }
            lvt_14_1_ = (int)((float)lvt_14_1_ * lvt_4_1_);
            ++lvt_8_1_;
            if (lvt_14_1_ <= 3) continue;
            boolean lvt_15_1_ = false;
            int lvt_16_1_ = -lvt_9_1_ * 9;
            GuiNewChat.drawRect(-2, lvt_16_1_ - 9, 0 + lvt_7_1_ + 4, lvt_16_1_, lvt_14_1_ / 2 << 24);
            String lvt_17_1_ = lvt_10_1_.getChatComponent().getFormattedText();
            GlStateManager.enableBlend();
            this.mc.fontRendererObj.drawStringWithShadow(lvt_17_1_, 0.0f, lvt_16_1_ - 8, 0xFFFFFF + (lvt_14_1_ << 24));
            GlStateManager.disableAlpha();
            GlStateManager.disableBlend();
        }
        if (lvt_5_1_) {
            int lvt_9_2_ = this.mc.fontRendererObj.FONT_HEIGHT;
            GlStateManager.translate(-3.0f, 0.0f, 0.0f);
            int lvt_10_2_ = lvt_3_1_ * lvt_9_2_ + lvt_3_1_;
            int lvt_11_2_ = lvt_8_1_ * lvt_9_2_ + lvt_8_1_;
            int lvt_12_2_ = this.scrollPos * lvt_11_2_ / lvt_3_1_;
            int lvt_13_1_ = lvt_11_2_ * lvt_11_2_ / lvt_10_2_;
            if (lvt_10_2_ != lvt_11_2_) {
                int lvt_14_2_ = lvt_12_2_ > 0 ? 170 : 96;
                int lvt_15_2_ = this.isScrolled ? 0xCC3333 : 0x3333AA;
                GuiNewChat.drawRect(0, -lvt_12_2_, 2, -lvt_12_2_ - lvt_13_1_, lvt_15_2_ + (lvt_14_2_ << 24));
                GuiNewChat.drawRect(2, -lvt_12_2_, 1, -lvt_12_2_ - lvt_13_1_, 0xCCCCCC + (lvt_14_2_ << 24));
            }
        }
        GlStateManager.popMatrix();
    }

    public void clearChatMessages(boolean p_clearChatMessages_1_) {
        this.drawnChatLines.clear();
        this.chatLines.clear();
        if (p_clearChatMessages_1_) {
            this.sentMessages.clear();
        }
    }

    public void printChatMessage(ITextComponent p_printChatMessage_1_) {
        this.printChatMessageWithOptionalDeletion(p_printChatMessage_1_, 0);
    }

    public void printChatMessageWithOptionalDeletion(ITextComponent p_printChatMessageWithOptionalDeletion_1_, int p_printChatMessageWithOptionalDeletion_2_) {
        this.setChatLine(p_printChatMessageWithOptionalDeletion_1_, p_printChatMessageWithOptionalDeletion_2_, this.mc.ingameGUI.getUpdateCounter(), false);
        LOGGER.info("[CHAT] {}", new Object[]{p_printChatMessageWithOptionalDeletion_1_.getUnformattedText().replaceAll("\r", "\\\\r").replaceAll("\n", "\\\\n")});
    }

    private void setChatLine(ITextComponent p_setChatLine_1_, int p_setChatLine_2_, int p_setChatLine_3_, boolean p_setChatLine_4_) {
        if (p_setChatLine_2_ != 0) {
            this.deleteChatLine(p_setChatLine_2_);
        }
        int lvt_5_1_ = MathHelper.floor((float)this.getChatWidth() / this.getChatScale());
        List<ITextComponent> lvt_6_1_ = GuiUtilRenderComponents.splitText(p_setChatLine_1_, lvt_5_1_, this.mc.fontRendererObj, false, false);
        boolean lvt_7_1_ = this.getChatOpen();
        for (ITextComponent lvt_9_1_ : lvt_6_1_) {
            if (lvt_7_1_ && this.scrollPos > 0) {
                this.isScrolled = true;
                this.scroll(1);
            }
            this.drawnChatLines.add(0, new ChatLine(p_setChatLine_3_, lvt_9_1_, p_setChatLine_2_));
        }
        while (this.drawnChatLines.size() > 100) {
            this.drawnChatLines.remove(this.drawnChatLines.size() - 1);
        }
        if (!p_setChatLine_4_) {
            this.chatLines.add(0, new ChatLine(p_setChatLine_3_, p_setChatLine_1_, p_setChatLine_2_));
            while (this.chatLines.size() > 100) {
                this.chatLines.remove(this.chatLines.size() - 1);
            }
        }
    }

    public void refreshChat() {
        this.drawnChatLines.clear();
        this.resetScroll();
        for (int lvt_1_1_ = this.chatLines.size() - 1; lvt_1_1_ >= 0; --lvt_1_1_) {
            ChatLine lvt_2_1_ = this.chatLines.get(lvt_1_1_);
            this.setChatLine(lvt_2_1_.getChatComponent(), lvt_2_1_.getChatLineID(), lvt_2_1_.getUpdatedCounter(), true);
        }
    }

    public List<String> getSentMessages() {
        return this.sentMessages;
    }

    public void addToSentMessages(String p_addToSentMessages_1_) {
        if (this.sentMessages.isEmpty() || !this.sentMessages.get(this.sentMessages.size() - 1).equals(p_addToSentMessages_1_)) {
            this.sentMessages.add(p_addToSentMessages_1_);
        }
    }

    public void resetScroll() {
        this.scrollPos = 0;
        this.isScrolled = false;
    }

    public void scroll(int p_scroll_1_) {
        this.scrollPos += p_scroll_1_;
        int lvt_2_1_ = this.drawnChatLines.size();
        if (this.scrollPos > lvt_2_1_ - this.getLineCount()) {
            this.scrollPos = lvt_2_1_ - this.getLineCount();
        }
        if (this.scrollPos <= 0) {
            this.scrollPos = 0;
            this.isScrolled = false;
        }
    }

    @Nullable
    public ITextComponent getChatComponent(int p_getChatComponent_1_, int p_getChatComponent_2_) {
        if (!this.getChatOpen()) {
            return null;
        }
        ScaledResolution lvt_3_1_ = new ScaledResolution(this.mc);
        int lvt_4_1_ = lvt_3_1_.getScaleFactor();
        float lvt_5_1_ = this.getChatScale();
        int lvt_6_1_ = p_getChatComponent_1_ / lvt_4_1_ - 2;
        int lvt_7_1_ = p_getChatComponent_2_ / lvt_4_1_ - 40;
        lvt_6_1_ = MathHelper.floor((float)lvt_6_1_ / lvt_5_1_);
        lvt_7_1_ = MathHelper.floor((float)lvt_7_1_ / lvt_5_1_);
        if (lvt_6_1_ < 0 || lvt_7_1_ < 0) {
            return null;
        }
        int lvt_8_1_ = Math.min(this.getLineCount(), this.drawnChatLines.size());
        if (lvt_6_1_ <= MathHelper.floor((float)this.getChatWidth() / this.getChatScale()) && lvt_7_1_ < this.mc.fontRendererObj.FONT_HEIGHT * lvt_8_1_ + lvt_8_1_) {
            int lvt_9_1_ = lvt_7_1_ / this.mc.fontRendererObj.FONT_HEIGHT + this.scrollPos;
            if (lvt_9_1_ >= 0 && lvt_9_1_ < this.drawnChatLines.size()) {
                ChatLine lvt_10_1_ = this.drawnChatLines.get(lvt_9_1_);
                int lvt_11_1_ = 0;
                for (ITextComponent lvt_13_1_ : lvt_10_1_.getChatComponent()) {
                    if (!(lvt_13_1_ instanceof TextComponentString) || (lvt_11_1_ += this.mc.fontRendererObj.getStringWidth(GuiUtilRenderComponents.removeTextColorsIfConfigured(((TextComponentString)lvt_13_1_).getText(), false))) <= lvt_6_1_) continue;
                    return lvt_13_1_;
                }
            }
            return null;
        }
        return null;
    }

    public boolean getChatOpen() {
        return this.mc.currentScreen instanceof GuiChat;
    }

    public void deleteChatLine(int p_deleteChatLine_1_) {
        Iterator<ChatLine> lvt_2_1_ = this.drawnChatLines.iterator();
        while (lvt_2_1_.hasNext()) {
            ChatLine lvt_3_1_ = lvt_2_1_.next();
            if (lvt_3_1_.getChatLineID() != p_deleteChatLine_1_) continue;
            lvt_2_1_.remove();
        }
        lvt_2_1_ = this.chatLines.iterator();
        while (lvt_2_1_.hasNext()) {
            ChatLine lvt_3_2_ = lvt_2_1_.next();
            if (lvt_3_2_.getChatLineID() != p_deleteChatLine_1_) continue;
            lvt_2_1_.remove();
            break;
        }
    }

    public int getChatWidth() {
        return GuiNewChat.calculateChatboxWidth(this.mc.gameSettings.chatWidth);
    }

    public int getChatHeight() {
        return GuiNewChat.calculateChatboxHeight(this.getChatOpen() ? this.mc.gameSettings.chatHeightFocused : this.mc.gameSettings.chatHeightUnfocused);
    }

    public float getChatScale() {
        return this.mc.gameSettings.chatScale;
    }

    public static int calculateChatboxWidth(float p_calculateChatboxWidth_0_) {
        int lvt_1_1_ = 320;
        int lvt_2_1_ = 40;
        return MathHelper.floor(p_calculateChatboxWidth_0_ * 280.0f + 40.0f);
    }

    public static int calculateChatboxHeight(float p_calculateChatboxHeight_0_) {
        int lvt_1_1_ = 180;
        int lvt_2_1_ = 20;
        return MathHelper.floor(p_calculateChatboxHeight_0_ * 160.0f + 20.0f);
    }

    public int getLineCount() {
        return this.getChatHeight() / 9;
    }
}

