/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiOptionSlider
extends GuiButton {
    private float sliderValue = 1.0f;
    public boolean dragging;
    private final GameSettings.Options options;
    private final float minValue;
    private final float maxValue;

    public GuiOptionSlider(int p_i45016_1_, int p_i45016_2_, int p_i45016_3_, GameSettings.Options p_i45016_4_) {
        this(p_i45016_1_, p_i45016_2_, p_i45016_3_, p_i45016_4_, 0.0f, 1.0f);
    }

    public GuiOptionSlider(int p_i45017_1_, int p_i45017_2_, int p_i45017_3_, GameSettings.Options p_i45017_4_, float p_i45017_5_, float p_i45017_6_) {
        super(p_i45017_1_, p_i45017_2_, p_i45017_3_, 150, 20, "");
        this.options = p_i45017_4_;
        this.minValue = p_i45017_5_;
        this.maxValue = p_i45017_6_;
        Minecraft lvt_7_1_ = Minecraft.getMinecraft();
        this.sliderValue = p_i45017_4_.normalizeValue(lvt_7_1_.gameSettings.getOptionFloatValue(p_i45017_4_));
        this.displayString = lvt_7_1_.gameSettings.getKeyBinding(p_i45017_4_);
    }

    @Override
    protected int getHoverState(boolean p_getHoverState_1_) {
        return 0;
    }

    @Override
    protected void mouseDragged(Minecraft p_mouseDragged_1_, int p_mouseDragged_2_, int p_mouseDragged_3_) {
        if (!this.visible) {
            return;
        }
        if (this.dragging) {
            this.sliderValue = (float)(p_mouseDragged_2_ - (this.xPosition + 4)) / (float)(this.width - 8);
            this.sliderValue = MathHelper.clamp(this.sliderValue, 0.0f, 1.0f);
            float lvt_4_1_ = this.options.denormalizeValue(this.sliderValue);
            p_mouseDragged_1_.gameSettings.setOptionFloatValue(this.options, lvt_4_1_);
            this.sliderValue = this.options.normalizeValue(lvt_4_1_);
            this.displayString = p_mouseDragged_1_.gameSettings.getKeyBinding(this.options);
        }
        p_mouseDragged_1_.getTextureManager().bindTexture(BUTTON_TEXTURES);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.drawTexturedModalRect(this.xPosition + (int)(this.sliderValue * (float)(this.width - 8)), this.yPosition, 0, 66, 4, 20);
        this.drawTexturedModalRect(this.xPosition + (int)(this.sliderValue * (float)(this.width - 8)) + 4, this.yPosition, 196, 66, 4, 20);
    }

    @Override
    public boolean mousePressed(Minecraft p_mousePressed_1_, int p_mousePressed_2_, int p_mousePressed_3_) {
        if (super.mousePressed(p_mousePressed_1_, p_mousePressed_2_, p_mousePressed_3_)) {
            this.sliderValue = (float)(p_mousePressed_2_ - (this.xPosition + 4)) / (float)(this.width - 8);
            this.sliderValue = MathHelper.clamp(this.sliderValue, 0.0f, 1.0f);
            p_mousePressed_1_.gameSettings.setOptionFloatValue(this.options, this.options.denormalizeValue(this.sliderValue));
            this.displayString = p_mousePressed_1_.gameSettings.getKeyBinding(this.options);
            this.dragging = true;
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(int p_mouseReleased_1_, int p_mouseReleased_2_) {
        this.dragging = false;
    }
}

