/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiControls;
import net.minecraft.client.gui.GuiCustomizeSkin;
import net.minecraft.client.gui.GuiLanguage;
import net.minecraft.client.gui.GuiLockIconButton;
import net.minecraft.client.gui.GuiOptionButton;
import net.minecraft.client.gui.GuiOptionSlider;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenOptionsSounds;
import net.minecraft.client.gui.GuiScreenResourcePacks;
import net.minecraft.client.gui.GuiSnooper;
import net.minecraft.client.gui.GuiVideoSettings;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.ScreenChatOptions;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiOptions
extends GuiScreen {
    private static final GameSettings.Options[] SCREEN_OPTIONS = new GameSettings.Options[]{GameSettings.Options.FOV};
    private final GuiScreen lastScreen;
    private final GameSettings settings;
    private GuiButton difficultyButton;
    private GuiLockIconButton lockButton;
    protected String title = "Options";

    public GuiOptions(GuiScreen p_i1046_1_, GameSettings p_i1046_2_) {
        this.lastScreen = p_i1046_1_;
        this.settings = p_i1046_2_;
    }

    @Override
    public void initGui() {
        this.title = I18n.format("options.title", new Object[0]);
        int lvt_1_1_ = 0;
        for (GameSettings.Options lvt_5_1_ : SCREEN_OPTIONS) {
            if (lvt_5_1_.getEnumFloat()) {
                this.buttonList.add(new GuiOptionSlider(lvt_5_1_.returnEnumOrdinal(), this.width / 2 - 155 + lvt_1_1_ % 2 * 160, this.height / 6 - 12 + 24 * (lvt_1_1_ >> 1), lvt_5_1_));
            } else {
                GuiOptionButton lvt_6_1_ = new GuiOptionButton(lvt_5_1_.returnEnumOrdinal(), this.width / 2 - 155 + lvt_1_1_ % 2 * 160, this.height / 6 - 12 + 24 * (lvt_1_1_ >> 1), lvt_5_1_, this.settings.getKeyBinding(lvt_5_1_));
                this.buttonList.add(lvt_6_1_);
            }
            ++lvt_1_1_;
        }
        if (this.mc.world != null) {
            EnumDifficulty lvt_2_1_ = this.mc.world.getDifficulty();
            this.difficultyButton = new GuiButton(108, this.width / 2 - 155 + lvt_1_1_ % 2 * 160, this.height / 6 - 12 + 24 * (lvt_1_1_ >> 1), 150, 20, this.getDifficultyText(lvt_2_1_));
            this.buttonList.add(this.difficultyButton);
            if (this.mc.isSingleplayer() && !this.mc.world.getWorldInfo().isHardcoreModeEnabled()) {
                this.difficultyButton.setWidth(this.difficultyButton.getButtonWidth() - 20);
                this.lockButton = new GuiLockIconButton(109, this.difficultyButton.xPosition + this.difficultyButton.getButtonWidth(), this.difficultyButton.yPosition);
                this.buttonList.add(this.lockButton);
                this.lockButton.setLocked(this.mc.world.getWorldInfo().isDifficultyLocked());
                this.lockButton.enabled = !this.lockButton.isLocked();
                this.difficultyButton.enabled = !this.lockButton.isLocked();
            } else {
                this.difficultyButton.enabled = false;
            }
        } else {
            this.buttonList.add(new GuiOptionButton(GameSettings.Options.REALMS_NOTIFICATIONS.returnEnumOrdinal(), this.width / 2 - 155 + lvt_1_1_ % 2 * 160, this.height / 6 - 12 + 24 * (lvt_1_1_ >> 1), GameSettings.Options.REALMS_NOTIFICATIONS, this.settings.getKeyBinding(GameSettings.Options.REALMS_NOTIFICATIONS)));
        }
        this.buttonList.add(new GuiButton(110, this.width / 2 - 155, this.height / 6 + 48 - 6, 150, 20, I18n.format("options.skinCustomisation", new Object[0])));
        this.buttonList.add(new GuiButton(106, this.width / 2 + 5, this.height / 6 + 48 - 6, 150, 20, I18n.format("options.sounds", new Object[0])));
        this.buttonList.add(new GuiButton(101, this.width / 2 - 155, this.height / 6 + 72 - 6, 150, 20, I18n.format("options.video", new Object[0])));
        this.buttonList.add(new GuiButton(100, this.width / 2 + 5, this.height / 6 + 72 - 6, 150, 20, I18n.format("options.controls", new Object[0])));
        this.buttonList.add(new GuiButton(102, this.width / 2 - 155, this.height / 6 + 96 - 6, 150, 20, I18n.format("options.language", new Object[0])));
        this.buttonList.add(new GuiButton(103, this.width / 2 + 5, this.height / 6 + 96 - 6, 150, 20, I18n.format("options.chat.title", new Object[0])));
        this.buttonList.add(new GuiButton(105, this.width / 2 - 155, this.height / 6 + 120 - 6, 150, 20, I18n.format("options.resourcepack", new Object[0])));
        this.buttonList.add(new GuiButton(104, this.width / 2 + 5, this.height / 6 + 120 - 6, 150, 20, I18n.format("options.snooper.view", new Object[0])));
        this.buttonList.add(new GuiButton(200, this.width / 2 - 100, this.height / 6 + 168, I18n.format("gui.done", new Object[0])));
    }

    public String getDifficultyText(EnumDifficulty p_getDifficultyText_1_) {
        TextComponentString lvt_2_1_ = new TextComponentString("");
        lvt_2_1_.appendSibling(new TextComponentTranslation("options.difficulty", new Object[0]));
        lvt_2_1_.appendText(": ");
        lvt_2_1_.appendSibling(new TextComponentTranslation(p_getDifficultyText_1_.getDifficultyResourceKey(), new Object[0]));
        return lvt_2_1_.getFormattedText();
    }

    @Override
    public void confirmClicked(boolean p_confirmClicked_1_, int p_confirmClicked_2_) {
        this.mc.displayGuiScreen(this);
        if (p_confirmClicked_2_ == 109 && p_confirmClicked_1_ && this.mc.world != null) {
            this.mc.world.getWorldInfo().setDifficultyLocked(true);
            this.lockButton.setLocked(true);
            this.lockButton.enabled = false;
            this.difficultyButton.enabled = false;
        }
    }

    @Override
    protected void keyTyped(char p_keyTyped_1_, int p_keyTyped_2_) throws IOException {
        if (p_keyTyped_2_ == 1) {
            this.mc.gameSettings.saveOptions();
        }
        super.keyTyped(p_keyTyped_1_, p_keyTyped_2_);
    }

    @Override
    protected void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
        if (!p_actionPerformed_1_.enabled) {
            return;
        }
        if (p_actionPerformed_1_.id < 100 && p_actionPerformed_1_ instanceof GuiOptionButton) {
            GameSettings.Options lvt_2_1_ = ((GuiOptionButton)p_actionPerformed_1_).returnEnumOptions();
            this.settings.setOptionValue(lvt_2_1_, 1);
            p_actionPerformed_1_.displayString = this.settings.getKeyBinding(GameSettings.Options.getEnumOptions(p_actionPerformed_1_.id));
        }
        if (p_actionPerformed_1_.id == 108) {
            this.mc.world.getWorldInfo().setDifficulty(EnumDifficulty.getDifficultyEnum(this.mc.world.getDifficulty().getDifficultyId() + 1));
            this.difficultyButton.displayString = this.getDifficultyText(this.mc.world.getDifficulty());
        }
        if (p_actionPerformed_1_.id == 109) {
            this.mc.displayGuiScreen(new GuiYesNo(this, new TextComponentTranslation("difficulty.lock.title", new Object[0]).getFormattedText(), new TextComponentTranslation("difficulty.lock.question", new TextComponentTranslation(this.mc.world.getWorldInfo().getDifficulty().getDifficultyResourceKey(), new Object[0])).getFormattedText(), 109));
        }
        if (p_actionPerformed_1_.id == 110) {
            this.mc.gameSettings.saveOptions();
            this.mc.displayGuiScreen(new GuiCustomizeSkin(this));
        }
        if (p_actionPerformed_1_.id == 101) {
            this.mc.gameSettings.saveOptions();
            this.mc.displayGuiScreen(new GuiVideoSettings(this, this.settings));
        }
        if (p_actionPerformed_1_.id == 100) {
            this.mc.gameSettings.saveOptions();
            this.mc.displayGuiScreen(new GuiControls(this, this.settings));
        }
        if (p_actionPerformed_1_.id == 102) {
            this.mc.gameSettings.saveOptions();
            this.mc.displayGuiScreen(new GuiLanguage(this, this.settings, this.mc.getLanguageManager()));
        }
        if (p_actionPerformed_1_.id == 103) {
            this.mc.gameSettings.saveOptions();
            this.mc.displayGuiScreen(new ScreenChatOptions(this, this.settings));
        }
        if (p_actionPerformed_1_.id == 104) {
            this.mc.gameSettings.saveOptions();
            this.mc.displayGuiScreen(new GuiSnooper(this, this.settings));
        }
        if (p_actionPerformed_1_.id == 200) {
            this.mc.gameSettings.saveOptions();
            this.mc.displayGuiScreen(this.lastScreen);
        }
        if (p_actionPerformed_1_.id == 105) {
            this.mc.gameSettings.saveOptions();
            this.mc.displayGuiScreen(new GuiScreenResourcePacks(this));
        }
        if (p_actionPerformed_1_.id == 106) {
            this.mc.gameSettings.saveOptions();
            this.mc.displayGuiScreen(new GuiScreenOptionsSounds(this, this.settings));
        }
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRendererObj, this.title, this.width / 2, 15, 0xFFFFFF);
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
    }
}

