/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiOptionButton;
import net.minecraft.client.gui.GuiOptionSlider;
import net.minecraft.client.settings.GameSettings;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiOptionsRowList
extends GuiListExtended {
    private final List<Row> options = Lists.newArrayList();

    public GuiOptionsRowList(Minecraft p_i45015_1_, int p_i45015_2_, int p_i45015_3_, int p_i45015_4_, int p_i45015_5_, int p_i45015_6_, GameSettings.Options ... p_i45015_7_) {
        super(p_i45015_1_, p_i45015_2_, p_i45015_3_, p_i45015_4_, p_i45015_5_, p_i45015_6_);
        this.centerListVertically = false;
        for (int lvt_8_1_ = 0; lvt_8_1_ < p_i45015_7_.length; lvt_8_1_ += 2) {
            GameSettings.Options lvt_9_1_ = p_i45015_7_[lvt_8_1_];
            GameSettings.Options lvt_10_1_ = lvt_8_1_ < p_i45015_7_.length - 1 ? p_i45015_7_[lvt_8_1_ + 1] : null;
            GuiButton lvt_11_1_ = this.createButton(p_i45015_1_, p_i45015_2_ / 2 - 155, 0, lvt_9_1_);
            GuiButton lvt_12_1_ = this.createButton(p_i45015_1_, p_i45015_2_ / 2 - 155 + 160, 0, lvt_10_1_);
            this.options.add(new Row(lvt_11_1_, lvt_12_1_));
        }
    }

    private GuiButton createButton(Minecraft p_createButton_1_, int p_createButton_2_, int p_createButton_3_, GameSettings.Options p_createButton_4_) {
        if (p_createButton_4_ == null) {
            return null;
        }
        int lvt_5_1_ = p_createButton_4_.returnEnumOrdinal();
        return p_createButton_4_.getEnumFloat() ? new GuiOptionSlider(lvt_5_1_, p_createButton_2_, p_createButton_3_, p_createButton_4_) : new GuiOptionButton(lvt_5_1_, p_createButton_2_, p_createButton_3_, p_createButton_4_, p_createButton_1_.gameSettings.getKeyBinding(p_createButton_4_));
    }

    @Override
    public Row getListEntry(int p_getListEntry_1_) {
        return this.options.get(p_getListEntry_1_);
    }

    @Override
    protected int getSize() {
        return this.options.size();
    }

    @Override
    public int getListWidth() {
        return 400;
    }

    @Override
    protected int getScrollBarX() {
        return super.getScrollBarX() + 32;
    }

    @Override
    public /* synthetic */ GuiListExtended.IGuiListEntry getListEntry(int p_getListEntry_1_) {
        return this.getListEntry(p_getListEntry_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public static class Row
    implements GuiListExtended.IGuiListEntry {
        private final Minecraft client = Minecraft.getMinecraft();
        private final GuiButton buttonA;
        private final GuiButton buttonB;

        public Row(GuiButton p_i45014_1_, GuiButton p_i45014_2_) {
            this.buttonA = p_i45014_1_;
            this.buttonB = p_i45014_2_;
        }

        @Override
        public void drawEntry(int p_drawEntry_1_, int p_drawEntry_2_, int p_drawEntry_3_, int p_drawEntry_4_, int p_drawEntry_5_, int p_drawEntry_6_, int p_drawEntry_7_, boolean p_drawEntry_8_) {
            if (this.buttonA != null) {
                this.buttonA.yPosition = p_drawEntry_3_;
                this.buttonA.drawButton(this.client, p_drawEntry_6_, p_drawEntry_7_);
            }
            if (this.buttonB != null) {
                this.buttonB.yPosition = p_drawEntry_3_;
                this.buttonB.drawButton(this.client, p_drawEntry_6_, p_drawEntry_7_);
            }
        }

        @Override
        public boolean mousePressed(int p_mousePressed_1_, int p_mousePressed_2_, int p_mousePressed_3_, int p_mousePressed_4_, int p_mousePressed_5_, int p_mousePressed_6_) {
            if (this.buttonA.mousePressed(this.client, p_mousePressed_2_, p_mousePressed_3_)) {
                if (this.buttonA instanceof GuiOptionButton) {
                    this.client.gameSettings.setOptionValue(((GuiOptionButton)this.buttonA).returnEnumOptions(), 1);
                    this.buttonA.displayString = this.client.gameSettings.getKeyBinding(GameSettings.Options.getEnumOptions(this.buttonA.id));
                }
                return true;
            }
            if (this.buttonB != null && this.buttonB.mousePressed(this.client, p_mousePressed_2_, p_mousePressed_3_)) {
                if (this.buttonB instanceof GuiOptionButton) {
                    this.client.gameSettings.setOptionValue(((GuiOptionButton)this.buttonB).returnEnumOptions(), 1);
                    this.buttonB.displayString = this.client.gameSettings.getKeyBinding(GameSettings.Options.getEnumOptions(this.buttonB.id));
                }
                return true;
            }
            return false;
        }

        @Override
        public void mouseReleased(int p_mouseReleased_1_, int p_mouseReleased_2_, int p_mouseReleased_3_, int p_mouseReleased_4_, int p_mouseReleased_5_, int p_mouseReleased_6_) {
            if (this.buttonA != null) {
                this.buttonA.mouseReleased(p_mouseReleased_2_, p_mouseReleased_3_);
            }
            if (this.buttonB != null) {
                this.buttonB.mouseReleased(p_mouseReleased_2_, p_mouseReleased_3_);
            }
        }

        @Override
        public void setSelected(int p_setSelected_1_, int p_setSelected_2_, int p_setSelected_3_) {
        }
    }
}

