/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiListButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlider;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.IntHashMap;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiPageButtonList
extends GuiListExtended {
    private final List<GuiEntry> entries = Lists.newArrayList();
    private final IntHashMap<Gui> componentMap = new IntHashMap();
    private final List<GuiTextField> editBoxes = Lists.newArrayList();
    private final GuiListEntry[][] pages;
    private int page;
    private final GuiResponder responder;
    private Gui focusedControl;

    public GuiPageButtonList(Minecraft p_i45536_1_, int p_i45536_2_, int p_i45536_3_, int p_i45536_4_, int p_i45536_5_, int p_i45536_6_, GuiResponder p_i45536_7_, GuiListEntry[] ... p_i45536_8_) {
        super(p_i45536_1_, p_i45536_2_, p_i45536_3_, p_i45536_4_, p_i45536_5_, p_i45536_6_);
        this.responder = p_i45536_7_;
        this.pages = p_i45536_8_;
        this.centerListVertically = false;
        this.populateComponents();
        this.populateEntries();
    }

    private void populateComponents() {
        for (GuiListEntry[] lvt_4_1_ : this.pages) {
            for (int lvt_5_1_ = 0; lvt_5_1_ < lvt_4_1_.length; lvt_5_1_ += 2) {
                GuiListEntry lvt_6_1_ = lvt_4_1_[lvt_5_1_];
                GuiListEntry lvt_7_1_ = lvt_5_1_ < lvt_4_1_.length - 1 ? lvt_4_1_[lvt_5_1_ + 1] : null;
                Gui lvt_8_1_ = this.createEntry(lvt_6_1_, 0, lvt_7_1_ == null);
                Gui lvt_9_1_ = this.createEntry(lvt_7_1_, 160, lvt_6_1_ == null);
                GuiEntry lvt_10_1_ = new GuiEntry(lvt_8_1_, lvt_9_1_);
                this.entries.add(lvt_10_1_);
                if (lvt_6_1_ != null && lvt_8_1_ != null) {
                    this.componentMap.addKey(lvt_6_1_.getId(), lvt_8_1_);
                    if (lvt_8_1_ instanceof GuiTextField) {
                        this.editBoxes.add((GuiTextField)lvt_8_1_);
                    }
                }
                if (lvt_7_1_ == null || lvt_9_1_ == null) continue;
                this.componentMap.addKey(lvt_7_1_.getId(), lvt_9_1_);
                if (!(lvt_9_1_ instanceof GuiTextField)) continue;
                this.editBoxes.add((GuiTextField)lvt_9_1_);
            }
        }
    }

    private void populateEntries() {
        this.entries.clear();
        for (int lvt_1_1_ = 0; lvt_1_1_ < this.pages[this.page].length; lvt_1_1_ += 2) {
            GuiListEntry lvt_2_1_ = this.pages[this.page][lvt_1_1_];
            GuiListEntry lvt_3_1_ = lvt_1_1_ < this.pages[this.page].length - 1 ? this.pages[this.page][lvt_1_1_ + 1] : null;
            Gui lvt_4_1_ = this.componentMap.lookup(lvt_2_1_.getId());
            Gui lvt_5_1_ = lvt_3_1_ != null ? this.componentMap.lookup(lvt_3_1_.getId()) : null;
            GuiEntry lvt_6_1_ = new GuiEntry(lvt_4_1_, lvt_5_1_);
            this.entries.add(lvt_6_1_);
        }
    }

    public void setPage(int p_setPage_1_) {
        if (p_setPage_1_ == this.page) {
            return;
        }
        int lvt_2_1_ = this.page;
        this.page = p_setPage_1_;
        this.populateEntries();
        this.markVisibility(lvt_2_1_, p_setPage_1_);
        this.amountScrolled = 0.0f;
    }

    public int getPage() {
        return this.page;
    }

    public int getPageCount() {
        return this.pages.length;
    }

    public Gui getFocusedControl() {
        return this.focusedControl;
    }

    public void previousPage() {
        if (this.page > 0) {
            this.setPage(this.page - 1);
        }
    }

    public void nextPage() {
        if (this.page < this.pages.length - 1) {
            this.setPage(this.page + 1);
        }
    }

    public Gui getComponent(int p_getComponent_1_) {
        return this.componentMap.lookup(p_getComponent_1_);
    }

    private void markVisibility(int p_markVisibility_1_, int p_markVisibility_2_) {
        for (GuiListEntry lvt_6_1_ : this.pages[p_markVisibility_1_]) {
            if (lvt_6_1_ == null) continue;
            this.setComponentVisibility(this.componentMap.lookup(lvt_6_1_.getId()), false);
        }
        for (GuiListEntry lvt_6_2_ : this.pages[p_markVisibility_2_]) {
            if (lvt_6_2_ == null) continue;
            this.setComponentVisibility(this.componentMap.lookup(lvt_6_2_.getId()), true);
        }
    }

    private void setComponentVisibility(Gui p_setComponentVisibility_1_, boolean p_setComponentVisibility_2_) {
        if (p_setComponentVisibility_1_ instanceof GuiButton) {
            ((GuiButton)p_setComponentVisibility_1_).visible = p_setComponentVisibility_2_;
        } else if (p_setComponentVisibility_1_ instanceof GuiTextField) {
            ((GuiTextField)p_setComponentVisibility_1_).setVisible(p_setComponentVisibility_2_);
        } else if (p_setComponentVisibility_1_ instanceof GuiLabel) {
            ((GuiLabel)p_setComponentVisibility_1_).visible = p_setComponentVisibility_2_;
        }
    }

    @Nullable
    private Gui createEntry(GuiListEntry p_createEntry_1_, int p_createEntry_2_, boolean p_createEntry_3_) {
        if (p_createEntry_1_ instanceof GuiSlideEntry) {
            return this.createSlider(this.width / 2 - 155 + p_createEntry_2_, 0, (GuiSlideEntry)p_createEntry_1_);
        }
        if (p_createEntry_1_ instanceof GuiButtonEntry) {
            return this.createButton(this.width / 2 - 155 + p_createEntry_2_, 0, (GuiButtonEntry)p_createEntry_1_);
        }
        if (p_createEntry_1_ instanceof EditBoxEntry) {
            return this.createTextField(this.width / 2 - 155 + p_createEntry_2_, 0, (EditBoxEntry)p_createEntry_1_);
        }
        if (p_createEntry_1_ instanceof GuiLabelEntry) {
            return this.createLabel(this.width / 2 - 155 + p_createEntry_2_, 0, (GuiLabelEntry)p_createEntry_1_, p_createEntry_3_);
        }
        return null;
    }

    public void setActive(boolean p_setActive_1_) {
        for (GuiEntry lvt_3_1_ : this.entries) {
            if (lvt_3_1_.component1 instanceof GuiButton) {
                ((GuiButton)((GuiEntry)lvt_3_1_).component1).enabled = p_setActive_1_;
            }
            if (!(lvt_3_1_.component2 instanceof GuiButton)) continue;
            ((GuiButton)((GuiEntry)lvt_3_1_).component2).enabled = p_setActive_1_;
        }
    }

    @Override
    public boolean mouseClicked(int p_mouseClicked_1_, int p_mouseClicked_2_, int p_mouseClicked_3_) {
        boolean lvt_4_1_ = super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        int lvt_5_1_ = this.getSlotIndexFromScreenCoords(p_mouseClicked_1_, p_mouseClicked_2_);
        if (lvt_5_1_ >= 0) {
            GuiEntry lvt_6_1_ = this.getListEntry(lvt_5_1_);
            if (this.focusedControl != lvt_6_1_.focusedControl && this.focusedControl != null && this.focusedControl instanceof GuiTextField) {
                ((GuiTextField)this.focusedControl).setFocused(false);
            }
            this.focusedControl = lvt_6_1_.focusedControl;
        }
        return lvt_4_1_;
    }

    private GuiSlider createSlider(int p_createSlider_1_, int p_createSlider_2_, GuiSlideEntry p_createSlider_3_) {
        GuiSlider lvt_4_1_ = new GuiSlider(this.responder, p_createSlider_3_.getId(), p_createSlider_1_, p_createSlider_2_, p_createSlider_3_.getCaption(), p_createSlider_3_.getMinValue(), p_createSlider_3_.getMaxValue(), p_createSlider_3_.getInitalValue(), p_createSlider_3_.getFormatter());
        lvt_4_1_.visible = p_createSlider_3_.shouldStartVisible();
        return lvt_4_1_;
    }

    private GuiListButton createButton(int p_createButton_1_, int p_createButton_2_, GuiButtonEntry p_createButton_3_) {
        GuiListButton lvt_4_1_ = new GuiListButton(this.responder, p_createButton_3_.getId(), p_createButton_1_, p_createButton_2_, p_createButton_3_.getCaption(), p_createButton_3_.getInitialValue());
        lvt_4_1_.visible = p_createButton_3_.shouldStartVisible();
        return lvt_4_1_;
    }

    private GuiTextField createTextField(int p_createTextField_1_, int p_createTextField_2_, EditBoxEntry p_createTextField_3_) {
        GuiTextField lvt_4_1_ = new GuiTextField(p_createTextField_3_.getId(), this.mc.fontRendererObj, p_createTextField_1_, p_createTextField_2_, 150, 20);
        lvt_4_1_.setText(p_createTextField_3_.getCaption());
        lvt_4_1_.setGuiResponder(this.responder);
        lvt_4_1_.setVisible(p_createTextField_3_.shouldStartVisible());
        lvt_4_1_.setValidator(p_createTextField_3_.getFilter());
        return lvt_4_1_;
    }

    private GuiLabel createLabel(int p_createLabel_1_, int p_createLabel_2_, GuiLabelEntry p_createLabel_3_, boolean p_createLabel_4_) {
        GuiLabel lvt_5_2_;
        if (p_createLabel_4_) {
            GuiLabel lvt_5_1_ = new GuiLabel(this.mc.fontRendererObj, p_createLabel_3_.getId(), p_createLabel_1_, p_createLabel_2_, this.width - p_createLabel_1_ * 2, 20, -1);
        } else {
            lvt_5_2_ = new GuiLabel(this.mc.fontRendererObj, p_createLabel_3_.getId(), p_createLabel_1_, p_createLabel_2_, 150, 20, -1);
        }
        lvt_5_2_.visible = p_createLabel_3_.shouldStartVisible();
        lvt_5_2_.addLine(p_createLabel_3_.getCaption());
        lvt_5_2_.setCentered();
        return lvt_5_2_;
    }

    public void onKeyPressed(char p_onKeyPressed_1_, int p_onKeyPressed_2_) {
        if (!(this.focusedControl instanceof GuiTextField)) {
            return;
        }
        GuiTextField lvt_3_1_ = (GuiTextField)this.focusedControl;
        if (GuiScreen.isKeyComboCtrlV(p_onKeyPressed_2_)) {
            int lvt_6_1_;
            String lvt_4_1_ = GuiScreen.getClipboardString();
            String[] lvt_5_1_ = lvt_4_1_.split(";");
            int lvt_7_1_ = lvt_6_1_ = this.editBoxes.indexOf(this.focusedControl);
            for (String lvt_11_1_ : lvt_5_1_) {
                GuiTextField lvt_12_1_ = this.editBoxes.get(lvt_7_1_);
                lvt_12_1_.setText(lvt_11_1_);
                lvt_12_1_.setResponderEntryValue(lvt_12_1_.getId(), lvt_11_1_);
                lvt_7_1_ = lvt_7_1_ == this.editBoxes.size() - 1 ? 0 : ++lvt_7_1_;
                if (lvt_7_1_ == lvt_6_1_) break;
            }
            return;
        }
        if (p_onKeyPressed_2_ == 15) {
            lvt_3_1_.setFocused(false);
            int lvt_4_2_ = this.editBoxes.indexOf(this.focusedControl);
            lvt_4_2_ = GuiScreen.isShiftKeyDown() ? (lvt_4_2_ == 0 ? this.editBoxes.size() - 1 : --lvt_4_2_) : (lvt_4_2_ == this.editBoxes.size() - 1 ? 0 : ++lvt_4_2_);
            this.focusedControl = this.editBoxes.get(lvt_4_2_);
            lvt_3_1_ = (GuiTextField)this.focusedControl;
            lvt_3_1_.setFocused(true);
            int lvt_5_2_ = lvt_3_1_.yPosition + this.slotHeight;
            int lvt_6_2_ = lvt_3_1_.yPosition;
            if (lvt_5_2_ > this.bottom) {
                this.amountScrolled += (float)(lvt_5_2_ - this.bottom);
            } else if (lvt_6_2_ < this.top) {
                this.amountScrolled = lvt_6_2_;
            }
        } else {
            lvt_3_1_.textboxKeyTyped(p_onKeyPressed_1_, p_onKeyPressed_2_);
        }
    }

    @Override
    public GuiEntry getListEntry(int p_getListEntry_1_) {
        return this.entries.get(p_getListEntry_1_);
    }

    @Override
    public int getSize() {
        return this.entries.size();
    }

    @Override
    public int getListWidth() {
        return 400;
    }

    @Override
    protected int getScrollBarX() {
        return super.getScrollBarX() + 32;
    }

    @Override
    public /* synthetic */ GuiListExtended.IGuiListEntry getListEntry(int p_getListEntry_1_) {
        return this.getListEntry(p_getListEntry_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public static interface GuiResponder {
        public void setEntryValue(int var1, boolean var2);

        public void setEntryValue(int var1, float var2);

        public void setEntryValue(int var1, String var2);
    }

    @SideOnly(value=Side.CLIENT)
    public static class GuiLabelEntry
    extends GuiListEntry {
        public GuiLabelEntry(int p_i45532_1_, String p_i45532_2_, boolean p_i45532_3_) {
            super(p_i45532_1_, p_i45532_2_, p_i45532_3_);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class EditBoxEntry
    extends GuiListEntry {
        private final Predicate<String> filter;

        public EditBoxEntry(int p_i45534_1_, String p_i45534_2_, boolean p_i45534_3_, Predicate<String> p_i45534_4_) {
            super(p_i45534_1_, p_i45534_2_, p_i45534_3_);
            this.filter = (Predicate)Objects.firstNonNull(p_i45534_4_, (Object)Predicates.alwaysTrue());
        }

        public Predicate<String> getFilter() {
            return this.filter;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class GuiButtonEntry
    extends GuiListEntry {
        private final boolean initialValue;

        public GuiButtonEntry(int p_i45535_1_, String p_i45535_2_, boolean p_i45535_3_, boolean p_i45535_4_) {
            super(p_i45535_1_, p_i45535_2_, p_i45535_3_);
            this.initialValue = p_i45535_4_;
        }

        public boolean getInitialValue() {
            return this.initialValue;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class GuiSlideEntry
    extends GuiListEntry {
        private final GuiSlider.FormatHelper formatter;
        private final float minValue;
        private final float maxValue;
        private final float initialValue;

        public GuiSlideEntry(int p_i45530_1_, String p_i45530_2_, boolean p_i45530_3_, GuiSlider.FormatHelper p_i45530_4_, float p_i45530_5_, float p_i45530_6_, float p_i45530_7_) {
            super(p_i45530_1_, p_i45530_2_, p_i45530_3_);
            this.formatter = p_i45530_4_;
            this.minValue = p_i45530_5_;
            this.maxValue = p_i45530_6_;
            this.initialValue = p_i45530_7_;
        }

        public GuiSlider.FormatHelper getFormatter() {
            return this.formatter;
        }

        public float getMinValue() {
            return this.minValue;
        }

        public float getMaxValue() {
            return this.maxValue;
        }

        public float getInitalValue() {
            return this.initialValue;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class GuiListEntry {
        private final int id;
        private final String caption;
        private final boolean startVisible;

        public GuiListEntry(int p_i45531_1_, String p_i45531_2_, boolean p_i45531_3_) {
            this.id = p_i45531_1_;
            this.caption = p_i45531_2_;
            this.startVisible = p_i45531_3_;
        }

        public int getId() {
            return this.id;
        }

        public String getCaption() {
            return this.caption;
        }

        public boolean shouldStartVisible() {
            return this.startVisible;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class GuiEntry
    implements GuiListExtended.IGuiListEntry {
        private final Minecraft client = Minecraft.getMinecraft();
        private final Gui component1;
        private final Gui component2;
        private Gui focusedControl;

        public GuiEntry(Gui p_i45533_1_, Gui p_i45533_2_) {
            this.component1 = p_i45533_1_;
            this.component2 = p_i45533_2_;
        }

        public Gui getComponent1() {
            return this.component1;
        }

        public Gui getComponent2() {
            return this.component2;
        }

        @Override
        public void drawEntry(int p_drawEntry_1_, int p_drawEntry_2_, int p_drawEntry_3_, int p_drawEntry_4_, int p_drawEntry_5_, int p_drawEntry_6_, int p_drawEntry_7_, boolean p_drawEntry_8_) {
            this.renderComponent(this.component1, p_drawEntry_3_, p_drawEntry_6_, p_drawEntry_7_, false);
            this.renderComponent(this.component2, p_drawEntry_3_, p_drawEntry_6_, p_drawEntry_7_, false);
        }

        private void renderComponent(Gui p_renderComponent_1_, int p_renderComponent_2_, int p_renderComponent_3_, int p_renderComponent_4_, boolean p_renderComponent_5_) {
            if (p_renderComponent_1_ == null) {
                return;
            }
            if (p_renderComponent_1_ instanceof GuiButton) {
                this.renderButton((GuiButton)p_renderComponent_1_, p_renderComponent_2_, p_renderComponent_3_, p_renderComponent_4_, p_renderComponent_5_);
            } else if (p_renderComponent_1_ instanceof GuiTextField) {
                this.renderTextField((GuiTextField)p_renderComponent_1_, p_renderComponent_2_, p_renderComponent_5_);
            } else if (p_renderComponent_1_ instanceof GuiLabel) {
                this.renderLabel((GuiLabel)p_renderComponent_1_, p_renderComponent_2_, p_renderComponent_3_, p_renderComponent_4_, p_renderComponent_5_);
            }
        }

        private void renderButton(GuiButton p_renderButton_1_, int p_renderButton_2_, int p_renderButton_3_, int p_renderButton_4_, boolean p_renderButton_5_) {
            p_renderButton_1_.yPosition = p_renderButton_2_;
            if (!p_renderButton_5_) {
                p_renderButton_1_.drawButton(this.client, p_renderButton_3_, p_renderButton_4_);
            }
        }

        private void renderTextField(GuiTextField p_renderTextField_1_, int p_renderTextField_2_, boolean p_renderTextField_3_) {
            p_renderTextField_1_.yPosition = p_renderTextField_2_;
            if (!p_renderTextField_3_) {
                p_renderTextField_1_.drawTextBox();
            }
        }

        private void renderLabel(GuiLabel p_renderLabel_1_, int p_renderLabel_2_, int p_renderLabel_3_, int p_renderLabel_4_, boolean p_renderLabel_5_) {
            p_renderLabel_1_.y = p_renderLabel_2_;
            if (!p_renderLabel_5_) {
                p_renderLabel_1_.drawLabel(this.client, p_renderLabel_3_, p_renderLabel_4_);
            }
        }

        @Override
        public void setSelected(int p_setSelected_1_, int p_setSelected_2_, int p_setSelected_3_) {
            this.renderComponent(this.component1, p_setSelected_3_, 0, 0, true);
            this.renderComponent(this.component2, p_setSelected_3_, 0, 0, true);
        }

        @Override
        public boolean mousePressed(int p_mousePressed_1_, int p_mousePressed_2_, int p_mousePressed_3_, int p_mousePressed_4_, int p_mousePressed_5_, int p_mousePressed_6_) {
            boolean lvt_7_1_ = this.clickComponent(this.component1, p_mousePressed_2_, p_mousePressed_3_, p_mousePressed_4_);
            boolean lvt_8_1_ = this.clickComponent(this.component2, p_mousePressed_2_, p_mousePressed_3_, p_mousePressed_4_);
            return lvt_7_1_ || lvt_8_1_;
        }

        private boolean clickComponent(Gui p_clickComponent_1_, int p_clickComponent_2_, int p_clickComponent_3_, int p_clickComponent_4_) {
            if (p_clickComponent_1_ == null) {
                return false;
            }
            if (p_clickComponent_1_ instanceof GuiButton) {
                return this.clickButton((GuiButton)p_clickComponent_1_, p_clickComponent_2_, p_clickComponent_3_, p_clickComponent_4_);
            }
            if (p_clickComponent_1_ instanceof GuiTextField) {
                this.clickTextField((GuiTextField)p_clickComponent_1_, p_clickComponent_2_, p_clickComponent_3_, p_clickComponent_4_);
            }
            return false;
        }

        private boolean clickButton(GuiButton p_clickButton_1_, int p_clickButton_2_, int p_clickButton_3_, int p_clickButton_4_) {
            boolean lvt_5_1_ = p_clickButton_1_.mousePressed(this.client, p_clickButton_2_, p_clickButton_3_);
            if (lvt_5_1_) {
                this.focusedControl = p_clickButton_1_;
            }
            return lvt_5_1_;
        }

        private void clickTextField(GuiTextField p_clickTextField_1_, int p_clickTextField_2_, int p_clickTextField_3_, int p_clickTextField_4_) {
            p_clickTextField_1_.mouseClicked(p_clickTextField_2_, p_clickTextField_3_, p_clickTextField_4_);
            if (p_clickTextField_1_.isFocused()) {
                this.focusedControl = p_clickTextField_1_;
            }
        }

        @Override
        public void mouseReleased(int p_mouseReleased_1_, int p_mouseReleased_2_, int p_mouseReleased_3_, int p_mouseReleased_4_, int p_mouseReleased_5_, int p_mouseReleased_6_) {
            this.releaseComponent(this.component1, p_mouseReleased_2_, p_mouseReleased_3_, p_mouseReleased_4_);
            this.releaseComponent(this.component2, p_mouseReleased_2_, p_mouseReleased_3_, p_mouseReleased_4_);
        }

        private void releaseComponent(Gui p_releaseComponent_1_, int p_releaseComponent_2_, int p_releaseComponent_3_, int p_releaseComponent_4_) {
            if (p_releaseComponent_1_ == null) {
                return;
            }
            if (p_releaseComponent_1_ instanceof GuiButton) {
                this.releaseButton((GuiButton)p_releaseComponent_1_, p_releaseComponent_2_, p_releaseComponent_3_, p_releaseComponent_4_);
            }
        }

        private void releaseButton(GuiButton p_releaseButton_1_, int p_releaseButton_2_, int p_releaseButton_3_, int p_releaseButton_4_) {
            p_releaseButton_1_.mouseReleased(p_releaseButton_2_, p_releaseButton_3_);
        }
    }
}

