/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.mojang.authlib.GameProfile;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiPlayerTabOverlay
extends Gui {
    private static final Ordering<NetworkPlayerInfo> ENTRY_ORDERING = Ordering.from((Comparator)new PlayerComparator());
    private final Minecraft mc;
    private final GuiIngame guiIngame;
    private ITextComponent footer;
    private ITextComponent header;
    private long lastTimeOpened;
    private boolean isBeingRendered;

    public GuiPlayerTabOverlay(Minecraft p_i45529_1_, GuiIngame p_i45529_2_) {
        this.mc = p_i45529_1_;
        this.guiIngame = p_i45529_2_;
    }

    public String getPlayerName(NetworkPlayerInfo p_getPlayerName_1_) {
        if (p_getPlayerName_1_.getDisplayName() != null) {
            return p_getPlayerName_1_.getDisplayName().getFormattedText();
        }
        return ScorePlayerTeam.formatPlayerName(p_getPlayerName_1_.getPlayerTeam(), p_getPlayerName_1_.getGameProfile().getName());
    }

    public void updatePlayerList(boolean p_updatePlayerList_1_) {
        if (p_updatePlayerList_1_ && !this.isBeingRendered) {
            this.lastTimeOpened = Minecraft.getSystemTime();
        }
        this.isBeingRendered = p_updatePlayerList_1_;
    }

    /*
     * WARNING - void declaration
     */
    public void renderPlayerlist(int p_renderPlayerlist_1_, Scoreboard p_renderPlayerlist_2_, ScoreObjective p_renderPlayerlist_3_) {
        void var19_27;
        int lvt_12_3_;
        boolean lvt_11_1_;
        int lvt_8_1_;
        NetHandlerPlayClient lvt_4_1_ = this.mc.player.connection;
        List lvt_5_1_ = ENTRY_ORDERING.sortedCopy(lvt_4_1_.getPlayerInfoMap());
        int lvt_6_1_ = 0;
        int lvt_7_1_ = 0;
        for (NetworkPlayerInfo lvt_9_1_ : lvt_5_1_) {
            int lvt_10_1_ = this.mc.fontRendererObj.getStringWidth(this.getPlayerName(lvt_9_1_));
            lvt_6_1_ = Math.max(lvt_6_1_, lvt_10_1_);
            if (p_renderPlayerlist_3_ == null || p_renderPlayerlist_3_.getRenderType() == IScoreCriteria.EnumRenderType.HEARTS) continue;
            lvt_10_1_ = this.mc.fontRendererObj.getStringWidth(" " + p_renderPlayerlist_2_.getOrCreateScore(lvt_9_1_.getGameProfile().getName(), p_renderPlayerlist_3_).getScorePoints());
            lvt_7_1_ = Math.max(lvt_7_1_, lvt_10_1_);
        }
        lvt_5_1_ = lvt_5_1_.subList(0, Math.min(lvt_5_1_.size(), 80));
        int lvt_9_2_ = lvt_8_1_ = lvt_5_1_.size();
        int lvt_10_2_ = 1;
        while (lvt_9_2_ > 20) {
            lvt_9_2_ = (lvt_8_1_ + ++lvt_10_2_ - 1) / lvt_10_2_;
        }
        boolean bl = lvt_11_1_ = this.mc.isIntegratedServerRunning() || this.mc.getConnection().getNetworkManager().isEncrypted();
        if (p_renderPlayerlist_3_ != null) {
            if (p_renderPlayerlist_3_.getRenderType() == IScoreCriteria.EnumRenderType.HEARTS) {
                int lvt_12_1_ = 90;
            } else {
                int lvt_12_2_ = lvt_7_1_;
            }
        } else {
            lvt_12_3_ = 0;
        }
        int lvt_13_1_ = Math.min(lvt_10_2_ * ((lvt_11_1_ ? 9 : 0) + lvt_6_1_ + lvt_12_3_ + 13), p_renderPlayerlist_1_ - 50) / lvt_10_2_;
        int lvt_14_1_ = p_renderPlayerlist_1_ / 2 - (lvt_13_1_ * lvt_10_2_ + (lvt_10_2_ - 1) * 5) / 2;
        int lvt_15_1_ = 10;
        int lvt_16_1_ = lvt_13_1_ * lvt_10_2_ + (lvt_10_2_ - 1) * 5;
        List<String> lvt_17_1_ = null;
        if (this.header != null) {
            lvt_17_1_ = this.mc.fontRendererObj.listFormattedStringToWidth(this.header.getFormattedText(), p_renderPlayerlist_1_ - 50);
            for (String string : lvt_17_1_) {
                lvt_16_1_ = Math.max(lvt_16_1_, this.mc.fontRendererObj.getStringWidth(string));
            }
        }
        List<String> lvt_18_1_ = null;
        if (this.footer != null) {
            lvt_18_1_ = this.mc.fontRendererObj.listFormattedStringToWidth(this.footer.getFormattedText(), p_renderPlayerlist_1_ - 50);
            for (String lvt_20_1_ : lvt_18_1_) {
                lvt_16_1_ = Math.max(lvt_16_1_, this.mc.fontRendererObj.getStringWidth(lvt_20_1_));
            }
        }
        if (lvt_17_1_ != null) {
            GuiPlayerTabOverlay.drawRect(p_renderPlayerlist_1_ / 2 - lvt_16_1_ / 2 - 1, lvt_15_1_ - 1, p_renderPlayerlist_1_ / 2 + lvt_16_1_ / 2 + 1, lvt_15_1_ + lvt_17_1_.size() * this.mc.fontRendererObj.FONT_HEIGHT, Integer.MIN_VALUE);
            for (String lvt_20_2_ : lvt_17_1_) {
                int lvt_21_1_ = this.mc.fontRendererObj.getStringWidth(lvt_20_2_);
                this.mc.fontRendererObj.drawStringWithShadow(lvt_20_2_, p_renderPlayerlist_1_ / 2 - lvt_21_1_ / 2, lvt_15_1_, -1);
                lvt_15_1_ += this.mc.fontRendererObj.FONT_HEIGHT;
            }
            ++lvt_15_1_;
        }
        GuiPlayerTabOverlay.drawRect(p_renderPlayerlist_1_ / 2 - lvt_16_1_ / 2 - 1, lvt_15_1_ - 1, p_renderPlayerlist_1_ / 2 + lvt_16_1_ / 2 + 1, lvt_15_1_ + lvt_9_2_ * 9, Integer.MIN_VALUE);
        boolean bl2 = false;
        while (var19_27 < lvt_8_1_) {
            void lvt_20_3_ = var19_27 / lvt_9_2_;
            void lvt_21_2_ = var19_27 % lvt_9_2_;
            int lvt_22_1_ = lvt_14_1_ + lvt_20_3_ * lvt_13_1_ + lvt_20_3_ * 5;
            int lvt_23_1_ = lvt_15_1_ + lvt_21_2_ * 9;
            GuiPlayerTabOverlay.drawRect(lvt_22_1_, lvt_23_1_, lvt_22_1_ + lvt_13_1_, lvt_23_1_ + 8, 0x20FFFFFF);
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            GlStateManager.enableAlpha();
            GlStateManager.enableBlend();
            GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
            if (var19_27 < lvt_5_1_.size()) {
                int lvt_27_2_;
                int lvt_28_2_;
                NetworkPlayerInfo lvt_24_1_ = (NetworkPlayerInfo)lvt_5_1_.get((int)var19_27);
                GameProfile lvt_25_1_ = lvt_24_1_.getGameProfile();
                if (lvt_11_1_) {
                    EntityPlayer lvt_26_1_ = this.mc.world.getPlayerEntityByUUID(lvt_25_1_.getId());
                    boolean lvt_27_1_ = lvt_26_1_ != null && lvt_26_1_.isWearing(EnumPlayerModelParts.CAPE) && ("Dinnerbone".equals(lvt_25_1_.getName()) || "Grumm".equals(lvt_25_1_.getName()));
                    this.mc.getTextureManager().bindTexture(lvt_24_1_.getLocationSkin());
                    int lvt_28_1_ = 8 + (lvt_27_1_ ? 8 : 0);
                    int lvt_29_1_ = 8 * (lvt_27_1_ ? -1 : 1);
                    Gui.drawScaledCustomSizeModalRect(lvt_22_1_, lvt_23_1_, 8.0f, lvt_28_1_, 8, lvt_29_1_, 8, 8, 64.0f, 64.0f);
                    if (lvt_26_1_ != null && lvt_26_1_.isWearing(EnumPlayerModelParts.HAT)) {
                        int lvt_30_1_ = 8 + (lvt_27_1_ ? 8 : 0);
                        int lvt_31_1_ = 8 * (lvt_27_1_ ? -1 : 1);
                        Gui.drawScaledCustomSizeModalRect(lvt_22_1_, lvt_23_1_, 40.0f, lvt_30_1_, 8, lvt_31_1_, 8, 8, 64.0f, 64.0f);
                    }
                    lvt_22_1_ += 9;
                }
                String lvt_26_2_ = this.getPlayerName(lvt_24_1_);
                if (lvt_24_1_.getGameType() == GameType.SPECTATOR) {
                    this.mc.fontRendererObj.drawStringWithShadow((Object)((Object)TextFormatting.ITALIC) + lvt_26_2_, lvt_22_1_, lvt_23_1_, -1862270977);
                } else {
                    this.mc.fontRendererObj.drawStringWithShadow(lvt_26_2_, lvt_22_1_, lvt_23_1_, -1);
                }
                if (p_renderPlayerlist_3_ != null && lvt_24_1_.getGameType() != GameType.SPECTATOR && (lvt_28_2_ = (lvt_27_2_ = lvt_22_1_ + lvt_6_1_ + 1) + lvt_12_3_) - lvt_27_2_ > 5) {
                    this.drawScoreboardValues(p_renderPlayerlist_3_, lvt_23_1_, lvt_25_1_.getName(), lvt_27_2_, lvt_28_2_, lvt_24_1_);
                }
                this.drawPing(lvt_13_1_, lvt_22_1_ - (lvt_11_1_ ? 9 : 0), lvt_23_1_, lvt_24_1_);
            }
            ++var19_27;
        }
        if (lvt_18_1_ != null) {
            GuiPlayerTabOverlay.drawRect(p_renderPlayerlist_1_ / 2 - lvt_16_1_ / 2 - 1, (lvt_15_1_ += lvt_9_2_ * 9 + 1) - 1, p_renderPlayerlist_1_ / 2 + lvt_16_1_ / 2 + 1, lvt_15_1_ + lvt_18_1_.size() * this.mc.fontRendererObj.FONT_HEIGHT, Integer.MIN_VALUE);
            for (String lvt_20_4_ : lvt_18_1_) {
                int lvt_21_3_ = this.mc.fontRendererObj.getStringWidth(lvt_20_4_);
                this.mc.fontRendererObj.drawStringWithShadow(lvt_20_4_, p_renderPlayerlist_1_ / 2 - lvt_21_3_ / 2, lvt_15_1_, -1);
                lvt_15_1_ += this.mc.fontRendererObj.FONT_HEIGHT;
            }
        }
    }

    protected void drawPing(int p_drawPing_1_, int p_drawPing_2_, int p_drawPing_3_, NetworkPlayerInfo p_drawPing_4_) {
        int lvt_6_6_;
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.getTextureManager().bindTexture(ICONS);
        boolean lvt_5_1_ = false;
        if (p_drawPing_4_.getResponseTime() < 0) {
            int lvt_6_1_ = 5;
        } else if (p_drawPing_4_.getResponseTime() < 150) {
            boolean lvt_6_2_ = false;
        } else if (p_drawPing_4_.getResponseTime() < 300) {
            boolean lvt_6_3_ = true;
        } else if (p_drawPing_4_.getResponseTime() < 600) {
            int lvt_6_4_ = 2;
        } else if (p_drawPing_4_.getResponseTime() < 1000) {
            int lvt_6_5_ = 3;
        } else {
            lvt_6_6_ = 4;
        }
        this.zLevel += 100.0f;
        this.drawTexturedModalRect(p_drawPing_2_ + p_drawPing_1_ - 11, p_drawPing_3_, 0, 176 + lvt_6_6_ * 8, 10, 8);
        this.zLevel -= 100.0f;
    }

    private void drawScoreboardValues(ScoreObjective p_drawScoreboardValues_1_, int p_drawScoreboardValues_2_, String p_drawScoreboardValues_3_, int p_drawScoreboardValues_4_, int p_drawScoreboardValues_5_, NetworkPlayerInfo p_drawScoreboardValues_6_) {
        int lvt_7_1_ = p_drawScoreboardValues_1_.getScoreboard().getOrCreateScore(p_drawScoreboardValues_3_, p_drawScoreboardValues_1_).getScorePoints();
        if (p_drawScoreboardValues_1_.getRenderType() == IScoreCriteria.EnumRenderType.HEARTS) {
            boolean lvt_10_1_;
            this.mc.getTextureManager().bindTexture(ICONS);
            if (this.lastTimeOpened == p_drawScoreboardValues_6_.getRenderVisibilityId()) {
                if (lvt_7_1_ < p_drawScoreboardValues_6_.getLastHealth()) {
                    p_drawScoreboardValues_6_.setLastHealthTime(Minecraft.getSystemTime());
                    p_drawScoreboardValues_6_.setHealthBlinkTime(this.guiIngame.getUpdateCounter() + 20);
                } else if (lvt_7_1_ > p_drawScoreboardValues_6_.getLastHealth()) {
                    p_drawScoreboardValues_6_.setLastHealthTime(Minecraft.getSystemTime());
                    p_drawScoreboardValues_6_.setHealthBlinkTime(this.guiIngame.getUpdateCounter() + 10);
                }
            }
            if (Minecraft.getSystemTime() - p_drawScoreboardValues_6_.getLastHealthTime() > 1000L || this.lastTimeOpened != p_drawScoreboardValues_6_.getRenderVisibilityId()) {
                p_drawScoreboardValues_6_.setLastHealth(lvt_7_1_);
                p_drawScoreboardValues_6_.setDisplayHealth(lvt_7_1_);
                p_drawScoreboardValues_6_.setLastHealthTime(Minecraft.getSystemTime());
            }
            p_drawScoreboardValues_6_.setRenderVisibilityId(this.lastTimeOpened);
            p_drawScoreboardValues_6_.setLastHealth(lvt_7_1_);
            int lvt_8_1_ = MathHelper.ceil((float)Math.max(lvt_7_1_, p_drawScoreboardValues_6_.getDisplayHealth()) / 2.0f);
            int lvt_9_1_ = Math.max(MathHelper.ceil(lvt_7_1_ / 2), Math.max(MathHelper.ceil(p_drawScoreboardValues_6_.getDisplayHealth() / 2), 10));
            boolean bl = lvt_10_1_ = p_drawScoreboardValues_6_.getHealthBlinkTime() > (long)this.guiIngame.getUpdateCounter() && (p_drawScoreboardValues_6_.getHealthBlinkTime() - (long)this.guiIngame.getUpdateCounter()) / 3L % 2L == 1L;
            if (lvt_8_1_ > 0) {
                float lvt_11_1_ = Math.min((float)(p_drawScoreboardValues_5_ - p_drawScoreboardValues_4_ - 4) / (float)lvt_9_1_, 9.0f);
                if (lvt_11_1_ > 3.0f) {
                    for (int lvt_12_1_ = lvt_8_1_; lvt_12_1_ < lvt_9_1_; ++lvt_12_1_) {
                        this.drawTexturedModalRect((float)p_drawScoreboardValues_4_ + (float)lvt_12_1_ * lvt_11_1_, (float)p_drawScoreboardValues_2_, lvt_10_1_ ? 25 : 16, 0, 9, 9);
                    }
                    for (int lvt_12_2_ = 0; lvt_12_2_ < lvt_8_1_; ++lvt_12_2_) {
                        this.drawTexturedModalRect((float)p_drawScoreboardValues_4_ + (float)lvt_12_2_ * lvt_11_1_, (float)p_drawScoreboardValues_2_, lvt_10_1_ ? 25 : 16, 0, 9, 9);
                        if (lvt_10_1_) {
                            if (lvt_12_2_ * 2 + 1 < p_drawScoreboardValues_6_.getDisplayHealth()) {
                                this.drawTexturedModalRect((float)p_drawScoreboardValues_4_ + (float)lvt_12_2_ * lvt_11_1_, (float)p_drawScoreboardValues_2_, 70, 0, 9, 9);
                            }
                            if (lvt_12_2_ * 2 + 1 == p_drawScoreboardValues_6_.getDisplayHealth()) {
                                this.drawTexturedModalRect((float)p_drawScoreboardValues_4_ + (float)lvt_12_2_ * lvt_11_1_, (float)p_drawScoreboardValues_2_, 79, 0, 9, 9);
                            }
                        }
                        if (lvt_12_2_ * 2 + 1 < lvt_7_1_) {
                            this.drawTexturedModalRect((float)p_drawScoreboardValues_4_ + (float)lvt_12_2_ * lvt_11_1_, (float)p_drawScoreboardValues_2_, lvt_12_2_ >= 10 ? 160 : 52, 0, 9, 9);
                        }
                        if (lvt_12_2_ * 2 + 1 != lvt_7_1_) continue;
                        this.drawTexturedModalRect((float)p_drawScoreboardValues_4_ + (float)lvt_12_2_ * lvt_11_1_, (float)p_drawScoreboardValues_2_, lvt_12_2_ >= 10 ? 169 : 61, 0, 9, 9);
                    }
                } else {
                    float lvt_12_3_ = MathHelper.clamp((float)lvt_7_1_ / 20.0f, 0.0f, 1.0f);
                    int lvt_13_1_ = (int)((1.0f - lvt_12_3_) * 255.0f) << 16 | (int)(lvt_12_3_ * 255.0f) << 8;
                    String lvt_14_1_ = "" + (float)lvt_7_1_ / 2.0f;
                    if (p_drawScoreboardValues_5_ - this.mc.fontRendererObj.getStringWidth(lvt_14_1_ + "hp") >= p_drawScoreboardValues_4_) {
                        lvt_14_1_ = lvt_14_1_ + "hp";
                    }
                    this.mc.fontRendererObj.drawStringWithShadow(lvt_14_1_, (p_drawScoreboardValues_5_ + p_drawScoreboardValues_4_) / 2 - this.mc.fontRendererObj.getStringWidth(lvt_14_1_) / 2, p_drawScoreboardValues_2_, lvt_13_1_);
                }
            }
        } else {
            String lvt_8_2_ = (Object)((Object)TextFormatting.YELLOW) + "" + lvt_7_1_;
            this.mc.fontRendererObj.drawStringWithShadow(lvt_8_2_, p_drawScoreboardValues_5_ - this.mc.fontRendererObj.getStringWidth(lvt_8_2_), p_drawScoreboardValues_2_, 0xFFFFFF);
        }
    }

    public void setFooter(ITextComponent p_setFooter_1_) {
        this.footer = p_setFooter_1_;
    }

    public void setHeader(ITextComponent p_setHeader_1_) {
        this.header = p_setHeader_1_;
    }

    public void resetFooterHeader() {
        this.header = null;
        this.footer = null;
    }

    @SideOnly(value=Side.CLIENT)
    static class PlayerComparator
    implements Comparator<NetworkPlayerInfo> {
        private PlayerComparator() {
        }

        @Override
        public int compare(NetworkPlayerInfo p_compare_1_, NetworkPlayerInfo p_compare_2_) {
            ScorePlayerTeam lvt_3_1_ = p_compare_1_.getPlayerTeam();
            ScorePlayerTeam lvt_4_1_ = p_compare_2_.getPlayerTeam();
            return ComparisonChain.start().compareTrueFirst(p_compare_1_.getGameType() != GameType.SPECTATOR, p_compare_2_.getGameType() != GameType.SPECTATOR).compare((Comparable)((Object)(lvt_3_1_ != null ? lvt_3_1_.getRegisteredName() : "")), (Comparable)((Object)(lvt_4_1_ != null ? lvt_4_1_.getRegisteredName() : ""))).compare((Comparable)((Object)p_compare_1_.getGameProfile().getName()), (Comparable)((Object)p_compare_2_.getGameProfile().getName())).result();
        }

        @Override
        public /* synthetic */ int compare(Object p_compare_1_, Object p_compare_2_) {
            return this.compare((NetworkPlayerInfo)p_compare_1_, (NetworkPlayerInfo)p_compare_2_);
        }
    }
}

