/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiRepair
extends GuiContainer
implements IContainerListener {
    private static final ResourceLocation ANVIL_RESOURCE = new ResourceLocation("textures/gui/container/anvil.png");
    private final ContainerRepair anvil;
    private GuiTextField nameField;
    private final InventoryPlayer playerInventory;

    public GuiRepair(InventoryPlayer p_i45508_1_, World p_i45508_2_) {
        super(new ContainerRepair(p_i45508_1_, p_i45508_2_, Minecraft.getMinecraft().player));
        this.playerInventory = p_i45508_1_;
        this.anvil = (ContainerRepair)this.inventorySlots;
    }

    @Override
    public void initGui() {
        super.initGui();
        Keyboard.enableRepeatEvents((boolean)true);
        int lvt_1_1_ = (this.width - this.xSize) / 2;
        int lvt_2_1_ = (this.height - this.ySize) / 2;
        this.nameField = new GuiTextField(0, this.fontRendererObj, lvt_1_1_ + 62, lvt_2_1_ + 24, 103, 12);
        this.nameField.setTextColor(-1);
        this.nameField.setDisabledTextColour(-1);
        this.nameField.setEnableBackgroundDrawing(false);
        this.nameField.setMaxStringLength(31);
        this.inventorySlots.removeListener(this);
        this.inventorySlots.addListener(this);
    }

    @Override
    public void onGuiClosed() {
        super.onGuiClosed();
        Keyboard.enableRepeatEvents((boolean)false);
        this.inventorySlots.removeListener(this);
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int p_drawGuiContainerForegroundLayer_1_, int p_drawGuiContainerForegroundLayer_2_) {
        GlStateManager.disableLighting();
        GlStateManager.disableBlend();
        this.fontRendererObj.drawString(I18n.format("container.repair", new Object[0]), 60, 6, 0x404040);
        if (this.anvil.maximumCost > 0) {
            int lvt_3_1_ = 8453920;
            boolean lvt_4_1_ = true;
            String lvt_5_1_ = I18n.format("container.repair.cost", this.anvil.maximumCost);
            if (this.anvil.maximumCost >= 40 && !this.mc.player.capabilities.isCreativeMode) {
                lvt_5_1_ = I18n.format("container.repair.expensive", new Object[0]);
                lvt_3_1_ = 0xFF6060;
            } else if (!this.anvil.getSlot(2).getHasStack()) {
                lvt_4_1_ = false;
            } else if (!this.anvil.getSlot(2).canTakeStack(this.playerInventory.player)) {
                lvt_3_1_ = 0xFF6060;
            }
            if (lvt_4_1_) {
                int lvt_6_1_ = 0xFF000000 | (lvt_3_1_ & 0xFCFCFC) >> 2 | lvt_3_1_ & 0xFF000000;
                int lvt_7_1_ = this.xSize - 8 - this.fontRendererObj.getStringWidth(lvt_5_1_);
                int lvt_8_1_ = 67;
                if (this.fontRendererObj.getUnicodeFlag()) {
                    GuiRepair.drawRect(lvt_7_1_ - 3, 65, this.xSize - 7, 77, -16777216);
                    GuiRepair.drawRect(lvt_7_1_ - 2, 66, this.xSize - 8, 76, -12895429);
                } else {
                    this.fontRendererObj.drawString(lvt_5_1_, lvt_7_1_, 68, lvt_6_1_);
                    this.fontRendererObj.drawString(lvt_5_1_, lvt_7_1_ + 1, 67, lvt_6_1_);
                    this.fontRendererObj.drawString(lvt_5_1_, lvt_7_1_ + 1, 68, lvt_6_1_);
                }
                this.fontRendererObj.drawString(lvt_5_1_, lvt_7_1_, 67, lvt_3_1_);
            }
        }
        GlStateManager.enableLighting();
    }

    @Override
    protected void keyTyped(char p_keyTyped_1_, int p_keyTyped_2_) throws IOException {
        if (this.nameField.textboxKeyTyped(p_keyTyped_1_, p_keyTyped_2_)) {
            this.renameItem();
        } else {
            super.keyTyped(p_keyTyped_1_, p_keyTyped_2_);
        }
    }

    private void renameItem() {
        String lvt_1_1_ = this.nameField.getText();
        Slot lvt_2_1_ = this.anvil.getSlot(0);
        if (lvt_2_1_ != null && lvt_2_1_.getHasStack() && !lvt_2_1_.getStack().hasDisplayName() && lvt_1_1_.equals(lvt_2_1_.getStack().getDisplayName())) {
            lvt_1_1_ = "";
        }
        this.anvil.updateItemName(lvt_1_1_);
        this.mc.player.connection.sendPacket(new CPacketCustomPayload("MC|ItemName", new PacketBuffer(Unpooled.buffer()).writeString(lvt_1_1_)));
    }

    @Override
    protected void mouseClicked(int p_mouseClicked_1_, int p_mouseClicked_2_, int p_mouseClicked_3_) throws IOException {
        super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        this.nameField.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
        GlStateManager.disableLighting();
        GlStateManager.disableBlend();
        this.nameField.drawTextBox();
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float p_drawGuiContainerBackgroundLayer_1_, int p_drawGuiContainerBackgroundLayer_2_, int p_drawGuiContainerBackgroundLayer_3_) {
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.getTextureManager().bindTexture(ANVIL_RESOURCE);
        int lvt_4_1_ = (this.width - this.xSize) / 2;
        int lvt_5_1_ = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(lvt_4_1_, lvt_5_1_, 0, 0, this.xSize, this.ySize);
        this.drawTexturedModalRect(lvt_4_1_ + 59, lvt_5_1_ + 20, 0, this.ySize + (this.anvil.getSlot(0).getHasStack() ? 0 : 16), 110, 16);
        if ((this.anvil.getSlot(0).getHasStack() || this.anvil.getSlot(1).getHasStack()) && !this.anvil.getSlot(2).getHasStack()) {
            this.drawTexturedModalRect(lvt_4_1_ + 99, lvt_5_1_ + 45, this.xSize, 0, 28, 21);
        }
    }

    @Override
    public void updateCraftingInventory(Container p_updateCraftingInventory_1_, NonNullList<ItemStack> p_updateCraftingInventory_2_) {
        this.sendSlotContents(p_updateCraftingInventory_1_, 0, p_updateCraftingInventory_1_.getSlot(0).getStack());
    }

    @Override
    public void sendSlotContents(Container p_sendSlotContents_1_, int p_sendSlotContents_2_, ItemStack p_sendSlotContents_3_) {
        if (p_sendSlotContents_2_ == 0) {
            this.nameField.setText(p_sendSlotContents_3_.isEmpty() ? "" : p_sendSlotContents_3_.getDisplayName());
            this.nameField.setEnabled(!p_sendSlotContents_3_.isEmpty());
            if (!p_sendSlotContents_3_.isEmpty()) {
                this.renameItem();
            }
        }
    }

    @Override
    public void sendProgressBarUpdate(Container p_sendProgressBarUpdate_1_, int p_sendProgressBarUpdate_2_, int p_sendProgressBarUpdate_3_) {
    }

    @Override
    public void sendAllWindowProperties(Container p_sendAllWindowProperties_1_, IInventory p_sendAllWindowProperties_2_) {
    }
}

