/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public abstract class GuiScreen
extends Gui
implements GuiYesNoCallback {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<String> PROTOCOLS = Sets.newHashSet((Object[])new String[]{"http", "https"});
    private static final Splitter NEWLINE_SPLITTER = Splitter.on((char)'\n');
    public Minecraft mc;
    protected RenderItem itemRender;
    public int width;
    public int height;
    protected List<GuiButton> buttonList = Lists.newArrayList();
    protected List<GuiLabel> labelList = Lists.newArrayList();
    public boolean allowUserInput;
    protected FontRenderer fontRendererObj;
    private GuiButton selectedButton;
    private int eventButton;
    private long lastMouseEvent;
    private int touchValue;
    private URI clickedLinkURI;
    protected boolean keyHandled;
    protected boolean mouseHandled;

    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        for (int i = 0; i < this.buttonList.size(); ++i) {
            this.buttonList.get(i).drawButton(this.mc, p_drawScreen_1_, p_drawScreen_2_);
        }
        for (int j = 0; j < this.labelList.size(); ++j) {
            this.labelList.get(j).drawLabel(this.mc, p_drawScreen_1_, p_drawScreen_2_);
        }
    }

    protected void keyTyped(char p_keyTyped_1_, int p_keyTyped_2_) throws IOException {
        if (p_keyTyped_2_ == 1) {
            this.mc.displayGuiScreen(null);
            if (this.mc.currentScreen == null) {
                this.mc.setIngameFocus();
            }
        }
    }

    protected <T extends GuiButton> T addButton(T p_addButton_1_) {
        this.buttonList.add(p_addButton_1_);
        return p_addButton_1_;
    }

    public static String getClipboardString() {
        try {
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static void setClipboardString(String p_setClipboardString_0_) {
        if (!StringUtils.isEmpty((CharSequence)p_setClipboardString_0_)) {
            try {
                StringSelection stringselection = new StringSelection(p_setClipboardString_0_);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringselection, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void renderToolTip(ItemStack p_renderToolTip_1_, int p_renderToolTip_2_, int p_renderToolTip_3_) {
        List<String> list = p_renderToolTip_1_.getTooltip(this.mc.player, this.mc.gameSettings.advancedItemTooltips);
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                list.set(i, (Object)((Object)p_renderToolTip_1_.getRarity().rarityColor) + list.get(i));
                continue;
            }
            list.set(i, (Object)((Object)TextFormatting.GRAY) + list.get(i));
        }
        FontRenderer font = p_renderToolTip_1_.getItem().getFontRenderer(p_renderToolTip_1_);
        GuiUtils.preItemToolTip(p_renderToolTip_1_);
        this.drawHoveringText(list, p_renderToolTip_2_, p_renderToolTip_3_, font == null ? this.fontRendererObj : font);
        GuiUtils.postItemToolTip();
    }

    protected void drawCreativeTabHoveringText(String p_drawCreativeTabHoveringText_1_, int p_drawCreativeTabHoveringText_2_, int p_drawCreativeTabHoveringText_3_) {
        this.drawHoveringText(Arrays.asList(p_drawCreativeTabHoveringText_1_), p_drawCreativeTabHoveringText_2_, p_drawCreativeTabHoveringText_3_);
    }

    protected void drawHoveringText(List<String> p_drawHoveringText_1_, int p_drawHoveringText_2_, int p_drawHoveringText_3_) {
        this.drawHoveringText(p_drawHoveringText_1_, p_drawHoveringText_2_, p_drawHoveringText_3_, this.fontRendererObj);
    }

    protected void drawHoveringText(List<String> p_drawHoveringText_1_, int p_drawHoveringText_2_, int p_drawHoveringText_3_, FontRenderer p_drawHoveringText_4_) {
        GuiUtils.drawHoveringText(p_drawHoveringText_1_, p_drawHoveringText_2_, p_drawHoveringText_3_, this.width, this.height, -1, p_drawHoveringText_4_);
    }

    protected void handleComponentHover(ITextComponent p_handleComponentHover_1_, int p_handleComponentHover_2_, int p_handleComponentHover_3_) {
        if (p_handleComponentHover_1_ != null && p_handleComponentHover_1_.getStyle().getHoverEvent() != null) {
            HoverEvent hoverevent = p_handleComponentHover_1_.getStyle().getHoverEvent();
            if (hoverevent.getAction() == HoverEvent.Action.SHOW_ITEM) {
                ItemStack itemstack = ItemStack.EMPTY;
                try {
                    NBTTagCompound nbtbase = JsonToNBT.getTagFromJson(hoverevent.getValue().getUnformattedText());
                    if (nbtbase instanceof NBTTagCompound) {
                        itemstack = new ItemStack(nbtbase);
                    }
                }
                catch (NBTException nbtbase) {
                    // empty catch block
                }
                if (itemstack.isEmpty()) {
                    this.drawCreativeTabHoveringText((Object)((Object)TextFormatting.RED) + "Invalid Item!", p_handleComponentHover_2_, p_handleComponentHover_3_);
                } else {
                    this.renderToolTip(itemstack, p_handleComponentHover_2_, p_handleComponentHover_3_);
                }
            } else if (hoverevent.getAction() == HoverEvent.Action.SHOW_ENTITY) {
                if (this.mc.gameSettings.advancedItemTooltips) {
                    try {
                        NBTTagCompound nbttagcompound = JsonToNBT.getTagFromJson(hoverevent.getValue().getUnformattedText());
                        ArrayList list1 = Lists.newArrayList();
                        list1.add(nbttagcompound.getString("name"));
                        if (nbttagcompound.hasKey("type", 8)) {
                            String s = nbttagcompound.getString("type");
                            list1.add("Type: " + s);
                        }
                        list1.add(nbttagcompound.getString("id"));
                        this.drawHoveringText(list1, p_handleComponentHover_2_, p_handleComponentHover_3_);
                    }
                    catch (NBTException var10) {
                        this.drawCreativeTabHoveringText((Object)((Object)TextFormatting.RED) + "Invalid Entity!", p_handleComponentHover_2_, p_handleComponentHover_3_);
                    }
                }
            } else if (hoverevent.getAction() == HoverEvent.Action.SHOW_TEXT) {
                this.drawHoveringText(NEWLINE_SPLITTER.splitToList((CharSequence)hoverevent.getValue().getFormattedText()), p_handleComponentHover_2_, p_handleComponentHover_3_);
            } else if (hoverevent.getAction() == HoverEvent.Action.SHOW_ACHIEVEMENT) {
                StatBase statbase = StatList.getOneShotStat(hoverevent.getValue().getUnformattedText());
                if (statbase != null) {
                    ITextComponent itextcomponent = statbase.getStatName();
                    TextComponentTranslation itextcomponent1 = new TextComponentTranslation("stats.tooltip.type." + (statbase.isAchievement() ? "achievement" : "statistic"), new Object[0]);
                    itextcomponent1.getStyle().setItalic(true);
                    String s1 = statbase instanceof Achievement ? ((Achievement)statbase).getDescription() : null;
                    ArrayList list = Lists.newArrayList((Object[])new String[]{itextcomponent.getFormattedText(), itextcomponent1.getFormattedText()});
                    if (s1 != null) {
                        list.addAll(this.fontRendererObj.listFormattedStringToWidth(s1, 150));
                    }
                    this.drawHoveringText(list, p_handleComponentHover_2_, p_handleComponentHover_3_);
                } else {
                    this.drawCreativeTabHoveringText((Object)((Object)TextFormatting.RED) + "Invalid statistic/achievement!", p_handleComponentHover_2_, p_handleComponentHover_3_);
                }
            }
            GlStateManager.disableLighting();
        }
    }

    protected void setText(String p_setText_1_, boolean p_setText_2_) {
    }

    protected boolean handleComponentClick(ITextComponent p_handleComponentClick_1_) {
        if (p_handleComponentClick_1_ == null) {
            return false;
        }
        ClickEvent clickevent = p_handleComponentClick_1_.getStyle().getClickEvent();
        if (GuiScreen.isShiftKeyDown()) {
            if (p_handleComponentClick_1_.getStyle().getInsertion() != null) {
                this.setText(p_handleComponentClick_1_.getStyle().getInsertion(), false);
            }
        } else if (clickevent != null) {
            block19: {
                if (clickevent.getAction() == ClickEvent.Action.OPEN_URL) {
                    if (!this.mc.gameSettings.chatLinks) {
                        return false;
                    }
                    try {
                        URI uri = new URI(clickevent.getValue());
                        String s = uri.getScheme();
                        if (s == null) {
                            throw new URISyntaxException(clickevent.getValue(), "Missing protocol");
                        }
                        if (!PROTOCOLS.contains(s.toLowerCase(Locale.ROOT))) {
                            throw new URISyntaxException(clickevent.getValue(), "Unsupported protocol: " + s.toLowerCase(Locale.ROOT));
                        }
                        if (this.mc.gameSettings.chatLinksPrompt) {
                            this.clickedLinkURI = uri;
                            this.mc.displayGuiScreen(new GuiConfirmOpenLink((GuiYesNoCallback)this, clickevent.getValue(), 31102009, false));
                            break block19;
                        }
                        this.openWebLink(uri);
                    }
                    catch (URISyntaxException urisyntaxexception) {
                        LOGGER.error("Can't open url for {}", new Object[]{clickevent, urisyntaxexception});
                    }
                } else if (clickevent.getAction() == ClickEvent.Action.OPEN_FILE) {
                    URI uri1 = new File(clickevent.getValue()).toURI();
                    this.openWebLink(uri1);
                } else if (clickevent.getAction() == ClickEvent.Action.SUGGEST_COMMAND) {
                    this.setText(clickevent.getValue(), true);
                } else if (clickevent.getAction() == ClickEvent.Action.RUN_COMMAND) {
                    this.sendChatMessage(clickevent.getValue(), false);
                } else {
                    LOGGER.error("Don't know how to handle {}", new Object[]{clickevent});
                }
            }
            return true;
        }
        return false;
    }

    public void sendChatMessage(String p_sendChatMessage_1_) {
        this.sendChatMessage(p_sendChatMessage_1_, true);
    }

    public void sendChatMessage(String p_sendChatMessage_1_, boolean p_sendChatMessage_2_) {
        if (p_sendChatMessage_2_) {
            this.mc.ingameGUI.getChatGUI().addToSentMessages(p_sendChatMessage_1_);
        }
        if (ClientCommandHandler.instance.executeCommand(this.mc.player, p_sendChatMessage_1_) != 0) {
            return;
        }
        this.mc.player.sendChatMessage(p_sendChatMessage_1_);
    }

    protected void mouseClicked(int p_mouseClicked_1_, int p_mouseClicked_2_, int p_mouseClicked_3_) throws IOException {
        if (p_mouseClicked_3_ == 0) {
            for (int i = 0; i < this.buttonList.size(); ++i) {
                GuiButton guibutton = this.buttonList.get(i);
                if (!guibutton.mousePressed(this.mc, p_mouseClicked_1_, p_mouseClicked_2_)) continue;
                GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre(this, guibutton, this.buttonList);
                if (MinecraftForge.EVENT_BUS.post(event)) break;
                this.selectedButton = guibutton = event.getButton();
                guibutton.playPressSound(this.mc.getSoundHandler());
                this.actionPerformed(guibutton);
                if (!this.equals(this.mc.currentScreen)) continue;
                MinecraftForge.EVENT_BUS.post(new GuiScreenEvent.ActionPerformedEvent.Post(this, event.getButton(), this.buttonList));
            }
        }
    }

    protected void mouseReleased(int p_mouseReleased_1_, int p_mouseReleased_2_, int p_mouseReleased_3_) {
        if (this.selectedButton != null && p_mouseReleased_3_ == 0) {
            this.selectedButton.mouseReleased(p_mouseReleased_1_, p_mouseReleased_2_);
            this.selectedButton = null;
        }
    }

    protected void mouseClickMove(int p_mouseClickMove_1_, int p_mouseClickMove_2_, int p_mouseClickMove_3_, long p_mouseClickMove_4_) {
    }

    protected void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
    }

    public void setWorldAndResolution(Minecraft p_setWorldAndResolution_1_, int p_setWorldAndResolution_2_, int p_setWorldAndResolution_3_) {
        this.mc = p_setWorldAndResolution_1_;
        this.itemRender = p_setWorldAndResolution_1_.getRenderItem();
        this.fontRendererObj = p_setWorldAndResolution_1_.fontRendererObj;
        this.width = p_setWorldAndResolution_2_;
        this.height = p_setWorldAndResolution_3_;
        if (!MinecraftForge.EVENT_BUS.post(new GuiScreenEvent.InitGuiEvent.Pre(this, this.buttonList))) {
            this.buttonList.clear();
            this.initGui();
        }
        MinecraftForge.EVENT_BUS.post(new GuiScreenEvent.InitGuiEvent.Post(this, this.buttonList));
    }

    public void setGuiSize(int p_setGuiSize_1_, int p_setGuiSize_2_) {
        this.width = p_setGuiSize_1_;
        this.height = p_setGuiSize_2_;
    }

    public void initGui() {
    }

    public void handleInput() throws IOException {
        if (Mouse.isCreated()) {
            while (Mouse.next()) {
                this.mouseHandled = false;
                if (MinecraftForge.EVENT_BUS.post(new GuiScreenEvent.MouseInputEvent.Pre(this))) continue;
                this.handleMouseInput();
                if (!this.equals(this.mc.currentScreen) || this.mouseHandled) continue;
                MinecraftForge.EVENT_BUS.post(new GuiScreenEvent.MouseInputEvent.Post(this));
            }
        }
        if (Keyboard.isCreated()) {
            while (Keyboard.next()) {
                this.keyHandled = false;
                if (MinecraftForge.EVENT_BUS.post(new GuiScreenEvent.KeyboardInputEvent.Pre(this))) continue;
                this.handleKeyboardInput();
                if (!this.equals(this.mc.currentScreen) || this.keyHandled) continue;
                MinecraftForge.EVENT_BUS.post(new GuiScreenEvent.KeyboardInputEvent.Post(this));
            }
        }
    }

    public void handleMouseInput() throws IOException {
        int i = Mouse.getEventX() * this.width / this.mc.displayWidth;
        int j = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
        int k = Mouse.getEventButton();
        if (Mouse.getEventButtonState()) {
            if (this.mc.gameSettings.touchscreen && this.touchValue++ > 0) {
                return;
            }
            this.eventButton = k;
            this.lastMouseEvent = Minecraft.getSystemTime();
            this.mouseClicked(i, j, this.eventButton);
        } else if (k != -1) {
            if (this.mc.gameSettings.touchscreen && --this.touchValue > 0) {
                return;
            }
            this.eventButton = -1;
            this.mouseReleased(i, j, k);
        } else if (this.eventButton != -1 && this.lastMouseEvent > 0L) {
            long l = Minecraft.getSystemTime() - this.lastMouseEvent;
            this.mouseClickMove(i, j, this.eventButton, l);
        }
    }

    public void handleKeyboardInput() throws IOException {
        char c0 = Keyboard.getEventCharacter();
        if (Keyboard.getEventKey() == 0 && c0 >= ' ' || Keyboard.getEventKeyState()) {
            this.keyTyped(c0, Keyboard.getEventKey());
        }
        this.mc.dispatchKeypresses();
    }

    public void updateScreen() {
    }

    public void onGuiClosed() {
    }

    public void drawDefaultBackground() {
        this.drawWorldBackground(0);
        MinecraftForge.EVENT_BUS.post(new GuiScreenEvent.BackgroundDrawnEvent(this));
    }

    public void drawWorldBackground(int p_drawWorldBackground_1_) {
        if (this.mc.world != null) {
            this.drawGradientRect(0, 0, this.width, this.height, -1072689136, -804253680);
        } else {
            this.drawBackground(p_drawWorldBackground_1_);
        }
    }

    public void drawBackground(int p_drawBackground_1_) {
        GlStateManager.disableLighting();
        GlStateManager.disableFog();
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        this.mc.getTextureManager().bindTexture(OPTIONS_BACKGROUND);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        float f = 32.0f;
        vertexbuffer.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
        vertexbuffer.pos(0.0, this.height, 0.0).tex(0.0, (float)this.height / 32.0f + (float)p_drawBackground_1_).color(64, 64, 64, 255).endVertex();
        vertexbuffer.pos(this.width, this.height, 0.0).tex((float)this.width / 32.0f, (float)this.height / 32.0f + (float)p_drawBackground_1_).color(64, 64, 64, 255).endVertex();
        vertexbuffer.pos(this.width, 0.0, 0.0).tex((float)this.width / 32.0f, p_drawBackground_1_).color(64, 64, 64, 255).endVertex();
        vertexbuffer.pos(0.0, 0.0, 0.0).tex(0.0, p_drawBackground_1_).color(64, 64, 64, 255).endVertex();
        tessellator.draw();
    }

    public boolean doesGuiPauseGame() {
        return true;
    }

    @Override
    public void confirmClicked(boolean p_confirmClicked_1_, int p_confirmClicked_2_) {
        if (p_confirmClicked_2_ == 31102009) {
            if (p_confirmClicked_1_) {
                this.openWebLink(this.clickedLinkURI);
            }
            this.clickedLinkURI = null;
            this.mc.displayGuiScreen(this);
        }
    }

    private void openWebLink(URI p_openWebLink_1_) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, p_openWebLink_1_);
        }
        catch (Throwable throwable1) {
            Throwable throwable = throwable1.getCause();
            LOGGER.error("Couldn't open link: {}", new Object[]{throwable == null ? "<UNKNOWN>" : throwable.getMessage()});
        }
    }

    public static boolean isCtrlKeyDown() {
        return Minecraft.IS_RUNNING_ON_MAC ? Keyboard.isKeyDown((int)219) || Keyboard.isKeyDown((int)220) : Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static boolean isAltKeyDown() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }

    public static boolean isKeyComboCtrlX(int p_isKeyComboCtrlX_0_) {
        return p_isKeyComboCtrlX_0_ == 45 && GuiScreen.isCtrlKeyDown() && !GuiScreen.isShiftKeyDown() && !GuiScreen.isAltKeyDown();
    }

    public static boolean isKeyComboCtrlV(int p_isKeyComboCtrlV_0_) {
        return p_isKeyComboCtrlV_0_ == 47 && GuiScreen.isCtrlKeyDown() && !GuiScreen.isShiftKeyDown() && !GuiScreen.isAltKeyDown();
    }

    public static boolean isKeyComboCtrlC(int p_isKeyComboCtrlC_0_) {
        return p_isKeyComboCtrlC_0_ == 46 && GuiScreen.isCtrlKeyDown() && !GuiScreen.isShiftKeyDown() && !GuiScreen.isAltKeyDown();
    }

    public static boolean isKeyComboCtrlA(int p_isKeyComboCtrlA_0_) {
        return p_isKeyComboCtrlA_0_ == 30 && GuiScreen.isCtrlKeyDown() && !GuiScreen.isShiftKeyDown() && !GuiScreen.isAltKeyDown();
    }

    public void onResize(Minecraft p_onResize_1_, int p_onResize_2_, int p_onResize_3_) {
        this.setWorldAndResolution(p_onResize_1_, p_onResize_2_, p_onResize_3_);
    }
}

