/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import com.google.gson.JsonParseException;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWrittenBook;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiScreenBook
extends GuiScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation BOOK_GUI_TEXTURES = new ResourceLocation("textures/gui/book.png");
    private final EntityPlayer editingPlayer;
    private final ItemStack bookObj;
    private final boolean bookIsUnsigned;
    private boolean bookIsModified;
    private boolean bookGettingSigned;
    private int updateCount;
    private final int bookImageWidth = 192;
    private final int bookImageHeight = 192;
    private int bookTotalPages = 1;
    private int currPage;
    private NBTTagList bookPages;
    private String bookTitle = "";
    private List<ITextComponent> cachedComponents;
    private int cachedPage = -1;
    private NextPageButton buttonNextPage;
    private NextPageButton buttonPreviousPage;
    private GuiButton buttonDone;
    private GuiButton buttonSign;
    private GuiButton buttonFinalize;
    private GuiButton buttonCancel;

    public GuiScreenBook(EntityPlayer p_i1080_1_, ItemStack p_i1080_2_, boolean p_i1080_3_) {
        this.editingPlayer = p_i1080_1_;
        this.bookObj = p_i1080_2_;
        this.bookIsUnsigned = p_i1080_3_;
        if (p_i1080_2_.hasTagCompound()) {
            NBTTagCompound lvt_4_1_ = p_i1080_2_.getTagCompound();
            this.bookPages = lvt_4_1_.getTagList("pages", 8).copy();
            this.bookTotalPages = this.bookPages.tagCount();
            if (this.bookTotalPages < 1) {
                this.bookTotalPages = 1;
            }
        }
        if (this.bookPages == null && p_i1080_3_) {
            this.bookPages = new NBTTagList();
            this.bookPages.appendTag(new NBTTagString(""));
            this.bookTotalPages = 1;
        }
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        ++this.updateCount;
    }

    @Override
    public void initGui() {
        this.buttonList.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        if (this.bookIsUnsigned) {
            this.buttonSign = this.addButton(new GuiButton(3, this.width / 2 - 100, 196, 98, 20, I18n.format("book.signButton", new Object[0])));
            this.buttonDone = this.addButton(new GuiButton(0, this.width / 2 + 2, 196, 98, 20, I18n.format("gui.done", new Object[0])));
            this.buttonFinalize = this.addButton(new GuiButton(5, this.width / 2 - 100, 196, 98, 20, I18n.format("book.finalizeButton", new Object[0])));
            this.buttonCancel = this.addButton(new GuiButton(4, this.width / 2 + 2, 196, 98, 20, I18n.format("gui.cancel", new Object[0])));
        } else {
            this.buttonDone = this.addButton(new GuiButton(0, this.width / 2 - 100, 196, 200, 20, I18n.format("gui.done", new Object[0])));
        }
        int lvt_1_1_ = (this.width - 192) / 2;
        int lvt_2_1_ = 2;
        this.buttonNextPage = this.addButton(new NextPageButton(1, lvt_1_1_ + 120, 156, true));
        this.buttonPreviousPage = this.addButton(new NextPageButton(2, lvt_1_1_ + 38, 156, false));
        this.updateButtons();
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private void updateButtons() {
        this.buttonNextPage.visible = !this.bookGettingSigned && (this.currPage < this.bookTotalPages - 1 || this.bookIsUnsigned);
        this.buttonPreviousPage.visible = !this.bookGettingSigned && this.currPage > 0;
        boolean bl = this.buttonDone.visible = !this.bookIsUnsigned || !this.bookGettingSigned;
        if (this.bookIsUnsigned) {
            this.buttonSign.visible = !this.bookGettingSigned;
            this.buttonCancel.visible = this.bookGettingSigned;
            this.buttonFinalize.visible = this.bookGettingSigned;
            this.buttonFinalize.enabled = !this.bookTitle.trim().isEmpty();
        }
    }

    private void sendBookToServer(boolean p_sendBookToServer_1_) throws IOException {
        if (!this.bookIsUnsigned || !this.bookIsModified) {
            return;
        }
        if (this.bookPages != null) {
            String lvt_2_1_;
            while (this.bookPages.tagCount() > 1 && (lvt_2_1_ = this.bookPages.getStringTagAt(this.bookPages.tagCount() - 1)).isEmpty()) {
                this.bookPages.removeTag(this.bookPages.tagCount() - 1);
            }
            if (this.bookObj.hasTagCompound()) {
                NBTTagCompound lvt_2_2_ = this.bookObj.getTagCompound();
                lvt_2_2_.setTag("pages", this.bookPages);
            } else {
                this.bookObj.setTagInfo("pages", this.bookPages);
            }
            String lvt_2_3_ = "MC|BEdit";
            if (p_sendBookToServer_1_) {
                lvt_2_3_ = "MC|BSign";
                this.bookObj.setTagInfo("author", new NBTTagString(this.editingPlayer.getName()));
                this.bookObj.setTagInfo("title", new NBTTagString(this.bookTitle.trim()));
            }
            PacketBuffer lvt_3_1_ = new PacketBuffer(Unpooled.buffer());
            lvt_3_1_.writeItemStack(this.bookObj);
            this.mc.getConnection().sendPacket(new CPacketCustomPayload(lvt_2_3_, lvt_3_1_));
        }
    }

    @Override
    protected void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
        if (!p_actionPerformed_1_.enabled) {
            return;
        }
        if (p_actionPerformed_1_.id == 0) {
            this.mc.displayGuiScreen(null);
            this.sendBookToServer(false);
        } else if (p_actionPerformed_1_.id == 3 && this.bookIsUnsigned) {
            this.bookGettingSigned = true;
        } else if (p_actionPerformed_1_.id == 1) {
            if (this.currPage < this.bookTotalPages - 1) {
                ++this.currPage;
            } else if (this.bookIsUnsigned) {
                this.addNewPage();
                if (this.currPage < this.bookTotalPages - 1) {
                    ++this.currPage;
                }
            }
        } else if (p_actionPerformed_1_.id == 2) {
            if (this.currPage > 0) {
                --this.currPage;
            }
        } else if (p_actionPerformed_1_.id == 5 && this.bookGettingSigned) {
            this.sendBookToServer(true);
            this.mc.displayGuiScreen(null);
        } else if (p_actionPerformed_1_.id == 4 && this.bookGettingSigned) {
            this.bookGettingSigned = false;
        }
        this.updateButtons();
    }

    private void addNewPage() {
        if (this.bookPages == null || this.bookPages.tagCount() >= 50) {
            return;
        }
        this.bookPages.appendTag(new NBTTagString(""));
        ++this.bookTotalPages;
        this.bookIsModified = true;
    }

    @Override
    protected void keyTyped(char p_keyTyped_1_, int p_keyTyped_2_) throws IOException {
        super.keyTyped(p_keyTyped_1_, p_keyTyped_2_);
        if (!this.bookIsUnsigned) {
            return;
        }
        if (this.bookGettingSigned) {
            this.keyTypedInTitle(p_keyTyped_1_, p_keyTyped_2_);
        } else {
            this.keyTypedInBook(p_keyTyped_1_, p_keyTyped_2_);
        }
    }

    private void keyTypedInBook(char p_keyTypedInBook_1_, int p_keyTypedInBook_2_) {
        if (GuiScreen.isKeyComboCtrlV(p_keyTypedInBook_2_)) {
            this.pageInsertIntoCurrent(GuiScreen.getClipboardString());
            return;
        }
        switch (p_keyTypedInBook_2_) {
            case 14: {
                String lvt_3_1_ = this.pageGetCurrent();
                if (!lvt_3_1_.isEmpty()) {
                    this.pageSetCurrent(lvt_3_1_.substring(0, lvt_3_1_.length() - 1));
                }
                return;
            }
            case 28: 
            case 156: {
                this.pageInsertIntoCurrent("\n");
                return;
            }
        }
        if (ChatAllowedCharacters.isAllowedCharacter(p_keyTypedInBook_1_)) {
            this.pageInsertIntoCurrent(Character.toString(p_keyTypedInBook_1_));
            return;
        }
    }

    private void keyTypedInTitle(char p_keyTypedInTitle_1_, int p_keyTypedInTitle_2_) throws IOException {
        switch (p_keyTypedInTitle_2_) {
            case 14: {
                if (!this.bookTitle.isEmpty()) {
                    this.bookTitle = this.bookTitle.substring(0, this.bookTitle.length() - 1);
                    this.updateButtons();
                }
                return;
            }
            case 28: 
            case 156: {
                if (!this.bookTitle.isEmpty()) {
                    this.sendBookToServer(true);
                    this.mc.displayGuiScreen(null);
                }
                return;
            }
        }
        if (this.bookTitle.length() < 16 && ChatAllowedCharacters.isAllowedCharacter(p_keyTypedInTitle_1_)) {
            this.bookTitle = this.bookTitle + Character.toString(p_keyTypedInTitle_1_);
            this.updateButtons();
            this.bookIsModified = true;
        }
    }

    private String pageGetCurrent() {
        if (this.bookPages != null && this.currPage >= 0 && this.currPage < this.bookPages.tagCount()) {
            return this.bookPages.getStringTagAt(this.currPage);
        }
        return "";
    }

    private void pageSetCurrent(String p_pageSetCurrent_1_) {
        if (this.bookPages != null && this.currPage >= 0 && this.currPage < this.bookPages.tagCount()) {
            this.bookPages.set(this.currPage, new NBTTagString(p_pageSetCurrent_1_));
            this.bookIsModified = true;
        }
    }

    private void pageInsertIntoCurrent(String p_pageInsertIntoCurrent_1_) {
        String lvt_2_1_ = this.pageGetCurrent();
        String lvt_3_1_ = lvt_2_1_ + p_pageInsertIntoCurrent_1_;
        int lvt_4_1_ = this.fontRendererObj.getWordWrappedHeight(lvt_3_1_ + "" + (Object)((Object)TextFormatting.BLACK) + "_", 118);
        if (lvt_4_1_ <= 128 && lvt_3_1_.length() < 256) {
            this.pageSetCurrent(lvt_3_1_);
        }
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.getTextureManager().bindTexture(BOOK_GUI_TEXTURES);
        int lvt_4_1_ = (this.width - 192) / 2;
        int lvt_5_1_ = 2;
        this.drawTexturedModalRect(lvt_4_1_, 2, 0, 0, 192, 192);
        if (this.bookGettingSigned) {
            String lvt_6_1_ = this.bookTitle;
            if (this.bookIsUnsigned) {
                lvt_6_1_ = this.updateCount / 6 % 2 == 0 ? lvt_6_1_ + "" + (Object)((Object)TextFormatting.BLACK) + "_" : lvt_6_1_ + "" + (Object)((Object)TextFormatting.GRAY) + "_";
            }
            String lvt_7_1_ = I18n.format("book.editTitle", new Object[0]);
            int lvt_8_1_ = this.fontRendererObj.getStringWidth(lvt_7_1_);
            this.fontRendererObj.drawString(lvt_7_1_, lvt_4_1_ + 36 + (116 - lvt_8_1_) / 2, 34, 0);
            int lvt_9_1_ = this.fontRendererObj.getStringWidth(lvt_6_1_);
            this.fontRendererObj.drawString(lvt_6_1_, lvt_4_1_ + 36 + (116 - lvt_9_1_) / 2, 50, 0);
            String lvt_10_1_ = I18n.format("book.byAuthor", this.editingPlayer.getName());
            int lvt_11_1_ = this.fontRendererObj.getStringWidth(lvt_10_1_);
            this.fontRendererObj.drawString((Object)((Object)TextFormatting.DARK_GRAY) + lvt_10_1_, lvt_4_1_ + 36 + (116 - lvt_11_1_) / 2, 60, 0);
            String lvt_12_1_ = I18n.format("book.finalizeWarning", new Object[0]);
            this.fontRendererObj.drawSplitString(lvt_12_1_, lvt_4_1_ + 36, 82, 116, 0);
        } else {
            String lvt_6_2_ = I18n.format("book.pageIndicator", this.currPage + 1, this.bookTotalPages);
            String lvt_7_2_ = "";
            if (this.bookPages != null && this.currPage >= 0 && this.currPage < this.bookPages.tagCount()) {
                lvt_7_2_ = this.bookPages.getStringTagAt(this.currPage);
            }
            if (this.bookIsUnsigned) {
                lvt_7_2_ = this.fontRendererObj.getBidiFlag() ? lvt_7_2_ + "_" : (this.updateCount / 6 % 2 == 0 ? lvt_7_2_ + "" + (Object)((Object)TextFormatting.BLACK) + "_" : lvt_7_2_ + "" + (Object)((Object)TextFormatting.GRAY) + "_");
            } else if (this.cachedPage != this.currPage) {
                if (ItemWrittenBook.validBookTagContents(this.bookObj.getTagCompound())) {
                    try {
                        ITextComponent lvt_8_2_ = ITextComponent.Serializer.jsonToComponent(lvt_7_2_);
                        this.cachedComponents = lvt_8_2_ != null ? GuiUtilRenderComponents.splitText(lvt_8_2_, 116, this.fontRendererObj, true, true) : null;
                    }
                    catch (JsonParseException lvt_8_3_) {
                        this.cachedComponents = null;
                    }
                } else {
                    TextComponentString lvt_8_4_ = new TextComponentString((Object)((Object)TextFormatting.DARK_RED) + "* Invalid book tag *");
                    this.cachedComponents = Lists.newArrayList((Iterable)lvt_8_4_);
                }
                this.cachedPage = this.currPage;
            }
            int lvt_8_5_ = this.fontRendererObj.getStringWidth(lvt_6_2_);
            this.fontRendererObj.drawString(lvt_6_2_, lvt_4_1_ - lvt_8_5_ + 192 - 44, 18, 0);
            if (this.cachedComponents == null) {
                this.fontRendererObj.drawSplitString(lvt_7_2_, lvt_4_1_ + 36, 34, 116, 0);
            } else {
                int lvt_9_2_ = Math.min(128 / this.fontRendererObj.FONT_HEIGHT, this.cachedComponents.size());
                for (int lvt_10_2_ = 0; lvt_10_2_ < lvt_9_2_; ++lvt_10_2_) {
                    ITextComponent lvt_11_2_ = this.cachedComponents.get(lvt_10_2_);
                    this.fontRendererObj.drawString(lvt_11_2_.getUnformattedText(), lvt_4_1_ + 36, 34 + lvt_10_2_ * this.fontRendererObj.FONT_HEIGHT, 0);
                }
                ITextComponent lvt_10_3_ = this.getClickedComponentAt(p_drawScreen_1_, p_drawScreen_2_);
                if (lvt_10_3_ != null) {
                    this.handleComponentHover(lvt_10_3_, p_drawScreen_1_, p_drawScreen_2_);
                }
            }
        }
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
    }

    @Override
    protected void mouseClicked(int p_mouseClicked_1_, int p_mouseClicked_2_, int p_mouseClicked_3_) throws IOException {
        ITextComponent lvt_4_1_;
        if (p_mouseClicked_3_ == 0 && (lvt_4_1_ = this.getClickedComponentAt(p_mouseClicked_1_, p_mouseClicked_2_)) != null && this.handleComponentClick(lvt_4_1_)) {
            return;
        }
        super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
    }

    @Override
    protected boolean handleComponentClick(ITextComponent p_handleComponentClick_1_) {
        ClickEvent lvt_2_1_ = p_handleComponentClick_1_.getStyle().getClickEvent();
        if (lvt_2_1_ == null) {
            return false;
        }
        if (lvt_2_1_.getAction() == ClickEvent.Action.CHANGE_PAGE) {
            String lvt_3_1_ = lvt_2_1_.getValue();
            try {
                int lvt_4_1_ = Integer.parseInt(lvt_3_1_) - 1;
                if (lvt_4_1_ >= 0 && lvt_4_1_ < this.bookTotalPages && lvt_4_1_ != this.currPage) {
                    this.currPage = lvt_4_1_;
                    this.updateButtons();
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }
        boolean lvt_3_2_ = super.handleComponentClick(p_handleComponentClick_1_);
        if (lvt_3_2_ && lvt_2_1_.getAction() == ClickEvent.Action.RUN_COMMAND) {
            this.mc.displayGuiScreen(null);
        }
        return lvt_3_2_;
    }

    @Nullable
    public ITextComponent getClickedComponentAt(int p_getClickedComponentAt_1_, int p_getClickedComponentAt_2_) {
        if (this.cachedComponents == null) {
            return null;
        }
        int lvt_3_1_ = p_getClickedComponentAt_1_ - (this.width - 192) / 2 - 36;
        int lvt_4_1_ = p_getClickedComponentAt_2_ - 2 - 16 - 16;
        if (lvt_3_1_ < 0 || lvt_4_1_ < 0) {
            return null;
        }
        int lvt_5_1_ = Math.min(128 / this.fontRendererObj.FONT_HEIGHT, this.cachedComponents.size());
        if (lvt_3_1_ <= 116 && lvt_4_1_ < this.mc.fontRendererObj.FONT_HEIGHT * lvt_5_1_ + lvt_5_1_) {
            int lvt_6_1_ = lvt_4_1_ / this.mc.fontRendererObj.FONT_HEIGHT;
            if (lvt_6_1_ >= 0 && lvt_6_1_ < this.cachedComponents.size()) {
                ITextComponent lvt_7_1_ = this.cachedComponents.get(lvt_6_1_);
                int lvt_8_1_ = 0;
                for (ITextComponent lvt_10_1_ : lvt_7_1_) {
                    if (!(lvt_10_1_ instanceof TextComponentString) || (lvt_8_1_ += this.mc.fontRendererObj.getStringWidth(((TextComponentString)lvt_10_1_).getText())) <= lvt_3_1_) continue;
                    return lvt_10_1_;
                }
            }
            return null;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    static class NextPageButton
    extends GuiButton {
        private final boolean isForward;

        public NextPageButton(int p_i46316_1_, int p_i46316_2_, int p_i46316_3_, boolean p_i46316_4_) {
            super(p_i46316_1_, p_i46316_2_, p_i46316_3_, 23, 13, "");
            this.isForward = p_i46316_4_;
        }

        @Override
        public void drawButton(Minecraft p_drawButton_1_, int p_drawButton_2_, int p_drawButton_3_) {
            if (!this.visible) {
                return;
            }
            boolean lvt_4_1_ = p_drawButton_2_ >= this.xPosition && p_drawButton_3_ >= this.yPosition && p_drawButton_2_ < this.xPosition + this.width && p_drawButton_3_ < this.yPosition + this.height;
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            p_drawButton_1_.getTextureManager().bindTexture(BOOK_GUI_TEXTURES);
            int lvt_5_1_ = 0;
            int lvt_6_1_ = 192;
            if (lvt_4_1_) {
                lvt_5_1_ += 23;
            }
            if (!this.isForward) {
                lvt_6_1_ += 13;
            }
            this.drawTexturedModalRect(this.xPosition, this.yPosition, lvt_5_1_, lvt_6_1_, 23, 13);
        }
    }
}

