/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiOptionButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiScreenOptionsSounds
extends GuiScreen {
    private final GuiScreen parent;
    private final GameSettings game_settings_4;
    protected String title = "Options";
    private String offDisplayString;

    public GuiScreenOptionsSounds(GuiScreen p_i45025_1_, GameSettings p_i45025_2_) {
        this.parent = p_i45025_1_;
        this.game_settings_4 = p_i45025_2_;
    }

    @Override
    public void initGui() {
        this.title = I18n.format("options.sounds.title", new Object[0]);
        this.offDisplayString = I18n.format("options.off", new Object[0]);
        int lvt_1_1_ = 0;
        this.buttonList.add(new Button(SoundCategory.MASTER.ordinal(), this.width / 2 - 155 + lvt_1_1_ % 2 * 160, this.height / 6 - 12 + 24 * (lvt_1_1_ >> 1), SoundCategory.MASTER, true));
        lvt_1_1_ += 2;
        for (SoundCategory lvt_5_1_ : SoundCategory.values()) {
            if (lvt_5_1_ == SoundCategory.MASTER) continue;
            this.buttonList.add(new Button(lvt_5_1_.ordinal(), this.width / 2 - 155 + lvt_1_1_ % 2 * 160, this.height / 6 - 12 + 24 * (lvt_1_1_ >> 1), lvt_5_1_, false));
            ++lvt_1_1_;
        }
        this.buttonList.add(new GuiOptionButton(201, this.width / 2 - 75, this.height / 6 - 12 + 24 * (++lvt_1_1_ >> 1), GameSettings.Options.SHOW_SUBTITLES, this.game_settings_4.getKeyBinding(GameSettings.Options.SHOW_SUBTITLES)));
        this.buttonList.add(new GuiButton(200, this.width / 2 - 100, this.height / 6 + 168, I18n.format("gui.done", new Object[0])));
    }

    @Override
    protected void keyTyped(char p_keyTyped_1_, int p_keyTyped_2_) throws IOException {
        if (p_keyTyped_2_ == 1) {
            this.mc.gameSettings.saveOptions();
        }
        super.keyTyped(p_keyTyped_1_, p_keyTyped_2_);
    }

    @Override
    protected void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
        if (!p_actionPerformed_1_.enabled) {
            return;
        }
        if (p_actionPerformed_1_.id == 200) {
            this.mc.gameSettings.saveOptions();
            this.mc.displayGuiScreen(this.parent);
        } else if (p_actionPerformed_1_.id == 201) {
            this.mc.gameSettings.setOptionValue(GameSettings.Options.SHOW_SUBTITLES, 1);
            p_actionPerformed_1_.displayString = this.mc.gameSettings.getKeyBinding(GameSettings.Options.SHOW_SUBTITLES);
            this.mc.gameSettings.saveOptions();
        }
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRendererObj, this.title, this.width / 2, 15, 0xFFFFFF);
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
    }

    protected String getDisplayString(SoundCategory p_getDisplayString_1_) {
        float lvt_2_1_ = this.game_settings_4.getSoundLevel(p_getDisplayString_1_);
        if (lvt_2_1_ == 0.0f) {
            return this.offDisplayString;
        }
        return (int)(lvt_2_1_ * 100.0f) + "%";
    }

    @SideOnly(value=Side.CLIENT)
    class Button
    extends GuiButton {
        private final SoundCategory category;
        private final String categoryName;
        public float volume;
        public boolean pressed;

        public Button(int p_i46744_2_, int p_i46744_3_, int p_i46744_4_, SoundCategory p_i46744_5_, boolean p_i46744_6_) {
            super(p_i46744_2_, p_i46744_3_, p_i46744_4_, p_i46744_6_ ? 310 : 150, 20, "");
            this.volume = 1.0f;
            this.category = p_i46744_5_;
            this.categoryName = I18n.format("soundCategory." + p_i46744_5_.getName(), new Object[0]);
            this.displayString = this.categoryName + ": " + GuiScreenOptionsSounds.this.getDisplayString(p_i46744_5_);
            this.volume = GuiScreenOptionsSounds.this.game_settings_4.getSoundLevel(p_i46744_5_);
        }

        @Override
        protected int getHoverState(boolean p_getHoverState_1_) {
            return 0;
        }

        @Override
        protected void mouseDragged(Minecraft p_mouseDragged_1_, int p_mouseDragged_2_, int p_mouseDragged_3_) {
            if (!this.visible) {
                return;
            }
            if (this.pressed) {
                this.volume = (float)(p_mouseDragged_2_ - (this.xPosition + 4)) / (float)(this.width - 8);
                this.volume = MathHelper.clamp(this.volume, 0.0f, 1.0f);
                p_mouseDragged_1_.gameSettings.setSoundLevel(this.category, this.volume);
                p_mouseDragged_1_.gameSettings.saveOptions();
                this.displayString = this.categoryName + ": " + GuiScreenOptionsSounds.this.getDisplayString(this.category);
            }
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            this.drawTexturedModalRect(this.xPosition + (int)(this.volume * (float)(this.width - 8)), this.yPosition, 0, 66, 4, 20);
            this.drawTexturedModalRect(this.xPosition + (int)(this.volume * (float)(this.width - 8)) + 4, this.yPosition, 196, 66, 4, 20);
        }

        @Override
        public boolean mousePressed(Minecraft p_mousePressed_1_, int p_mousePressed_2_, int p_mousePressed_3_) {
            if (super.mousePressed(p_mousePressed_1_, p_mousePressed_2_, p_mousePressed_3_)) {
                this.volume = (float)(p_mousePressed_2_ - (this.xPosition + 4)) / (float)(this.width - 8);
                this.volume = MathHelper.clamp(this.volume, 0.0f, 1.0f);
                p_mousePressed_1_.gameSettings.setSoundLevel(this.category, this.volume);
                p_mousePressed_1_.gameSettings.saveOptions();
                this.displayString = this.categoryName + ": " + GuiScreenOptionsSounds.this.getDisplayString(this.category);
                this.pressed = true;
                return true;
            }
            return false;
        }

        @Override
        public void playPressSound(SoundHandler p_playPressSound_1_) {
        }

        @Override
        public void mouseReleased(int p_mouseReleased_1_, int p_mouseReleased_2_) {
            if (this.pressed) {
                GuiScreenOptionsSounds.this.mc.getSoundHandler().playSound(PositionedSoundRecord.getMasterRecord(SoundEvents.UI_BUTTON_CLICK, 1.0f));
            }
            this.pressed = false;
        }
    }
}

