/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonRealmsProxy;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsScreen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiScreenRealmsProxy
extends GuiScreen {
    private final RealmsScreen proxy;

    public GuiScreenRealmsProxy(RealmsScreen p_i1087_1_) {
        this.proxy = p_i1087_1_;
        this.buttonList = Collections.synchronizedList(Lists.newArrayList());
    }

    public RealmsScreen getProxy() {
        return this.proxy;
    }

    @Override
    public void initGui() {
        this.proxy.init();
        super.initGui();
    }

    public void drawCenteredString(String p_drawCenteredString_1_, int p_drawCenteredString_2_, int p_drawCenteredString_3_, int p_drawCenteredString_4_) {
        super.drawCenteredString(this.fontRendererObj, p_drawCenteredString_1_, p_drawCenteredString_2_, p_drawCenteredString_3_, p_drawCenteredString_4_);
    }

    public void drawString(String p_drawString_1_, int p_drawString_2_, int p_drawString_3_, int p_drawString_4_, boolean p_drawString_5_) {
        if (p_drawString_5_) {
            super.drawString(this.fontRendererObj, p_drawString_1_, p_drawString_2_, p_drawString_3_, p_drawString_4_);
        } else {
            this.fontRendererObj.drawString(p_drawString_1_, p_drawString_2_, p_drawString_3_, p_drawString_4_);
        }
    }

    @Override
    public void drawTexturedModalRect(int p_drawTexturedModalRect_1_, int p_drawTexturedModalRect_2_, int p_drawTexturedModalRect_3_, int p_drawTexturedModalRect_4_, int p_drawTexturedModalRect_5_, int p_drawTexturedModalRect_6_) {
        this.proxy.blit(p_drawTexturedModalRect_1_, p_drawTexturedModalRect_2_, p_drawTexturedModalRect_3_, p_drawTexturedModalRect_4_, p_drawTexturedModalRect_5_, p_drawTexturedModalRect_6_);
        super.drawTexturedModalRect(p_drawTexturedModalRect_1_, p_drawTexturedModalRect_2_, p_drawTexturedModalRect_3_, p_drawTexturedModalRect_4_, p_drawTexturedModalRect_5_, p_drawTexturedModalRect_6_);
    }

    @Override
    public void drawGradientRect(int p_drawGradientRect_1_, int p_drawGradientRect_2_, int p_drawGradientRect_3_, int p_drawGradientRect_4_, int p_drawGradientRect_5_, int p_drawGradientRect_6_) {
        super.drawGradientRect(p_drawGradientRect_1_, p_drawGradientRect_2_, p_drawGradientRect_3_, p_drawGradientRect_4_, p_drawGradientRect_5_, p_drawGradientRect_6_);
    }

    @Override
    public void drawDefaultBackground() {
        super.drawDefaultBackground();
    }

    @Override
    public boolean doesGuiPauseGame() {
        return super.doesGuiPauseGame();
    }

    @Override
    public void drawWorldBackground(int p_drawWorldBackground_1_) {
        super.drawWorldBackground(p_drawWorldBackground_1_);
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        this.proxy.render(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
    }

    @Override
    public void renderToolTip(ItemStack p_renderToolTip_1_, int p_renderToolTip_2_, int p_renderToolTip_3_) {
        super.renderToolTip(p_renderToolTip_1_, p_renderToolTip_2_, p_renderToolTip_3_);
    }

    @Override
    public void drawCreativeTabHoveringText(String p_drawCreativeTabHoveringText_1_, int p_drawCreativeTabHoveringText_2_, int p_drawCreativeTabHoveringText_3_) {
        super.drawCreativeTabHoveringText(p_drawCreativeTabHoveringText_1_, p_drawCreativeTabHoveringText_2_, p_drawCreativeTabHoveringText_3_);
    }

    @Override
    public void drawHoveringText(List<String> p_drawHoveringText_1_, int p_drawHoveringText_2_, int p_drawHoveringText_3_) {
        super.drawHoveringText(p_drawHoveringText_1_, p_drawHoveringText_2_, p_drawHoveringText_3_);
    }

    @Override
    public void updateScreen() {
        this.proxy.tick();
        super.updateScreen();
    }

    public int getFontHeight() {
        return this.fontRendererObj.FONT_HEIGHT;
    }

    public int getStringWidth(String p_getStringWidth_1_) {
        return this.fontRendererObj.getStringWidth(p_getStringWidth_1_);
    }

    public void fontDrawShadow(String p_fontDrawShadow_1_, int p_fontDrawShadow_2_, int p_fontDrawShadow_3_, int p_fontDrawShadow_4_) {
        this.fontRendererObj.drawStringWithShadow(p_fontDrawShadow_1_, p_fontDrawShadow_2_, p_fontDrawShadow_3_, p_fontDrawShadow_4_);
    }

    public List<String> fontSplit(String p_fontSplit_1_, int p_fontSplit_2_) {
        return this.fontRendererObj.listFormattedStringToWidth(p_fontSplit_1_, p_fontSplit_2_);
    }

    @Override
    public final void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
        this.proxy.buttonClicked(((GuiButtonRealmsProxy)p_actionPerformed_1_).getRealmsButton());
    }

    public void buttonsClear() {
        this.buttonList.clear();
    }

    public void buttonsAdd(RealmsButton p_buttonsAdd_1_) {
        this.buttonList.add(p_buttonsAdd_1_.getProxy());
    }

    public List<RealmsButton> buttons() {
        ArrayList lvt_1_1_ = Lists.newArrayListWithExpectedSize((int)this.buttonList.size());
        for (GuiButton lvt_3_1_ : this.buttonList) {
            lvt_1_1_.add(((GuiButtonRealmsProxy)lvt_3_1_).getRealmsButton());
        }
        return lvt_1_1_;
    }

    public void buttonsRemove(RealmsButton p_buttonsRemove_1_) {
        this.buttonList.remove(p_buttonsRemove_1_.getProxy());
    }

    @Override
    public void mouseClicked(int p_mouseClicked_1_, int p_mouseClicked_2_, int p_mouseClicked_3_) throws IOException {
        this.proxy.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
    }

    @Override
    public void handleMouseInput() throws IOException {
        this.proxy.mouseEvent();
        super.handleMouseInput();
    }

    @Override
    public void handleKeyboardInput() throws IOException {
        this.proxy.keyboardEvent();
        super.handleKeyboardInput();
    }

    @Override
    public void mouseReleased(int p_mouseReleased_1_, int p_mouseReleased_2_, int p_mouseReleased_3_) {
        this.proxy.mouseReleased(p_mouseReleased_1_, p_mouseReleased_2_, p_mouseReleased_3_);
    }

    @Override
    public void mouseClickMove(int p_mouseClickMove_1_, int p_mouseClickMove_2_, int p_mouseClickMove_3_, long p_mouseClickMove_4_) {
        this.proxy.mouseDragged(p_mouseClickMove_1_, p_mouseClickMove_2_, p_mouseClickMove_3_, p_mouseClickMove_4_);
    }

    @Override
    public void keyTyped(char p_keyTyped_1_, int p_keyTyped_2_) throws IOException {
        this.proxy.keyPressed(p_keyTyped_1_, p_keyTyped_2_);
    }

    @Override
    public void confirmClicked(boolean p_confirmClicked_1_, int p_confirmClicked_2_) {
        this.proxy.confirmResult(p_confirmClicked_1_, p_confirmClicked_2_);
    }

    @Override
    public void onGuiClosed() {
        this.proxy.removed();
        super.onGuiClosed();
    }
}

