/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiOptionButton;
import net.minecraft.client.gui.GuiResourcePackAvailable;
import net.minecraft.client.gui.GuiResourcePackSelected;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.ResourcePackListEntry;
import net.minecraft.client.resources.ResourcePackListEntryDefault;
import net.minecraft.client.resources.ResourcePackListEntryFound;
import net.minecraft.client.resources.ResourcePackListEntryServer;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiScreenResourcePacks
extends GuiScreen {
    private final GuiScreen parentScreen;
    private List<ResourcePackListEntry> availableResourcePacks;
    private List<ResourcePackListEntry> selectedResourcePacks;
    private GuiResourcePackAvailable availableResourcePacksList;
    private GuiResourcePackSelected selectedResourcePacksList;
    private boolean changed;

    public GuiScreenResourcePacks(GuiScreen p_i45050_1_) {
        this.parentScreen = p_i45050_1_;
    }

    @Override
    public void initGui() {
        this.buttonList.add(new GuiOptionButton(2, this.width / 2 - 154, this.height - 48, I18n.format("resourcePack.openFolder", new Object[0])));
        this.buttonList.add(new GuiOptionButton(1, this.width / 2 + 4, this.height - 48, I18n.format("gui.done", new Object[0])));
        if (!this.changed) {
            this.availableResourcePacks = Lists.newArrayList();
            this.selectedResourcePacks = Lists.newArrayList();
            ResourcePackRepository lvt_1_1_ = this.mc.getResourcePackRepository();
            lvt_1_1_.updateRepositoryEntriesAll();
            ArrayList lvt_2_1_ = Lists.newArrayList(lvt_1_1_.getRepositoryEntriesAll());
            lvt_2_1_.removeAll(lvt_1_1_.getRepositoryEntries());
            for (ResourcePackRepository.Entry lvt_4_1_ : lvt_2_1_) {
                this.availableResourcePacks.add(new ResourcePackListEntryFound(this, lvt_4_1_));
            }
            ResourcePackRepository.Entry lvt_3_1_ = lvt_1_1_.getResourcePackEntry();
            if (lvt_3_1_ != null) {
                this.selectedResourcePacks.add(new ResourcePackListEntryServer(this, lvt_1_1_.getResourcePackInstance()));
            }
            for (ResourcePackRepository.Entry lvt_5_1_ : Lists.reverse(lvt_1_1_.getRepositoryEntries())) {
                this.selectedResourcePacks.add(new ResourcePackListEntryFound(this, lvt_5_1_));
            }
            this.selectedResourcePacks.add(new ResourcePackListEntryDefault(this));
        }
        this.availableResourcePacksList = new GuiResourcePackAvailable(this.mc, 200, this.height, this.availableResourcePacks);
        this.availableResourcePacksList.setSlotXBoundsFromLeft(this.width / 2 - 4 - 200);
        this.availableResourcePacksList.registerScrollButtons(7, 8);
        this.selectedResourcePacksList = new GuiResourcePackSelected(this.mc, 200, this.height, this.selectedResourcePacks);
        this.selectedResourcePacksList.setSlotXBoundsFromLeft(this.width / 2 + 4);
        this.selectedResourcePacksList.registerScrollButtons(7, 8);
    }

    @Override
    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        this.selectedResourcePacksList.handleMouseInput();
        this.availableResourcePacksList.handleMouseInput();
    }

    public boolean hasResourcePackEntry(ResourcePackListEntry p_hasResourcePackEntry_1_) {
        return this.selectedResourcePacks.contains(p_hasResourcePackEntry_1_);
    }

    public List<ResourcePackListEntry> getListContaining(ResourcePackListEntry p_getListContaining_1_) {
        if (this.hasResourcePackEntry(p_getListContaining_1_)) {
            return this.selectedResourcePacks;
        }
        return this.availableResourcePacks;
    }

    public List<ResourcePackListEntry> getAvailableResourcePacks() {
        return this.availableResourcePacks;
    }

    public List<ResourcePackListEntry> getSelectedResourcePacks() {
        return this.selectedResourcePacks;
    }

    @Override
    protected void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
        if (!p_actionPerformed_1_.enabled) {
            return;
        }
        if (p_actionPerformed_1_.id == 2) {
            File lvt_2_1_ = this.mc.getResourcePackRepository().getDirResourcepacks();
            OpenGlHelper.openFile(lvt_2_1_);
        } else if (p_actionPerformed_1_.id == 1) {
            if (this.changed) {
                ArrayList lvt_2_2_ = Lists.newArrayList();
                for (ResourcePackListEntry lvt_4_1_ : this.selectedResourcePacks) {
                    if (!(lvt_4_1_ instanceof ResourcePackListEntryFound)) continue;
                    lvt_2_2_.add(((ResourcePackListEntryFound)lvt_4_1_).getResourcePackEntry());
                }
                Collections.reverse(lvt_2_2_);
                this.mc.getResourcePackRepository().setRepositories(lvt_2_2_);
                this.mc.gameSettings.resourcePacks.clear();
                this.mc.gameSettings.incompatibleResourcePacks.clear();
                for (ResourcePackRepository.Entry lvt_4_2_ : lvt_2_2_) {
                    this.mc.gameSettings.resourcePacks.add(lvt_4_2_.getResourcePackName());
                    if (lvt_4_2_.getPackFormat() == 3) continue;
                    this.mc.gameSettings.incompatibleResourcePacks.add(lvt_4_2_.getResourcePackName());
                }
                this.mc.gameSettings.saveOptions();
                this.mc.refreshResources();
            }
            this.mc.displayGuiScreen(this.parentScreen);
        }
    }

    @Override
    protected void mouseClicked(int p_mouseClicked_1_, int p_mouseClicked_2_, int p_mouseClicked_3_) throws IOException {
        super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        this.availableResourcePacksList.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        this.selectedResourcePacksList.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
    }

    @Override
    protected void mouseReleased(int p_mouseReleased_1_, int p_mouseReleased_2_, int p_mouseReleased_3_) {
        super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_2_, p_mouseReleased_3_);
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        this.drawBackground(0);
        this.availableResourcePacksList.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
        this.selectedResourcePacksList.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
        this.drawCenteredString(this.fontRendererObj, I18n.format("resourcePack.title", new Object[0]), this.width / 2, 16, 0xFFFFFF);
        this.drawCenteredString(this.fontRendererObj, I18n.format("resourcePack.folderInfo", new Object[0]), this.width / 2 - 77, this.height - 26, 0x808080);
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
    }

    public void markChanged() {
        this.changed = true;
    }
}

