/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.realms.RealmsSimpleScrolledSelectionList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiSimpleScrolledSelectionListProxy
extends GuiSlot {
    private final RealmsSimpleScrolledSelectionList realmsScrolledSelectionList;

    public GuiSimpleScrolledSelectionListProxy(RealmsSimpleScrolledSelectionList p_i45525_1_, int p_i45525_2_, int p_i45525_3_, int p_i45525_4_, int p_i45525_5_, int p_i45525_6_) {
        super(Minecraft.getMinecraft(), p_i45525_2_, p_i45525_3_, p_i45525_4_, p_i45525_5_, p_i45525_6_);
        this.realmsScrolledSelectionList = p_i45525_1_;
    }

    @Override
    protected int getSize() {
        return this.realmsScrolledSelectionList.getItemCount();
    }

    @Override
    protected void elementClicked(int p_elementClicked_1_, boolean p_elementClicked_2_, int p_elementClicked_3_, int p_elementClicked_4_) {
        this.realmsScrolledSelectionList.selectItem(p_elementClicked_1_, p_elementClicked_2_, p_elementClicked_3_, p_elementClicked_4_);
    }

    @Override
    protected boolean isSelected(int p_isSelected_1_) {
        return this.realmsScrolledSelectionList.isSelectedItem(p_isSelected_1_);
    }

    @Override
    protected void drawBackground() {
        this.realmsScrolledSelectionList.renderBackground();
    }

    @Override
    protected void drawSlot(int p_drawSlot_1_, int p_drawSlot_2_, int p_drawSlot_3_, int p_drawSlot_4_, int p_drawSlot_5_, int p_drawSlot_6_) {
        this.realmsScrolledSelectionList.renderItem(p_drawSlot_1_, p_drawSlot_2_, p_drawSlot_3_, p_drawSlot_4_, p_drawSlot_5_, p_drawSlot_6_);
    }

    public int getWidth() {
        return this.width;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    @Override
    protected int getContentHeight() {
        return this.realmsScrolledSelectionList.getMaxPosition();
    }

    @Override
    protected int getScrollBarX() {
        return this.realmsScrolledSelectionList.getScrollbarPosition();
    }

    @Override
    public void handleMouseInput() {
        super.handleMouseInput();
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        if (!this.visible) {
            return;
        }
        this.mouseX = p_drawScreen_1_;
        this.mouseY = p_drawScreen_2_;
        this.drawBackground();
        int lvt_4_1_ = this.getScrollBarX();
        int lvt_5_1_ = lvt_4_1_ + 6;
        this.bindAmountScrolled();
        GlStateManager.disableLighting();
        GlStateManager.disableFog();
        Tessellator lvt_6_1_ = Tessellator.getInstance();
        VertexBuffer lvt_7_1_ = lvt_6_1_.getBuffer();
        int lvt_8_1_ = this.left + this.width / 2 - this.getListWidth() / 2 + 2;
        int lvt_9_1_ = this.top + 4 - (int)this.amountScrolled;
        if (this.hasListHeader) {
            this.drawListHeader(lvt_8_1_, lvt_9_1_, lvt_6_1_);
        }
        this.drawSelectionBox(lvt_8_1_, lvt_9_1_, p_drawScreen_1_, p_drawScreen_2_);
        GlStateManager.disableDepth();
        this.overlayBackground(0, this.top, 255, 255);
        this.overlayBackground(this.bottom, this.height, 255, 255);
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE);
        GlStateManager.disableAlpha();
        GlStateManager.shadeModel(7425);
        GlStateManager.disableTexture2D();
        int lvt_10_1_ = this.getMaxScroll();
        if (lvt_10_1_ > 0) {
            int lvt_11_1_ = (this.bottom - this.top) * (this.bottom - this.top) / this.getContentHeight();
            int lvt_12_1_ = (int)this.amountScrolled * (this.bottom - this.top - (lvt_11_1_ = MathHelper.clamp(lvt_11_1_, 32, this.bottom - this.top - 8))) / lvt_10_1_ + this.top;
            if (lvt_12_1_ < this.top) {
                lvt_12_1_ = this.top;
            }
            lvt_7_1_.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
            lvt_7_1_.pos(lvt_4_1_, this.bottom, 0.0).tex(0.0, 1.0).color(0, 0, 0, 255).endVertex();
            lvt_7_1_.pos(lvt_5_1_, this.bottom, 0.0).tex(1.0, 1.0).color(0, 0, 0, 255).endVertex();
            lvt_7_1_.pos(lvt_5_1_, this.top, 0.0).tex(1.0, 0.0).color(0, 0, 0, 255).endVertex();
            lvt_7_1_.pos(lvt_4_1_, this.top, 0.0).tex(0.0, 0.0).color(0, 0, 0, 255).endVertex();
            lvt_6_1_.draw();
            lvt_7_1_.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
            lvt_7_1_.pos(lvt_4_1_, lvt_12_1_ + lvt_11_1_, 0.0).tex(0.0, 1.0).color(128, 128, 128, 255).endVertex();
            lvt_7_1_.pos(lvt_5_1_, lvt_12_1_ + lvt_11_1_, 0.0).tex(1.0, 1.0).color(128, 128, 128, 255).endVertex();
            lvt_7_1_.pos(lvt_5_1_, lvt_12_1_, 0.0).tex(1.0, 0.0).color(128, 128, 128, 255).endVertex();
            lvt_7_1_.pos(lvt_4_1_, lvt_12_1_, 0.0).tex(0.0, 0.0).color(128, 128, 128, 255).endVertex();
            lvt_6_1_.draw();
            lvt_7_1_.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
            lvt_7_1_.pos(lvt_4_1_, lvt_12_1_ + lvt_11_1_ - 1, 0.0).tex(0.0, 1.0).color(192, 192, 192, 255).endVertex();
            lvt_7_1_.pos(lvt_5_1_ - 1, lvt_12_1_ + lvt_11_1_ - 1, 0.0).tex(1.0, 1.0).color(192, 192, 192, 255).endVertex();
            lvt_7_1_.pos(lvt_5_1_ - 1, lvt_12_1_, 0.0).tex(1.0, 0.0).color(192, 192, 192, 255).endVertex();
            lvt_7_1_.pos(lvt_4_1_, lvt_12_1_, 0.0).tex(0.0, 0.0).color(192, 192, 192, 255).endVertex();
            lvt_6_1_.draw();
        }
        this.renderDecorations(p_drawScreen_1_, p_drawScreen_2_);
        GlStateManager.enableTexture2D();
        GlStateManager.shadeModel(7424);
        GlStateManager.enableAlpha();
        GlStateManager.disableBlend();
    }
}

