/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiSnooper
extends GuiScreen {
    private final GuiScreen lastScreen;
    private final GameSettings game_settings_2;
    private final java.util.List<String> keys = Lists.newArrayList();
    private final java.util.List<String> values = Lists.newArrayList();
    private String title;
    private String[] desc;
    private List list;
    private GuiButton toggleButton;

    public GuiSnooper(GuiScreen p_i1061_1_, GameSettings p_i1061_2_) {
        this.lastScreen = p_i1061_1_;
        this.game_settings_2 = p_i1061_2_;
    }

    @Override
    public void initGui() {
        this.title = I18n.format("options.snooper.title", new Object[0]);
        String lvt_1_1_ = I18n.format("options.snooper.desc", new Object[0]);
        ArrayList lvt_2_1_ = Lists.newArrayList();
        for (String lvt_4_1_ : this.fontRendererObj.listFormattedStringToWidth(lvt_1_1_, this.width - 30)) {
            lvt_2_1_.add(lvt_4_1_);
        }
        this.desc = lvt_2_1_.toArray(new String[lvt_2_1_.size()]);
        this.keys.clear();
        this.values.clear();
        this.toggleButton = this.addButton(new GuiButton(1, this.width / 2 - 152, this.height - 30, 150, 20, this.game_settings_2.getKeyBinding(GameSettings.Options.SNOOPER_ENABLED)));
        this.buttonList.add(new GuiButton(2, this.width / 2 + 2, this.height - 30, 150, 20, I18n.format("gui.done", new Object[0])));
        boolean lvt_3_1_ = this.mc.getIntegratedServer() != null && this.mc.getIntegratedServer().getPlayerUsageSnooper() != null;
        for (Map.Entry<String, String> lvt_5_1_ : new TreeMap<String, String>(this.mc.getPlayerUsageSnooper().getCurrentStats()).entrySet()) {
            this.keys.add((lvt_3_1_ ? "C " : "") + lvt_5_1_.getKey());
            this.values.add(this.fontRendererObj.trimStringToWidth(lvt_5_1_.getValue(), this.width - 220));
        }
        if (lvt_3_1_) {
            for (Map.Entry<String, String> lvt_5_2_ : new TreeMap<String, String>(this.mc.getIntegratedServer().getPlayerUsageSnooper().getCurrentStats()).entrySet()) {
                this.keys.add("S " + lvt_5_2_.getKey());
                this.values.add(this.fontRendererObj.trimStringToWidth(lvt_5_2_.getValue(), this.width - 220));
            }
        }
        this.list = new List();
    }

    @Override
    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        this.list.handleMouseInput();
    }

    @Override
    protected void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
        if (!p_actionPerformed_1_.enabled) {
            return;
        }
        if (p_actionPerformed_1_.id == 2) {
            this.game_settings_2.saveOptions();
            this.game_settings_2.saveOptions();
            this.mc.displayGuiScreen(this.lastScreen);
        }
        if (p_actionPerformed_1_.id == 1) {
            this.game_settings_2.setOptionValue(GameSettings.Options.SNOOPER_ENABLED, 1);
            this.toggleButton.displayString = this.game_settings_2.getKeyBinding(GameSettings.Options.SNOOPER_ENABLED);
        }
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        this.drawDefaultBackground();
        this.list.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
        this.drawCenteredString(this.fontRendererObj, this.title, this.width / 2, 8, 0xFFFFFF);
        int lvt_4_1_ = 22;
        for (String lvt_8_1_ : this.desc) {
            this.drawCenteredString(this.fontRendererObj, lvt_8_1_, this.width / 2, lvt_4_1_, 0x808080);
            lvt_4_1_ += this.fontRendererObj.FONT_HEIGHT;
        }
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
    }

    @SideOnly(value=Side.CLIENT)
    class List
    extends GuiSlot {
        public List() {
            super(GuiSnooper.this.mc, GuiSnooper.this.width, GuiSnooper.this.height, 80, GuiSnooper.this.height - 40, GuiSnooper.this.fontRendererObj.FONT_HEIGHT + 1);
        }

        @Override
        protected int getSize() {
            return GuiSnooper.this.keys.size();
        }

        @Override
        protected void elementClicked(int p_elementClicked_1_, boolean p_elementClicked_2_, int p_elementClicked_3_, int p_elementClicked_4_) {
        }

        @Override
        protected boolean isSelected(int p_isSelected_1_) {
            return false;
        }

        @Override
        protected void drawBackground() {
        }

        @Override
        protected void drawSlot(int p_drawSlot_1_, int p_drawSlot_2_, int p_drawSlot_3_, int p_drawSlot_4_, int p_drawSlot_5_, int p_drawSlot_6_) {
            GuiSnooper.this.fontRendererObj.drawString((String)GuiSnooper.this.keys.get(p_drawSlot_1_), 10, p_drawSlot_3_, 0xFFFFFF);
            GuiSnooper.this.fontRendererObj.drawString((String)GuiSnooper.this.values.get(p_drawSlot_1_), 230, p_drawSlot_3_, 0xFFFFFF);
        }

        @Override
        protected int getScrollBarX() {
            return this.width - 10;
        }
    }
}

