/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.spectator.ISpectatorMenuObject;
import net.minecraft.client.gui.spectator.ISpectatorMenuRecipient;
import net.minecraft.client.gui.spectator.SpectatorMenu;
import net.minecraft.client.gui.spectator.categories.SpectatorDetails;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiSpectator
extends Gui
implements ISpectatorMenuRecipient {
    private static final ResourceLocation WIDGETS = new ResourceLocation("textures/gui/widgets.png");
    public static final ResourceLocation SPECTATOR_WIDGETS = new ResourceLocation("textures/gui/spectator_widgets.png");
    private final Minecraft mc;
    private long lastSelectionTime;
    private SpectatorMenu menu;

    public GuiSpectator(Minecraft p_i45527_1_) {
        this.mc = p_i45527_1_;
    }

    public void onHotbarSelected(int p_onHotbarSelected_1_) {
        this.lastSelectionTime = Minecraft.getSystemTime();
        if (this.menu != null) {
            this.menu.selectSlot(p_onHotbarSelected_1_);
        } else {
            this.menu = new SpectatorMenu(this);
        }
    }

    private float getHotbarAlpha() {
        long i = this.lastSelectionTime - Minecraft.getSystemTime() + 5000L;
        return MathHelper.clamp((float)i / 2000.0f, 0.0f, 1.0f);
    }

    public void renderTooltip(ScaledResolution p_renderTooltip_1_, float p_renderTooltip_2_) {
        if (this.menu != null) {
            float f = this.getHotbarAlpha();
            if (f <= 0.0f) {
                this.menu.exit();
            } else {
                int i = p_renderTooltip_1_.getScaledWidth() / 2;
                float f1 = this.zLevel;
                this.zLevel = -90.0f;
                float f2 = (float)p_renderTooltip_1_.getScaledHeight() - 22.0f * f;
                SpectatorDetails spectatordetails = this.menu.getCurrentPage();
                this.renderPage(p_renderTooltip_1_, f, i, f2, spectatordetails);
                this.zLevel = f1;
            }
        }
    }

    protected void renderPage(ScaledResolution p_renderPage_1_, float p_renderPage_2_, int p_renderPage_3_, float p_renderPage_4_, SpectatorDetails p_renderPage_5_) {
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.color(1.0f, 1.0f, 1.0f, p_renderPage_2_);
        this.mc.getTextureManager().bindTexture(WIDGETS);
        this.drawTexturedModalRect((float)(p_renderPage_3_ - 91), p_renderPage_4_, 0, 0, 182, 22);
        if (p_renderPage_5_.getSelectedSlot() >= 0) {
            this.drawTexturedModalRect((float)(p_renderPage_3_ - 91 - 1 + p_renderPage_5_.getSelectedSlot() * 20), p_renderPage_4_ - 1.0f, 0, 22, 24, 22);
        }
        RenderHelper.enableGUIStandardItemLighting();
        for (int i = 0; i < 9; ++i) {
            this.renderSlot(i, p_renderPage_1_.getScaledWidth() / 2 - 90 + i * 20 + 2, p_renderPage_4_ + 3.0f, p_renderPage_2_, p_renderPage_5_.getObject(i));
        }
        RenderHelper.disableStandardItemLighting();
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableBlend();
    }

    private void renderSlot(int p_renderSlot_1_, int p_renderSlot_2_, float p_renderSlot_3_, float p_renderSlot_4_, ISpectatorMenuObject p_renderSlot_5_) {
        this.mc.getTextureManager().bindTexture(SPECTATOR_WIDGETS);
        if (p_renderSlot_5_ != SpectatorMenu.EMPTY_SLOT) {
            int i = (int)(p_renderSlot_4_ * 255.0f);
            GlStateManager.pushMatrix();
            GlStateManager.translate(p_renderSlot_2_, p_renderSlot_3_, 0.0f);
            float f = p_renderSlot_5_.isEnabled() ? 1.0f : 0.25f;
            GlStateManager.color(f, f, f, p_renderSlot_4_);
            p_renderSlot_5_.renderIcon(f, i);
            GlStateManager.popMatrix();
            String s = String.valueOf(this.mc.gameSettings.keyBindsHotbar[p_renderSlot_1_].getDisplayName());
            if (i > 3 && p_renderSlot_5_.isEnabled()) {
                this.mc.fontRendererObj.drawStringWithShadow(s, p_renderSlot_2_ + 19 - 2 - this.mc.fontRendererObj.getStringWidth(s), p_renderSlot_3_ + 6.0f + 3.0f, 0xFFFFFF + (i << 24));
            }
        }
    }

    public void renderSelectedItem(ScaledResolution p_renderSelectedItem_1_) {
        int i = (int)(this.getHotbarAlpha() * 255.0f);
        if (i > 3 && this.menu != null) {
            String s;
            ISpectatorMenuObject ispectatormenuobject = this.menu.getSelectedItem();
            String string = s = ispectatormenuobject == SpectatorMenu.EMPTY_SLOT ? this.menu.getSelectedCategory().getPrompt().getFormattedText() : ispectatormenuobject.getSpectatorName().getFormattedText();
            if (s != null) {
                int j = (p_renderSelectedItem_1_.getScaledWidth() - this.mc.fontRendererObj.getStringWidth(s)) / 2;
                int k = p_renderSelectedItem_1_.getScaledHeight() - 35;
                GlStateManager.pushMatrix();
                GlStateManager.enableBlend();
                GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
                this.mc.fontRendererObj.drawStringWithShadow(s, j, k, 0xFFFFFF + (i << 24));
                GlStateManager.disableBlend();
                GlStateManager.popMatrix();
            }
        }
    }

    @Override
    public void onSpectatorMenuClosed(SpectatorMenu p_onSpectatorMenuClosed_1_) {
        this.menu = null;
        this.lastSelectionTime = 0L;
    }

    public boolean isMenuActive() {
        return this.menu != null;
    }

    public void onMouseScroll(int p_onMouseScroll_1_) {
        int i;
        for (i = this.menu.getSelectedSlot() + p_onMouseScroll_1_; !(i < 0 || i > 8 || this.menu.getItem(i) != SpectatorMenu.EMPTY_SLOT && this.menu.getItem(i).isEnabled()); i += p_onMouseScroll_1_) {
        }
        if (i >= 0 && i <= 8) {
            this.menu.selectSlot(i);
            this.lastSelectionTime = Minecraft.getSystemTime();
        }
    }

    public void onMiddleClick() {
        this.lastSelectionTime = Minecraft.getSystemTime();
        if (this.isMenuActive()) {
            int i = this.menu.getSelectedSlot();
            if (i != -1) {
                this.menu.selectSlot(i);
            }
        } else {
            this.menu = new SpectatorMenu(this);
        }
    }
}

