/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ISoundEventListener;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiSubtitleOverlay
extends Gui
implements ISoundEventListener {
    private final Minecraft client;
    private final List<Subtitle> subtitles = Lists.newArrayList();
    private boolean enabled;

    public GuiSubtitleOverlay(Minecraft p_i46603_1_) {
        this.client = p_i46603_1_;
    }

    public void renderSubtitles(ScaledResolution p_renderSubtitles_1_) {
        if (!this.enabled && this.client.gameSettings.showSubtitles) {
            this.client.getSoundHandler().addListener(this);
            this.enabled = true;
        } else if (this.enabled && !this.client.gameSettings.showSubtitles) {
            this.client.getSoundHandler().removeListener(this);
            this.enabled = false;
        }
        if (!this.enabled || this.subtitles.isEmpty()) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        Vec3d lvt_2_1_ = new Vec3d(this.client.player.posX, this.client.player.posY + (double)this.client.player.getEyeHeight(), this.client.player.posZ);
        Vec3d lvt_3_1_ = new Vec3d(0.0, 0.0, -1.0).rotatePitch(-this.client.player.rotationPitch * ((float)Math.PI / 180)).rotateYaw(-this.client.player.rotationYaw * ((float)Math.PI / 180));
        Vec3d lvt_4_1_ = new Vec3d(0.0, 1.0, 0.0).rotatePitch(-this.client.player.rotationPitch * ((float)Math.PI / 180)).rotateYaw(-this.client.player.rotationYaw * ((float)Math.PI / 180));
        Vec3d lvt_5_1_ = lvt_3_1_.crossProduct(lvt_4_1_);
        int lvt_6_1_ = 0;
        int lvt_7_1_ = 0;
        Iterator<Subtitle> lvt_8_1_ = this.subtitles.iterator();
        while (lvt_8_1_.hasNext()) {
            Subtitle lvt_9_1_ = lvt_8_1_.next();
            if (lvt_9_1_.getStartTime() + 3000L <= Minecraft.getSystemTime()) {
                lvt_8_1_.remove();
                continue;
            }
            lvt_7_1_ = Math.max(lvt_7_1_, this.client.fontRendererObj.getStringWidth(lvt_9_1_.getString()));
        }
        lvt_7_1_ += this.client.fontRendererObj.getStringWidth("<") + this.client.fontRendererObj.getStringWidth(" ") + this.client.fontRendererObj.getStringWidth(">") + this.client.fontRendererObj.getStringWidth(" ");
        for (Subtitle lvt_9_2_ : this.subtitles) {
            int lvt_10_1_ = 255;
            String lvt_11_1_ = lvt_9_2_.getString();
            Vec3d lvt_12_1_ = lvt_9_2_.getLocation().subtract(lvt_2_1_).normalize();
            double lvt_13_1_ = -lvt_5_1_.dotProduct(lvt_12_1_);
            double lvt_15_1_ = -lvt_3_1_.dotProduct(lvt_12_1_);
            boolean lvt_17_1_ = lvt_15_1_ > 0.5;
            int lvt_18_1_ = lvt_7_1_ / 2;
            int lvt_19_1_ = this.client.fontRendererObj.FONT_HEIGHT;
            int lvt_20_1_ = lvt_19_1_ / 2;
            float lvt_21_1_ = 1.0f;
            int lvt_22_1_ = this.client.fontRendererObj.getStringWidth(lvt_11_1_);
            int lvt_23_1_ = MathHelper.floor(MathHelper.clampedLerp(255.0, 75.0, (float)(Minecraft.getSystemTime() - lvt_9_2_.getStartTime()) / 3000.0f));
            int lvt_24_1_ = lvt_23_1_ << 16 | lvt_23_1_ << 8 | lvt_23_1_;
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)p_renderSubtitles_1_.getScaledWidth() - (float)lvt_18_1_ * 1.0f - 2.0f, (float)(p_renderSubtitles_1_.getScaledHeight() - 30) - (float)(lvt_6_1_ * (lvt_19_1_ + 1)) * 1.0f, 0.0f);
            GlStateManager.scale(1.0f, 1.0f, 1.0f);
            GuiSubtitleOverlay.drawRect(-lvt_18_1_ - 1, -lvt_20_1_ - 1, lvt_18_1_ + 1, lvt_20_1_ + 1, -872415232);
            GlStateManager.enableBlend();
            if (!lvt_17_1_) {
                if (lvt_13_1_ > 0.0) {
                    this.client.fontRendererObj.drawString(">", lvt_18_1_ - this.client.fontRendererObj.getStringWidth(">"), -lvt_20_1_, lvt_24_1_ + -16777216);
                } else if (lvt_13_1_ < 0.0) {
                    this.client.fontRendererObj.drawString("<", -lvt_18_1_, -lvt_20_1_, lvt_24_1_ + -16777216);
                }
            }
            this.client.fontRendererObj.drawString(lvt_11_1_, -lvt_22_1_ / 2, -lvt_20_1_, lvt_24_1_ + -16777216);
            GlStateManager.popMatrix();
            ++lvt_6_1_;
        }
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }

    @Override
    public void soundPlay(ISound p_soundPlay_1_, SoundEventAccessor p_soundPlay_2_) {
        if (p_soundPlay_2_.getSubtitle() == null) {
            return;
        }
        String lvt_3_1_ = p_soundPlay_2_.getSubtitle().getFormattedText();
        if (!this.subtitles.isEmpty()) {
            for (Subtitle lvt_5_1_ : this.subtitles) {
                if (!lvt_5_1_.getString().equals(lvt_3_1_)) continue;
                lvt_5_1_.refresh(new Vec3d(p_soundPlay_1_.getXPosF(), p_soundPlay_1_.getYPosF(), p_soundPlay_1_.getZPosF()));
                return;
            }
        }
        this.subtitles.add(new Subtitle(lvt_3_1_, new Vec3d(p_soundPlay_1_.getXPosF(), p_soundPlay_1_.getYPosF(), p_soundPlay_1_.getZPosF())));
    }

    @SideOnly(value=Side.CLIENT)
    public class Subtitle {
        private final String subtitle;
        private long startTime;
        private Vec3d location;

        public Subtitle(String p_i47104_2_, Vec3d p_i47104_3_) {
            this.subtitle = p_i47104_2_;
            this.location = p_i47104_3_;
            this.startTime = Minecraft.getSystemTime();
        }

        public String getString() {
            return this.subtitle;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public Vec3d getLocation() {
            return this.location;
        }

        public void refresh(Vec3d p_refresh_1_) {
            this.location = p_refresh_1_;
            this.startTime = Minecraft.getSystemTime();
        }
    }
}

