/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Random;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResource;
import net.minecraft.network.play.client.CPacketClientStatus;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class GuiWinGame
extends GuiScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation MINECRAFT_LOGO = new ResourceLocation("textures/gui/title/minecraft.png");
    private static final ResourceLocation VIGNETTE_TEXTURE = new ResourceLocation("textures/misc/vignette.png");
    private int time;
    private List<String> lines;
    private int totalScrollLength;
    private final float scrollSpeed = 0.5f;

    @Override
    public void updateScreen() {
        MusicTicker lvt_1_1_ = this.mc.getMusicTicker();
        SoundHandler lvt_2_1_ = this.mc.getSoundHandler();
        if (this.time == 0) {
            lvt_1_1_.stopMusic();
            lvt_1_1_.playMusic(MusicTicker.MusicType.CREDITS);
            lvt_2_1_.resumeSounds();
        }
        lvt_2_1_.update();
        ++this.time;
        float lvt_3_1_ = (float)(this.totalScrollLength + this.height + this.height + 24) / 0.5f;
        if ((float)this.time > lvt_3_1_) {
            this.sendRespawnPacket();
        }
    }

    @Override
    protected void keyTyped(char p_keyTyped_1_, int p_keyTyped_2_) throws IOException {
        if (p_keyTyped_2_ == 1) {
            this.sendRespawnPacket();
        }
    }

    private void sendRespawnPacket() {
        this.mc.player.connection.sendPacket(new CPacketClientStatus(CPacketClientStatus.State.PERFORM_RESPAWN));
        this.mc.displayGuiScreen(null);
    }

    @Override
    public boolean doesGuiPauseGame() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initGui() {
        if (this.lines != null) {
            return;
        }
        this.lines = Lists.newArrayList();
        IResource lvt_1_1_ = null;
        try {
            String lvt_7_1_;
            String lvt_2_1_ = "" + (Object)((Object)TextFormatting.WHITE) + (Object)((Object)TextFormatting.OBFUSCATED) + (Object)((Object)TextFormatting.GREEN) + (Object)((Object)TextFormatting.AQUA);
            int lvt_3_1_ = 274;
            lvt_1_1_ = this.mc.getResourceManager().getResource(new ResourceLocation("texts/end.txt"));
            InputStream lvt_4_1_ = lvt_1_1_.getInputStream();
            BufferedReader lvt_5_1_ = new BufferedReader(new InputStreamReader(lvt_4_1_, Charsets.UTF_8));
            Random lvt_6_1_ = new Random(8124371L);
            while ((lvt_7_1_ = lvt_5_1_.readLine()) != null) {
                lvt_7_1_ = lvt_7_1_.replaceAll("PLAYERNAME", this.mc.getSession().getUsername());
                while (lvt_7_1_.contains(lvt_2_1_)) {
                    int lvt_8_1_ = lvt_7_1_.indexOf(lvt_2_1_);
                    String lvt_9_1_ = lvt_7_1_.substring(0, lvt_8_1_);
                    String lvt_10_1_ = lvt_7_1_.substring(lvt_8_1_ + lvt_2_1_.length());
                    lvt_7_1_ = lvt_9_1_ + (Object)((Object)TextFormatting.WHITE) + (Object)((Object)TextFormatting.OBFUSCATED) + "XXXXXXXX".substring(0, lvt_6_1_.nextInt(4) + 3) + lvt_10_1_;
                }
                this.lines.addAll(this.mc.fontRendererObj.listFormattedStringToWidth(lvt_7_1_, 274));
                this.lines.add("");
            }
            lvt_4_1_.close();
            for (int lvt_8_2_ = 0; lvt_8_2_ < 8; ++lvt_8_2_) {
                this.lines.add("");
            }
            lvt_4_1_ = this.mc.getResourceManager().getResource(new ResourceLocation("texts/credits.txt")).getInputStream();
            lvt_5_1_ = new BufferedReader(new InputStreamReader(lvt_4_1_, Charsets.UTF_8));
            while ((lvt_7_1_ = lvt_5_1_.readLine()) != null) {
                lvt_7_1_ = lvt_7_1_.replaceAll("PLAYERNAME", this.mc.getSession().getUsername());
                lvt_7_1_ = lvt_7_1_.replaceAll("\t", "    ");
                this.lines.addAll(this.mc.fontRendererObj.listFormattedStringToWidth(lvt_7_1_, 274));
                this.lines.add("");
            }
            lvt_4_1_.close();
            this.totalScrollLength = this.lines.size() * 12;
            IOUtils.closeQuietly((Closeable)lvt_1_1_);
        }
        catch (Exception lvt_2_2_) {
            LOGGER.error("Couldn't load credits", (Throwable)lvt_2_2_);
        }
        finally {
            IOUtils.closeQuietly(lvt_1_1_);
        }
    }

    private void drawWinGameScreen(int p_drawWinGameScreen_1_, int p_drawWinGameScreen_2_, float p_drawWinGameScreen_3_) {
        Tessellator lvt_4_1_ = Tessellator.getInstance();
        VertexBuffer lvt_5_1_ = lvt_4_1_.getBuffer();
        this.mc.getTextureManager().bindTexture(Gui.OPTIONS_BACKGROUND);
        lvt_5_1_.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
        int lvt_6_1_ = this.width;
        float lvt_7_1_ = 0.0f - ((float)this.time + p_drawWinGameScreen_3_) * 0.5f * 0.5f;
        float lvt_8_1_ = (float)this.height - ((float)this.time + p_drawWinGameScreen_3_) * 0.5f * 0.5f;
        float lvt_9_1_ = 0.015625f;
        float lvt_10_1_ = ((float)this.time + p_drawWinGameScreen_3_ - 0.0f) * 0.02f;
        float lvt_11_1_ = (float)(this.totalScrollLength + this.height + this.height + 24) / 0.5f;
        float lvt_12_1_ = (lvt_11_1_ - 20.0f - ((float)this.time + p_drawWinGameScreen_3_)) * 0.005f;
        if (lvt_12_1_ < lvt_10_1_) {
            lvt_10_1_ = lvt_12_1_;
        }
        if (lvt_10_1_ > 1.0f) {
            lvt_10_1_ = 1.0f;
        }
        lvt_10_1_ *= lvt_10_1_;
        lvt_10_1_ = lvt_10_1_ * 96.0f / 255.0f;
        lvt_5_1_.pos(0.0, this.height, this.zLevel).tex(0.0, lvt_7_1_ * 0.015625f).color(lvt_10_1_, lvt_10_1_, lvt_10_1_, 1.0f).endVertex();
        lvt_5_1_.pos(lvt_6_1_, this.height, this.zLevel).tex((float)lvt_6_1_ * 0.015625f, lvt_7_1_ * 0.015625f).color(lvt_10_1_, lvt_10_1_, lvt_10_1_, 1.0f).endVertex();
        lvt_5_1_.pos(lvt_6_1_, 0.0, this.zLevel).tex((float)lvt_6_1_ * 0.015625f, lvt_8_1_ * 0.015625f).color(lvt_10_1_, lvt_10_1_, lvt_10_1_, 1.0f).endVertex();
        lvt_5_1_.pos(0.0, 0.0, this.zLevel).tex(0.0, lvt_8_1_ * 0.015625f).color(lvt_10_1_, lvt_10_1_, lvt_10_1_, 1.0f).endVertex();
        lvt_4_1_.draw();
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        this.drawWinGameScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
        Tessellator lvt_4_1_ = Tessellator.getInstance();
        VertexBuffer lvt_5_1_ = lvt_4_1_.getBuffer();
        int lvt_6_1_ = 274;
        int lvt_7_1_ = this.width / 2 - 137;
        int lvt_8_1_ = this.height + 50;
        float lvt_9_1_ = -((float)this.time + p_drawScreen_3_) * 0.5f;
        GlStateManager.pushMatrix();
        GlStateManager.translate(0.0f, lvt_9_1_, 0.0f);
        this.mc.getTextureManager().bindTexture(MINECRAFT_LOGO);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.drawTexturedModalRect(lvt_7_1_, lvt_8_1_, 0, 0, 155, 44);
        this.drawTexturedModalRect(lvt_7_1_ + 155, lvt_8_1_, 0, 45, 155, 44);
        int lvt_10_1_ = lvt_8_1_ + 200;
        for (int lvt_11_1_ = 0; lvt_11_1_ < this.lines.size(); ++lvt_11_1_) {
            float lvt_12_1_;
            if (lvt_11_1_ == this.lines.size() - 1 && (lvt_12_1_ = (float)lvt_10_1_ + lvt_9_1_ - (float)(this.height / 2 - 6)) < 0.0f) {
                GlStateManager.translate(0.0f, -lvt_12_1_, 0.0f);
            }
            if ((float)lvt_10_1_ + lvt_9_1_ + 12.0f + 8.0f > 0.0f && (float)lvt_10_1_ + lvt_9_1_ < (float)this.height) {
                String lvt_12_2_ = this.lines.get(lvt_11_1_);
                if (lvt_12_2_.startsWith("[C]")) {
                    this.fontRendererObj.drawStringWithShadow(lvt_12_2_.substring(3), lvt_7_1_ + (274 - this.fontRendererObj.getStringWidth(lvt_12_2_.substring(3))) / 2, lvt_10_1_, 0xFFFFFF);
                } else {
                    this.fontRendererObj.fontRandom.setSeed((long)lvt_11_1_ * 4238972211L + (long)(this.time / 4));
                    this.fontRendererObj.drawStringWithShadow(lvt_12_2_, lvt_7_1_, lvt_10_1_, 0xFFFFFF);
                }
            }
            lvt_10_1_ += 12;
        }
        GlStateManager.popMatrix();
        this.mc.getTextureManager().bindTexture(VIGNETTE_TEXTURE);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc(GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR);
        int lvt_11_2_ = this.width;
        int lvt_12_3_ = this.height;
        lvt_5_1_.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
        lvt_5_1_.pos(0.0, lvt_12_3_, this.zLevel).tex(0.0, 1.0).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        lvt_5_1_.pos(lvt_11_2_, lvt_12_3_, this.zLevel).tex(1.0, 1.0).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        lvt_5_1_.pos(lvt_11_2_, 0.0, this.zLevel).tex(1.0, 0.0).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        lvt_5_1_.pos(0.0, 0.0, this.zLevel).tex(0.0, 0.0).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        lvt_4_1_.draw();
        GlStateManager.disableBlend();
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
    }
}

