/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.io.File;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiWorldEdit
extends GuiScreen {
    private final GuiScreen lastScreen;
    private GuiTextField nameEdit;
    private final String worldId;

    public GuiWorldEdit(GuiScreen p_i46593_1_, String p_i46593_2_) {
        this.lastScreen = p_i46593_1_;
        this.worldId = p_i46593_2_;
    }

    @Override
    public void updateScreen() {
        this.nameEdit.updateCursorCounter();
    }

    @Override
    public void initGui() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonList.clear();
        GuiButton lvt_1_1_ = this.addButton(new GuiButton(3, this.width / 2 - 100, this.height / 4 + 24 + 12, I18n.format("selectWorld.edit.resetIcon", new Object[0])));
        this.buttonList.add(new GuiButton(4, this.width / 2 - 100, this.height / 4 + 48 + 12, I18n.format("selectWorld.edit.openFolder", new Object[0])));
        this.buttonList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 96 + 12, I18n.format("selectWorld.edit.save", new Object[0])));
        this.buttonList.add(new GuiButton(1, this.width / 2 - 100, this.height / 4 + 120 + 12, I18n.format("gui.cancel", new Object[0])));
        lvt_1_1_.enabled = this.mc.getSaveLoader().getFile(this.worldId, "icon.png").isFile();
        ISaveFormat lvt_2_1_ = this.mc.getSaveLoader();
        WorldInfo lvt_3_1_ = lvt_2_1_.getWorldInfo(this.worldId);
        String lvt_4_1_ = lvt_3_1_ == null ? "" : lvt_3_1_.getWorldName();
        this.nameEdit = new GuiTextField(2, this.fontRendererObj, this.width / 2 - 100, 60, 200, 20);
        this.nameEdit.setFocused(true);
        this.nameEdit.setText(lvt_4_1_);
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
        if (!p_actionPerformed_1_.enabled) {
            return;
        }
        if (p_actionPerformed_1_.id == 1) {
            this.mc.displayGuiScreen(this.lastScreen);
        } else if (p_actionPerformed_1_.id == 0) {
            ISaveFormat lvt_2_1_ = this.mc.getSaveLoader();
            lvt_2_1_.renameWorld(this.worldId, this.nameEdit.getText().trim());
            this.mc.displayGuiScreen(this.lastScreen);
        } else if (p_actionPerformed_1_.id == 3) {
            ISaveFormat lvt_2_2_ = this.mc.getSaveLoader();
            FileUtils.deleteQuietly((File)lvt_2_2_.getFile(this.worldId, "icon.png"));
            p_actionPerformed_1_.enabled = false;
        } else if (p_actionPerformed_1_.id == 4) {
            ISaveFormat lvt_2_3_ = this.mc.getSaveLoader();
            OpenGlHelper.openFile(lvt_2_3_.getFile(this.worldId, "icon.png").getParentFile());
        }
    }

    @Override
    protected void keyTyped(char p_keyTyped_1_, int p_keyTyped_2_) throws IOException {
        this.nameEdit.textboxKeyTyped(p_keyTyped_1_, p_keyTyped_2_);
        boolean bl = ((GuiButton)this.buttonList.get((int)2)).enabled = !this.nameEdit.getText().trim().isEmpty();
        if (p_keyTyped_2_ == 28 || p_keyTyped_2_ == 156) {
            this.actionPerformed((GuiButton)this.buttonList.get(2));
        }
    }

    @Override
    protected void mouseClicked(int p_mouseClicked_1_, int p_mouseClicked_2_, int p_mouseClicked_3_) throws IOException {
        super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        this.nameEdit.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRendererObj, I18n.format("selectWorld.edit.title", new Object[0]), this.width / 2, 20, 0xFFFFFF);
        this.drawString(this.fontRendererObj, I18n.format("selectWorld.enterName", new Object[0]), this.width / 2 - 100, 47, 0xA0A0A0);
        this.nameEdit.drawTextBox();
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
    }
}

