/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiListWorldSelection;
import net.minecraft.client.gui.GuiListWorldSelectionEntry;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class GuiWorldSelection
extends GuiScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    protected GuiScreen prevScreen;
    protected String title = "Select world";
    private String worldVersTooltip;
    private GuiButton deleteButton;
    private GuiButton selectButton;
    private GuiButton renameButton;
    private GuiButton copyButton;
    private GuiListWorldSelection selectionList;

    public GuiWorldSelection(GuiScreen p_i46592_1_) {
        this.prevScreen = p_i46592_1_;
    }

    @Override
    public void initGui() {
        this.title = I18n.format("selectWorld.title", new Object[0]);
        this.selectionList = new GuiListWorldSelection(this, this.mc, this.width, this.height, 32, this.height - 64, 36);
        this.postInit();
    }

    @Override
    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        this.selectionList.handleMouseInput();
    }

    public void postInit() {
        this.selectButton = this.addButton(new GuiButton(1, this.width / 2 - 154, this.height - 52, 150, 20, I18n.format("selectWorld.select", new Object[0])));
        this.addButton(new GuiButton(3, this.width / 2 + 4, this.height - 52, 150, 20, I18n.format("selectWorld.create", new Object[0])));
        this.renameButton = this.addButton(new GuiButton(4, this.width / 2 - 154, this.height - 28, 72, 20, I18n.format("selectWorld.edit", new Object[0])));
        this.deleteButton = this.addButton(new GuiButton(2, this.width / 2 - 76, this.height - 28, 72, 20, I18n.format("selectWorld.delete", new Object[0])));
        this.copyButton = this.addButton(new GuiButton(5, this.width / 2 + 4, this.height - 28, 72, 20, I18n.format("selectWorld.recreate", new Object[0])));
        this.addButton(new GuiButton(0, this.width / 2 + 82, this.height - 28, 72, 20, I18n.format("gui.cancel", new Object[0])));
        this.selectButton.enabled = false;
        this.deleteButton.enabled = false;
        this.renameButton.enabled = false;
        this.copyButton.enabled = false;
    }

    @Override
    protected void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
        if (!p_actionPerformed_1_.enabled) {
            return;
        }
        GuiListWorldSelectionEntry lvt_2_1_ = this.selectionList.getSelectedWorld();
        if (p_actionPerformed_1_.id == 2) {
            if (lvt_2_1_ != null) {
                lvt_2_1_.deleteWorld();
            }
        } else if (p_actionPerformed_1_.id == 1) {
            if (lvt_2_1_ != null) {
                lvt_2_1_.joinWorld();
            }
        } else if (p_actionPerformed_1_.id == 3) {
            this.mc.displayGuiScreen(new GuiCreateWorld(this));
        } else if (p_actionPerformed_1_.id == 4) {
            if (lvt_2_1_ != null) {
                lvt_2_1_.editWorld();
            }
        } else if (p_actionPerformed_1_.id == 0) {
            this.mc.displayGuiScreen(this.prevScreen);
        } else if (p_actionPerformed_1_.id == 5 && lvt_2_1_ != null) {
            lvt_2_1_.recreateWorld();
        }
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        this.worldVersTooltip = null;
        this.selectionList.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
        this.drawCenteredString(this.fontRendererObj, this.title, this.width / 2, 20, 0xFFFFFF);
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
        if (this.worldVersTooltip != null) {
            this.drawHoveringText(Lists.newArrayList((Iterable)Splitter.on((String)"\n").split((CharSequence)this.worldVersTooltip)), p_drawScreen_1_, p_drawScreen_2_);
        }
    }

    @Override
    protected void mouseClicked(int p_mouseClicked_1_, int p_mouseClicked_2_, int p_mouseClicked_3_) throws IOException {
        super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        this.selectionList.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
    }

    @Override
    protected void mouseReleased(int p_mouseReleased_1_, int p_mouseReleased_2_, int p_mouseReleased_3_) {
        super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_2_, p_mouseReleased_3_);
        this.selectionList.mouseReleased(p_mouseReleased_1_, p_mouseReleased_2_, p_mouseReleased_3_);
    }

    public void setVersionTooltip(String p_setVersionTooltip_1_) {
        this.worldVersTooltip = p_setVersionTooltip_1_;
    }

    public void selectWorld(GuiListWorldSelectionEntry p_selectWorld_1_) {
        boolean lvt_2_1_;
        this.selectButton.enabled = lvt_2_1_ = p_selectWorld_1_ != null;
        this.deleteButton.enabled = lvt_2_1_;
        this.renameButton.enabled = lvt_2_1_;
        this.copyButton.enabled = lvt_2_1_;
    }
}

