/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MapItemRenderer {
    private static final ResourceLocation TEXTURE_MAP_ICONS = new ResourceLocation("textures/map/map_icons.png");
    private final TextureManager textureManager;
    private final Map<String, Instance> loadedMaps = Maps.newHashMap();

    public MapItemRenderer(TextureManager p_i45009_1_) {
        this.textureManager = p_i45009_1_;
    }

    public void updateMapTexture(MapData p_updateMapTexture_1_) {
        this.getMapRendererInstance(p_updateMapTexture_1_).updateMapTexture();
    }

    public void renderMap(MapData p_renderMap_1_, boolean p_renderMap_2_) {
        this.getMapRendererInstance(p_renderMap_1_).render(p_renderMap_2_);
    }

    private Instance getMapRendererInstance(MapData p_getMapRendererInstance_1_) {
        Instance lvt_2_1_ = this.loadedMaps.get(p_getMapRendererInstance_1_.mapName);
        if (lvt_2_1_ == null) {
            lvt_2_1_ = new Instance(p_getMapRendererInstance_1_);
            this.loadedMaps.put(p_getMapRendererInstance_1_.mapName, lvt_2_1_);
        }
        return lvt_2_1_;
    }

    @Nullable
    public Instance getMapInstanceIfExists(String p_getMapInstanceIfExists_1_) {
        return this.loadedMaps.get(p_getMapInstanceIfExists_1_);
    }

    public void clearLoadedMaps() {
        for (Instance lvt_2_1_ : this.loadedMaps.values()) {
            this.textureManager.deleteTexture(lvt_2_1_.location);
        }
        this.loadedMaps.clear();
    }

    @Nullable
    public MapData getData(Instance p_getData_1_) {
        if (p_getData_1_ != null) {
            return p_getData_1_.mapData;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    class Instance {
        private final MapData mapData;
        private final DynamicTexture mapTexture;
        private final ResourceLocation location;
        private final int[] mapTextureData;

        private Instance(MapData p_i45007_2_) {
            this.mapData = p_i45007_2_;
            this.mapTexture = new DynamicTexture(128, 128);
            this.mapTextureData = this.mapTexture.getTextureData();
            this.location = MapItemRenderer.this.textureManager.getDynamicTextureLocation("map/" + p_i45007_2_.mapName, this.mapTexture);
            for (int lvt_3_1_ = 0; lvt_3_1_ < this.mapTextureData.length; ++lvt_3_1_) {
                this.mapTextureData[lvt_3_1_] = 0;
            }
        }

        private void updateMapTexture() {
            for (int lvt_1_1_ = 0; lvt_1_1_ < 16384; ++lvt_1_1_) {
                int lvt_2_1_ = this.mapData.colors[lvt_1_1_] & 0xFF;
                this.mapTextureData[lvt_1_1_] = lvt_2_1_ / 4 == 0 ? (lvt_1_1_ + lvt_1_1_ / 128 & 1) * 8 + 16 << 24 : MapColor.COLORS[lvt_2_1_ / 4].getMapColor(lvt_2_1_ & 3);
            }
            this.mapTexture.updateDynamicTexture();
        }

        private void render(boolean p_render_1_) {
            boolean lvt_2_1_ = false;
            boolean lvt_3_1_ = false;
            Tessellator lvt_4_1_ = Tessellator.getInstance();
            VertexBuffer lvt_5_1_ = lvt_4_1_.getBuffer();
            float lvt_6_1_ = 0.0f;
            MapItemRenderer.this.textureManager.bindTexture(this.location);
            GlStateManager.enableBlend();
            GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE);
            GlStateManager.disableAlpha();
            lvt_5_1_.begin(7, DefaultVertexFormats.POSITION_TEX);
            lvt_5_1_.pos(0.0, 128.0, -0.01f).tex(0.0, 1.0).endVertex();
            lvt_5_1_.pos(128.0, 128.0, -0.01f).tex(1.0, 1.0).endVertex();
            lvt_5_1_.pos(128.0, 0.0, -0.01f).tex(1.0, 0.0).endVertex();
            lvt_5_1_.pos(0.0, 0.0, -0.01f).tex(0.0, 0.0).endVertex();
            lvt_4_1_.draw();
            GlStateManager.enableAlpha();
            GlStateManager.disableBlend();
            MapItemRenderer.this.textureManager.bindTexture(TEXTURE_MAP_ICONS);
            int lvt_7_1_ = 0;
            for (MapDecoration lvt_9_1_ : this.mapData.mapDecorations.values()) {
                if (p_render_1_ && !lvt_9_1_.renderOnFrame()) continue;
                GlStateManager.pushMatrix();
                GlStateManager.translate(0.0f + (float)lvt_9_1_.getX() / 2.0f + 64.0f, 0.0f + (float)lvt_9_1_.getY() / 2.0f + 64.0f, -0.02f);
                GlStateManager.rotate((float)(lvt_9_1_.getRotation() * 360) / 16.0f, 0.0f, 0.0f, 1.0f);
                GlStateManager.scale(4.0f, 4.0f, 3.0f);
                GlStateManager.translate(-0.125f, 0.125f, 0.0f);
                byte lvt_10_1_ = lvt_9_1_.getImage();
                float lvt_11_1_ = (float)(lvt_10_1_ % 4 + 0) / 4.0f;
                float lvt_12_1_ = (float)(lvt_10_1_ / 4 + 0) / 4.0f;
                float lvt_13_1_ = (float)(lvt_10_1_ % 4 + 1) / 4.0f;
                float lvt_14_1_ = (float)(lvt_10_1_ / 4 + 1) / 4.0f;
                lvt_5_1_.begin(7, DefaultVertexFormats.POSITION_TEX);
                float lvt_15_1_ = -0.001f;
                lvt_5_1_.pos(-1.0, 1.0, (float)lvt_7_1_ * -0.001f).tex(lvt_11_1_, lvt_12_1_).endVertex();
                lvt_5_1_.pos(1.0, 1.0, (float)lvt_7_1_ * -0.001f).tex(lvt_13_1_, lvt_12_1_).endVertex();
                lvt_5_1_.pos(1.0, -1.0, (float)lvt_7_1_ * -0.001f).tex(lvt_13_1_, lvt_14_1_).endVertex();
                lvt_5_1_.pos(-1.0, -1.0, (float)lvt_7_1_ * -0.001f).tex(lvt_11_1_, lvt_14_1_).endVertex();
                lvt_4_1_.draw();
                GlStateManager.popMatrix();
                ++lvt_7_1_;
            }
            GlStateManager.pushMatrix();
            GlStateManager.translate(0.0f, 0.0f, -0.04f);
            GlStateManager.scale(1.0f, 1.0f, 1.0f);
            GlStateManager.popMatrix();
        }
    }
}

