/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiOptionButton;
import net.minecraft.client.gui.GuiOptionSlider;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ScreenChatOptions
extends GuiScreen {
    private static final GameSettings.Options[] CHAT_OPTIONS = new GameSettings.Options[]{GameSettings.Options.CHAT_VISIBILITY, GameSettings.Options.CHAT_COLOR, GameSettings.Options.CHAT_LINKS, GameSettings.Options.CHAT_OPACITY, GameSettings.Options.CHAT_LINKS_PROMPT, GameSettings.Options.CHAT_SCALE, GameSettings.Options.CHAT_HEIGHT_FOCUSED, GameSettings.Options.CHAT_HEIGHT_UNFOCUSED, GameSettings.Options.CHAT_WIDTH, GameSettings.Options.REDUCED_DEBUG_INFO};
    private final GuiScreen parentScreen;
    private final GameSettings game_settings;
    private String chatTitle;

    public ScreenChatOptions(GuiScreen p_i1023_1_, GameSettings p_i1023_2_) {
        this.parentScreen = p_i1023_1_;
        this.game_settings = p_i1023_2_;
    }

    @Override
    public void initGui() {
        this.chatTitle = I18n.format("options.chat.title", new Object[0]);
        int lvt_1_1_ = 0;
        for (GameSettings.Options lvt_5_1_ : CHAT_OPTIONS) {
            if (lvt_5_1_.getEnumFloat()) {
                this.buttonList.add(new GuiOptionSlider(lvt_5_1_.returnEnumOrdinal(), this.width / 2 - 155 + lvt_1_1_ % 2 * 160, this.height / 6 + 24 * (lvt_1_1_ >> 1), lvt_5_1_));
            } else {
                this.buttonList.add(new GuiOptionButton(lvt_5_1_.returnEnumOrdinal(), this.width / 2 - 155 + lvt_1_1_ % 2 * 160, this.height / 6 + 24 * (lvt_1_1_ >> 1), lvt_5_1_, this.game_settings.getKeyBinding(lvt_5_1_)));
            }
            ++lvt_1_1_;
        }
        this.buttonList.add(new GuiButton(200, this.width / 2 - 100, this.height / 6 + 120, I18n.format("gui.done", new Object[0])));
    }

    @Override
    protected void keyTyped(char p_keyTyped_1_, int p_keyTyped_2_) throws IOException {
        if (p_keyTyped_2_ == 1) {
            this.mc.gameSettings.saveOptions();
        }
        super.keyTyped(p_keyTyped_1_, p_keyTyped_2_);
    }

    @Override
    protected void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
        if (!p_actionPerformed_1_.enabled) {
            return;
        }
        if (p_actionPerformed_1_.id < 100 && p_actionPerformed_1_ instanceof GuiOptionButton) {
            this.game_settings.setOptionValue(((GuiOptionButton)p_actionPerformed_1_).returnEnumOptions(), 1);
            p_actionPerformed_1_.displayString = this.game_settings.getKeyBinding(GameSettings.Options.getEnumOptions(p_actionPerformed_1_.id));
        }
        if (p_actionPerformed_1_.id == 200) {
            this.mc.gameSettings.saveOptions();
            this.mc.displayGuiScreen(this.parentScreen);
        }
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRendererObj, this.chatTitle, this.width / 2, 20, 0xFFFFFF);
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
    }
}

