/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.network.LanServerInfo;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ServerListEntryLanDetected
implements GuiListExtended.IGuiListEntry {
    private final GuiMultiplayer screen;
    protected final Minecraft mc;
    protected final LanServerInfo serverData;
    private long lastClickTime;

    protected ServerListEntryLanDetected(GuiMultiplayer p_i47141_1_, LanServerInfo p_i47141_2_) {
        this.screen = p_i47141_1_;
        this.serverData = p_i47141_2_;
        this.mc = Minecraft.getMinecraft();
    }

    @Override
    public void drawEntry(int p_drawEntry_1_, int p_drawEntry_2_, int p_drawEntry_3_, int p_drawEntry_4_, int p_drawEntry_5_, int p_drawEntry_6_, int p_drawEntry_7_, boolean p_drawEntry_8_) {
        this.mc.fontRendererObj.drawString(I18n.format("lanServer.title", new Object[0]), p_drawEntry_2_ + 32 + 3, p_drawEntry_3_ + 1, 0xFFFFFF);
        this.mc.fontRendererObj.drawString(this.serverData.getServerMotd(), p_drawEntry_2_ + 32 + 3, p_drawEntry_3_ + 12, 0x808080);
        if (this.mc.gameSettings.hideServerAddress) {
            this.mc.fontRendererObj.drawString(I18n.format("selectServer.hiddenAddress", new Object[0]), p_drawEntry_2_ + 32 + 3, p_drawEntry_3_ + 12 + 11, 0x303030);
        } else {
            this.mc.fontRendererObj.drawString(this.serverData.getServerIpPort(), p_drawEntry_2_ + 32 + 3, p_drawEntry_3_ + 12 + 11, 0x303030);
        }
    }

    @Override
    public boolean mousePressed(int p_mousePressed_1_, int p_mousePressed_2_, int p_mousePressed_3_, int p_mousePressed_4_, int p_mousePressed_5_, int p_mousePressed_6_) {
        this.screen.selectServer(p_mousePressed_1_);
        if (Minecraft.getSystemTime() - this.lastClickTime < 250L) {
            this.screen.connectToSelected();
        }
        this.lastClickTime = Minecraft.getSystemTime();
        return false;
    }

    @Override
    public void setSelected(int p_setSelected_1_, int p_setSelected_2_, int p_setSelected_3_) {
    }

    @Override
    public void mouseReleased(int p_mouseReleased_1_, int p_mouseReleased_2_, int p_mouseReleased_3_, int p_mouseReleased_4_, int p_mouseReleased_5_, int p_mouseReleased_6_) {
    }

    public LanServerInfo getServerData() {
        return this.serverData;
    }
}

