/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.ServerListEntryLanDetected;
import net.minecraft.client.gui.ServerListEntryLanScan;
import net.minecraft.client.gui.ServerListEntryNormal;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.network.LanServerInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ServerSelectionList
extends GuiListExtended {
    private final GuiMultiplayer owner;
    private final List<ServerListEntryNormal> serverListInternet = Lists.newArrayList();
    private final List<ServerListEntryLanDetected> serverListLan = Lists.newArrayList();
    private final GuiListExtended.IGuiListEntry lanScanEntry = new ServerListEntryLanScan();
    private int selectedSlotIndex = -1;

    public ServerSelectionList(GuiMultiplayer p_i45049_1_, Minecraft p_i45049_2_, int p_i45049_3_, int p_i45049_4_, int p_i45049_5_, int p_i45049_6_, int p_i45049_7_) {
        super(p_i45049_2_, p_i45049_3_, p_i45049_4_, p_i45049_5_, p_i45049_6_, p_i45049_7_);
        this.owner = p_i45049_1_;
    }

    @Override
    public GuiListExtended.IGuiListEntry getListEntry(int p_getListEntry_1_) {
        if (p_getListEntry_1_ < this.serverListInternet.size()) {
            return this.serverListInternet.get(p_getListEntry_1_);
        }
        if ((p_getListEntry_1_ -= this.serverListInternet.size()) == 0) {
            return this.lanScanEntry;
        }
        return this.serverListLan.get(--p_getListEntry_1_);
    }

    @Override
    protected int getSize() {
        return this.serverListInternet.size() + 1 + this.serverListLan.size();
    }

    public void setSelectedSlotIndex(int p_setSelectedSlotIndex_1_) {
        this.selectedSlotIndex = p_setSelectedSlotIndex_1_;
    }

    @Override
    protected boolean isSelected(int p_isSelected_1_) {
        return p_isSelected_1_ == this.selectedSlotIndex;
    }

    public int getSelected() {
        return this.selectedSlotIndex;
    }

    public void updateOnlineServers(ServerList p_updateOnlineServers_1_) {
        this.serverListInternet.clear();
        for (int lvt_2_1_ = 0; lvt_2_1_ < p_updateOnlineServers_1_.countServers(); ++lvt_2_1_) {
            this.serverListInternet.add(new ServerListEntryNormal(this.owner, p_updateOnlineServers_1_.getServerData(lvt_2_1_)));
        }
    }

    public void updateNetworkServers(List<LanServerInfo> p_updateNetworkServers_1_) {
        this.serverListLan.clear();
        for (LanServerInfo lvt_3_1_ : p_updateNetworkServers_1_) {
            this.serverListLan.add(new ServerListEntryLanDetected(this.owner, lvt_3_1_));
        }
    }

    @Override
    protected int getScrollBarX() {
        return super.getScrollBarX() + 30;
    }

    @Override
    public int getListWidth() {
        return super.getListWidth() + 85;
    }
}

