/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.achievement;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.stats.Achievement;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiAchievement
extends Gui {
    private static final ResourceLocation ACHIEVEMENT_BG = new ResourceLocation("textures/gui/achievement/achievement_background.png");
    private final Minecraft mc;
    private int width;
    private int height;
    private String achievementTitle;
    private String achievementDescription;
    private Achievement theAchievement;
    private long notificationTime;
    private final RenderItem renderItem;
    private boolean permanentNotification;

    public GuiAchievement(Minecraft p_i1063_1_) {
        this.mc = p_i1063_1_;
        this.renderItem = p_i1063_1_.getRenderItem();
    }

    public void displayAchievement(Achievement p_displayAchievement_1_) {
        this.achievementTitle = I18n.format("achievement.get", new Object[0]);
        this.achievementDescription = p_displayAchievement_1_.getStatName().getUnformattedText();
        this.notificationTime = Minecraft.getSystemTime();
        this.theAchievement = p_displayAchievement_1_;
        this.permanentNotification = false;
    }

    public void displayUnformattedAchievement(Achievement p_displayUnformattedAchievement_1_) {
        this.achievementTitle = p_displayUnformattedAchievement_1_.getStatName().getUnformattedText();
        this.achievementDescription = p_displayUnformattedAchievement_1_.getDescription();
        this.notificationTime = Minecraft.getSystemTime() + 2500L;
        this.theAchievement = p_displayUnformattedAchievement_1_;
        this.permanentNotification = true;
    }

    private void updateAchievementWindowScale() {
        GlStateManager.viewport(0, 0, this.mc.displayWidth, this.mc.displayHeight);
        GlStateManager.matrixMode(5889);
        GlStateManager.loadIdentity();
        GlStateManager.matrixMode(5888);
        GlStateManager.loadIdentity();
        this.width = this.mc.displayWidth;
        this.height = this.mc.displayHeight;
        ScaledResolution lvt_1_1_ = new ScaledResolution(this.mc);
        this.width = lvt_1_1_.getScaledWidth();
        this.height = lvt_1_1_.getScaledHeight();
        GlStateManager.clear(256);
        GlStateManager.matrixMode(5889);
        GlStateManager.loadIdentity();
        GlStateManager.ortho(0.0, this.width, this.height, 0.0, 1000.0, 3000.0);
        GlStateManager.matrixMode(5888);
        GlStateManager.loadIdentity();
        GlStateManager.translate(0.0f, 0.0f, -2000.0f);
    }

    public void updateAchievementWindow() {
        if (this.theAchievement == null || this.notificationTime == 0L || Minecraft.getMinecraft().player == null) {
            return;
        }
        double lvt_1_1_ = (double)(Minecraft.getSystemTime() - this.notificationTime) / 3000.0;
        if (this.permanentNotification) {
            if (lvt_1_1_ > 0.5) {
                lvt_1_1_ = 0.5;
            }
        } else if (lvt_1_1_ < 0.0 || lvt_1_1_ > 1.0) {
            this.notificationTime = 0L;
            return;
        }
        this.updateAchievementWindowScale();
        GlStateManager.disableDepth();
        GlStateManager.depthMask(false);
        double lvt_3_1_ = lvt_1_1_ * 2.0;
        if (lvt_3_1_ > 1.0) {
            lvt_3_1_ = 2.0 - lvt_3_1_;
        }
        lvt_3_1_ *= 4.0;
        if ((lvt_3_1_ = 1.0 - lvt_3_1_) < 0.0) {
            lvt_3_1_ = 0.0;
        }
        lvt_3_1_ *= lvt_3_1_;
        lvt_3_1_ *= lvt_3_1_;
        int lvt_5_1_ = this.width - 160;
        int lvt_6_1_ = 0 - (int)(lvt_3_1_ * 36.0);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.enableTexture2D();
        this.mc.getTextureManager().bindTexture(ACHIEVEMENT_BG);
        GlStateManager.disableLighting();
        this.drawTexturedModalRect(lvt_5_1_, lvt_6_1_, 96, 202, 160, 32);
        if (this.permanentNotification) {
            this.mc.fontRendererObj.drawSplitString(this.achievementDescription, lvt_5_1_ + 30, lvt_6_1_ + 7, 120, -1);
        } else {
            this.mc.fontRendererObj.drawString(this.achievementTitle, lvt_5_1_ + 30, lvt_6_1_ + 7, -256);
            this.mc.fontRendererObj.drawString(this.achievementDescription, lvt_5_1_ + 30, lvt_6_1_ + 18, -1);
        }
        RenderHelper.enableGUIStandardItemLighting();
        GlStateManager.disableLighting();
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableColorMaterial();
        GlStateManager.enableLighting();
        this.renderItem.renderItemAndEffectIntoGUI(this.theAchievement.theItemStack, lvt_5_1_ + 8, lvt_6_1_ + 8);
        GlStateManager.disableLighting();
        GlStateManager.depthMask(true);
        GlStateManager.enableDepth();
    }

    public void clearAchievements() {
        this.theAchievement = null;
        this.notificationTime = 0L;
    }
}

