/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.achievement;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.IProgressMeter;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityList;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.client.CPacketClientStatus;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatCrafting;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatisticsManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiStats
extends GuiScreen
implements IProgressMeter {
    protected GuiScreen parentScreen;
    protected String screenTitle = "Select world";
    private StatsGeneral generalStats;
    private StatsItem itemStats;
    private StatsBlock blockStats;
    private StatsMobsList mobStats;
    private final StatisticsManager stats;
    private GuiSlot displaySlot;
    private boolean doesGuiPauseGame = true;

    public GuiStats(GuiScreen p_i1071_1_, StatisticsManager p_i1071_2_) {
        this.parentScreen = p_i1071_1_;
        this.stats = p_i1071_2_;
    }

    @Override
    public void initGui() {
        this.screenTitle = I18n.format("gui.stats", new Object[0]);
        this.doesGuiPauseGame = true;
        this.mc.getConnection().sendPacket(new CPacketClientStatus(CPacketClientStatus.State.REQUEST_STATS));
    }

    @Override
    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        if (this.displaySlot != null) {
            this.displaySlot.handleMouseInput();
        }
    }

    public void initLists() {
        this.generalStats = new StatsGeneral(this.mc);
        this.generalStats.registerScrollButtons(1, 1);
        this.itemStats = new StatsItem(this.mc);
        this.itemStats.registerScrollButtons(1, 1);
        this.blockStats = new StatsBlock(this.mc);
        this.blockStats.registerScrollButtons(1, 1);
        this.mobStats = new StatsMobsList(this.mc);
        this.mobStats.registerScrollButtons(1, 1);
    }

    public void createButtons() {
        this.buttonList.add(new GuiButton(0, this.width / 2 + 4, this.height - 28, 150, 20, I18n.format("gui.done", new Object[0])));
        this.buttonList.add(new GuiButton(1, this.width / 2 - 160, this.height - 52, 80, 20, I18n.format("stat.generalButton", new Object[0])));
        GuiButton lvt_1_1_ = this.addButton(new GuiButton(2, this.width / 2 - 80, this.height - 52, 80, 20, I18n.format("stat.blocksButton", new Object[0])));
        GuiButton lvt_2_1_ = this.addButton(new GuiButton(3, this.width / 2, this.height - 52, 80, 20, I18n.format("stat.itemsButton", new Object[0])));
        GuiButton lvt_3_1_ = this.addButton(new GuiButton(4, this.width / 2 + 80, this.height - 52, 80, 20, I18n.format("stat.mobsButton", new Object[0])));
        if (this.blockStats.getSize() == 0) {
            lvt_1_1_.enabled = false;
        }
        if (this.itemStats.getSize() == 0) {
            lvt_2_1_.enabled = false;
        }
        if (this.mobStats.getSize() == 0) {
            lvt_3_1_.enabled = false;
        }
    }

    @Override
    protected void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
        if (!p_actionPerformed_1_.enabled) {
            return;
        }
        if (p_actionPerformed_1_.id == 0) {
            this.mc.displayGuiScreen(this.parentScreen);
        } else if (p_actionPerformed_1_.id == 1) {
            this.displaySlot = this.generalStats;
        } else if (p_actionPerformed_1_.id == 3) {
            this.displaySlot = this.itemStats;
        } else if (p_actionPerformed_1_.id == 2) {
            this.displaySlot = this.blockStats;
        } else if (p_actionPerformed_1_.id == 4) {
            this.displaySlot = this.mobStats;
        } else {
            this.displaySlot.actionPerformed(p_actionPerformed_1_);
        }
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        if (this.doesGuiPauseGame) {
            this.drawDefaultBackground();
            this.drawCenteredString(this.fontRendererObj, I18n.format("multiplayer.downloadingStats", new Object[0]), this.width / 2, this.height / 2, 0xFFFFFF);
            this.drawCenteredString(this.fontRendererObj, LOADING_STRINGS[(int)(Minecraft.getSystemTime() / 150L % (long)LOADING_STRINGS.length)], this.width / 2, this.height / 2 + this.fontRendererObj.FONT_HEIGHT * 2, 0xFFFFFF);
        } else {
            this.displaySlot.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
            this.drawCenteredString(this.fontRendererObj, this.screenTitle, this.width / 2, 20, 0xFFFFFF);
            super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
        }
    }

    @Override
    public void doneLoading() {
        if (this.doesGuiPauseGame) {
            this.initLists();
            this.createButtons();
            this.displaySlot = this.generalStats;
            this.doesGuiPauseGame = false;
        }
    }

    @Override
    public boolean doesGuiPauseGame() {
        return !this.doesGuiPauseGame;
    }

    private void drawStatsScreen(int p_drawStatsScreen_1_, int p_drawStatsScreen_2_, Item p_drawStatsScreen_3_) {
        this.drawButtonBackground(p_drawStatsScreen_1_ + 1, p_drawStatsScreen_2_ + 1);
        GlStateManager.enableRescaleNormal();
        RenderHelper.enableGUIStandardItemLighting();
        this.itemRender.renderItemIntoGUI(p_drawStatsScreen_3_.getDefaultInstance(), p_drawStatsScreen_1_ + 2, p_drawStatsScreen_2_ + 2);
        RenderHelper.disableStandardItemLighting();
        GlStateManager.disableRescaleNormal();
    }

    private void drawButtonBackground(int p_drawButtonBackground_1_, int p_drawButtonBackground_2_) {
        this.drawSprite(p_drawButtonBackground_1_, p_drawButtonBackground_2_, 0, 0);
    }

    private void drawSprite(int p_drawSprite_1_, int p_drawSprite_2_, int p_drawSprite_3_, int p_drawSprite_4_) {
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.getTextureManager().bindTexture(STAT_ICONS);
        float lvt_5_1_ = 0.0078125f;
        float lvt_6_1_ = 0.0078125f;
        int lvt_7_1_ = 18;
        int lvt_8_1_ = 18;
        Tessellator lvt_9_1_ = Tessellator.getInstance();
        VertexBuffer lvt_10_1_ = lvt_9_1_.getBuffer();
        lvt_10_1_.begin(7, DefaultVertexFormats.POSITION_TEX);
        lvt_10_1_.pos(p_drawSprite_1_ + 0, p_drawSprite_2_ + 18, this.zLevel).tex((float)(p_drawSprite_3_ + 0) * 0.0078125f, (float)(p_drawSprite_4_ + 18) * 0.0078125f).endVertex();
        lvt_10_1_.pos(p_drawSprite_1_ + 18, p_drawSprite_2_ + 18, this.zLevel).tex((float)(p_drawSprite_3_ + 18) * 0.0078125f, (float)(p_drawSprite_4_ + 18) * 0.0078125f).endVertex();
        lvt_10_1_.pos(p_drawSprite_1_ + 18, p_drawSprite_2_ + 0, this.zLevel).tex((float)(p_drawSprite_3_ + 18) * 0.0078125f, (float)(p_drawSprite_4_ + 0) * 0.0078125f).endVertex();
        lvt_10_1_.pos(p_drawSprite_1_ + 0, p_drawSprite_2_ + 0, this.zLevel).tex((float)(p_drawSprite_3_ + 0) * 0.0078125f, (float)(p_drawSprite_4_ + 0) * 0.0078125f).endVertex();
        lvt_9_1_.draw();
    }

    @SideOnly(value=Side.CLIENT)
    class StatsMobsList
    extends GuiSlot {
        private final List<EntityList.EntityEggInfo> mobs;

        public StatsMobsList(Minecraft p_i45510_2_) {
            super(p_i45510_2_, GuiStats.this.width, GuiStats.this.height, 32, GuiStats.this.height - 64, ((GuiStats)GuiStats.this).fontRendererObj.FONT_HEIGHT * 4);
            this.mobs = Lists.newArrayList();
            this.setShowSelectionBox(false);
            for (EntityList.EntityEggInfo lvt_4_1_ : EntityList.ENTITY_EGGS.values()) {
                if (GuiStats.this.stats.readStat(lvt_4_1_.killEntityStat) <= 0 && GuiStats.this.stats.readStat(lvt_4_1_.entityKilledByStat) <= 0) continue;
                this.mobs.add(lvt_4_1_);
            }
        }

        @Override
        protected int getSize() {
            return this.mobs.size();
        }

        @Override
        protected void elementClicked(int p_elementClicked_1_, boolean p_elementClicked_2_, int p_elementClicked_3_, int p_elementClicked_4_) {
        }

        @Override
        protected boolean isSelected(int p_isSelected_1_) {
            return false;
        }

        @Override
        protected int getContentHeight() {
            return this.getSize() * ((GuiStats)GuiStats.this).fontRendererObj.FONT_HEIGHT * 4;
        }

        @Override
        protected void drawBackground() {
            GuiStats.this.drawDefaultBackground();
        }

        @Override
        protected void drawSlot(int p_drawSlot_1_, int p_drawSlot_2_, int p_drawSlot_3_, int p_drawSlot_4_, int p_drawSlot_5_, int p_drawSlot_6_) {
            EntityList.EntityEggInfo lvt_7_1_ = this.mobs.get(p_drawSlot_1_);
            String lvt_8_1_ = I18n.format("entity." + EntityList.getTranslationName(lvt_7_1_.spawnedID) + ".name", new Object[0]);
            int lvt_9_1_ = GuiStats.this.stats.readStat(lvt_7_1_.killEntityStat);
            int lvt_10_1_ = GuiStats.this.stats.readStat(lvt_7_1_.entityKilledByStat);
            String lvt_11_1_ = I18n.format("stat.entityKills", lvt_9_1_, lvt_8_1_);
            String lvt_12_1_ = I18n.format("stat.entityKilledBy", lvt_8_1_, lvt_10_1_);
            if (lvt_9_1_ == 0) {
                lvt_11_1_ = I18n.format("stat.entityKills.none", lvt_8_1_);
            }
            if (lvt_10_1_ == 0) {
                lvt_12_1_ = I18n.format("stat.entityKilledBy.none", lvt_8_1_);
            }
            GuiStats.this.drawString(GuiStats.this.fontRendererObj, lvt_8_1_, p_drawSlot_2_ + 2 - 10, p_drawSlot_3_ + 1, 0xFFFFFF);
            GuiStats.this.drawString(GuiStats.this.fontRendererObj, lvt_11_1_, p_drawSlot_2_ + 2, p_drawSlot_3_ + 1 + ((GuiStats)GuiStats.this).fontRendererObj.FONT_HEIGHT, lvt_9_1_ == 0 ? 0x606060 : 0x909090);
            GuiStats.this.drawString(GuiStats.this.fontRendererObj, lvt_12_1_, p_drawSlot_2_ + 2, p_drawSlot_3_ + 1 + ((GuiStats)GuiStats.this).fontRendererObj.FONT_HEIGHT * 2, lvt_10_1_ == 0 ? 0x606060 : 0x909090);
        }
    }

    @SideOnly(value=Side.CLIENT)
    class StatsBlock
    extends Stats {
        public StatsBlock(Minecraft p_i45513_2_) {
            super(p_i45513_2_);
            this.statsHolder = Lists.newArrayList();
            for (StatCrafting lvt_4_1_ : StatList.MINE_BLOCK_STATS) {
                boolean lvt_5_1_ = false;
                Item lvt_6_1_ = lvt_4_1_.getItem();
                if (GuiStats.this.stats.readStat(lvt_4_1_) > 0) {
                    lvt_5_1_ = true;
                } else if (StatList.getObjectUseStats(lvt_6_1_) != null && GuiStats.this.stats.readStat(StatList.getObjectUseStats(lvt_6_1_)) > 0) {
                    lvt_5_1_ = true;
                } else if (StatList.getCraftStats(lvt_6_1_) != null && GuiStats.this.stats.readStat(StatList.getCraftStats(lvt_6_1_)) > 0) {
                    lvt_5_1_ = true;
                } else if (StatList.getObjectsPickedUpStats(lvt_6_1_) != null && GuiStats.this.stats.readStat(StatList.getObjectsPickedUpStats(lvt_6_1_)) > 0) {
                    lvt_5_1_ = true;
                } else if (StatList.getDroppedObjectStats(lvt_6_1_) != null && GuiStats.this.stats.readStat(StatList.getDroppedObjectStats(lvt_6_1_)) > 0) {
                    lvt_5_1_ = true;
                }
                if (!lvt_5_1_) continue;
                this.statsHolder.add(lvt_4_1_);
            }
            this.statSorter = new Comparator<StatCrafting>(){

                @Override
                public int compare(StatCrafting p_compare_1_, StatCrafting p_compare_2_) {
                    Item lvt_3_1_ = p_compare_1_.getItem();
                    Item lvt_4_1_ = p_compare_2_.getItem();
                    StatBase lvt_5_1_ = null;
                    StatBase lvt_6_1_ = null;
                    if (StatsBlock.this.sortColumn == 2) {
                        lvt_5_1_ = StatList.getBlockStats(Block.getBlockFromItem(lvt_3_1_));
                        lvt_6_1_ = StatList.getBlockStats(Block.getBlockFromItem(lvt_4_1_));
                    } else if (StatsBlock.this.sortColumn == 0) {
                        lvt_5_1_ = StatList.getCraftStats(lvt_3_1_);
                        lvt_6_1_ = StatList.getCraftStats(lvt_4_1_);
                    } else if (StatsBlock.this.sortColumn == 1) {
                        lvt_5_1_ = StatList.getObjectUseStats(lvt_3_1_);
                        lvt_6_1_ = StatList.getObjectUseStats(lvt_4_1_);
                    } else if (StatsBlock.this.sortColumn == 3) {
                        lvt_5_1_ = StatList.getObjectsPickedUpStats(lvt_3_1_);
                        lvt_6_1_ = StatList.getObjectsPickedUpStats(lvt_4_1_);
                    } else if (StatsBlock.this.sortColumn == 4) {
                        lvt_5_1_ = StatList.getDroppedObjectStats(lvt_3_1_);
                        lvt_6_1_ = StatList.getDroppedObjectStats(lvt_4_1_);
                    }
                    if (lvt_5_1_ != null || lvt_6_1_ != null) {
                        int lvt_8_1_;
                        if (lvt_5_1_ == null) {
                            return 1;
                        }
                        if (lvt_6_1_ == null) {
                            return -1;
                        }
                        int lvt_7_1_ = GuiStats.this.stats.readStat(lvt_5_1_);
                        if (lvt_7_1_ != (lvt_8_1_ = GuiStats.this.stats.readStat(lvt_6_1_))) {
                            return (lvt_7_1_ - lvt_8_1_) * StatsBlock.this.sortOrder;
                        }
                    }
                    return Item.getIdFromItem(lvt_3_1_) - Item.getIdFromItem(lvt_4_1_);
                }

                @Override
                public /* synthetic */ int compare(Object p_compare_1_, Object p_compare_2_) {
                    return this.compare((StatCrafting)p_compare_1_, (StatCrafting)p_compare_2_);
                }
            };
        }

        @Override
        protected void drawListHeader(int p_drawListHeader_1_, int p_drawListHeader_2_, Tessellator p_drawListHeader_3_) {
            super.drawListHeader(p_drawListHeader_1_, p_drawListHeader_2_, p_drawListHeader_3_);
            if (this.headerPressed == 0) {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 115 - 18 + 1, p_drawListHeader_2_ + 1 + 1, 18, 18);
            } else {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 115 - 18, p_drawListHeader_2_ + 1, 18, 18);
            }
            if (this.headerPressed == 1) {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 165 - 18 + 1, p_drawListHeader_2_ + 1 + 1, 36, 18);
            } else {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 165 - 18, p_drawListHeader_2_ + 1, 36, 18);
            }
            if (this.headerPressed == 2) {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 215 - 18 + 1, p_drawListHeader_2_ + 1 + 1, 54, 18);
            } else {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 215 - 18, p_drawListHeader_2_ + 1, 54, 18);
            }
            if (this.headerPressed == 3) {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 265 - 18 + 1, p_drawListHeader_2_ + 1 + 1, 90, 18);
            } else {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 265 - 18, p_drawListHeader_2_ + 1, 90, 18);
            }
            if (this.headerPressed == 4) {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 315 - 18 + 1, p_drawListHeader_2_ + 1 + 1, 108, 18);
            } else {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 315 - 18, p_drawListHeader_2_ + 1, 108, 18);
            }
        }

        @Override
        protected void drawSlot(int p_drawSlot_1_, int p_drawSlot_2_, int p_drawSlot_3_, int p_drawSlot_4_, int p_drawSlot_5_, int p_drawSlot_6_) {
            StatCrafting lvt_7_1_ = this.getSlotStat(p_drawSlot_1_);
            Item lvt_8_1_ = lvt_7_1_.getItem();
            GuiStats.this.drawStatsScreen(p_drawSlot_2_ + 40, p_drawSlot_3_, lvt_8_1_);
            this.renderStat(StatList.getCraftStats(lvt_8_1_), p_drawSlot_2_ + 115, p_drawSlot_3_, p_drawSlot_1_ % 2 == 0);
            this.renderStat(StatList.getObjectUseStats(lvt_8_1_), p_drawSlot_2_ + 165, p_drawSlot_3_, p_drawSlot_1_ % 2 == 0);
            this.renderStat(lvt_7_1_, p_drawSlot_2_ + 215, p_drawSlot_3_, p_drawSlot_1_ % 2 == 0);
            this.renderStat(StatList.getObjectsPickedUpStats(lvt_8_1_), p_drawSlot_2_ + 265, p_drawSlot_3_, p_drawSlot_1_ % 2 == 0);
            this.renderStat(StatList.getDroppedObjectStats(lvt_8_1_), p_drawSlot_2_ + 315, p_drawSlot_3_, p_drawSlot_1_ % 2 == 0);
        }

        @Override
        protected String getHeaderDescriptionId(int p_getHeaderDescriptionId_1_) {
            if (p_getHeaderDescriptionId_1_ == 0) {
                return "stat.crafted";
            }
            if (p_getHeaderDescriptionId_1_ == 1) {
                return "stat.used";
            }
            if (p_getHeaderDescriptionId_1_ == 3) {
                return "stat.pickup";
            }
            if (p_getHeaderDescriptionId_1_ == 4) {
                return "stat.dropped";
            }
            return "stat.mined";
        }
    }

    @SideOnly(value=Side.CLIENT)
    class StatsItem
    extends Stats {
        public StatsItem(Minecraft p_i45511_2_) {
            super(p_i45511_2_);
            this.statsHolder = Lists.newArrayList();
            for (StatCrafting lvt_4_1_ : StatList.USE_ITEM_STATS) {
                boolean lvt_5_1_ = false;
                Item lvt_6_1_ = lvt_4_1_.getItem();
                if (GuiStats.this.stats.readStat(lvt_4_1_) > 0) {
                    lvt_5_1_ = true;
                } else if (StatList.getObjectBreakStats(lvt_6_1_) != null && GuiStats.this.stats.readStat(StatList.getObjectBreakStats(lvt_6_1_)) > 0) {
                    lvt_5_1_ = true;
                } else if (StatList.getCraftStats(lvt_6_1_) != null && GuiStats.this.stats.readStat(StatList.getCraftStats(lvt_6_1_)) > 0) {
                    lvt_5_1_ = true;
                } else if (StatList.getObjectsPickedUpStats(lvt_6_1_) != null && GuiStats.this.stats.readStat(StatList.getObjectsPickedUpStats(lvt_6_1_)) > 0) {
                    lvt_5_1_ = true;
                } else if (StatList.getDroppedObjectStats(lvt_6_1_) != null && GuiStats.this.stats.readStat(StatList.getDroppedObjectStats(lvt_6_1_)) > 0) {
                    lvt_5_1_ = true;
                }
                if (!lvt_5_1_) continue;
                this.statsHolder.add(lvt_4_1_);
            }
            this.statSorter = new Comparator<StatCrafting>(){

                @Override
                public int compare(StatCrafting p_compare_1_, StatCrafting p_compare_2_) {
                    Item lvt_3_1_ = p_compare_1_.getItem();
                    Item lvt_4_1_ = p_compare_2_.getItem();
                    int lvt_5_1_ = Item.getIdFromItem(lvt_3_1_);
                    int lvt_6_1_ = Item.getIdFromItem(lvt_4_1_);
                    StatBase lvt_7_1_ = null;
                    StatBase lvt_8_1_ = null;
                    if (StatsItem.this.sortColumn == 0) {
                        lvt_7_1_ = StatList.getObjectBreakStats(lvt_3_1_);
                        lvt_8_1_ = StatList.getObjectBreakStats(lvt_4_1_);
                    } else if (StatsItem.this.sortColumn == 1) {
                        lvt_7_1_ = StatList.getCraftStats(lvt_3_1_);
                        lvt_8_1_ = StatList.getCraftStats(lvt_4_1_);
                    } else if (StatsItem.this.sortColumn == 2) {
                        lvt_7_1_ = StatList.getObjectUseStats(lvt_3_1_);
                        lvt_8_1_ = StatList.getObjectUseStats(lvt_4_1_);
                    } else if (StatsItem.this.sortColumn == 3) {
                        lvt_7_1_ = StatList.getObjectsPickedUpStats(lvt_3_1_);
                        lvt_8_1_ = StatList.getObjectsPickedUpStats(lvt_4_1_);
                    } else if (StatsItem.this.sortColumn == 4) {
                        lvt_7_1_ = StatList.getDroppedObjectStats(lvt_3_1_);
                        lvt_8_1_ = StatList.getDroppedObjectStats(lvt_4_1_);
                    }
                    if (lvt_7_1_ != null || lvt_8_1_ != null) {
                        int lvt_10_1_;
                        if (lvt_7_1_ == null) {
                            return 1;
                        }
                        if (lvt_8_1_ == null) {
                            return -1;
                        }
                        int lvt_9_1_ = GuiStats.this.stats.readStat(lvt_7_1_);
                        if (lvt_9_1_ != (lvt_10_1_ = GuiStats.this.stats.readStat(lvt_8_1_))) {
                            return (lvt_9_1_ - lvt_10_1_) * StatsItem.this.sortOrder;
                        }
                    }
                    return lvt_5_1_ - lvt_6_1_;
                }

                @Override
                public /* synthetic */ int compare(Object p_compare_1_, Object p_compare_2_) {
                    return this.compare((StatCrafting)p_compare_1_, (StatCrafting)p_compare_2_);
                }
            };
        }

        @Override
        protected void drawListHeader(int p_drawListHeader_1_, int p_drawListHeader_2_, Tessellator p_drawListHeader_3_) {
            super.drawListHeader(p_drawListHeader_1_, p_drawListHeader_2_, p_drawListHeader_3_);
            if (this.headerPressed == 0) {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 115 - 18 + 1, p_drawListHeader_2_ + 1 + 1, 72, 18);
            } else {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 115 - 18, p_drawListHeader_2_ + 1, 72, 18);
            }
            if (this.headerPressed == 1) {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 165 - 18 + 1, p_drawListHeader_2_ + 1 + 1, 18, 18);
            } else {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 165 - 18, p_drawListHeader_2_ + 1, 18, 18);
            }
            if (this.headerPressed == 2) {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 215 - 18 + 1, p_drawListHeader_2_ + 1 + 1, 36, 18);
            } else {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 215 - 18, p_drawListHeader_2_ + 1, 36, 18);
            }
            if (this.headerPressed == 3) {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 265 - 18 + 1, p_drawListHeader_2_ + 1 + 1, 90, 18);
            } else {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 265 - 18, p_drawListHeader_2_ + 1, 90, 18);
            }
            if (this.headerPressed == 4) {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 315 - 18 + 1, p_drawListHeader_2_ + 1 + 1, 108, 18);
            } else {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 315 - 18, p_drawListHeader_2_ + 1, 108, 18);
            }
        }

        @Override
        protected void drawSlot(int p_drawSlot_1_, int p_drawSlot_2_, int p_drawSlot_3_, int p_drawSlot_4_, int p_drawSlot_5_, int p_drawSlot_6_) {
            StatCrafting lvt_7_1_ = this.getSlotStat(p_drawSlot_1_);
            Item lvt_8_1_ = lvt_7_1_.getItem();
            GuiStats.this.drawStatsScreen(p_drawSlot_2_ + 40, p_drawSlot_3_, lvt_8_1_);
            this.renderStat(StatList.getObjectBreakStats(lvt_8_1_), p_drawSlot_2_ + 115, p_drawSlot_3_, p_drawSlot_1_ % 2 == 0);
            this.renderStat(StatList.getCraftStats(lvt_8_1_), p_drawSlot_2_ + 165, p_drawSlot_3_, p_drawSlot_1_ % 2 == 0);
            this.renderStat(lvt_7_1_, p_drawSlot_2_ + 215, p_drawSlot_3_, p_drawSlot_1_ % 2 == 0);
            this.renderStat(StatList.getObjectsPickedUpStats(lvt_8_1_), p_drawSlot_2_ + 265, p_drawSlot_3_, p_drawSlot_1_ % 2 == 0);
            this.renderStat(StatList.getDroppedObjectStats(lvt_8_1_), p_drawSlot_2_ + 315, p_drawSlot_3_, p_drawSlot_1_ % 2 == 0);
        }

        @Override
        protected String getHeaderDescriptionId(int p_getHeaderDescriptionId_1_) {
            if (p_getHeaderDescriptionId_1_ == 1) {
                return "stat.crafted";
            }
            if (p_getHeaderDescriptionId_1_ == 2) {
                return "stat.used";
            }
            if (p_getHeaderDescriptionId_1_ == 3) {
                return "stat.pickup";
            }
            if (p_getHeaderDescriptionId_1_ == 4) {
                return "stat.dropped";
            }
            return "stat.depleted";
        }
    }

    @SideOnly(value=Side.CLIENT)
    abstract class Stats
    extends GuiSlot {
        protected int headerPressed;
        protected List<StatCrafting> statsHolder;
        protected Comparator<StatCrafting> statSorter;
        protected int sortColumn;
        protected int sortOrder;

        protected Stats(Minecraft p_i45509_2_) {
            super(p_i45509_2_, GuiStats.this.width, GuiStats.this.height, 32, GuiStats.this.height - 64, 20);
            this.headerPressed = -1;
            this.sortColumn = -1;
            this.setShowSelectionBox(false);
            this.setHasListHeader(true, 20);
        }

        @Override
        protected void elementClicked(int p_elementClicked_1_, boolean p_elementClicked_2_, int p_elementClicked_3_, int p_elementClicked_4_) {
        }

        @Override
        protected boolean isSelected(int p_isSelected_1_) {
            return false;
        }

        @Override
        public int getListWidth() {
            return 375;
        }

        @Override
        protected int getScrollBarX() {
            return this.width / 2 + 140;
        }

        @Override
        protected void drawBackground() {
            GuiStats.this.drawDefaultBackground();
        }

        @Override
        protected void drawListHeader(int p_drawListHeader_1_, int p_drawListHeader_2_, Tessellator p_drawListHeader_3_) {
            if (!Mouse.isButtonDown((int)0)) {
                this.headerPressed = -1;
            }
            if (this.headerPressed == 0) {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 115 - 18, p_drawListHeader_2_ + 1, 0, 0);
            } else {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 115 - 18, p_drawListHeader_2_ + 1, 0, 18);
            }
            if (this.headerPressed == 1) {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 165 - 18, p_drawListHeader_2_ + 1, 0, 0);
            } else {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 165 - 18, p_drawListHeader_2_ + 1, 0, 18);
            }
            if (this.headerPressed == 2) {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 215 - 18, p_drawListHeader_2_ + 1, 0, 0);
            } else {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 215 - 18, p_drawListHeader_2_ + 1, 0, 18);
            }
            if (this.headerPressed == 3) {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 265 - 18, p_drawListHeader_2_ + 1, 0, 0);
            } else {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 265 - 18, p_drawListHeader_2_ + 1, 0, 18);
            }
            if (this.headerPressed == 4) {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 315 - 18, p_drawListHeader_2_ + 1, 0, 0);
            } else {
                GuiStats.this.drawSprite(p_drawListHeader_1_ + 315 - 18, p_drawListHeader_2_ + 1, 0, 18);
            }
            if (this.sortColumn != -1) {
                int lvt_4_1_ = 79;
                int lvt_5_1_ = 18;
                if (this.sortColumn == 1) {
                    lvt_4_1_ = 129;
                } else if (this.sortColumn == 2) {
                    lvt_4_1_ = 179;
                } else if (this.sortColumn == 3) {
                    lvt_4_1_ = 229;
                } else if (this.sortColumn == 4) {
                    lvt_4_1_ = 279;
                }
                if (this.sortOrder == 1) {
                    lvt_5_1_ = 36;
                }
                GuiStats.this.drawSprite(p_drawListHeader_1_ + lvt_4_1_, p_drawListHeader_2_ + 1, lvt_5_1_, 0);
            }
        }

        @Override
        protected void clickedHeader(int p_clickedHeader_1_, int p_clickedHeader_2_) {
            this.headerPressed = -1;
            if (p_clickedHeader_1_ >= 79 && p_clickedHeader_1_ < 115) {
                this.headerPressed = 0;
            } else if (p_clickedHeader_1_ >= 129 && p_clickedHeader_1_ < 165) {
                this.headerPressed = 1;
            } else if (p_clickedHeader_1_ >= 179 && p_clickedHeader_1_ < 215) {
                this.headerPressed = 2;
            } else if (p_clickedHeader_1_ >= 229 && p_clickedHeader_1_ < 265) {
                this.headerPressed = 3;
            } else if (p_clickedHeader_1_ >= 279 && p_clickedHeader_1_ < 315) {
                this.headerPressed = 4;
            }
            if (this.headerPressed >= 0) {
                this.sortByColumn(this.headerPressed);
                this.mc.getSoundHandler().playSound(PositionedSoundRecord.getMasterRecord(SoundEvents.UI_BUTTON_CLICK, 1.0f));
            }
        }

        @Override
        protected final int getSize() {
            return this.statsHolder.size();
        }

        protected final StatCrafting getSlotStat(int p_getSlotStat_1_) {
            return this.statsHolder.get(p_getSlotStat_1_);
        }

        protected abstract String getHeaderDescriptionId(int var1);

        protected void renderStat(StatBase p_renderStat_1_, int p_renderStat_2_, int p_renderStat_3_, boolean p_renderStat_4_) {
            if (p_renderStat_1_ != null) {
                String lvt_5_1_ = p_renderStat_1_.format(GuiStats.this.stats.readStat(p_renderStat_1_));
                GuiStats.this.drawString(GuiStats.this.fontRendererObj, lvt_5_1_, p_renderStat_2_ - GuiStats.this.fontRendererObj.getStringWidth(lvt_5_1_), p_renderStat_3_ + 5, p_renderStat_4_ ? 0xFFFFFF : 0x909090);
            } else {
                String lvt_5_2_ = "-";
                GuiStats.this.drawString(GuiStats.this.fontRendererObj, "-", p_renderStat_2_ - GuiStats.this.fontRendererObj.getStringWidth("-"), p_renderStat_3_ + 5, p_renderStat_4_ ? 0xFFFFFF : 0x909090);
            }
        }

        @Override
        protected void renderDecorations(int p_renderDecorations_1_, int p_renderDecorations_2_) {
            if (p_renderDecorations_2_ < this.top || p_renderDecorations_2_ > this.bottom) {
                return;
            }
            int lvt_3_1_ = this.getSlotIndexFromScreenCoords(p_renderDecorations_1_, p_renderDecorations_2_);
            int lvt_4_1_ = (this.width - this.getListWidth()) / 2;
            if (lvt_3_1_ >= 0) {
                if (p_renderDecorations_1_ < lvt_4_1_ + 40 || p_renderDecorations_1_ > lvt_4_1_ + 40 + 20) {
                    return;
                }
                StatCrafting lvt_5_1_ = this.getSlotStat(lvt_3_1_);
                this.renderMouseHoverToolTip(lvt_5_1_, p_renderDecorations_1_, p_renderDecorations_2_);
            } else {
                String lvt_5_7_;
                if (p_renderDecorations_1_ >= lvt_4_1_ + 115 - 18 && p_renderDecorations_1_ <= lvt_4_1_ + 115) {
                    String lvt_5_2_ = this.getHeaderDescriptionId(0);
                } else if (p_renderDecorations_1_ >= lvt_4_1_ + 165 - 18 && p_renderDecorations_1_ <= lvt_4_1_ + 165) {
                    String lvt_5_3_ = this.getHeaderDescriptionId(1);
                } else if (p_renderDecorations_1_ >= lvt_4_1_ + 215 - 18 && p_renderDecorations_1_ <= lvt_4_1_ + 215) {
                    String lvt_5_4_ = this.getHeaderDescriptionId(2);
                } else if (p_renderDecorations_1_ >= lvt_4_1_ + 265 - 18 && p_renderDecorations_1_ <= lvt_4_1_ + 265) {
                    String lvt_5_5_ = this.getHeaderDescriptionId(3);
                } else if (p_renderDecorations_1_ >= lvt_4_1_ + 315 - 18 && p_renderDecorations_1_ <= lvt_4_1_ + 315) {
                    String lvt_5_6_ = this.getHeaderDescriptionId(4);
                } else {
                    return;
                }
                lvt_5_7_ = ("" + I18n.format(lvt_5_7_, new Object[0])).trim();
                if (!lvt_5_7_.isEmpty()) {
                    int lvt_6_1_ = p_renderDecorations_1_ + 12;
                    int lvt_7_1_ = p_renderDecorations_2_ - 12;
                    int lvt_8_1_ = GuiStats.this.fontRendererObj.getStringWidth(lvt_5_7_);
                    GuiStats.this.drawGradientRect(lvt_6_1_ - 3, lvt_7_1_ - 3, lvt_6_1_ + lvt_8_1_ + 3, lvt_7_1_ + 8 + 3, -1073741824, -1073741824);
                    GuiStats.this.fontRendererObj.drawStringWithShadow(lvt_5_7_, lvt_6_1_, lvt_7_1_, -1);
                }
            }
        }

        protected void renderMouseHoverToolTip(StatCrafting p_renderMouseHoverToolTip_1_, int p_renderMouseHoverToolTip_2_, int p_renderMouseHoverToolTip_3_) {
            if (p_renderMouseHoverToolTip_1_ == null) {
                return;
            }
            Item lvt_4_1_ = p_renderMouseHoverToolTip_1_.getItem();
            ItemStack lvt_5_1_ = new ItemStack(lvt_4_1_);
            String lvt_6_1_ = lvt_5_1_.getUnlocalizedName();
            String lvt_7_1_ = ("" + I18n.format(lvt_6_1_ + ".name", new Object[0])).trim();
            if (!lvt_7_1_.isEmpty()) {
                int lvt_8_1_ = p_renderMouseHoverToolTip_2_ + 12;
                int lvt_9_1_ = p_renderMouseHoverToolTip_3_ - 12;
                int lvt_10_1_ = GuiStats.this.fontRendererObj.getStringWidth(lvt_7_1_);
                GuiStats.this.drawGradientRect(lvt_8_1_ - 3, lvt_9_1_ - 3, lvt_8_1_ + lvt_10_1_ + 3, lvt_9_1_ + 8 + 3, -1073741824, -1073741824);
                GuiStats.this.fontRendererObj.drawStringWithShadow(lvt_7_1_, lvt_8_1_, lvt_9_1_, -1);
            }
        }

        protected void sortByColumn(int p_sortByColumn_1_) {
            if (p_sortByColumn_1_ != this.sortColumn) {
                this.sortColumn = p_sortByColumn_1_;
                this.sortOrder = -1;
            } else if (this.sortOrder == -1) {
                this.sortOrder = 1;
            } else {
                this.sortColumn = -1;
                this.sortOrder = 0;
            }
            Collections.sort(this.statsHolder, this.statSorter);
        }
    }

    @SideOnly(value=Side.CLIENT)
    class StatsGeneral
    extends GuiSlot {
        public StatsGeneral(Minecraft p_i45512_2_) {
            super(p_i45512_2_, GuiStats.this.width, GuiStats.this.height, 32, GuiStats.this.height - 64, 10);
            this.setShowSelectionBox(false);
        }

        @Override
        protected int getSize() {
            return StatList.BASIC_STATS.size();
        }

        @Override
        protected void elementClicked(int p_elementClicked_1_, boolean p_elementClicked_2_, int p_elementClicked_3_, int p_elementClicked_4_) {
        }

        @Override
        protected boolean isSelected(int p_isSelected_1_) {
            return false;
        }

        @Override
        protected int getContentHeight() {
            return this.getSize() * 10;
        }

        @Override
        protected void drawBackground() {
            GuiStats.this.drawDefaultBackground();
        }

        @Override
        protected void drawSlot(int p_drawSlot_1_, int p_drawSlot_2_, int p_drawSlot_3_, int p_drawSlot_4_, int p_drawSlot_5_, int p_drawSlot_6_) {
            StatBase lvt_7_1_ = StatList.BASIC_STATS.get(p_drawSlot_1_);
            GuiStats.this.drawString(GuiStats.this.fontRendererObj, lvt_7_1_.getStatName().getUnformattedText(), p_drawSlot_2_ + 2, p_drawSlot_3_ + 1, p_drawSlot_1_ % 2 == 0 ? 0xFFFFFF : 0x909090);
            String lvt_8_1_ = lvt_7_1_.format(GuiStats.this.stats.readStat(lvt_7_1_));
            GuiStats.this.drawString(GuiStats.this.fontRendererObj, lvt_8_1_, p_drawSlot_2_ + 2 + 213 - GuiStats.this.fontRendererObj.getStringWidth(lvt_8_1_), p_drawSlot_3_ + 1, p_drawSlot_1_ % 2 == 0 ? 0xFFFFFF : 0x909090);
        }
    }
}

