/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.inventory;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.ContainerBeacon;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCloseWindow;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class GuiBeacon
extends GuiContainer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation BEACON_GUI_TEXTURES = new ResourceLocation("textures/gui/container/beacon.png");
    private final IInventory tileBeacon;
    private ConfirmButton beaconConfirmButton;
    private boolean buttonsNotDrawn;

    public GuiBeacon(InventoryPlayer p_i45507_1_, IInventory p_i45507_2_) {
        super(new ContainerBeacon(p_i45507_1_, p_i45507_2_));
        this.tileBeacon = p_i45507_2_;
        this.xSize = 230;
        this.ySize = 219;
    }

    @Override
    public void initGui() {
        super.initGui();
        this.beaconConfirmButton = new ConfirmButton(-1, this.guiLeft + 164, this.guiTop + 107);
        this.buttonList.add(this.beaconConfirmButton);
        this.buttonList.add(new CancelButton(-2, this.guiLeft + 190, this.guiTop + 107));
        this.buttonsNotDrawn = true;
        this.beaconConfirmButton.enabled = false;
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        int lvt_1_1_ = this.tileBeacon.getField(0);
        Potion lvt_2_1_ = Potion.getPotionById(this.tileBeacon.getField(1));
        Potion lvt_3_1_ = Potion.getPotionById(this.tileBeacon.getField(2));
        if (this.buttonsNotDrawn && lvt_1_1_ >= 0) {
            this.buttonsNotDrawn = false;
            int lvt_4_1_ = 100;
            for (int lvt_5_1_ = 0; lvt_5_1_ <= 2; ++lvt_5_1_) {
                int lvt_6_1_ = TileEntityBeacon.EFFECTS_LIST[lvt_5_1_].length;
                int lvt_7_1_ = lvt_6_1_ * 22 + (lvt_6_1_ - 1) * 2;
                for (int lvt_8_1_ = 0; lvt_8_1_ < lvt_6_1_; ++lvt_8_1_) {
                    Potion lvt_9_1_ = TileEntityBeacon.EFFECTS_LIST[lvt_5_1_][lvt_8_1_];
                    PowerButton lvt_10_1_ = new PowerButton(lvt_4_1_++, this.guiLeft + 76 + lvt_8_1_ * 24 - lvt_7_1_ / 2, this.guiTop + 22 + lvt_5_1_ * 25, lvt_9_1_, lvt_5_1_);
                    this.buttonList.add(lvt_10_1_);
                    if (lvt_5_1_ >= lvt_1_1_) {
                        lvt_10_1_.enabled = false;
                        continue;
                    }
                    if (lvt_9_1_ != lvt_2_1_) continue;
                    lvt_10_1_.setSelected(true);
                }
            }
            int lvt_5_2_ = 3;
            int lvt_6_2_ = TileEntityBeacon.EFFECTS_LIST[3].length + 1;
            int lvt_7_2_ = lvt_6_2_ * 22 + (lvt_6_2_ - 1) * 2;
            for (int lvt_8_2_ = 0; lvt_8_2_ < lvt_6_2_ - 1; ++lvt_8_2_) {
                Potion lvt_9_2_ = TileEntityBeacon.EFFECTS_LIST[3][lvt_8_2_];
                PowerButton lvt_10_2_ = new PowerButton(lvt_4_1_++, this.guiLeft + 167 + lvt_8_2_ * 24 - lvt_7_2_ / 2, this.guiTop + 47, lvt_9_2_, 3);
                this.buttonList.add(lvt_10_2_);
                if (3 >= lvt_1_1_) {
                    lvt_10_2_.enabled = false;
                    continue;
                }
                if (lvt_9_2_ != lvt_3_1_) continue;
                lvt_10_2_.setSelected(true);
            }
            if (lvt_2_1_ != null) {
                PowerButton lvt_8_3_ = new PowerButton(lvt_4_1_++, this.guiLeft + 167 + (lvt_6_2_ - 1) * 24 - lvt_7_2_ / 2, this.guiTop + 47, lvt_2_1_, 3);
                this.buttonList.add(lvt_8_3_);
                if (3 >= lvt_1_1_) {
                    lvt_8_3_.enabled = false;
                } else if (lvt_2_1_ == lvt_3_1_) {
                    lvt_8_3_.setSelected(true);
                }
            }
        }
        this.beaconConfirmButton.enabled = !this.tileBeacon.getStackInSlot(0).isEmpty() && lvt_2_1_ != null;
    }

    @Override
    protected void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
        if (p_actionPerformed_1_.id == -2) {
            this.mc.player.connection.sendPacket(new CPacketCloseWindow(this.mc.player.openContainer.windowId));
            this.mc.displayGuiScreen(null);
        } else if (p_actionPerformed_1_.id == -1) {
            String lvt_2_1_ = "MC|Beacon";
            PacketBuffer lvt_3_1_ = new PacketBuffer(Unpooled.buffer());
            lvt_3_1_.writeInt(this.tileBeacon.getField(1));
            lvt_3_1_.writeInt(this.tileBeacon.getField(2));
            this.mc.getConnection().sendPacket(new CPacketCustomPayload("MC|Beacon", lvt_3_1_));
            this.mc.player.connection.sendPacket(new CPacketCloseWindow(this.mc.player.openContainer.windowId));
            this.mc.displayGuiScreen(null);
        } else if (p_actionPerformed_1_ instanceof PowerButton) {
            PowerButton lvt_2_2_ = (PowerButton)p_actionPerformed_1_;
            if (lvt_2_2_.isSelected()) {
                return;
            }
            int lvt_3_2_ = Potion.getIdFromPotion(lvt_2_2_.effect);
            if (lvt_2_2_.tier < 3) {
                this.tileBeacon.setField(1, lvt_3_2_);
            } else {
                this.tileBeacon.setField(2, lvt_3_2_);
            }
            this.buttonList.clear();
            this.initGui();
            this.updateScreen();
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int p_drawGuiContainerForegroundLayer_1_, int p_drawGuiContainerForegroundLayer_2_) {
        RenderHelper.disableStandardItemLighting();
        this.drawCenteredString(this.fontRendererObj, I18n.format("tile.beacon.primary", new Object[0]), 62, 10, 0xE0E0E0);
        this.drawCenteredString(this.fontRendererObj, I18n.format("tile.beacon.secondary", new Object[0]), 169, 10, 0xE0E0E0);
        for (GuiButton lvt_4_1_ : this.buttonList) {
            if (!lvt_4_1_.isMouseOver()) continue;
            lvt_4_1_.drawButtonForegroundLayer(p_drawGuiContainerForegroundLayer_1_ - this.guiLeft, p_drawGuiContainerForegroundLayer_2_ - this.guiTop);
            break;
        }
        RenderHelper.enableGUIStandardItemLighting();
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float p_drawGuiContainerBackgroundLayer_1_, int p_drawGuiContainerBackgroundLayer_2_, int p_drawGuiContainerBackgroundLayer_3_) {
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.getTextureManager().bindTexture(BEACON_GUI_TEXTURES);
        int lvt_4_1_ = (this.width - this.xSize) / 2;
        int lvt_5_1_ = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(lvt_4_1_, lvt_5_1_, 0, 0, this.xSize, this.ySize);
        this.itemRender.zLevel = 100.0f;
        this.itemRender.renderItemAndEffectIntoGUI(new ItemStack(Items.EMERALD), lvt_4_1_ + 42, lvt_5_1_ + 109);
        this.itemRender.renderItemAndEffectIntoGUI(new ItemStack(Items.DIAMOND), lvt_4_1_ + 42 + 22, lvt_5_1_ + 109);
        this.itemRender.renderItemAndEffectIntoGUI(new ItemStack(Items.GOLD_INGOT), lvt_4_1_ + 42 + 44, lvt_5_1_ + 109);
        this.itemRender.renderItemAndEffectIntoGUI(new ItemStack(Items.IRON_INGOT), lvt_4_1_ + 42 + 66, lvt_5_1_ + 109);
        this.itemRender.zLevel = 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    class CancelButton
    extends Button {
        public CancelButton(int p_i1074_2_, int p_i1074_3_, int p_i1074_4_) {
            super(p_i1074_2_, p_i1074_3_, p_i1074_4_, BEACON_GUI_TEXTURES, 112, 220);
        }

        @Override
        public void drawButtonForegroundLayer(int p_drawButtonForegroundLayer_1_, int p_drawButtonForegroundLayer_2_) {
            GuiBeacon.this.drawCreativeTabHoveringText(I18n.format("gui.cancel", new Object[0]), p_drawButtonForegroundLayer_1_, p_drawButtonForegroundLayer_2_);
        }
    }

    @SideOnly(value=Side.CLIENT)
    class ConfirmButton
    extends Button {
        public ConfirmButton(int p_i1075_2_, int p_i1075_3_, int p_i1075_4_) {
            super(p_i1075_2_, p_i1075_3_, p_i1075_4_, BEACON_GUI_TEXTURES, 90, 220);
        }

        @Override
        public void drawButtonForegroundLayer(int p_drawButtonForegroundLayer_1_, int p_drawButtonForegroundLayer_2_) {
            GuiBeacon.this.drawCreativeTabHoveringText(I18n.format("gui.done", new Object[0]), p_drawButtonForegroundLayer_1_, p_drawButtonForegroundLayer_2_);
        }
    }

    @SideOnly(value=Side.CLIENT)
    class PowerButton
    extends Button {
        private final Potion effect;
        private final int tier;

        public PowerButton(int p_i47045_2_, int p_i47045_3_, int p_i47045_4_, Potion p_i47045_5_, int p_i47045_6_) {
            super(p_i47045_2_, p_i47045_3_, p_i47045_4_, GuiContainer.INVENTORY_BACKGROUND, p_i47045_5_.getStatusIconIndex() % 8 * 18, 198 + p_i47045_5_.getStatusIconIndex() / 8 * 18);
            this.effect = p_i47045_5_;
            this.tier = p_i47045_6_;
        }

        @Override
        public void drawButtonForegroundLayer(int p_drawButtonForegroundLayer_1_, int p_drawButtonForegroundLayer_2_) {
            String lvt_3_1_ = I18n.format(this.effect.getName(), new Object[0]);
            if (this.tier >= 3 && this.effect != MobEffects.REGENERATION) {
                lvt_3_1_ = lvt_3_1_ + " II";
            }
            GuiBeacon.this.drawCreativeTabHoveringText(lvt_3_1_, p_drawButtonForegroundLayer_1_, p_drawButtonForegroundLayer_2_);
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class Button
    extends GuiButton {
        private final ResourceLocation iconTexture;
        private final int iconX;
        private final int iconY;
        private boolean selected;

        protected Button(int p_i1077_1_, int p_i1077_2_, int p_i1077_3_, ResourceLocation p_i1077_4_, int p_i1077_5_, int p_i1077_6_) {
            super(p_i1077_1_, p_i1077_2_, p_i1077_3_, 22, 22, "");
            this.iconTexture = p_i1077_4_;
            this.iconX = p_i1077_5_;
            this.iconY = p_i1077_6_;
        }

        @Override
        public void drawButton(Minecraft p_drawButton_1_, int p_drawButton_2_, int p_drawButton_3_) {
            if (!this.visible) {
                return;
            }
            p_drawButton_1_.getTextureManager().bindTexture(BEACON_GUI_TEXTURES);
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            this.hovered = p_drawButton_2_ >= this.xPosition && p_drawButton_3_ >= this.yPosition && p_drawButton_2_ < this.xPosition + this.width && p_drawButton_3_ < this.yPosition + this.height;
            int lvt_4_1_ = 219;
            int lvt_5_1_ = 0;
            if (!this.enabled) {
                lvt_5_1_ += this.width * 2;
            } else if (this.selected) {
                lvt_5_1_ += this.width * 1;
            } else if (this.hovered) {
                lvt_5_1_ += this.width * 3;
            }
            this.drawTexturedModalRect(this.xPosition, this.yPosition, lvt_5_1_, 219, this.width, this.height);
            if (!BEACON_GUI_TEXTURES.equals(this.iconTexture)) {
                p_drawButton_1_.getTextureManager().bindTexture(this.iconTexture);
            }
            this.drawTexturedModalRect(this.xPosition + 2, this.yPosition + 2, this.iconX, this.iconY, 18, 18);
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean p_setSelected_1_) {
            this.selected = p_setSelected_1_;
        }
    }
}

