/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.inventory;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ContainerBrewingStand;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiBrewingStand
extends GuiContainer {
    private static final ResourceLocation BREWING_STAND_GUI_TEXTURES = new ResourceLocation("textures/gui/container/brewing_stand.png");
    private static final int[] BUBBLELENGTHS = new int[]{29, 24, 20, 16, 11, 6, 0};
    private final InventoryPlayer playerInventory;
    private final IInventory tileBrewingStand;

    public GuiBrewingStand(InventoryPlayer p_i45506_1_, IInventory p_i45506_2_) {
        super(new ContainerBrewingStand(p_i45506_1_, p_i45506_2_));
        this.playerInventory = p_i45506_1_;
        this.tileBrewingStand = p_i45506_2_;
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int p_drawGuiContainerForegroundLayer_1_, int p_drawGuiContainerForegroundLayer_2_) {
        String lvt_3_1_ = this.tileBrewingStand.getDisplayName().getUnformattedText();
        this.fontRendererObj.drawString(lvt_3_1_, this.xSize / 2 - this.fontRendererObj.getStringWidth(lvt_3_1_) / 2, 6, 0x404040);
        this.fontRendererObj.drawString(this.playerInventory.getDisplayName().getUnformattedText(), 8, this.ySize - 96 + 2, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float p_drawGuiContainerBackgroundLayer_1_, int p_drawGuiContainerBackgroundLayer_2_, int p_drawGuiContainerBackgroundLayer_3_) {
        int lvt_8_1_;
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.getTextureManager().bindTexture(BREWING_STAND_GUI_TEXTURES);
        int lvt_4_1_ = (this.width - this.xSize) / 2;
        int lvt_5_1_ = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(lvt_4_1_, lvt_5_1_, 0, 0, this.xSize, this.ySize);
        int lvt_6_1_ = this.tileBrewingStand.getField(1);
        int lvt_7_1_ = MathHelper.clamp((18 * lvt_6_1_ + 20 - 1) / 20, 0, 18);
        if (lvt_7_1_ > 0) {
            this.drawTexturedModalRect(lvt_4_1_ + 60, lvt_5_1_ + 44, 176, 29, lvt_7_1_, 4);
        }
        if ((lvt_8_1_ = this.tileBrewingStand.getField(0)) > 0) {
            int lvt_9_1_ = (int)(28.0f * (1.0f - (float)lvt_8_1_ / 400.0f));
            if (lvt_9_1_ > 0) {
                this.drawTexturedModalRect(lvt_4_1_ + 97, lvt_5_1_ + 16, 176, 0, 9, lvt_9_1_);
            }
            if ((lvt_9_1_ = BUBBLELENGTHS[lvt_8_1_ / 2 % 7]) > 0) {
                this.drawTexturedModalRect(lvt_4_1_ + 63, lvt_5_1_ + 14 + 29 - lvt_9_1_, 185, 29 - lvt_9_1_, 12, lvt_9_1_);
            }
        }
    }
}

