/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.inventory;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.achievement.GuiAchievements;
import net.minecraft.client.gui.achievement.GuiStats;
import net.minecraft.client.gui.inventory.CreativeCrafting;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiContainerCreative
extends InventoryEffectRenderer {
    private static final ResourceLocation CREATIVE_INVENTORY_TABS = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final InventoryBasic basicInventory = new InventoryBasic("tmp", true, 45);
    private static int selectedTabIndex = CreativeTabs.BUILDING_BLOCKS.getTabIndex();
    private float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;
    private GuiTextField searchField;
    private List<Slot> originalSlots;
    private Slot destroyItemSlot;
    private boolean clearSearch;
    private CreativeCrafting listener;
    private static int tabPage = 0;
    private int maxPages = 0;

    public GuiContainerCreative(EntityPlayer p_i1088_1_) {
        super(new ContainerCreative(p_i1088_1_));
        p_i1088_1_.openContainer = this.inventorySlots;
        this.allowUserInput = true;
        this.ySize = 136;
        this.xSize = 195;
    }

    @Override
    public void updateScreen() {
        if (!this.mc.playerController.isInCreativeMode()) {
            this.mc.displayGuiScreen(new GuiInventory(this.mc.player));
        }
    }

    @Override
    protected void handleMouseClick(Slot p_handleMouseClick_1_, int p_handleMouseClick_2_, int p_handleMouseClick_3_, ClickType p_handleMouseClick_4_) {
        this.clearSearch = true;
        boolean flag = p_handleMouseClick_4_ == ClickType.QUICK_MOVE;
        ClickType clickType = p_handleMouseClick_4_ = p_handleMouseClick_2_ == -999 && p_handleMouseClick_4_ == ClickType.PICKUP ? ClickType.THROW : p_handleMouseClick_4_;
        if (p_handleMouseClick_1_ == null && selectedTabIndex != CreativeTabs.INVENTORY.getTabIndex() && p_handleMouseClick_4_ != ClickType.QUICK_CRAFT) {
            InventoryPlayer inventoryplayer1 = this.mc.player.inventory;
            if (!inventoryplayer1.getItemStack().isEmpty()) {
                if (p_handleMouseClick_3_ == 0) {
                    this.mc.player.dropItem(inventoryplayer1.getItemStack(), true);
                    this.mc.playerController.sendPacketDropItem(inventoryplayer1.getItemStack());
                    inventoryplayer1.setItemStack(ItemStack.EMPTY);
                }
                if (p_handleMouseClick_3_ == 1) {
                    ItemStack itemstack6 = inventoryplayer1.getItemStack().splitStack(1);
                    this.mc.player.dropItem(itemstack6, true);
                    this.mc.playerController.sendPacketDropItem(itemstack6);
                }
            }
        } else if (p_handleMouseClick_1_ == this.destroyItemSlot && flag) {
            for (int j = 0; j < this.mc.player.inventoryContainer.getInventory().size(); ++j) {
                this.mc.playerController.sendSlotPacket(ItemStack.EMPTY, j);
            }
        } else if (selectedTabIndex == CreativeTabs.INVENTORY.getTabIndex()) {
            if (p_handleMouseClick_1_ == this.destroyItemSlot) {
                this.mc.player.inventory.setItemStack(ItemStack.EMPTY);
            } else if (p_handleMouseClick_4_ == ClickType.THROW && p_handleMouseClick_1_ != null && p_handleMouseClick_1_.getHasStack()) {
                ItemStack itemstack = p_handleMouseClick_1_.decrStackSize(p_handleMouseClick_3_ == 0 ? 1 : p_handleMouseClick_1_.getStack().getMaxStackSize());
                ItemStack itemstack1 = p_handleMouseClick_1_.getStack();
                this.mc.player.dropItem(itemstack, true);
                this.mc.playerController.sendPacketDropItem(itemstack);
                this.mc.playerController.sendSlotPacket(itemstack1, ((CreativeSlot)((CreativeSlot)p_handleMouseClick_1_)).slot.slotNumber);
            } else if (p_handleMouseClick_4_ == ClickType.THROW && !this.mc.player.inventory.getItemStack().isEmpty()) {
                this.mc.player.dropItem(this.mc.player.inventory.getItemStack(), true);
                this.mc.playerController.sendPacketDropItem(this.mc.player.inventory.getItemStack());
                this.mc.player.inventory.setItemStack(ItemStack.EMPTY);
            } else {
                this.mc.player.inventoryContainer.slotClick(p_handleMouseClick_1_ == null ? p_handleMouseClick_2_ : ((CreativeSlot)((CreativeSlot)p_handleMouseClick_1_)).slot.slotNumber, p_handleMouseClick_3_, p_handleMouseClick_4_, this.mc.player);
                this.mc.player.inventoryContainer.detectAndSendChanges();
            }
        } else if (p_handleMouseClick_4_ != ClickType.QUICK_CRAFT && p_handleMouseClick_1_.inventory == basicInventory) {
            InventoryPlayer inventoryplayer = this.mc.player.inventory;
            ItemStack itemstack5 = inventoryplayer.getItemStack();
            ItemStack itemstack7 = p_handleMouseClick_1_.getStack();
            if (p_handleMouseClick_4_ == ClickType.SWAP) {
                if (!itemstack7.isEmpty() && p_handleMouseClick_3_ >= 0 && p_handleMouseClick_3_ < 9) {
                    ItemStack itemstack10 = itemstack7.copy();
                    itemstack10.setCount(itemstack10.getMaxStackSize());
                    this.mc.player.inventory.setInventorySlotContents(p_handleMouseClick_3_, itemstack10);
                    this.mc.player.inventoryContainer.detectAndSendChanges();
                }
                return;
            }
            if (p_handleMouseClick_4_ == ClickType.CLONE) {
                if (inventoryplayer.getItemStack().isEmpty() && p_handleMouseClick_1_.getHasStack()) {
                    ItemStack itemstack9 = p_handleMouseClick_1_.getStack().copy();
                    itemstack9.setCount(itemstack9.getMaxStackSize());
                    inventoryplayer.setItemStack(itemstack9);
                }
                return;
            }
            if (p_handleMouseClick_4_ == ClickType.THROW) {
                if (!itemstack7.isEmpty()) {
                    ItemStack itemstack8 = itemstack7.copy();
                    itemstack8.setCount(p_handleMouseClick_3_ == 0 ? 1 : itemstack8.getMaxStackSize());
                    this.mc.player.dropItem(itemstack8, true);
                    this.mc.playerController.sendPacketDropItem(itemstack8);
                }
                return;
            }
            if (!itemstack5.isEmpty() && !itemstack7.isEmpty() && itemstack5.isItemEqual(itemstack7) && ItemStack.areItemStackTagsEqual(itemstack5, itemstack7)) {
                if (p_handleMouseClick_3_ == 0) {
                    if (flag) {
                        itemstack5.setCount(itemstack5.getMaxStackSize());
                    } else if (itemstack5.getCount() < itemstack5.getMaxStackSize()) {
                        itemstack5.grow(1);
                    }
                } else if (itemstack5.getCount() == 1) {
                    inventoryplayer.setItemStack(ItemStack.EMPTY);
                } else {
                    itemstack5.shrink(1);
                }
            } else if (!itemstack7.isEmpty() && itemstack5.isEmpty()) {
                inventoryplayer.setItemStack(itemstack7.copy());
                itemstack5 = inventoryplayer.getItemStack();
                if (flag) {
                    itemstack5.setCount(itemstack5.getMaxStackSize());
                }
            } else {
                inventoryplayer.setItemStack(ItemStack.EMPTY);
            }
        } else if (this.inventorySlots != null) {
            ItemStack itemstack3 = p_handleMouseClick_1_ == null ? ItemStack.EMPTY : this.inventorySlots.getSlot(p_handleMouseClick_1_.slotNumber).getStack();
            this.inventorySlots.slotClick(p_handleMouseClick_1_ == null ? p_handleMouseClick_2_ : p_handleMouseClick_1_.slotNumber, p_handleMouseClick_3_, p_handleMouseClick_4_, this.mc.player);
            if (Container.getDragEvent(p_handleMouseClick_3_) == 2) {
                for (int k = 0; k < 9; ++k) {
                    this.mc.playerController.sendSlotPacket(this.inventorySlots.getSlot(45 + k).getStack(), 36 + k);
                }
            } else if (p_handleMouseClick_1_ != null) {
                ItemStack itemstack4 = this.inventorySlots.getSlot(p_handleMouseClick_1_.slotNumber).getStack();
                this.mc.playerController.sendSlotPacket(itemstack4, p_handleMouseClick_1_.slotNumber - this.inventorySlots.inventorySlots.size() + 9 + 36);
                int i = 45 + p_handleMouseClick_3_;
                if (p_handleMouseClick_4_ == ClickType.SWAP) {
                    this.mc.playerController.sendSlotPacket(itemstack3, i - this.inventorySlots.inventorySlots.size() + 9 + 36);
                } else if (p_handleMouseClick_4_ == ClickType.THROW && itemstack3 != ItemStack.EMPTY) {
                    ItemStack itemstack2 = itemstack3.copy();
                    itemstack2.setCount(p_handleMouseClick_3_ == 0 ? 1 : itemstack2.getMaxStackSize());
                    this.mc.player.dropItem(itemstack2, true);
                    this.mc.playerController.sendPacketDropItem(itemstack2);
                }
            }
        }
    }

    @Override
    protected void updateActivePotionEffects() {
        int i = this.guiLeft;
        super.updateActivePotionEffects();
        if (this.searchField != null && this.guiLeft != i) {
            this.searchField.xPosition = this.guiLeft + 82;
        }
    }

    @Override
    public void initGui() {
        if (this.mc.playerController.isInCreativeMode()) {
            super.initGui();
            this.buttonList.clear();
            Keyboard.enableRepeatEvents((boolean)true);
            this.searchField = new GuiTextField(0, this.fontRendererObj, this.guiLeft + 82, this.guiTop + 6, 89, this.fontRendererObj.FONT_HEIGHT);
            this.searchField.setMaxStringLength(15);
            this.searchField.setEnableBackgroundDrawing(false);
            this.searchField.setVisible(false);
            this.searchField.setTextColor(0xFFFFFF);
            int i = selectedTabIndex;
            selectedTabIndex = -1;
            this.setCurrentCreativeTab(CreativeTabs.CREATIVE_TAB_ARRAY[i]);
            this.listener = new CreativeCrafting(this.mc);
            this.mc.player.inventoryContainer.addListener(this.listener);
            int tabCount = CreativeTabs.CREATIVE_TAB_ARRAY.length;
            if (tabCount > 12) {
                this.buttonList.add(new GuiButton(101, this.guiLeft, this.guiTop - 50, 20, 20, "<"));
                this.buttonList.add(new GuiButton(102, this.guiLeft + this.xSize - 20, this.guiTop - 50, 20, 20, ">"));
                this.maxPages = (tabCount - 12) / 10 + 1;
            }
        } else {
            this.mc.displayGuiScreen(new GuiInventory(this.mc.player));
        }
    }

    @Override
    public void onGuiClosed() {
        super.onGuiClosed();
        if (this.mc.player != null && this.mc.player.inventory != null) {
            this.mc.player.inventoryContainer.removeListener(this.listener);
        }
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void keyTyped(char p_keyTyped_1_, int p_keyTyped_2_) throws IOException {
        if (!CreativeTabs.CREATIVE_TAB_ARRAY[selectedTabIndex].hasSearchBar()) {
            if (GameSettings.isKeyDown(this.mc.gameSettings.keyBindChat)) {
                this.setCurrentCreativeTab(CreativeTabs.SEARCH);
            } else {
                super.keyTyped(p_keyTyped_1_, p_keyTyped_2_);
            }
        } else {
            if (this.clearSearch) {
                this.clearSearch = false;
                this.searchField.setText("");
            }
            if (!this.checkHotbarKeys(p_keyTyped_2_)) {
                if (this.searchField.textboxKeyTyped(p_keyTyped_1_, p_keyTyped_2_)) {
                    this.updateCreativeSearch();
                } else {
                    super.keyTyped(p_keyTyped_1_, p_keyTyped_2_);
                }
            }
        }
    }

    private void updateCreativeSearch() {
        ContainerCreative guicontainercreative$containercreative = (ContainerCreative)this.inventorySlots;
        guicontainercreative$containercreative.itemList.clear();
        CreativeTabs tab = CreativeTabs.CREATIVE_TAB_ARRAY[selectedTabIndex];
        if (tab.hasSearchBar() && tab != CreativeTabs.SEARCH) {
            tab.displayAllRelevantItems(guicontainercreative$containercreative.itemList);
            this.updateFilteredItems(guicontainercreative$containercreative);
            return;
        }
        for (Item item : Item.REGISTRY) {
            if (item == null || item.getCreativeTab() == null) continue;
            item.getSubItems(item, null, guicontainercreative$containercreative.itemList);
        }
        this.updateFilteredItems(guicontainercreative$containercreative);
    }

    private void updateFilteredItems(ContainerCreative p_updateFilteredItems_1_) {
        if (CreativeTabs.CREATIVE_TAB_ARRAY[selectedTabIndex] == CreativeTabs.SEARCH) {
            for (Enchantment enchantment : Enchantment.REGISTRY) {
                if (enchantment == null || enchantment.type == null) continue;
                Items.ENCHANTED_BOOK.getAll(enchantment, p_updateFilteredItems_1_.itemList);
            }
        }
        Iterator iterator = p_updateFilteredItems_1_.itemList.iterator();
        String s1 = this.searchField.getText().toLowerCase(Locale.ROOT);
        while (iterator.hasNext()) {
            ItemStack itemstack = (ItemStack)iterator.next();
            boolean flag = false;
            for (String s : itemstack.getTooltip(this.mc.player, this.mc.gameSettings.advancedItemTooltips)) {
                if (!TextFormatting.getTextWithoutFormattingCodes(s).toLowerCase(Locale.ROOT).contains(s1)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            iterator.remove();
        }
        this.currentScroll = 0.0f;
        p_updateFilteredItems_1_.scrollTo(0.0f);
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int p_drawGuiContainerForegroundLayer_1_, int p_drawGuiContainerForegroundLayer_2_) {
        CreativeTabs creativetabs = CreativeTabs.CREATIVE_TAB_ARRAY[selectedTabIndex];
        if (creativetabs != null && creativetabs.drawInForegroundOfTab()) {
            GlStateManager.disableBlend();
            this.fontRendererObj.drawString(I18n.format(creativetabs.getTranslatedTabLabel(), new Object[0]), 8, 6, 0x404040);
        }
    }

    @Override
    protected void mouseClicked(int p_mouseClicked_1_, int p_mouseClicked_2_, int p_mouseClicked_3_) throws IOException {
        if (p_mouseClicked_3_ == 0) {
            int i = p_mouseClicked_1_ - this.guiLeft;
            int j = p_mouseClicked_2_ - this.guiTop;
            for (CreativeTabs creativetabs : CreativeTabs.CREATIVE_TAB_ARRAY) {
                if (!this.isMouseOverTab(creativetabs, i, j)) continue;
                return;
            }
        }
        super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
    }

    @Override
    protected void mouseReleased(int p_mouseReleased_1_, int p_mouseReleased_2_, int p_mouseReleased_3_) {
        if (p_mouseReleased_3_ == 0) {
            int i = p_mouseReleased_1_ - this.guiLeft;
            int j = p_mouseReleased_2_ - this.guiTop;
            for (CreativeTabs creativetabs : CreativeTabs.CREATIVE_TAB_ARRAY) {
                if (creativetabs == null || !this.isMouseOverTab(creativetabs, i, j)) continue;
                this.setCurrentCreativeTab(creativetabs);
                return;
            }
        }
        super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_2_, p_mouseReleased_3_);
    }

    private boolean needsScrollBars() {
        if (CreativeTabs.CREATIVE_TAB_ARRAY[selectedTabIndex] == null) {
            return false;
        }
        return selectedTabIndex != CreativeTabs.INVENTORY.getTabIndex() && CreativeTabs.CREATIVE_TAB_ARRAY[selectedTabIndex].shouldHidePlayerInventory() && ((ContainerCreative)this.inventorySlots).canScroll();
    }

    private void setCurrentCreativeTab(CreativeTabs p_setCurrentCreativeTab_1_) {
        if (p_setCurrentCreativeTab_1_ == null) {
            return;
        }
        int i = selectedTabIndex;
        selectedTabIndex = p_setCurrentCreativeTab_1_.getTabIndex();
        ContainerCreative guicontainercreative$containercreative = (ContainerCreative)this.inventorySlots;
        this.dragSplittingSlots.clear();
        guicontainercreative$containercreative.itemList.clear();
        p_setCurrentCreativeTab_1_.displayAllRelevantItems(guicontainercreative$containercreative.itemList);
        if (p_setCurrentCreativeTab_1_ == CreativeTabs.INVENTORY) {
            Container container = this.mc.player.inventoryContainer;
            if (this.originalSlots == null) {
                this.originalSlots = guicontainercreative$containercreative.inventorySlots;
            }
            guicontainercreative$containercreative.inventorySlots = Lists.newArrayList();
            for (int j = 0; j < container.inventorySlots.size(); ++j) {
                CreativeSlot slot = new CreativeSlot(container.inventorySlots.get(j), j);
                guicontainercreative$containercreative.inventorySlots.add(slot);
                if (j >= 5 && j < 9) {
                    int j1 = j - 5;
                    int k1 = j1 / 2;
                    int l1 = j1 % 2;
                    slot.xPos = 54 + k1 * 54;
                    slot.yPos = 6 + l1 * 27;
                    continue;
                }
                if (j >= 0 && j < 5) {
                    slot.xPos = -2000;
                    slot.yPos = -2000;
                    continue;
                }
                if (j == 45) {
                    slot.xPos = 35;
                    slot.yPos = 20;
                    continue;
                }
                if (j >= container.inventorySlots.size()) continue;
                int k = j - 9;
                int l = k % 9;
                int i1 = k / 9;
                slot.xPos = 9 + l * 18;
                slot.yPos = j >= 36 ? 112 : 54 + i1 * 18;
            }
            this.destroyItemSlot = new Slot(basicInventory, 0, 173, 112);
            guicontainercreative$containercreative.inventorySlots.add(this.destroyItemSlot);
        } else if (i == CreativeTabs.INVENTORY.getTabIndex()) {
            guicontainercreative$containercreative.inventorySlots = this.originalSlots;
            this.originalSlots = null;
        }
        if (this.searchField != null) {
            if (p_setCurrentCreativeTab_1_.hasSearchBar()) {
                this.searchField.setVisible(true);
                this.searchField.setCanLoseFocus(false);
                this.searchField.setFocused(true);
                this.searchField.setText("");
                this.searchField.width = p_setCurrentCreativeTab_1_.getSearchbarWidth();
                this.searchField.xPosition = this.guiLeft + 171 - this.searchField.width;
                this.updateCreativeSearch();
            } else {
                this.searchField.setVisible(false);
                this.searchField.setCanLoseFocus(true);
                this.searchField.setFocused(false);
            }
        }
        this.currentScroll = 0.0f;
        guicontainercreative$containercreative.scrollTo(0.0f);
    }

    @Override
    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.needsScrollBars()) {
            int j = (((ContainerCreative)this.inventorySlots).itemList.size() + 9 - 1) / 9 - 5;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            this.currentScroll = MathHelper.clamp(this.currentScroll, 0.0f, 1.0f);
            ((ContainerCreative)this.inventorySlots).scrollTo(this.currentScroll);
        }
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        boolean flag = Mouse.isButtonDown((int)0);
        int i = this.guiLeft;
        int j = this.guiTop;
        int k = i + 175;
        int l = j + 18;
        int i1 = k + 14;
        int j1 = l + 112;
        if (!this.wasClicking && flag && p_drawScreen_1_ >= k && p_drawScreen_2_ >= l && p_drawScreen_1_ < i1 && p_drawScreen_2_ < j1) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(p_drawScreen_2_ - l) - 7.5f) / ((float)(j1 - l) - 15.0f);
            this.currentScroll = MathHelper.clamp(this.currentScroll, 0.0f, 1.0f);
            ((ContainerCreative)this.inventorySlots).scrollTo(this.currentScroll);
        }
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
        int start = tabPage * 10;
        int end = Math.min(CreativeTabs.CREATIVE_TAB_ARRAY.length, (tabPage + 1) * 10 + 2);
        if (tabPage != 0) {
            start += 2;
        }
        boolean rendered = false;
        for (CreativeTabs creativetabs : Arrays.copyOfRange(CreativeTabs.CREATIVE_TAB_ARRAY, start, end)) {
            if (creativetabs == null || !this.renderCreativeInventoryHoveringText(creativetabs, p_drawScreen_1_, p_drawScreen_2_)) continue;
            rendered = true;
            break;
        }
        if (!rendered && !this.renderCreativeInventoryHoveringText(CreativeTabs.SEARCH, p_drawScreen_1_, p_drawScreen_2_)) {
            this.renderCreativeInventoryHoveringText(CreativeTabs.INVENTORY, p_drawScreen_1_, p_drawScreen_2_);
        }
        if (this.destroyItemSlot != null && selectedTabIndex == CreativeTabs.INVENTORY.getTabIndex() && this.isPointInRegion(this.destroyItemSlot.xPos, this.destroyItemSlot.yPos, 16, 16, p_drawScreen_1_, p_drawScreen_2_)) {
            this.drawCreativeTabHoveringText(I18n.format("inventory.binSlot", new Object[0]), p_drawScreen_1_, p_drawScreen_2_);
        }
        if (this.maxPages != 0) {
            String page = String.format("%d / %d", tabPage + 1, this.maxPages + 1);
            int width = this.fontRendererObj.getStringWidth(page);
            GlStateManager.disableLighting();
            this.zLevel = 300.0f;
            this.itemRender.zLevel = 300.0f;
            this.fontRendererObj.drawString(page, this.guiLeft + this.xSize / 2 - width / 2, this.guiTop - 44, -1);
            this.zLevel = 0.0f;
            this.itemRender.zLevel = 0.0f;
        }
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.disableLighting();
    }

    @Override
    protected void renderToolTip(ItemStack p_renderToolTip_1_, int p_renderToolTip_2_, int p_renderToolTip_3_) {
        if (selectedTabIndex == CreativeTabs.SEARCH.getTabIndex()) {
            Map<Enchantment, Integer> map;
            List<String> list = p_renderToolTip_1_.getTooltip(this.mc.player, this.mc.gameSettings.advancedItemTooltips);
            CreativeTabs creativetabs = p_renderToolTip_1_.getItem().getCreativeTab();
            if (creativetabs == null && p_renderToolTip_1_.getItem() == Items.ENCHANTED_BOOK && (map = EnchantmentHelper.getEnchantments(p_renderToolTip_1_)).size() == 1) {
                Enchantment enchantment = map.keySet().iterator().next();
                for (CreativeTabs creativetabs1 : CreativeTabs.CREATIVE_TAB_ARRAY) {
                    if (!creativetabs1.hasRelevantEnchantmentType(enchantment.type)) continue;
                    creativetabs = creativetabs1;
                    break;
                }
            }
            if (creativetabs != null) {
                list.add(1, "" + (Object)((Object)TextFormatting.BOLD) + (Object)((Object)TextFormatting.BLUE) + I18n.format(creativetabs.getTranslatedTabLabel(), new Object[0]));
            }
            for (int i = 0; i < list.size(); ++i) {
                if (i == 0) {
                    list.set(i, (Object)((Object)p_renderToolTip_1_.getRarity().rarityColor) + list.get(i));
                    continue;
                }
                list.set(i, (Object)((Object)TextFormatting.GRAY) + list.get(i));
            }
            GuiUtils.preItemToolTip(p_renderToolTip_1_);
            this.drawHoveringText(list, p_renderToolTip_2_, p_renderToolTip_3_);
            GuiUtils.postItemToolTip();
        } else {
            super.renderToolTip(p_renderToolTip_1_, p_renderToolTip_2_, p_renderToolTip_3_);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float p_drawGuiContainerBackgroundLayer_1_, int p_drawGuiContainerBackgroundLayer_2_, int p_drawGuiContainerBackgroundLayer_3_) {
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        RenderHelper.enableGUIStandardItemLighting();
        CreativeTabs creativetabs = CreativeTabs.CREATIVE_TAB_ARRAY[selectedTabIndex];
        int start = tabPage * 10;
        int end = Math.min(CreativeTabs.CREATIVE_TAB_ARRAY.length, (tabPage + 1) * 10 + 2);
        if (tabPage != 0) {
            start += 2;
        }
        for (CreativeTabs creativetabs1 : Arrays.copyOfRange(CreativeTabs.CREATIVE_TAB_ARRAY, start, end)) {
            this.mc.getTextureManager().bindTexture(CREATIVE_INVENTORY_TABS);
            if (creativetabs1 == null || creativetabs1.getTabIndex() == selectedTabIndex) continue;
            this.drawTab(creativetabs1);
        }
        if (tabPage != 0) {
            if (creativetabs != CreativeTabs.SEARCH) {
                this.mc.getTextureManager().bindTexture(CREATIVE_INVENTORY_TABS);
                this.drawTab(CreativeTabs.SEARCH);
            }
            if (creativetabs != CreativeTabs.INVENTORY) {
                this.mc.getTextureManager().bindTexture(CREATIVE_INVENTORY_TABS);
                this.drawTab(CreativeTabs.INVENTORY);
            }
        }
        this.mc.getTextureManager().bindTexture(new ResourceLocation("textures/gui/container/creative_inventory/tab_" + creativetabs.getBackgroundImageName()));
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        this.searchField.drawTextBox();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        int i = this.guiLeft + 175;
        int j = this.guiTop + 18;
        int k = j + 112;
        this.mc.getTextureManager().bindTexture(CREATIVE_INVENTORY_TABS);
        if (creativetabs.shouldHidePlayerInventory()) {
            this.drawTexturedModalRect(i, j + (int)((float)(k - j - 17) * this.currentScroll), 232 + (this.needsScrollBars() ? 0 : 12), 0, 12, 15);
        }
        if ((creativetabs == null || creativetabs.getTabPage() != tabPage) && creativetabs != CreativeTabs.SEARCH && creativetabs != CreativeTabs.INVENTORY) {
            return;
        }
        this.drawTab(creativetabs);
        if (creativetabs == CreativeTabs.INVENTORY) {
            GuiInventory.drawEntityOnScreen(this.guiLeft + 88, this.guiTop + 45, 20, this.guiLeft + 88 - p_drawGuiContainerBackgroundLayer_2_, this.guiTop + 45 - 30 - p_drawGuiContainerBackgroundLayer_3_, this.mc.player);
        }
    }

    protected boolean isMouseOverTab(CreativeTabs p_isMouseOverTab_1_, int p_isMouseOverTab_2_, int p_isMouseOverTab_3_) {
        if (p_isMouseOverTab_1_.getTabPage() != tabPage && p_isMouseOverTab_1_ != CreativeTabs.SEARCH && p_isMouseOverTab_1_ != CreativeTabs.INVENTORY) {
            return false;
        }
        int i = p_isMouseOverTab_1_.getTabColumn();
        int j = 28 * i;
        int k = 0;
        if (i == 5) {
            j = this.xSize - 28 + 2;
        } else if (i > 0) {
            j += i;
        }
        k = p_isMouseOverTab_1_.isTabInFirstRow() ? (k -= 32) : (k += this.ySize);
        return p_isMouseOverTab_2_ >= j && p_isMouseOverTab_2_ <= j + 28 && p_isMouseOverTab_3_ >= k && p_isMouseOverTab_3_ <= k + 32;
    }

    protected boolean renderCreativeInventoryHoveringText(CreativeTabs p_renderCreativeInventoryHoveringText_1_, int p_renderCreativeInventoryHoveringText_2_, int p_renderCreativeInventoryHoveringText_3_) {
        int i = p_renderCreativeInventoryHoveringText_1_.getTabColumn();
        int j = 28 * i;
        int k = 0;
        if (i == 5) {
            j = this.xSize - 28 + 2;
        } else if (i > 0) {
            j += i;
        }
        k = p_renderCreativeInventoryHoveringText_1_.isTabInFirstRow() ? (k -= 32) : (k += this.ySize);
        if (this.isPointInRegion(j + 3, k + 3, 23, 27, p_renderCreativeInventoryHoveringText_2_, p_renderCreativeInventoryHoveringText_3_)) {
            this.drawCreativeTabHoveringText(I18n.format(p_renderCreativeInventoryHoveringText_1_.getTranslatedTabLabel(), new Object[0]), p_renderCreativeInventoryHoveringText_2_, p_renderCreativeInventoryHoveringText_3_);
            return true;
        }
        return false;
    }

    protected void drawTab(CreativeTabs p_drawTab_1_) {
        boolean flag = p_drawTab_1_.getTabIndex() == selectedTabIndex;
        boolean flag1 = p_drawTab_1_.isTabInFirstRow();
        int i = p_drawTab_1_.getTabColumn();
        int j = i * 28;
        int k = 0;
        int l = this.guiLeft + 28 * i;
        int i1 = this.guiTop;
        int j1 = 32;
        if (flag) {
            k += 32;
        }
        if (i == 5) {
            l = this.guiLeft + this.xSize - 28;
        } else if (i > 0) {
            l += i;
        }
        if (flag1) {
            i1 -= 28;
        } else {
            k += 64;
            i1 += this.ySize - 4;
        }
        GlStateManager.disableLighting();
        GlStateManager.color(1.0f, 1.0f, 1.0f);
        GlStateManager.enableBlend();
        this.drawTexturedModalRect(l, i1, j, k, 28, 32);
        this.zLevel = 100.0f;
        this.itemRender.zLevel = 100.0f;
        i1 = i1 + 8 + (flag1 ? 1 : -1);
        GlStateManager.enableLighting();
        GlStateManager.enableRescaleNormal();
        ItemStack itemstack = p_drawTab_1_.getIconItemStack();
        this.itemRender.renderItemAndEffectIntoGUI(itemstack, l += 6, i1);
        this.itemRender.renderItemOverlays(this.fontRendererObj, itemstack, l, i1);
        GlStateManager.disableLighting();
        this.itemRender.zLevel = 0.0f;
        this.zLevel = 0.0f;
    }

    @Override
    protected void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
        if (p_actionPerformed_1_.id == 0) {
            this.mc.displayGuiScreen(new GuiAchievements(this, this.mc.player.getStatFileWriter()));
        }
        if (p_actionPerformed_1_.id == 1) {
            this.mc.displayGuiScreen(new GuiStats(this, this.mc.player.getStatFileWriter()));
        }
        if (p_actionPerformed_1_.id == 101) {
            tabPage = Math.max(tabPage - 1, 0);
        } else if (p_actionPerformed_1_.id == 102) {
            tabPage = Math.min(tabPage + 1, this.maxPages);
        }
    }

    public int getSelectedTabIndex() {
        return selectedTabIndex;
    }

    @SideOnly(value=Side.CLIENT)
    class CreativeSlot
    extends Slot {
        private final Slot slot;

        public CreativeSlot(Slot p_i46313_2_, int p_i46313_3_) {
            super(p_i46313_2_.inventory, p_i46313_3_, 0, 0);
            this.slot = p_i46313_2_;
        }

        @Override
        public ItemStack onTake(EntityPlayer p_onTake_1_, ItemStack p_onTake_2_) {
            this.slot.onTake(p_onTake_1_, p_onTake_2_);
            return p_onTake_2_;
        }

        @Override
        public boolean isItemValid(ItemStack p_isItemValid_1_) {
            return this.slot.isItemValid(p_isItemValid_1_);
        }

        @Override
        public ItemStack getStack() {
            return this.slot.getStack();
        }

        @Override
        public boolean getHasStack() {
            return this.slot.getHasStack();
        }

        @Override
        public void putStack(ItemStack p_putStack_1_) {
            this.slot.putStack(p_putStack_1_);
        }

        @Override
        public void onSlotChanged() {
            this.slot.onSlotChanged();
        }

        @Override
        public int getSlotStackLimit() {
            return this.slot.getSlotStackLimit();
        }

        @Override
        public int getItemStackLimit(ItemStack p_getItemStackLimit_1_) {
            return this.slot.getItemStackLimit(p_getItemStackLimit_1_);
        }

        @Override
        @Nullable
        public String getSlotTexture() {
            return this.slot.getSlotTexture();
        }

        @Override
        public ItemStack decrStackSize(int p_decrStackSize_1_) {
            return this.slot.decrStackSize(p_decrStackSize_1_);
        }

        @Override
        public boolean isHere(IInventory p_isHere_1_, int p_isHere_2_) {
            return this.slot.isHere(p_isHere_1_, p_isHere_2_);
        }

        @Override
        public boolean canBeHovered() {
            return this.slot.canBeHovered();
        }

        @Override
        public boolean canTakeStack(EntityPlayer p_canTakeStack_1_) {
            return this.slot.canTakeStack(p_canTakeStack_1_);
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class ContainerCreative
    extends Container {
        public NonNullList<ItemStack> itemList = NonNullList.create();

        public ContainerCreative(EntityPlayer p_i1086_1_) {
            InventoryPlayer inventoryplayer = p_i1086_1_.inventory;
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.addSlotToContainer(new Slot(basicInventory, i * 9 + j, 9 + j * 18, 18 + i * 18));
                }
            }
            for (int k = 0; k < 9; ++k) {
                this.addSlotToContainer(new Slot(inventoryplayer, k, 9 + k * 18, 112));
            }
            this.scrollTo(0.0f);
        }

        @Override
        public boolean canInteractWith(EntityPlayer p_canInteractWith_1_) {
            return true;
        }

        public void scrollTo(float p_scrollTo_1_) {
            int i = (this.itemList.size() + 9 - 1) / 9 - 5;
            int j = (int)((double)(p_scrollTo_1_ * (float)i) + 0.5);
            if (j < 0) {
                j = 0;
            }
            for (int k = 0; k < 5; ++k) {
                for (int l = 0; l < 9; ++l) {
                    int i1 = l + (k + j) * 9;
                    if (i1 >= 0 && i1 < this.itemList.size()) {
                        basicInventory.setInventorySlotContents(l + k * 9, this.itemList.get(i1));
                        continue;
                    }
                    basicInventory.setInventorySlotContents(l + k * 9, ItemStack.EMPTY);
                }
            }
        }

        public boolean canScroll() {
            return this.itemList.size() > 45;
        }

        @Override
        protected void retrySlotClick(int p_retrySlotClick_1_, int p_retrySlotClick_2_, boolean p_retrySlotClick_3_, EntityPlayer p_retrySlotClick_4_) {
        }

        @Override
        public ItemStack transferStackInSlot(EntityPlayer p_transferStackInSlot_1_, int p_transferStackInSlot_2_) {
            Slot slot;
            if (p_transferStackInSlot_2_ >= this.inventorySlots.size() - 9 && p_transferStackInSlot_2_ < this.inventorySlots.size() && (slot = (Slot)this.inventorySlots.get(p_transferStackInSlot_2_)) != null && slot.getHasStack()) {
                slot.putStack(ItemStack.EMPTY);
            }
            return ItemStack.EMPTY;
        }

        @Override
        public boolean canMergeSlot(ItemStack p_canMergeSlot_1_, Slot p_canMergeSlot_2_) {
            return p_canMergeSlot_2_.yPos > 90;
        }

        @Override
        public boolean canDragIntoSlot(Slot p_canDragIntoSlot_1_) {
            return p_canDragIntoSlot_1_.inventory instanceof InventoryPlayer || p_canDragIntoSlot_1_.yPos > 90 && p_canDragIntoSlot_1_.xPos <= 162;
        }
    }
}

