/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.inventory;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.util.ITabCompleter;
import net.minecraft.util.TabCompleter;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiEditCommandBlockMinecart
extends GuiScreen
implements ITabCompleter {
    private GuiTextField commandField;
    private GuiTextField previousEdit;
    private final CommandBlockBaseLogic commandBlockLogic;
    private GuiButton doneButton;
    private GuiButton cancelButton;
    private GuiButton outputButton;
    private boolean trackOutput;
    private TabCompleter tabCompleter;

    public GuiEditCommandBlockMinecart(CommandBlockBaseLogic p_i46595_1_) {
        this.commandBlockLogic = p_i46595_1_;
    }

    @Override
    public void updateScreen() {
        this.commandField.updateCursorCounter();
    }

    @Override
    public void initGui() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonList.clear();
        this.doneButton = this.addButton(new GuiButton(0, this.width / 2 - 4 - 150, this.height / 4 + 120 + 12, 150, 20, I18n.format("gui.done", new Object[0])));
        this.cancelButton = this.addButton(new GuiButton(1, this.width / 2 + 4, this.height / 4 + 120 + 12, 150, 20, I18n.format("gui.cancel", new Object[0])));
        this.outputButton = this.addButton(new GuiButton(4, this.width / 2 + 150 - 20, 150, 20, 20, "O"));
        this.commandField = new GuiTextField(2, this.fontRendererObj, this.width / 2 - 150, 50, 300, 20);
        this.commandField.setMaxStringLength(32500);
        this.commandField.setFocused(true);
        this.commandField.setText(this.commandBlockLogic.getCommand());
        this.previousEdit = new GuiTextField(3, this.fontRendererObj, this.width / 2 - 150, 150, 276, 20);
        this.previousEdit.setMaxStringLength(32500);
        this.previousEdit.setEnabled(false);
        this.previousEdit.setText("-");
        this.trackOutput = this.commandBlockLogic.shouldTrackOutput();
        this.updateCommandOutput();
        this.doneButton.enabled = !this.commandField.getText().trim().isEmpty();
        this.tabCompleter = new TabCompleter(this.commandField, true){

            @Override
            @Nullable
            public BlockPos getTargetBlockPos() {
                return GuiEditCommandBlockMinecart.this.commandBlockLogic.getPosition();
            }
        };
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
        if (!p_actionPerformed_1_.enabled) {
            return;
        }
        if (p_actionPerformed_1_.id == 1) {
            this.commandBlockLogic.setTrackOutput(this.trackOutput);
            this.mc.displayGuiScreen(null);
        } else if (p_actionPerformed_1_.id == 0) {
            PacketBuffer lvt_2_1_ = new PacketBuffer(Unpooled.buffer());
            lvt_2_1_.writeByte(this.commandBlockLogic.getCommandBlockType());
            this.commandBlockLogic.fillInInfo(lvt_2_1_);
            lvt_2_1_.writeString(this.commandField.getText());
            lvt_2_1_.writeBoolean(this.commandBlockLogic.shouldTrackOutput());
            this.mc.getConnection().sendPacket(new CPacketCustomPayload("MC|AdvCmd", lvt_2_1_));
            if (!this.commandBlockLogic.shouldTrackOutput()) {
                this.commandBlockLogic.setLastOutput(null);
            }
            this.mc.displayGuiScreen(null);
        } else if (p_actionPerformed_1_.id == 4) {
            this.commandBlockLogic.setTrackOutput(!this.commandBlockLogic.shouldTrackOutput());
            this.updateCommandOutput();
        }
    }

    @Override
    protected void keyTyped(char p_keyTyped_1_, int p_keyTyped_2_) throws IOException {
        this.tabCompleter.resetRequested();
        if (p_keyTyped_2_ == 15) {
            this.tabCompleter.complete();
        } else {
            this.tabCompleter.resetDidComplete();
        }
        this.commandField.textboxKeyTyped(p_keyTyped_1_, p_keyTyped_2_);
        this.previousEdit.textboxKeyTyped(p_keyTyped_1_, p_keyTyped_2_);
        boolean bl = this.doneButton.enabled = !this.commandField.getText().trim().isEmpty();
        if (p_keyTyped_2_ == 28 || p_keyTyped_2_ == 156) {
            this.actionPerformed(this.doneButton);
        } else if (p_keyTyped_2_ == 1) {
            this.actionPerformed(this.cancelButton);
        }
    }

    @Override
    protected void mouseClicked(int p_mouseClicked_1_, int p_mouseClicked_2_, int p_mouseClicked_3_) throws IOException {
        super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        this.commandField.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        this.previousEdit.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRendererObj, I18n.format("advMode.setCommand", new Object[0]), this.width / 2, 20, 0xFFFFFF);
        this.drawString(this.fontRendererObj, I18n.format("advMode.command", new Object[0]), this.width / 2 - 150, 37, 0xA0A0A0);
        this.commandField.drawTextBox();
        int lvt_4_1_ = 75;
        int lvt_5_1_ = 0;
        this.drawString(this.fontRendererObj, I18n.format("advMode.nearestPlayer", new Object[0]), this.width / 2 - 150, lvt_4_1_ + lvt_5_1_++ * this.fontRendererObj.FONT_HEIGHT, 0xA0A0A0);
        this.drawString(this.fontRendererObj, I18n.format("advMode.randomPlayer", new Object[0]), this.width / 2 - 150, lvt_4_1_ + lvt_5_1_++ * this.fontRendererObj.FONT_HEIGHT, 0xA0A0A0);
        this.drawString(this.fontRendererObj, I18n.format("advMode.allPlayers", new Object[0]), this.width / 2 - 150, lvt_4_1_ + lvt_5_1_++ * this.fontRendererObj.FONT_HEIGHT, 0xA0A0A0);
        this.drawString(this.fontRendererObj, I18n.format("advMode.allEntities", new Object[0]), this.width / 2 - 150, lvt_4_1_ + lvt_5_1_++ * this.fontRendererObj.FONT_HEIGHT, 0xA0A0A0);
        this.drawString(this.fontRendererObj, "", this.width / 2 - 150, lvt_4_1_ + lvt_5_1_++ * this.fontRendererObj.FONT_HEIGHT, 0xA0A0A0);
        if (!this.previousEdit.getText().isEmpty()) {
            this.drawString(this.fontRendererObj, I18n.format("advMode.previousOutput", new Object[0]), this.width / 2 - 150, lvt_4_1_ += lvt_5_1_ * this.fontRendererObj.FONT_HEIGHT + 16, 0xA0A0A0);
            this.previousEdit.drawTextBox();
        }
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
    }

    private void updateCommandOutput() {
        if (this.commandBlockLogic.shouldTrackOutput()) {
            this.outputButton.displayString = "O";
            if (this.commandBlockLogic.getLastOutput() != null) {
                this.previousEdit.setText(this.commandBlockLogic.getLastOutput().getUnformattedText());
            }
        } else {
            this.outputButton.displayString = "X";
            this.previousEdit.setText("-");
        }
    }

    @Override
    public void setCompletions(String ... p_setCompletions_1_) {
        this.tabCompleter.setCompletions(p_setCompletions_1_);
    }
}

