/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.inventory;

import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.network.play.client.CPacketUpdateSign;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiEditSign
extends GuiScreen {
    private final TileEntitySign tileSign;
    private int updateCounter;
    private int editLine;
    private GuiButton doneBtn;

    public GuiEditSign(TileEntitySign p_i1097_1_) {
        this.tileSign = p_i1097_1_;
    }

    @Override
    public void initGui() {
        this.buttonList.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.doneBtn = this.addButton(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 120, I18n.format("gui.done", new Object[0])));
        this.tileSign.setEditable(false);
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
        NetHandlerPlayClient lvt_1_1_ = this.mc.getConnection();
        if (lvt_1_1_ != null) {
            lvt_1_1_.sendPacket(new CPacketUpdateSign(this.tileSign.getPos(), this.tileSign.signText));
        }
        this.tileSign.setEditable(true);
    }

    @Override
    public void updateScreen() {
        ++this.updateCounter;
    }

    @Override
    protected void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
        if (!p_actionPerformed_1_.enabled) {
            return;
        }
        if (p_actionPerformed_1_.id == 0) {
            this.tileSign.markDirty();
            this.mc.displayGuiScreen(null);
        }
    }

    @Override
    protected void keyTyped(char p_keyTyped_1_, int p_keyTyped_2_) throws IOException {
        if (p_keyTyped_2_ == 200) {
            this.editLine = this.editLine - 1 & 3;
        }
        if (p_keyTyped_2_ == 208 || p_keyTyped_2_ == 28 || p_keyTyped_2_ == 156) {
            this.editLine = this.editLine + 1 & 3;
        }
        String lvt_3_1_ = this.tileSign.signText[this.editLine].getUnformattedText();
        if (p_keyTyped_2_ == 14 && !lvt_3_1_.isEmpty()) {
            lvt_3_1_ = lvt_3_1_.substring(0, lvt_3_1_.length() - 1);
        }
        if (ChatAllowedCharacters.isAllowedCharacter(p_keyTyped_1_) && this.fontRendererObj.getStringWidth(lvt_3_1_ + p_keyTyped_1_) <= 90) {
            lvt_3_1_ = lvt_3_1_ + p_keyTyped_1_;
        }
        this.tileSign.signText[this.editLine] = new TextComponentString(lvt_3_1_);
        if (p_keyTyped_2_ == 1) {
            this.actionPerformed(this.doneBtn);
        }
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRendererObj, I18n.format("sign.edit", new Object[0]), this.width / 2, 40, 0xFFFFFF);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.pushMatrix();
        GlStateManager.translate(this.width / 2, 0.0f, 50.0f);
        float lvt_4_1_ = 93.75f;
        GlStateManager.scale(-93.75f, -93.75f, -93.75f);
        GlStateManager.rotate(180.0f, 0.0f, 1.0f, 0.0f);
        Block lvt_5_1_ = this.tileSign.getBlockType();
        if (lvt_5_1_ == Blocks.STANDING_SIGN) {
            float lvt_6_1_ = (float)(this.tileSign.getBlockMetadata() * 360) / 16.0f;
            GlStateManager.rotate(lvt_6_1_, 0.0f, 1.0f, 0.0f);
            GlStateManager.translate(0.0f, -1.0625f, 0.0f);
        } else {
            int lvt_6_2_ = this.tileSign.getBlockMetadata();
            float lvt_7_1_ = 0.0f;
            if (lvt_6_2_ == 2) {
                lvt_7_1_ = 180.0f;
            }
            if (lvt_6_2_ == 4) {
                lvt_7_1_ = 90.0f;
            }
            if (lvt_6_2_ == 5) {
                lvt_7_1_ = -90.0f;
            }
            GlStateManager.rotate(lvt_7_1_, 0.0f, 1.0f, 0.0f);
            GlStateManager.translate(0.0f, -1.0625f, 0.0f);
        }
        if (this.updateCounter / 6 % 2 == 0) {
            this.tileSign.lineBeingEdited = this.editLine;
        }
        TileEntityRendererDispatcher.instance.renderTileEntityAt(this.tileSign, -0.5, -0.75, -0.5, 0.0f);
        this.tileSign.lineBeingEdited = -1;
        GlStateManager.popMatrix();
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
    }
}

