/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.inventory;

import com.google.common.collect.Lists;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiEditStructure
extends GuiScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int[] LEGAL_KEY_CODES = new int[]{203, 205, 14, 211, 199, 207};
    private final TileEntityStructure tileStructure;
    private Mirror mirror = Mirror.NONE;
    private Rotation rotation = Rotation.NONE;
    private TileEntityStructure.Mode mode = TileEntityStructure.Mode.DATA;
    private boolean ignoreEntities;
    private boolean showAir;
    private boolean showBoundingBox;
    private GuiTextField nameEdit;
    private GuiTextField posXEdit;
    private GuiTextField posYEdit;
    private GuiTextField posZEdit;
    private GuiTextField sizeXEdit;
    private GuiTextField sizeYEdit;
    private GuiTextField sizeZEdit;
    private GuiTextField integrityEdit;
    private GuiTextField seedEdit;
    private GuiTextField dataEdit;
    private GuiButton doneButton;
    private GuiButton cancelButton;
    private GuiButton saveButton;
    private GuiButton loadButton;
    private GuiButton rotateZeroDegreesButton;
    private GuiButton rotateNinetyDegreesButton;
    private GuiButton rotate180DegreesButton;
    private GuiButton rotate270DegressButton;
    private GuiButton modeButton;
    private GuiButton detectSizeButton;
    private GuiButton showEntitiesButton;
    private GuiButton mirrorButton;
    private GuiButton showAirButton;
    private GuiButton showBoundingBoxButton;
    private final List<GuiTextField> tabOrder = Lists.newArrayList();
    private final DecimalFormat decimalFormat = new DecimalFormat("0.0###");

    public GuiEditStructure(TileEntityStructure p_i47142_1_) {
        this.tileStructure = p_i47142_1_;
        this.decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
    }

    @Override
    public void updateScreen() {
        this.nameEdit.updateCursorCounter();
        this.posXEdit.updateCursorCounter();
        this.posYEdit.updateCursorCounter();
        this.posZEdit.updateCursorCounter();
        this.sizeXEdit.updateCursorCounter();
        this.sizeYEdit.updateCursorCounter();
        this.sizeZEdit.updateCursorCounter();
        this.integrityEdit.updateCursorCounter();
        this.seedEdit.updateCursorCounter();
        this.dataEdit.updateCursorCounter();
    }

    @Override
    public void initGui() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonList.clear();
        this.doneButton = this.addButton(new GuiButton(0, this.width / 2 - 4 - 150, 210, 150, 20, I18n.format("gui.done", new Object[0])));
        this.cancelButton = this.addButton(new GuiButton(1, this.width / 2 + 4, 210, 150, 20, I18n.format("gui.cancel", new Object[0])));
        this.saveButton = this.addButton(new GuiButton(9, this.width / 2 + 4 + 100, 185, 50, 20, I18n.format("structure_block.button.save", new Object[0])));
        this.loadButton = this.addButton(new GuiButton(10, this.width / 2 + 4 + 100, 185, 50, 20, I18n.format("structure_block.button.load", new Object[0])));
        this.modeButton = this.addButton(new GuiButton(18, this.width / 2 - 4 - 150, 185, 50, 20, "MODE"));
        this.detectSizeButton = this.addButton(new GuiButton(19, this.width / 2 + 4 + 100, 120, 50, 20, I18n.format("structure_block.button.detect_size", new Object[0])));
        this.showEntitiesButton = this.addButton(new GuiButton(20, this.width / 2 + 4 + 100, 160, 50, 20, "ENTITIES"));
        this.mirrorButton = this.addButton(new GuiButton(21, this.width / 2 - 20, 185, 40, 20, "MIRROR"));
        this.showAirButton = this.addButton(new GuiButton(22, this.width / 2 + 4 + 100, 80, 50, 20, "SHOWAIR"));
        this.showBoundingBoxButton = this.addButton(new GuiButton(23, this.width / 2 + 4 + 100, 80, 50, 20, "SHOWBB"));
        this.rotateZeroDegreesButton = this.addButton(new GuiButton(11, this.width / 2 - 1 - 40 - 1 - 40 - 20, 185, 40, 20, "0"));
        this.rotateNinetyDegreesButton = this.addButton(new GuiButton(12, this.width / 2 - 1 - 40 - 20, 185, 40, 20, "90"));
        this.rotate180DegreesButton = this.addButton(new GuiButton(13, this.width / 2 + 1 + 20, 185, 40, 20, "180"));
        this.rotate270DegressButton = this.addButton(new GuiButton(14, this.width / 2 + 1 + 40 + 1 + 20, 185, 40, 20, "270"));
        this.nameEdit = new GuiTextField(2, this.fontRendererObj, this.width / 2 - 152, 40, 300, 20);
        this.nameEdit.setMaxStringLength(64);
        this.nameEdit.setText(this.tileStructure.getName());
        this.tabOrder.add(this.nameEdit);
        BlockPos lvt_1_1_ = this.tileStructure.getPosition();
        this.posXEdit = new GuiTextField(3, this.fontRendererObj, this.width / 2 - 152, 80, 80, 20);
        this.posXEdit.setMaxStringLength(15);
        this.posXEdit.setText(Integer.toString(lvt_1_1_.getX()));
        this.tabOrder.add(this.posXEdit);
        this.posYEdit = new GuiTextField(4, this.fontRendererObj, this.width / 2 - 72, 80, 80, 20);
        this.posYEdit.setMaxStringLength(15);
        this.posYEdit.setText(Integer.toString(lvt_1_1_.getY()));
        this.tabOrder.add(this.posYEdit);
        this.posZEdit = new GuiTextField(5, this.fontRendererObj, this.width / 2 + 8, 80, 80, 20);
        this.posZEdit.setMaxStringLength(15);
        this.posZEdit.setText(Integer.toString(lvt_1_1_.getZ()));
        this.tabOrder.add(this.posZEdit);
        BlockPos lvt_2_1_ = this.tileStructure.getStructureSize();
        this.sizeXEdit = new GuiTextField(6, this.fontRendererObj, this.width / 2 - 152, 120, 80, 20);
        this.sizeXEdit.setMaxStringLength(15);
        this.sizeXEdit.setText(Integer.toString(lvt_2_1_.getX()));
        this.tabOrder.add(this.sizeXEdit);
        this.sizeYEdit = new GuiTextField(7, this.fontRendererObj, this.width / 2 - 72, 120, 80, 20);
        this.sizeYEdit.setMaxStringLength(15);
        this.sizeYEdit.setText(Integer.toString(lvt_2_1_.getY()));
        this.tabOrder.add(this.sizeYEdit);
        this.sizeZEdit = new GuiTextField(8, this.fontRendererObj, this.width / 2 + 8, 120, 80, 20);
        this.sizeZEdit.setMaxStringLength(15);
        this.sizeZEdit.setText(Integer.toString(lvt_2_1_.getZ()));
        this.tabOrder.add(this.sizeZEdit);
        this.integrityEdit = new GuiTextField(15, this.fontRendererObj, this.width / 2 - 152, 120, 80, 20);
        this.integrityEdit.setMaxStringLength(15);
        this.integrityEdit.setText(this.decimalFormat.format(this.tileStructure.getIntegrity()));
        this.tabOrder.add(this.integrityEdit);
        this.seedEdit = new GuiTextField(16, this.fontRendererObj, this.width / 2 - 72, 120, 80, 20);
        this.seedEdit.setMaxStringLength(31);
        this.seedEdit.setText(Long.toString(this.tileStructure.getSeed()));
        this.tabOrder.add(this.seedEdit);
        this.dataEdit = new GuiTextField(17, this.fontRendererObj, this.width / 2 - 152, 120, 240, 20);
        this.dataEdit.setMaxStringLength(128);
        this.dataEdit.setText(this.tileStructure.getMetadata());
        this.tabOrder.add(this.dataEdit);
        this.mirror = this.tileStructure.getMirror();
        this.updateMirrorButton();
        this.rotation = this.tileStructure.getRotation();
        this.updateDirectionButtons();
        this.mode = this.tileStructure.getMode();
        this.updateMode();
        this.ignoreEntities = this.tileStructure.ignoresEntities();
        this.updateEntitiesButton();
        this.showAir = this.tileStructure.showsAir();
        this.updateToggleAirButton();
        this.showBoundingBox = this.tileStructure.showsBoundingBox();
        this.updateToggleBoundingBox();
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void actionPerformed(GuiButton p_actionPerformed_1_) throws IOException {
        if (!p_actionPerformed_1_.enabled) {
            return;
        }
        if (p_actionPerformed_1_.id == 1) {
            this.tileStructure.setMirror(this.mirror);
            this.tileStructure.setRotation(this.rotation);
            this.tileStructure.setMode(this.mode);
            this.tileStructure.setIgnoresEntities(this.ignoreEntities);
            this.tileStructure.setShowAir(this.showAir);
            this.tileStructure.setShowBoundingBox(this.showBoundingBox);
            this.mc.displayGuiScreen(null);
        } else if (p_actionPerformed_1_.id == 0) {
            if (this.sendToServer(1)) {
                this.mc.displayGuiScreen(null);
            }
        } else if (p_actionPerformed_1_.id == 9) {
            if (this.tileStructure.getMode() == TileEntityStructure.Mode.SAVE) {
                this.sendToServer(2);
                this.mc.displayGuiScreen(null);
            }
        } else if (p_actionPerformed_1_.id == 10) {
            if (this.tileStructure.getMode() == TileEntityStructure.Mode.LOAD) {
                this.sendToServer(3);
                this.mc.displayGuiScreen(null);
            }
        } else if (p_actionPerformed_1_.id == 11) {
            this.tileStructure.setRotation(Rotation.NONE);
            this.updateDirectionButtons();
        } else if (p_actionPerformed_1_.id == 12) {
            this.tileStructure.setRotation(Rotation.CLOCKWISE_90);
            this.updateDirectionButtons();
        } else if (p_actionPerformed_1_.id == 13) {
            this.tileStructure.setRotation(Rotation.CLOCKWISE_180);
            this.updateDirectionButtons();
        } else if (p_actionPerformed_1_.id == 14) {
            this.tileStructure.setRotation(Rotation.COUNTERCLOCKWISE_90);
            this.updateDirectionButtons();
        } else if (p_actionPerformed_1_.id == 18) {
            this.tileStructure.nextMode();
            this.updateMode();
        } else if (p_actionPerformed_1_.id == 19) {
            if (this.tileStructure.getMode() == TileEntityStructure.Mode.SAVE) {
                this.sendToServer(4);
                this.mc.displayGuiScreen(null);
            }
        } else if (p_actionPerformed_1_.id == 20) {
            this.tileStructure.setIgnoresEntities(!this.tileStructure.ignoresEntities());
            this.updateEntitiesButton();
        } else if (p_actionPerformed_1_.id == 22) {
            this.tileStructure.setShowAir(!this.tileStructure.showsAir());
            this.updateToggleAirButton();
        } else if (p_actionPerformed_1_.id == 23) {
            this.tileStructure.setShowBoundingBox(!this.tileStructure.showsBoundingBox());
            this.updateToggleBoundingBox();
        } else if (p_actionPerformed_1_.id == 21) {
            switch (this.tileStructure.getMirror()) {
                case NONE: {
                    this.tileStructure.setMirror(Mirror.LEFT_RIGHT);
                    break;
                }
                case LEFT_RIGHT: {
                    this.tileStructure.setMirror(Mirror.FRONT_BACK);
                    break;
                }
                case FRONT_BACK: {
                    this.tileStructure.setMirror(Mirror.NONE);
                }
            }
            this.updateMirrorButton();
        }
    }

    private void updateEntitiesButton() {
        boolean lvt_1_1_ = !this.tileStructure.ignoresEntities();
        this.showEntitiesButton.displayString = lvt_1_1_ ? I18n.format("options.on", new Object[0]) : I18n.format("options.off", new Object[0]);
    }

    private void updateToggleAirButton() {
        boolean lvt_1_1_ = this.tileStructure.showsAir();
        this.showAirButton.displayString = lvt_1_1_ ? I18n.format("options.on", new Object[0]) : I18n.format("options.off", new Object[0]);
    }

    private void updateToggleBoundingBox() {
        boolean lvt_1_1_ = this.tileStructure.showsBoundingBox();
        this.showBoundingBoxButton.displayString = lvt_1_1_ ? I18n.format("options.on", new Object[0]) : I18n.format("options.off", new Object[0]);
    }

    private void updateMirrorButton() {
        Mirror lvt_1_1_ = this.tileStructure.getMirror();
        switch (lvt_1_1_) {
            case NONE: {
                this.mirrorButton.displayString = "|";
                break;
            }
            case LEFT_RIGHT: {
                this.mirrorButton.displayString = "< >";
                break;
            }
            case FRONT_BACK: {
                this.mirrorButton.displayString = "^ v";
            }
        }
    }

    private void updateDirectionButtons() {
        this.rotateZeroDegreesButton.enabled = true;
        this.rotateNinetyDegreesButton.enabled = true;
        this.rotate180DegreesButton.enabled = true;
        this.rotate270DegressButton.enabled = true;
        switch (this.tileStructure.getRotation()) {
            case NONE: {
                this.rotateZeroDegreesButton.enabled = false;
                break;
            }
            case CLOCKWISE_180: {
                this.rotate180DegreesButton.enabled = false;
                break;
            }
            case COUNTERCLOCKWISE_90: {
                this.rotate270DegressButton.enabled = false;
                break;
            }
            case CLOCKWISE_90: {
                this.rotateNinetyDegreesButton.enabled = false;
            }
        }
    }

    private void updateMode() {
        this.nameEdit.setFocused(false);
        this.posXEdit.setFocused(false);
        this.posYEdit.setFocused(false);
        this.posZEdit.setFocused(false);
        this.sizeXEdit.setFocused(false);
        this.sizeYEdit.setFocused(false);
        this.sizeZEdit.setFocused(false);
        this.integrityEdit.setFocused(false);
        this.seedEdit.setFocused(false);
        this.dataEdit.setFocused(false);
        this.nameEdit.setVisible(false);
        this.nameEdit.setFocused(false);
        this.posXEdit.setVisible(false);
        this.posYEdit.setVisible(false);
        this.posZEdit.setVisible(false);
        this.sizeXEdit.setVisible(false);
        this.sizeYEdit.setVisible(false);
        this.sizeZEdit.setVisible(false);
        this.integrityEdit.setVisible(false);
        this.seedEdit.setVisible(false);
        this.dataEdit.setVisible(false);
        this.saveButton.visible = false;
        this.loadButton.visible = false;
        this.detectSizeButton.visible = false;
        this.showEntitiesButton.visible = false;
        this.mirrorButton.visible = false;
        this.rotateZeroDegreesButton.visible = false;
        this.rotateNinetyDegreesButton.visible = false;
        this.rotate180DegreesButton.visible = false;
        this.rotate270DegressButton.visible = false;
        this.showAirButton.visible = false;
        this.showBoundingBoxButton.visible = false;
        switch (this.tileStructure.getMode()) {
            case SAVE: {
                this.nameEdit.setVisible(true);
                this.nameEdit.setFocused(true);
                this.posXEdit.setVisible(true);
                this.posYEdit.setVisible(true);
                this.posZEdit.setVisible(true);
                this.sizeXEdit.setVisible(true);
                this.sizeYEdit.setVisible(true);
                this.sizeZEdit.setVisible(true);
                this.saveButton.visible = true;
                this.detectSizeButton.visible = true;
                this.showEntitiesButton.visible = true;
                this.showAirButton.visible = true;
                break;
            }
            case LOAD: {
                this.nameEdit.setVisible(true);
                this.nameEdit.setFocused(true);
                this.posXEdit.setVisible(true);
                this.posYEdit.setVisible(true);
                this.posZEdit.setVisible(true);
                this.integrityEdit.setVisible(true);
                this.seedEdit.setVisible(true);
                this.loadButton.visible = true;
                this.showEntitiesButton.visible = true;
                this.mirrorButton.visible = true;
                this.rotateZeroDegreesButton.visible = true;
                this.rotateNinetyDegreesButton.visible = true;
                this.rotate180DegreesButton.visible = true;
                this.rotate270DegressButton.visible = true;
                this.showBoundingBoxButton.visible = true;
                this.updateDirectionButtons();
                break;
            }
            case CORNER: {
                this.nameEdit.setVisible(true);
                this.nameEdit.setFocused(true);
                break;
            }
            case DATA: {
                this.dataEdit.setVisible(true);
                this.dataEdit.setFocused(true);
            }
        }
        this.modeButton.displayString = I18n.format("structure_block.mode." + this.tileStructure.getMode().getName(), new Object[0]);
    }

    private boolean sendToServer(int p_sendToServer_1_) {
        try {
            PacketBuffer lvt_2_1_ = new PacketBuffer(Unpooled.buffer());
            this.tileStructure.writeCoordinates(lvt_2_1_);
            lvt_2_1_.writeByte(p_sendToServer_1_);
            lvt_2_1_.writeString(this.tileStructure.getMode().toString());
            lvt_2_1_.writeString(this.nameEdit.getText());
            lvt_2_1_.writeInt(this.parseCoordinate(this.posXEdit.getText()));
            lvt_2_1_.writeInt(this.parseCoordinate(this.posYEdit.getText()));
            lvt_2_1_.writeInt(this.parseCoordinate(this.posZEdit.getText()));
            lvt_2_1_.writeInt(this.parseCoordinate(this.sizeXEdit.getText()));
            lvt_2_1_.writeInt(this.parseCoordinate(this.sizeYEdit.getText()));
            lvt_2_1_.writeInt(this.parseCoordinate(this.sizeZEdit.getText()));
            lvt_2_1_.writeString(this.tileStructure.getMirror().toString());
            lvt_2_1_.writeString(this.tileStructure.getRotation().toString());
            lvt_2_1_.writeString(this.dataEdit.getText());
            lvt_2_1_.writeBoolean(this.tileStructure.ignoresEntities());
            lvt_2_1_.writeBoolean(this.tileStructure.showsAir());
            lvt_2_1_.writeBoolean(this.tileStructure.showsBoundingBox());
            lvt_2_1_.writeFloat(this.parseIntegrity(this.integrityEdit.getText()));
            lvt_2_1_.writeVarLong(this.parseSeed(this.seedEdit.getText()));
            this.mc.getConnection().sendPacket(new CPacketCustomPayload("MC|Struct", lvt_2_1_));
            return true;
        }
        catch (Exception lvt_2_2_) {
            LOGGER.warn("Could not send structure block info", (Throwable)lvt_2_2_);
            return false;
        }
    }

    private long parseSeed(String p_parseSeed_1_) {
        try {
            return Long.valueOf(p_parseSeed_1_);
        }
        catch (NumberFormatException lvt_2_1_) {
            return 0L;
        }
    }

    private float parseIntegrity(String p_parseIntegrity_1_) {
        try {
            return Float.valueOf(p_parseIntegrity_1_).floatValue();
        }
        catch (NumberFormatException lvt_2_1_) {
            return 1.0f;
        }
    }

    private int parseCoordinate(String p_parseCoordinate_1_) {
        try {
            return Integer.parseInt(p_parseCoordinate_1_);
        }
        catch (NumberFormatException lvt_2_1_) {
            return 0;
        }
    }

    @Override
    protected void keyTyped(char p_keyTyped_1_, int p_keyTyped_2_) throws IOException {
        if (this.nameEdit.getVisible() && GuiEditStructure.isValidCharacterForName(p_keyTyped_1_, p_keyTyped_2_)) {
            this.nameEdit.textboxKeyTyped(p_keyTyped_1_, p_keyTyped_2_);
        }
        if (this.posXEdit.getVisible()) {
            this.posXEdit.textboxKeyTyped(p_keyTyped_1_, p_keyTyped_2_);
        }
        if (this.posYEdit.getVisible()) {
            this.posYEdit.textboxKeyTyped(p_keyTyped_1_, p_keyTyped_2_);
        }
        if (this.posZEdit.getVisible()) {
            this.posZEdit.textboxKeyTyped(p_keyTyped_1_, p_keyTyped_2_);
        }
        if (this.sizeXEdit.getVisible()) {
            this.sizeXEdit.textboxKeyTyped(p_keyTyped_1_, p_keyTyped_2_);
        }
        if (this.sizeYEdit.getVisible()) {
            this.sizeYEdit.textboxKeyTyped(p_keyTyped_1_, p_keyTyped_2_);
        }
        if (this.sizeZEdit.getVisible()) {
            this.sizeZEdit.textboxKeyTyped(p_keyTyped_1_, p_keyTyped_2_);
        }
        if (this.integrityEdit.getVisible()) {
            this.integrityEdit.textboxKeyTyped(p_keyTyped_1_, p_keyTyped_2_);
        }
        if (this.seedEdit.getVisible()) {
            this.seedEdit.textboxKeyTyped(p_keyTyped_1_, p_keyTyped_2_);
        }
        if (this.dataEdit.getVisible()) {
            this.dataEdit.textboxKeyTyped(p_keyTyped_1_, p_keyTyped_2_);
        }
        if (p_keyTyped_2_ == 15) {
            GuiTextField lvt_3_1_ = null;
            GuiTextField lvt_4_1_ = null;
            for (GuiTextField lvt_6_1_ : this.tabOrder) {
                if (lvt_3_1_ != null && lvt_6_1_.getVisible()) {
                    lvt_4_1_ = lvt_6_1_;
                    break;
                }
                if (!lvt_6_1_.isFocused() || !lvt_6_1_.getVisible()) continue;
                lvt_3_1_ = lvt_6_1_;
            }
            if (lvt_3_1_ != null && lvt_4_1_ == null) {
                for (GuiTextField lvt_6_2_ : this.tabOrder) {
                    if (!lvt_6_2_.getVisible() || lvt_6_2_ == lvt_3_1_) continue;
                    lvt_4_1_ = lvt_6_2_;
                    break;
                }
            }
            if (lvt_4_1_ != null && lvt_4_1_ != lvt_3_1_) {
                lvt_3_1_.setFocused(false);
                lvt_4_1_.setFocused(true);
            }
        }
        if (p_keyTyped_2_ == 28 || p_keyTyped_2_ == 156) {
            this.actionPerformed(this.doneButton);
        } else if (p_keyTyped_2_ == 1) {
            this.actionPerformed(this.cancelButton);
        }
    }

    private static boolean isValidCharacterForName(char p_isValidCharacterForName_0_, int p_isValidCharacterForName_1_) {
        boolean lvt_2_1_ = true;
        for (int lvt_6_1_ : LEGAL_KEY_CODES) {
            if (lvt_6_1_ != p_isValidCharacterForName_1_) continue;
            return true;
        }
        for (char lvt_6_2_ : ChatAllowedCharacters.ILLEGAL_STRUCTURE_CHARACTERS) {
            if (lvt_6_2_ != p_isValidCharacterForName_0_) continue;
            lvt_2_1_ = false;
            break;
        }
        return lvt_2_1_;
    }

    @Override
    protected void mouseClicked(int p_mouseClicked_1_, int p_mouseClicked_2_, int p_mouseClicked_3_) throws IOException {
        super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        if (this.nameEdit.getVisible()) {
            this.nameEdit.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        }
        if (this.posXEdit.getVisible()) {
            this.posXEdit.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        }
        if (this.posYEdit.getVisible()) {
            this.posYEdit.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        }
        if (this.posZEdit.getVisible()) {
            this.posZEdit.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        }
        if (this.sizeXEdit.getVisible()) {
            this.sizeXEdit.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        }
        if (this.sizeYEdit.getVisible()) {
            this.sizeYEdit.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        }
        if (this.sizeZEdit.getVisible()) {
            this.sizeZEdit.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        }
        if (this.integrityEdit.getVisible()) {
            this.integrityEdit.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        }
        if (this.seedEdit.getVisible()) {
            this.seedEdit.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        }
        if (this.dataEdit.getVisible()) {
            this.dataEdit.mouseClicked(p_mouseClicked_1_, p_mouseClicked_2_, p_mouseClicked_3_);
        }
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        this.drawDefaultBackground();
        TileEntityStructure.Mode lvt_4_1_ = this.tileStructure.getMode();
        this.drawCenteredString(this.fontRendererObj, I18n.format("tile.structureBlock.name", new Object[0]), this.width / 2, 10, 0xFFFFFF);
        if (lvt_4_1_ != TileEntityStructure.Mode.DATA) {
            this.drawString(this.fontRendererObj, I18n.format("structure_block.structure_name", new Object[0]), this.width / 2 - 153, 30, 0xA0A0A0);
            this.nameEdit.drawTextBox();
        }
        if (lvt_4_1_ == TileEntityStructure.Mode.LOAD || lvt_4_1_ == TileEntityStructure.Mode.SAVE) {
            this.drawString(this.fontRendererObj, I18n.format("structure_block.position", new Object[0]), this.width / 2 - 153, 70, 0xA0A0A0);
            this.posXEdit.drawTextBox();
            this.posYEdit.drawTextBox();
            this.posZEdit.drawTextBox();
            String lvt_5_1_ = I18n.format("structure_block.include_entities", new Object[0]);
            int lvt_6_1_ = this.fontRendererObj.getStringWidth(lvt_5_1_);
            this.drawString(this.fontRendererObj, lvt_5_1_, this.width / 2 + 154 - lvt_6_1_, 150, 0xA0A0A0);
        }
        if (lvt_4_1_ == TileEntityStructure.Mode.SAVE) {
            this.drawString(this.fontRendererObj, I18n.format("structure_block.size", new Object[0]), this.width / 2 - 153, 110, 0xA0A0A0);
            this.sizeXEdit.drawTextBox();
            this.sizeYEdit.drawTextBox();
            this.sizeZEdit.drawTextBox();
            String lvt_5_2_ = I18n.format("structure_block.detect_size", new Object[0]);
            int lvt_6_2_ = this.fontRendererObj.getStringWidth(lvt_5_2_);
            this.drawString(this.fontRendererObj, lvt_5_2_, this.width / 2 + 154 - lvt_6_2_, 110, 0xA0A0A0);
            String lvt_7_1_ = I18n.format("structure_block.show_air", new Object[0]);
            int lvt_8_1_ = this.fontRendererObj.getStringWidth(lvt_7_1_);
            this.drawString(this.fontRendererObj, lvt_7_1_, this.width / 2 + 154 - lvt_8_1_, 70, 0xA0A0A0);
        }
        if (lvt_4_1_ == TileEntityStructure.Mode.LOAD) {
            this.drawString(this.fontRendererObj, I18n.format("structure_block.integrity", new Object[0]), this.width / 2 - 153, 110, 0xA0A0A0);
            this.integrityEdit.drawTextBox();
            this.seedEdit.drawTextBox();
            String lvt_5_3_ = I18n.format("structure_block.show_boundingbox", new Object[0]);
            int lvt_6_3_ = this.fontRendererObj.getStringWidth(lvt_5_3_);
            this.drawString(this.fontRendererObj, lvt_5_3_, this.width / 2 + 154 - lvt_6_3_, 70, 0xA0A0A0);
        }
        if (lvt_4_1_ == TileEntityStructure.Mode.DATA) {
            this.drawString(this.fontRendererObj, I18n.format("structure_block.custom_data", new Object[0]), this.width / 2 - 153, 110, 0xA0A0A0);
            this.dataEdit.drawTextBox();
        }
        String lvt_5_4_ = "structure_block.mode_info." + lvt_4_1_.getName();
        this.drawString(this.fontRendererObj, I18n.format(lvt_5_4_, new Object[0]), this.width / 2 - 153, 174, 0xA0A0A0);
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
    }

    @Override
    public boolean doesGuiPauseGame() {
        return false;
    }
}

