/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.inventory;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiFurnace
extends GuiContainer {
    private static final ResourceLocation FURNACE_GUI_TEXTURES = new ResourceLocation("textures/gui/container/furnace.png");
    private final InventoryPlayer playerInventory;
    private final IInventory tileFurnace;

    public GuiFurnace(InventoryPlayer p_i45501_1_, IInventory p_i45501_2_) {
        super(new ContainerFurnace(p_i45501_1_, p_i45501_2_));
        this.playerInventory = p_i45501_1_;
        this.tileFurnace = p_i45501_2_;
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int p_drawGuiContainerForegroundLayer_1_, int p_drawGuiContainerForegroundLayer_2_) {
        String lvt_3_1_ = this.tileFurnace.getDisplayName().getUnformattedText();
        this.fontRendererObj.drawString(lvt_3_1_, this.xSize / 2 - this.fontRendererObj.getStringWidth(lvt_3_1_) / 2, 6, 0x404040);
        this.fontRendererObj.drawString(this.playerInventory.getDisplayName().getUnformattedText(), 8, this.ySize - 96 + 2, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float p_drawGuiContainerBackgroundLayer_1_, int p_drawGuiContainerBackgroundLayer_2_, int p_drawGuiContainerBackgroundLayer_3_) {
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.getTextureManager().bindTexture(FURNACE_GUI_TEXTURES);
        int lvt_4_1_ = (this.width - this.xSize) / 2;
        int lvt_5_1_ = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(lvt_4_1_, lvt_5_1_, 0, 0, this.xSize, this.ySize);
        if (TileEntityFurnace.isBurning(this.tileFurnace)) {
            int lvt_6_1_ = this.getBurnLeftScaled(13);
            this.drawTexturedModalRect(lvt_4_1_ + 56, lvt_5_1_ + 36 + 12 - lvt_6_1_, 176, 12 - lvt_6_1_, 14, lvt_6_1_ + 1);
        }
        int lvt_6_2_ = this.getCookProgressScaled(24);
        this.drawTexturedModalRect(lvt_4_1_ + 79, lvt_5_1_ + 34, 176, 14, lvt_6_2_ + 1, 16);
    }

    private int getCookProgressScaled(int p_getCookProgressScaled_1_) {
        int lvt_2_1_ = this.tileFurnace.getField(2);
        int lvt_3_1_ = this.tileFurnace.getField(3);
        if (lvt_3_1_ == 0 || lvt_2_1_ == 0) {
            return 0;
        }
        return lvt_2_1_ * p_getCookProgressScaled_1_ / lvt_3_1_;
    }

    private int getBurnLeftScaled(int p_getBurnLeftScaled_1_) {
        int lvt_2_1_ = this.tileFurnace.getField(1);
        if (lvt_2_1_ == 0) {
            lvt_2_1_ = 200;
        }
        return this.tileFurnace.getField(0) * p_getBurnLeftScaled_1_ / lvt_2_1_;
    }
}

