/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.inventory;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.passive.AbstractChestHorse;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.inventory.ContainerHorseInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiScreenHorseInventory
extends GuiContainer {
    private static final ResourceLocation HORSE_GUI_TEXTURES = new ResourceLocation("textures/gui/container/horse.png");
    private final IInventory playerInventory;
    private final IInventory horseInventory;
    private final AbstractHorse horseEntity;
    private float mousePosx;
    private float mousePosY;

    public GuiScreenHorseInventory(IInventory p_i1093_1_, IInventory p_i1093_2_, AbstractHorse p_i1093_3_) {
        super(new ContainerHorseInventory(p_i1093_1_, p_i1093_2_, p_i1093_3_, Minecraft.getMinecraft().player));
        this.playerInventory = p_i1093_1_;
        this.horseInventory = p_i1093_2_;
        this.horseEntity = p_i1093_3_;
        this.allowUserInput = false;
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int p_drawGuiContainerForegroundLayer_1_, int p_drawGuiContainerForegroundLayer_2_) {
        this.fontRendererObj.drawString(this.horseInventory.getDisplayName().getUnformattedText(), 8, 6, 0x404040);
        this.fontRendererObj.drawString(this.playerInventory.getDisplayName().getUnformattedText(), 8, this.ySize - 96 + 2, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float p_drawGuiContainerBackgroundLayer_1_, int p_drawGuiContainerBackgroundLayer_2_, int p_drawGuiContainerBackgroundLayer_3_) {
        AbstractChestHorse lvt_6_1_;
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.getTextureManager().bindTexture(HORSE_GUI_TEXTURES);
        int lvt_4_1_ = (this.width - this.xSize) / 2;
        int lvt_5_1_ = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(lvt_4_1_, lvt_5_1_, 0, 0, this.xSize, this.ySize);
        if (this.horseEntity instanceof AbstractChestHorse && (lvt_6_1_ = (AbstractChestHorse)this.horseEntity).hasChest()) {
            this.drawTexturedModalRect(lvt_4_1_ + 79, lvt_5_1_ + 17, 0, this.ySize, lvt_6_1_.getInventoryColumns() * 18, 54);
        }
        if (this.horseEntity.canBeSaddled()) {
            this.drawTexturedModalRect(lvt_4_1_ + 7, lvt_5_1_ + 35 - 18, 18, this.ySize + 54, 18, 18);
        }
        if (this.horseEntity.wearsArmor()) {
            if (this.horseEntity instanceof EntityLlama) {
                this.drawTexturedModalRect(lvt_4_1_ + 7, lvt_5_1_ + 35, 36, this.ySize + 54, 18, 18);
            } else {
                this.drawTexturedModalRect(lvt_4_1_ + 7, lvt_5_1_ + 35, 0, this.ySize + 54, 18, 18);
            }
        }
        GuiInventory.drawEntityOnScreen(lvt_4_1_ + 51, lvt_5_1_ + 60, 17, (float)(lvt_4_1_ + 51) - this.mousePosx, (float)(lvt_5_1_ + 75 - 50) - this.mousePosY, this.horseEntity);
    }

    @Override
    public void drawScreen(int p_drawScreen_1_, int p_drawScreen_2_, float p_drawScreen_3_) {
        this.mousePosx = p_drawScreen_1_;
        this.mousePosY = p_drawScreen_2_;
        super.drawScreen(p_drawScreen_1_, p_drawScreen_2_, p_drawScreen_3_);
    }
}

