/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.spectator;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiSpectator;
import net.minecraft.client.gui.spectator.BaseSpectatorGroup;
import net.minecraft.client.gui.spectator.ISpectatorMenuObject;
import net.minecraft.client.gui.spectator.ISpectatorMenuRecipient;
import net.minecraft.client.gui.spectator.ISpectatorMenuView;
import net.minecraft.client.gui.spectator.categories.SpectatorDetails;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SpectatorMenu {
    private static final ISpectatorMenuObject CLOSE_ITEM = new EndSpectatorObject();
    private static final ISpectatorMenuObject SCROLL_LEFT = new MoveMenuObject(-1, true);
    private static final ISpectatorMenuObject SCROLL_RIGHT_ENABLED = new MoveMenuObject(1, true);
    private static final ISpectatorMenuObject SCROLL_RIGHT_DISABLED = new MoveMenuObject(1, false);
    public static final ISpectatorMenuObject EMPTY_SLOT = new ISpectatorMenuObject(){

        @Override
        public void selectItem(SpectatorMenu p_selectItem_1_) {
        }

        @Override
        public ITextComponent getSpectatorName() {
            return new TextComponentString("");
        }

        @Override
        public void renderIcon(float p_renderIcon_1_, int p_renderIcon_2_) {
        }

        @Override
        public boolean isEnabled() {
            return false;
        }
    };
    private final ISpectatorMenuRecipient listener;
    private final List<SpectatorDetails> previousCategories = Lists.newArrayList();
    private ISpectatorMenuView category = new BaseSpectatorGroup();
    private int selectedSlot = -1;
    private int page;

    public SpectatorMenu(ISpectatorMenuRecipient p_i45497_1_) {
        this.listener = p_i45497_1_;
    }

    public ISpectatorMenuObject getItem(int p_getItem_1_) {
        int lvt_2_1_ = p_getItem_1_ + this.page * 6;
        if (this.page > 0 && p_getItem_1_ == 0) {
            return SCROLL_LEFT;
        }
        if (p_getItem_1_ == 7) {
            if (lvt_2_1_ < this.category.getItems().size()) {
                return SCROLL_RIGHT_ENABLED;
            }
            return SCROLL_RIGHT_DISABLED;
        }
        if (p_getItem_1_ == 8) {
            return CLOSE_ITEM;
        }
        if (lvt_2_1_ < 0 || lvt_2_1_ >= this.category.getItems().size()) {
            return EMPTY_SLOT;
        }
        return (ISpectatorMenuObject)Objects.firstNonNull((Object)this.category.getItems().get(lvt_2_1_), (Object)EMPTY_SLOT);
    }

    public List<ISpectatorMenuObject> getItems() {
        ArrayList lvt_1_1_ = Lists.newArrayList();
        for (int lvt_2_1_ = 0; lvt_2_1_ <= 8; ++lvt_2_1_) {
            lvt_1_1_.add(this.getItem(lvt_2_1_));
        }
        return lvt_1_1_;
    }

    public ISpectatorMenuObject getSelectedItem() {
        return this.getItem(this.selectedSlot);
    }

    public ISpectatorMenuView getSelectedCategory() {
        return this.category;
    }

    public void selectSlot(int p_selectSlot_1_) {
        ISpectatorMenuObject lvt_2_1_ = this.getItem(p_selectSlot_1_);
        if (lvt_2_1_ != EMPTY_SLOT) {
            if (this.selectedSlot == p_selectSlot_1_ && lvt_2_1_.isEnabled()) {
                lvt_2_1_.selectItem(this);
            } else {
                this.selectedSlot = p_selectSlot_1_;
            }
        }
    }

    public void exit() {
        this.listener.onSpectatorMenuClosed(this);
    }

    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    public void selectCategory(ISpectatorMenuView p_selectCategory_1_) {
        this.previousCategories.add(this.getCurrentPage());
        this.category = p_selectCategory_1_;
        this.selectedSlot = -1;
        this.page = 0;
    }

    public SpectatorDetails getCurrentPage() {
        return new SpectatorDetails(this.category, this.getItems(), this.selectedSlot);
    }

    @SideOnly(value=Side.CLIENT)
    static class MoveMenuObject
    implements ISpectatorMenuObject {
        private final int direction;
        private final boolean enabled;

        public MoveMenuObject(int p_i45495_1_, boolean p_i45495_2_) {
            this.direction = p_i45495_1_;
            this.enabled = p_i45495_2_;
        }

        @Override
        public void selectItem(SpectatorMenu p_selectItem_1_) {
            p_selectItem_1_.page = p_selectItem_1_.page + this.direction;
        }

        @Override
        public ITextComponent getSpectatorName() {
            if (this.direction < 0) {
                return new TextComponentTranslation("spectatorMenu.previous_page", new Object[0]);
            }
            return new TextComponentTranslation("spectatorMenu.next_page", new Object[0]);
        }

        @Override
        public void renderIcon(float p_renderIcon_1_, int p_renderIcon_2_) {
            Minecraft.getMinecraft().getTextureManager().bindTexture(GuiSpectator.SPECTATOR_WIDGETS);
            if (this.direction < 0) {
                Gui.drawModalRectWithCustomSizedTexture(0, 0, 144.0f, 0.0f, 16, 16, 256.0f, 256.0f);
            } else {
                Gui.drawModalRectWithCustomSizedTexture(0, 0, 160.0f, 0.0f, 16, 16, 256.0f, 256.0f);
            }
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class EndSpectatorObject
    implements ISpectatorMenuObject {
        private EndSpectatorObject() {
        }

        @Override
        public void selectItem(SpectatorMenu p_selectItem_1_) {
            p_selectItem_1_.exit();
        }

        @Override
        public ITextComponent getSpectatorName() {
            return new TextComponentTranslation("spectatorMenu.close", new Object[0]);
        }

        @Override
        public void renderIcon(float p_renderIcon_1_, int p_renderIcon_2_) {
            Minecraft.getMinecraft().getTextureManager().bindTexture(GuiSpectator.SPECTATOR_WIDGETS);
            Gui.drawModalRectWithCustomSizedTexture(0, 0, 128.0f, 0.0f, 16, 16, 256.0f, 256.0f);
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }
}

