/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.spectator.categories;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiSpectator;
import net.minecraft.client.gui.spectator.ISpectatorMenuObject;
import net.minecraft.client.gui.spectator.ISpectatorMenuView;
import net.minecraft.client.gui.spectator.SpectatorMenu;
import net.minecraft.client.gui.spectator.categories.TeleportToPlayer;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TeleportToTeam
implements ISpectatorMenuView,
ISpectatorMenuObject {
    private final List<ISpectatorMenuObject> items = Lists.newArrayList();

    public TeleportToTeam() {
        Minecraft lvt_1_1_ = Minecraft.getMinecraft();
        for (ScorePlayerTeam lvt_3_1_ : lvt_1_1_.world.getScoreboard().getTeams()) {
            this.items.add(new TeamSelectionObject(lvt_3_1_));
        }
    }

    @Override
    public List<ISpectatorMenuObject> getItems() {
        return this.items;
    }

    @Override
    public ITextComponent getPrompt() {
        return new TextComponentTranslation("spectatorMenu.team_teleport.prompt", new Object[0]);
    }

    @Override
    public void selectItem(SpectatorMenu p_selectItem_1_) {
        p_selectItem_1_.selectCategory(this);
    }

    @Override
    public ITextComponent getSpectatorName() {
        return new TextComponentTranslation("spectatorMenu.team_teleport", new Object[0]);
    }

    @Override
    public void renderIcon(float p_renderIcon_1_, int p_renderIcon_2_) {
        Minecraft.getMinecraft().getTextureManager().bindTexture(GuiSpectator.SPECTATOR_WIDGETS);
        Gui.drawModalRectWithCustomSizedTexture(0, 0, 16.0f, 0.0f, 16, 16, 256.0f, 256.0f);
    }

    @Override
    public boolean isEnabled() {
        for (ISpectatorMenuObject lvt_2_1_ : this.items) {
            if (!lvt_2_1_.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    class TeamSelectionObject
    implements ISpectatorMenuObject {
        private final ScorePlayerTeam team;
        private final ResourceLocation location;
        private final List<NetworkPlayerInfo> players;

        public TeamSelectionObject(ScorePlayerTeam p_i45492_2_) {
            this.team = p_i45492_2_;
            this.players = Lists.newArrayList();
            for (String lvt_4_1_ : p_i45492_2_.getMembershipCollection()) {
                NetworkPlayerInfo lvt_5_1_ = Minecraft.getMinecraft().getConnection().getPlayerInfo(lvt_4_1_);
                if (lvt_5_1_ == null) continue;
                this.players.add(lvt_5_1_);
            }
            if (this.players.isEmpty()) {
                this.location = DefaultPlayerSkin.getDefaultSkinLegacy();
            } else {
                String lvt_3_1_ = this.players.get(new Random().nextInt(this.players.size())).getGameProfile().getName();
                this.location = AbstractClientPlayer.getLocationSkin(lvt_3_1_);
                AbstractClientPlayer.getDownloadImageSkin(this.location, lvt_3_1_);
            }
        }

        @Override
        public void selectItem(SpectatorMenu p_selectItem_1_) {
            p_selectItem_1_.selectCategory(new TeleportToPlayer(this.players));
        }

        @Override
        public ITextComponent getSpectatorName() {
            return new TextComponentString(this.team.getTeamName());
        }

        @Override
        public void renderIcon(float p_renderIcon_1_, int p_renderIcon_2_) {
            int lvt_3_1_ = -1;
            String lvt_4_1_ = FontRenderer.getFormatFromString(this.team.getColorPrefix());
            if (lvt_4_1_.length() >= 2) {
                lvt_3_1_ = Minecraft.getMinecraft().fontRendererObj.getColorCode(lvt_4_1_.charAt(1));
            }
            if (lvt_3_1_ >= 0) {
                float lvt_5_1_ = (float)(lvt_3_1_ >> 16 & 0xFF) / 255.0f;
                float lvt_6_1_ = (float)(lvt_3_1_ >> 8 & 0xFF) / 255.0f;
                float lvt_7_1_ = (float)(lvt_3_1_ & 0xFF) / 255.0f;
                Gui.drawRect(1, 1, 15, 15, MathHelper.rgb(lvt_5_1_ * p_renderIcon_1_, lvt_6_1_ * p_renderIcon_1_, lvt_7_1_ * p_renderIcon_1_) | p_renderIcon_2_ << 24);
            }
            Minecraft.getMinecraft().getTextureManager().bindTexture(this.location);
            GlStateManager.color(p_renderIcon_1_, p_renderIcon_1_, p_renderIcon_1_, (float)p_renderIcon_2_ / 255.0f);
            Gui.drawScaledCustomSizeModalRect(2, 2, 8.0f, 8.0f, 8, 8, 12, 12, 64.0f, 64.0f);
            Gui.drawScaledCustomSizeModalRect(2, 2, 40.0f, 8.0f, 8, 8, 12, 12, 64.0f, 64.0f);
        }

        @Override
        public boolean isEnabled() {
            return !this.players.isEmpty();
        }
    }
}

