/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.main;

import com.mojang.authlib.properties.PropertyMap;
import java.io.File;
import java.net.Proxy;
import net.minecraft.client.resources.ResourceIndex;
import net.minecraft.client.resources.ResourceIndexFolder;
import net.minecraft.util.Session;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GameConfiguration {
    public final UserInformation userInfo;
    public final DisplayInformation displayInfo;
    public final FolderInformation folderInfo;
    public final GameInformation gameInfo;
    public final ServerInformation serverInfo;

    public GameConfiguration(UserInformation p_i45491_1_, DisplayInformation p_i45491_2_, FolderInformation p_i45491_3_, GameInformation p_i45491_4_, ServerInformation p_i45491_5_) {
        this.userInfo = p_i45491_1_;
        this.displayInfo = p_i45491_2_;
        this.folderInfo = p_i45491_3_;
        this.gameInfo = p_i45491_4_;
        this.serverInfo = p_i45491_5_;
    }

    @SideOnly(value=Side.CLIENT)
    public static class ServerInformation {
        public final String serverName;
        public final int serverPort;

        public ServerInformation(String p_i45487_1_, int p_i45487_2_) {
            this.serverName = p_i45487_1_;
            this.serverPort = p_i45487_2_;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class FolderInformation {
        public final File mcDataDir;
        public final File resourcePacksDir;
        public final File assetsDir;
        public final String assetIndex;

        public FolderInformation(File p_i45489_1_, File p_i45489_2_, File p_i45489_3_, String p_i45489_4_) {
            this.mcDataDir = p_i45489_1_;
            this.resourcePacksDir = p_i45489_2_;
            this.assetsDir = p_i45489_3_;
            this.assetIndex = p_i45489_4_;
        }

        public ResourceIndex getAssetsIndex() {
            return this.assetIndex == null ? new ResourceIndexFolder(this.assetsDir) : new ResourceIndex(this.assetsDir, this.assetIndex);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class DisplayInformation {
        public final int width;
        public final int height;
        public final boolean fullscreen;
        public final boolean checkGlErrors;

        public DisplayInformation(int p_i45490_1_, int p_i45490_2_, boolean p_i45490_3_, boolean p_i45490_4_) {
            this.width = p_i45490_1_;
            this.height = p_i45490_2_;
            this.fullscreen = p_i45490_3_;
            this.checkGlErrors = p_i45490_4_;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class UserInformation {
        public final Session session;
        public final PropertyMap userProperties;
        public final PropertyMap profileProperties;
        public final Proxy proxy;

        public UserInformation(Session p_i46375_1_, PropertyMap p_i46375_2_, PropertyMap p_i46375_3_, Proxy p_i46375_4_) {
            this.session = p_i46375_1_;
            this.userProperties = p_i46375_2_;
            this.profileProperties = p_i46375_3_;
            this.proxy = p_i46375_4_;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class GameInformation {
        public final boolean isDemo;
        public final String version;
        public final String versionType;

        public GameInformation(boolean p_i46801_1_, String p_i46801_2_, String p_i46801_3_) {
            this.isDemo = p_i46801_1_;
            this.version = p_i46801_2_;
            this.versionType = p_i46801_3_;
        }
    }
}

