/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.ModelArmorStandArmor;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.util.EnumHandSide;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelArmorStand
extends ModelArmorStandArmor {
    public ModelRenderer standRightSide;
    public ModelRenderer standLeftSide;
    public ModelRenderer standWaist;
    public ModelRenderer standBase;

    public ModelArmorStand() {
        this(0.0f);
    }

    public ModelArmorStand(float p_i46306_1_) {
        super(p_i46306_1_, 64, 64);
        this.bipedHead = new ModelRenderer(this, 0, 0);
        this.bipedHead.addBox(-1.0f, -7.0f, -1.0f, 2, 7, 2, p_i46306_1_);
        this.bipedHead.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.bipedBody = new ModelRenderer(this, 0, 26);
        this.bipedBody.addBox(-6.0f, 0.0f, -1.5f, 12, 3, 3, p_i46306_1_);
        this.bipedBody.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.bipedRightArm = new ModelRenderer(this, 24, 0);
        this.bipedRightArm.addBox(-2.0f, -2.0f, -1.0f, 2, 12, 2, p_i46306_1_);
        this.bipedRightArm.setRotationPoint(-5.0f, 2.0f, 0.0f);
        this.bipedLeftArm = new ModelRenderer(this, 32, 16);
        this.bipedLeftArm.mirror = true;
        this.bipedLeftArm.addBox(0.0f, -2.0f, -1.0f, 2, 12, 2, p_i46306_1_);
        this.bipedLeftArm.setRotationPoint(5.0f, 2.0f, 0.0f);
        this.bipedRightLeg = new ModelRenderer(this, 8, 0);
        this.bipedRightLeg.addBox(-1.0f, 0.0f, -1.0f, 2, 11, 2, p_i46306_1_);
        this.bipedRightLeg.setRotationPoint(-1.9f, 12.0f, 0.0f);
        this.bipedLeftLeg = new ModelRenderer(this, 40, 16);
        this.bipedLeftLeg.mirror = true;
        this.bipedLeftLeg.addBox(-1.0f, 0.0f, -1.0f, 2, 11, 2, p_i46306_1_);
        this.bipedLeftLeg.setRotationPoint(1.9f, 12.0f, 0.0f);
        this.standRightSide = new ModelRenderer(this, 16, 0);
        this.standRightSide.addBox(-3.0f, 3.0f, -1.0f, 2, 7, 2, p_i46306_1_);
        this.standRightSide.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.standRightSide.showModel = true;
        this.standLeftSide = new ModelRenderer(this, 48, 16);
        this.standLeftSide.addBox(1.0f, 3.0f, -1.0f, 2, 7, 2, p_i46306_1_);
        this.standLeftSide.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.standWaist = new ModelRenderer(this, 0, 48);
        this.standWaist.addBox(-4.0f, 10.0f, -1.0f, 8, 2, 2, p_i46306_1_);
        this.standWaist.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.standBase = new ModelRenderer(this, 0, 32);
        this.standBase.addBox(-6.0f, 11.0f, -6.0f, 12, 1, 12, p_i46306_1_);
        this.standBase.setRotationPoint(0.0f, 12.0f, 0.0f);
        this.bipedHeadwear.showModel = false;
    }

    @Override
    public void setRotationAngles(float p_setRotationAngles_1_, float p_setRotationAngles_2_, float p_setRotationAngles_3_, float p_setRotationAngles_4_, float p_setRotationAngles_5_, float p_setRotationAngles_6_, Entity p_setRotationAngles_7_) {
        super.setRotationAngles(p_setRotationAngles_1_, p_setRotationAngles_2_, p_setRotationAngles_3_, p_setRotationAngles_4_, p_setRotationAngles_5_, p_setRotationAngles_6_, p_setRotationAngles_7_);
        if (!(p_setRotationAngles_7_ instanceof EntityArmorStand)) {
            return;
        }
        EntityArmorStand lvt_8_1_ = (EntityArmorStand)p_setRotationAngles_7_;
        this.bipedLeftArm.showModel = lvt_8_1_.getShowArms();
        this.bipedRightArm.showModel = lvt_8_1_.getShowArms();
        this.standBase.showModel = !lvt_8_1_.hasNoBasePlate();
        this.bipedLeftLeg.setRotationPoint(1.9f, 12.0f, 0.0f);
        this.bipedRightLeg.setRotationPoint(-1.9f, 12.0f, 0.0f);
        this.standRightSide.rotateAngleX = (float)Math.PI / 180 * lvt_8_1_.getBodyRotation().getX();
        this.standRightSide.rotateAngleY = (float)Math.PI / 180 * lvt_8_1_.getBodyRotation().getY();
        this.standRightSide.rotateAngleZ = (float)Math.PI / 180 * lvt_8_1_.getBodyRotation().getZ();
        this.standLeftSide.rotateAngleX = (float)Math.PI / 180 * lvt_8_1_.getBodyRotation().getX();
        this.standLeftSide.rotateAngleY = (float)Math.PI / 180 * lvt_8_1_.getBodyRotation().getY();
        this.standLeftSide.rotateAngleZ = (float)Math.PI / 180 * lvt_8_1_.getBodyRotation().getZ();
        this.standWaist.rotateAngleX = (float)Math.PI / 180 * lvt_8_1_.getBodyRotation().getX();
        this.standWaist.rotateAngleY = (float)Math.PI / 180 * lvt_8_1_.getBodyRotation().getY();
        this.standWaist.rotateAngleZ = (float)Math.PI / 180 * lvt_8_1_.getBodyRotation().getZ();
        this.standBase.rotateAngleX = 0.0f;
        this.standBase.rotateAngleY = (float)Math.PI / 180 * -p_setRotationAngles_7_.rotationYaw;
        this.standBase.rotateAngleZ = 0.0f;
    }

    @Override
    public void render(Entity p_render_1_, float p_render_2_, float p_render_3_, float p_render_4_, float p_render_5_, float p_render_6_, float p_render_7_) {
        super.render(p_render_1_, p_render_2_, p_render_3_, p_render_4_, p_render_5_, p_render_6_, p_render_7_);
        GlStateManager.pushMatrix();
        if (this.isChild) {
            float lvt_8_1_ = 2.0f;
            GlStateManager.scale(0.5f, 0.5f, 0.5f);
            GlStateManager.translate(0.0f, 24.0f * p_render_7_, 0.0f);
            this.standRightSide.render(p_render_7_);
            this.standLeftSide.render(p_render_7_);
            this.standWaist.render(p_render_7_);
            this.standBase.render(p_render_7_);
        } else {
            if (p_render_1_.isSneaking()) {
                GlStateManager.translate(0.0f, 0.2f, 0.0f);
            }
            this.standRightSide.render(p_render_7_);
            this.standLeftSide.render(p_render_7_);
            this.standWaist.render(p_render_7_);
            this.standBase.render(p_render_7_);
        }
        GlStateManager.popMatrix();
    }

    @Override
    public void postRenderArm(float p_postRenderArm_1_, EnumHandSide p_postRenderArm_2_) {
        ModelRenderer lvt_3_1_ = this.getArmForSide(p_postRenderArm_2_);
        boolean lvt_4_1_ = lvt_3_1_.showModel;
        lvt_3_1_.showModel = true;
        super.postRenderArm(p_postRenderArm_1_, p_postRenderArm_2_);
        lvt_3_1_.showModel = lvt_4_1_;
    }
}

