/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.TextureOffset;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;

public abstract class ModelBase {
    public float swingProgress;
    public boolean isRiding;
    public boolean isChild = true;
    public List<ModelRenderer> boxList = Lists.newArrayList();
    private final Map<String, TextureOffset> modelTextureMap = Maps.newHashMap();
    public int textureWidth = 64;
    public int textureHeight = 32;

    public void render(Entity p_render_1_, float p_render_2_, float p_render_3_, float p_render_4_, float p_render_5_, float p_render_6_, float p_render_7_) {
    }

    public void setRotationAngles(float p_setRotationAngles_1_, float p_setRotationAngles_2_, float p_setRotationAngles_3_, float p_setRotationAngles_4_, float p_setRotationAngles_5_, float p_setRotationAngles_6_, Entity p_setRotationAngles_7_) {
    }

    public void setLivingAnimations(EntityLivingBase p_setLivingAnimations_1_, float p_setLivingAnimations_2_, float p_setLivingAnimations_3_, float p_setLivingAnimations_4_) {
    }

    public ModelRenderer getRandomModelBox(Random p_getRandomModelBox_1_) {
        return this.boxList.get(p_getRandomModelBox_1_.nextInt(this.boxList.size()));
    }

    protected void setTextureOffset(String p_setTextureOffset_1_, int p_setTextureOffset_2_, int p_setTextureOffset_3_) {
        this.modelTextureMap.put(p_setTextureOffset_1_, new TextureOffset(p_setTextureOffset_2_, p_setTextureOffset_3_));
    }

    public TextureOffset getTextureOffset(String p_getTextureOffset_1_) {
        return this.modelTextureMap.get(p_getTextureOffset_1_);
    }

    public static void copyModelAngles(ModelRenderer p_copyModelAngles_0_, ModelRenderer p_copyModelAngles_1_) {
        p_copyModelAngles_1_.rotateAngleX = p_copyModelAngles_0_.rotateAngleX;
        p_copyModelAngles_1_.rotateAngleY = p_copyModelAngles_0_.rotateAngleY;
        p_copyModelAngles_1_.rotateAngleZ = p_copyModelAngles_0_.rotateAngleZ;
        p_copyModelAngles_1_.rotationPointX = p_copyModelAngles_0_.rotationPointX;
        p_copyModelAngles_1_.rotationPointY = p_copyModelAngles_0_.rotationPointY;
        p_copyModelAngles_1_.rotationPointZ = p_copyModelAngles_0_.rotationPointZ;
    }

    public void setModelAttributes(ModelBase p_setModelAttributes_1_) {
        this.swingProgress = p_setModelAttributes_1_.swingProgress;
        this.isRiding = p_setModelAttributes_1_.isRiding;
        this.isChild = p_setModelAttributes_1_.isChild;
    }
}

