/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelBiped
extends ModelBase {
    public ModelRenderer bipedHead;
    public ModelRenderer bipedHeadwear;
    public ModelRenderer bipedBody;
    public ModelRenderer bipedRightArm;
    public ModelRenderer bipedLeftArm;
    public ModelRenderer bipedRightLeg;
    public ModelRenderer bipedLeftLeg;
    public ArmPose leftArmPose = ArmPose.EMPTY;
    public ArmPose rightArmPose = ArmPose.EMPTY;
    public boolean isSneak;

    public ModelBiped() {
        this(0.0f);
    }

    public ModelBiped(float p_i1148_1_) {
        this(p_i1148_1_, 0.0f, 64, 32);
    }

    public ModelBiped(float p_i1149_1_, float p_i1149_2_, int p_i1149_3_, int p_i1149_4_) {
        this.textureWidth = p_i1149_3_;
        this.textureHeight = p_i1149_4_;
        this.bipedHead = new ModelRenderer(this, 0, 0);
        this.bipedHead.addBox(-4.0f, -8.0f, -4.0f, 8, 8, 8, p_i1149_1_);
        this.bipedHead.setRotationPoint(0.0f, 0.0f + p_i1149_2_, 0.0f);
        this.bipedHeadwear = new ModelRenderer(this, 32, 0);
        this.bipedHeadwear.addBox(-4.0f, -8.0f, -4.0f, 8, 8, 8, p_i1149_1_ + 0.5f);
        this.bipedHeadwear.setRotationPoint(0.0f, 0.0f + p_i1149_2_, 0.0f);
        this.bipedBody = new ModelRenderer(this, 16, 16);
        this.bipedBody.addBox(-4.0f, 0.0f, -2.0f, 8, 12, 4, p_i1149_1_);
        this.bipedBody.setRotationPoint(0.0f, 0.0f + p_i1149_2_, 0.0f);
        this.bipedRightArm = new ModelRenderer(this, 40, 16);
        this.bipedRightArm.addBox(-3.0f, -2.0f, -2.0f, 4, 12, 4, p_i1149_1_);
        this.bipedRightArm.setRotationPoint(-5.0f, 2.0f + p_i1149_2_, 0.0f);
        this.bipedLeftArm = new ModelRenderer(this, 40, 16);
        this.bipedLeftArm.mirror = true;
        this.bipedLeftArm.addBox(-1.0f, -2.0f, -2.0f, 4, 12, 4, p_i1149_1_);
        this.bipedLeftArm.setRotationPoint(5.0f, 2.0f + p_i1149_2_, 0.0f);
        this.bipedRightLeg = new ModelRenderer(this, 0, 16);
        this.bipedRightLeg.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, p_i1149_1_);
        this.bipedRightLeg.setRotationPoint(-1.9f, 12.0f + p_i1149_2_, 0.0f);
        this.bipedLeftLeg = new ModelRenderer(this, 0, 16);
        this.bipedLeftLeg.mirror = true;
        this.bipedLeftLeg.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, p_i1149_1_);
        this.bipedLeftLeg.setRotationPoint(1.9f, 12.0f + p_i1149_2_, 0.0f);
    }

    @Override
    public void render(Entity p_render_1_, float p_render_2_, float p_render_3_, float p_render_4_, float p_render_5_, float p_render_6_, float p_render_7_) {
        this.setRotationAngles(p_render_2_, p_render_3_, p_render_4_, p_render_5_, p_render_6_, p_render_7_, p_render_1_);
        GlStateManager.pushMatrix();
        if (this.isChild) {
            float lvt_8_1_ = 2.0f;
            GlStateManager.scale(0.75f, 0.75f, 0.75f);
            GlStateManager.translate(0.0f, 16.0f * p_render_7_, 0.0f);
            this.bipedHead.render(p_render_7_);
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            GlStateManager.scale(0.5f, 0.5f, 0.5f);
            GlStateManager.translate(0.0f, 24.0f * p_render_7_, 0.0f);
            this.bipedBody.render(p_render_7_);
            this.bipedRightArm.render(p_render_7_);
            this.bipedLeftArm.render(p_render_7_);
            this.bipedRightLeg.render(p_render_7_);
            this.bipedLeftLeg.render(p_render_7_);
            this.bipedHeadwear.render(p_render_7_);
        } else {
            if (p_render_1_.isSneaking()) {
                GlStateManager.translate(0.0f, 0.2f, 0.0f);
            }
            this.bipedHead.render(p_render_7_);
            this.bipedBody.render(p_render_7_);
            this.bipedRightArm.render(p_render_7_);
            this.bipedLeftArm.render(p_render_7_);
            this.bipedRightLeg.render(p_render_7_);
            this.bipedLeftLeg.render(p_render_7_);
            this.bipedHeadwear.render(p_render_7_);
        }
        GlStateManager.popMatrix();
    }

    @Override
    public void setRotationAngles(float p_setRotationAngles_1_, float p_setRotationAngles_2_, float p_setRotationAngles_3_, float p_setRotationAngles_4_, float p_setRotationAngles_5_, float p_setRotationAngles_6_, Entity p_setRotationAngles_7_) {
        boolean lvt_8_1_ = p_setRotationAngles_7_ instanceof EntityLivingBase && ((EntityLivingBase)p_setRotationAngles_7_).getTicksElytraFlying() > 4;
        this.bipedHead.rotateAngleY = p_setRotationAngles_4_ * ((float)Math.PI / 180);
        this.bipedHead.rotateAngleX = lvt_8_1_ ? -0.7853982f : p_setRotationAngles_5_ * ((float)Math.PI / 180);
        this.bipedBody.rotateAngleY = 0.0f;
        this.bipedRightArm.rotationPointZ = 0.0f;
        this.bipedRightArm.rotationPointX = -5.0f;
        this.bipedLeftArm.rotationPointZ = 0.0f;
        this.bipedLeftArm.rotationPointX = 5.0f;
        float lvt_9_1_ = 1.0f;
        if (lvt_8_1_) {
            lvt_9_1_ = (float)(p_setRotationAngles_7_.motionX * p_setRotationAngles_7_.motionX + p_setRotationAngles_7_.motionY * p_setRotationAngles_7_.motionY + p_setRotationAngles_7_.motionZ * p_setRotationAngles_7_.motionZ);
            lvt_9_1_ /= 0.2f;
            lvt_9_1_ *= lvt_9_1_ * lvt_9_1_;
        }
        if (lvt_9_1_ < 1.0f) {
            lvt_9_1_ = 1.0f;
        }
        this.bipedRightArm.rotateAngleX = MathHelper.cos(p_setRotationAngles_1_ * 0.6662f + (float)Math.PI) * 2.0f * p_setRotationAngles_2_ * 0.5f / lvt_9_1_;
        this.bipedLeftArm.rotateAngleX = MathHelper.cos(p_setRotationAngles_1_ * 0.6662f) * 2.0f * p_setRotationAngles_2_ * 0.5f / lvt_9_1_;
        this.bipedRightArm.rotateAngleZ = 0.0f;
        this.bipedLeftArm.rotateAngleZ = 0.0f;
        this.bipedRightLeg.rotateAngleX = MathHelper.cos(p_setRotationAngles_1_ * 0.6662f) * 1.4f * p_setRotationAngles_2_ / lvt_9_1_;
        this.bipedLeftLeg.rotateAngleX = MathHelper.cos(p_setRotationAngles_1_ * 0.6662f + (float)Math.PI) * 1.4f * p_setRotationAngles_2_ / lvt_9_1_;
        this.bipedRightLeg.rotateAngleY = 0.0f;
        this.bipedLeftLeg.rotateAngleY = 0.0f;
        this.bipedRightLeg.rotateAngleZ = 0.0f;
        this.bipedLeftLeg.rotateAngleZ = 0.0f;
        if (this.isRiding) {
            this.bipedRightArm.rotateAngleX += -0.62831855f;
            this.bipedLeftArm.rotateAngleX += -0.62831855f;
            this.bipedRightLeg.rotateAngleX = -1.4137167f;
            this.bipedRightLeg.rotateAngleY = 0.31415927f;
            this.bipedRightLeg.rotateAngleZ = 0.07853982f;
            this.bipedLeftLeg.rotateAngleX = -1.4137167f;
            this.bipedLeftLeg.rotateAngleY = -0.31415927f;
            this.bipedLeftLeg.rotateAngleZ = -0.07853982f;
        }
        this.bipedRightArm.rotateAngleY = 0.0f;
        this.bipedRightArm.rotateAngleZ = 0.0f;
        switch (this.leftArmPose) {
            case EMPTY: {
                this.bipedLeftArm.rotateAngleY = 0.0f;
                break;
            }
            case BLOCK: {
                this.bipedLeftArm.rotateAngleX = this.bipedLeftArm.rotateAngleX * 0.5f - 0.9424779f;
                this.bipedLeftArm.rotateAngleY = 0.5235988f;
                break;
            }
            case ITEM: {
                this.bipedLeftArm.rotateAngleX = this.bipedLeftArm.rotateAngleX * 0.5f - 0.31415927f;
                this.bipedLeftArm.rotateAngleY = 0.0f;
            }
        }
        switch (this.rightArmPose) {
            case EMPTY: {
                this.bipedRightArm.rotateAngleY = 0.0f;
                break;
            }
            case BLOCK: {
                this.bipedRightArm.rotateAngleX = this.bipedRightArm.rotateAngleX * 0.5f - 0.9424779f;
                this.bipedRightArm.rotateAngleY = -0.5235988f;
                break;
            }
            case ITEM: {
                this.bipedRightArm.rotateAngleX = this.bipedRightArm.rotateAngleX * 0.5f - 0.31415927f;
                this.bipedRightArm.rotateAngleY = 0.0f;
            }
        }
        if (this.swingProgress > 0.0f) {
            EnumHandSide lvt_10_1_ = this.getMainHand(p_setRotationAngles_7_);
            ModelRenderer lvt_11_1_ = this.getArmForSide(lvt_10_1_);
            float lvt_12_1_ = this.swingProgress;
            this.bipedBody.rotateAngleY = MathHelper.sin(MathHelper.sqrt(lvt_12_1_) * ((float)Math.PI * 2)) * 0.2f;
            if (lvt_10_1_ == EnumHandSide.LEFT) {
                this.bipedBody.rotateAngleY *= -1.0f;
            }
            this.bipedRightArm.rotationPointZ = MathHelper.sin(this.bipedBody.rotateAngleY) * 5.0f;
            this.bipedRightArm.rotationPointX = -MathHelper.cos(this.bipedBody.rotateAngleY) * 5.0f;
            this.bipedLeftArm.rotationPointZ = -MathHelper.sin(this.bipedBody.rotateAngleY) * 5.0f;
            this.bipedLeftArm.rotationPointX = MathHelper.cos(this.bipedBody.rotateAngleY) * 5.0f;
            this.bipedRightArm.rotateAngleY += this.bipedBody.rotateAngleY;
            this.bipedLeftArm.rotateAngleY += this.bipedBody.rotateAngleY;
            this.bipedLeftArm.rotateAngleX += this.bipedBody.rotateAngleY;
            lvt_12_1_ = 1.0f - this.swingProgress;
            lvt_12_1_ *= lvt_12_1_;
            lvt_12_1_ *= lvt_12_1_;
            lvt_12_1_ = 1.0f - lvt_12_1_;
            float lvt_13_1_ = MathHelper.sin(lvt_12_1_ * (float)Math.PI);
            float lvt_14_1_ = MathHelper.sin(this.swingProgress * (float)Math.PI) * -(this.bipedHead.rotateAngleX - 0.7f) * 0.75f;
            lvt_11_1_.rotateAngleX = (float)((double)lvt_11_1_.rotateAngleX - ((double)lvt_13_1_ * 1.2 + (double)lvt_14_1_));
            lvt_11_1_.rotateAngleY += this.bipedBody.rotateAngleY * 2.0f;
            lvt_11_1_.rotateAngleZ += MathHelper.sin(this.swingProgress * (float)Math.PI) * -0.4f;
        }
        if (this.isSneak) {
            this.bipedBody.rotateAngleX = 0.5f;
            this.bipedRightArm.rotateAngleX += 0.4f;
            this.bipedLeftArm.rotateAngleX += 0.4f;
            this.bipedRightLeg.rotationPointZ = 4.0f;
            this.bipedLeftLeg.rotationPointZ = 4.0f;
            this.bipedRightLeg.rotationPointY = 9.0f;
            this.bipedLeftLeg.rotationPointY = 9.0f;
            this.bipedHead.rotationPointY = 1.0f;
        } else {
            this.bipedBody.rotateAngleX = 0.0f;
            this.bipedRightLeg.rotationPointZ = 0.1f;
            this.bipedLeftLeg.rotationPointZ = 0.1f;
            this.bipedRightLeg.rotationPointY = 12.0f;
            this.bipedLeftLeg.rotationPointY = 12.0f;
            this.bipedHead.rotationPointY = 0.0f;
        }
        this.bipedRightArm.rotateAngleZ += MathHelper.cos(p_setRotationAngles_3_ * 0.09f) * 0.05f + 0.05f;
        this.bipedLeftArm.rotateAngleZ -= MathHelper.cos(p_setRotationAngles_3_ * 0.09f) * 0.05f + 0.05f;
        this.bipedRightArm.rotateAngleX += MathHelper.sin(p_setRotationAngles_3_ * 0.067f) * 0.05f;
        this.bipedLeftArm.rotateAngleX -= MathHelper.sin(p_setRotationAngles_3_ * 0.067f) * 0.05f;
        if (this.rightArmPose == ArmPose.BOW_AND_ARROW) {
            this.bipedRightArm.rotateAngleY = -0.1f + this.bipedHead.rotateAngleY;
            this.bipedLeftArm.rotateAngleY = 0.1f + this.bipedHead.rotateAngleY + 0.4f;
            this.bipedRightArm.rotateAngleX = -1.5707964f + this.bipedHead.rotateAngleX;
            this.bipedLeftArm.rotateAngleX = -1.5707964f + this.bipedHead.rotateAngleX;
        } else if (this.leftArmPose == ArmPose.BOW_AND_ARROW) {
            this.bipedRightArm.rotateAngleY = -0.1f + this.bipedHead.rotateAngleY - 0.4f;
            this.bipedLeftArm.rotateAngleY = 0.1f + this.bipedHead.rotateAngleY;
            this.bipedRightArm.rotateAngleX = -1.5707964f + this.bipedHead.rotateAngleX;
            this.bipedLeftArm.rotateAngleX = -1.5707964f + this.bipedHead.rotateAngleX;
        }
        ModelBiped.copyModelAngles(this.bipedHead, this.bipedHeadwear);
    }

    @Override
    public void setModelAttributes(ModelBase p_setModelAttributes_1_) {
        super.setModelAttributes(p_setModelAttributes_1_);
        if (p_setModelAttributes_1_ instanceof ModelBiped) {
            ModelBiped lvt_2_1_ = (ModelBiped)p_setModelAttributes_1_;
            this.leftArmPose = lvt_2_1_.leftArmPose;
            this.rightArmPose = lvt_2_1_.rightArmPose;
            this.isSneak = lvt_2_1_.isSneak;
        }
    }

    public void setInvisible(boolean p_setInvisible_1_) {
        this.bipedHead.showModel = p_setInvisible_1_;
        this.bipedHeadwear.showModel = p_setInvisible_1_;
        this.bipedBody.showModel = p_setInvisible_1_;
        this.bipedRightArm.showModel = p_setInvisible_1_;
        this.bipedLeftArm.showModel = p_setInvisible_1_;
        this.bipedRightLeg.showModel = p_setInvisible_1_;
        this.bipedLeftLeg.showModel = p_setInvisible_1_;
    }

    public void postRenderArm(float p_postRenderArm_1_, EnumHandSide p_postRenderArm_2_) {
        this.getArmForSide(p_postRenderArm_2_).postRender(p_postRenderArm_1_);
    }

    protected ModelRenderer getArmForSide(EnumHandSide p_getArmForSide_1_) {
        if (p_getArmForSide_1_ == EnumHandSide.LEFT) {
            return this.bipedLeftArm;
        }
        return this.bipedRightArm;
    }

    protected EnumHandSide getMainHand(Entity p_getMainHand_1_) {
        if (p_getMainHand_1_ instanceof EntityLivingBase) {
            EntityLivingBase lvt_2_1_ = (EntityLivingBase)p_getMainHand_1_;
            EnumHandSide lvt_3_1_ = lvt_2_1_.getPrimaryHand();
            return lvt_2_1_.swingingHand == EnumHand.MAIN_HAND ? lvt_3_1_ : lvt_3_1_.opposite();
        }
        return EnumHandSide.RIGHT;
    }

    @SideOnly(value=Side.CLIENT)
    public static enum ArmPose {
        EMPTY,
        ITEM,
        BLOCK,
        BOW_AND_ARROW;

    }
}

